//! Process service implementation.

pub mod api;

pub use api::{
    METHOD_SHUTDOWN_TREE, ProcessService, SERVICE_NAME, ShutdownTreeRequest,
    ShutdownTreeResponse,
};

#[cfg(test)]
use crate::workspace::ipc::error::Error;

/// Mock implementation for testing.
#[cfg(test)]
#[derive(Debug)]
pub struct MockProcessService;

#[cfg(test)]
#[async_trait::async_trait]
impl ProcessService for MockProcessService {
    async fn shutdown_tree(
        &self,
        _request: ShutdownTreeRequest,
    ) -> Result<ShutdownTreeResponse, Error> {
        Ok(ShutdownTreeResponse { acknowledged: true })
    }
}
