use std::sync::LazyLock;

use crate::workspace::ipc::protocol::Response;

pub mod auth;
pub mod data_plane;
pub mod error;
pub mod multiplex;
pub mod platform;
pub mod process_manager;
pub mod protocol;
pub mod router;
pub mod services;
pub mod transport;
pub mod types;

// process is for calls that apply to any subprocess, e.g. graceful shutdown
pub static IPC_API: LazyLock<Vec<&str>> = LazyLock::new(|| {
    vec![
        "process",
        "formats",
        "io",
        "network",
        "renderer",
        "storage",
        "workspace",
    ]
});

pub fn assert_ipc_response_ok(response: &Response) {
    assert!(response.ok, "IPC response indicates failure: {response:?}");
}

pub fn assert_ipc_response_error(response: &Response) {
    assert!(
        !response.ok,
        "IPC response indicates success when error expected: {response:?}"
    );
}
