// This does use some unsafe code for IPC (because shared memory requires it);
// those cases are marked with `#[allow(unsafe_code)]`.
#![deny(unsafe_code)]
#![deny(unused_must_use)]
#![warn(clippy::pedantic)]
#![deny(clippy::as_conversions)]
#![deny(clippy::unnecessary_fallible_conversions)]
#![deny(clippy::try_err)]
#![deny(clippy::ok_expect)]
#![warn(clippy::expect_used)]
#![warn(clippy::panic)]
#![warn(clippy::indexing_slicing)]
#![warn(clippy::unwrap_used)]
#![warn(clippy::unwrap_in_result)]
#![warn(clippy::panic_in_result_fn)]
#![warn(clippy::map_err_ignore)]
#![allow(clippy::collapsible_if)]
#![allow(clippy::must_use_candidate)]
#![allow(clippy::needless_range_loop)]
#![allow(clippy::missing_panics_doc)]
#![allow(clippy::missing_errors_doc)]
pub mod formats;
pub mod io;
pub mod network;
pub mod renderer;
pub mod storage;
pub mod workspace;

pub mod cli;
pub mod utilities;

use crate::storage::get_storage_dir;
#[allow(clippy::wildcard_imports)]
use crate::utilities::*;
pub use ctb_test_macro::ctb_test;
use include_dir::{Dir, include_dir};
pub use serde_json::json as utilities_serde_json_json;

// Note to self: If tons of tests like cli::tests::test_get_help_bytes fail, it
// may be because there's some bug where these are flaky. Run `cargo build`
// again to regenerate them. (FIXME)
static PROJECT_DIR: Dir = include_dir!("$CARGO_MANIFEST_DIR/../built/assets");
static SOURCE_ZIP: Dir = include_dir!("$CARGO_MANIFEST_DIR/../built/src");

#[macro_export]
macro_rules! json {
    ($($json:tt)+) => {
        $crate::utilities_json_json!($($json)+)
    };
}

#[cfg(test)]
mod tests {

    #[crate::ctb_test]
    fn it_works() {
        assert_eq!(2 + 2, 4);
    }
}
