//! Controller for general web pages outside of the app UI itself.

use axum::response::IntoResponse;
use axum::{extract::State, response::Response};

// for `oneshot`

use crate::io::webui::{
    AppState, RequestState, respond_general, respond_markdown_page,
};
use crate::io::webui::controllers::base::{redirect_temporary};
use crate::json_value;
use crate::utilities::build_info;

pub async fn get_index(
    State(state): State<AppState>,
    req: RequestState,
) -> Response {
    let commit = build_info().commit;
    respond_general(&state, req, "index", &json_value!({}))
}

pub async fn privacy_policy(
    State(state): State<AppState>,
    req: RequestState,
) -> Response {
    respond_markdown_page(&state, req, "privacy-policy")
}

pub async fn subscribe(
    State(state): State<AppState>,
    req: RequestState,
) -> Response {
    redirect_temporary(req.is_js_request, "https://collectivetoolbox.eo.page/")
}

#[cfg(test)]
mod tests {
    use crate::io::webui::test_helpers::{
        assert_eq_or_print_body, assert_or_print_body, test_get_no_login,
    };

    #[crate::ctb_test(tokio::test)]
    async fn can_get_index() {
        let (status, body) = test_get_no_login("/").await;
        assert_eq_or_print_body(status, 200, &body);
        assert_or_print_body(
            body.contains("<title>Collective Toolbox</title>"),
            &body,
        );
    }
}
