use html2text::from_read;

pub fn html2text(html: Vec<u8>) -> Vec<u8> {
    html2text_with_width(html, 80)
}

pub fn html2text_with_width(html: Vec<u8>, width: u16) -> Vec<u8> {
    from_read(html.as_slice(), width.into())
        .unwrap()
        .as_bytes()
        .to_vec()
}
