
<img src="assets/logo.svg" alt="💙COLLECTIVE" width="400"/>

## Collective Toolbox: Overview

Collective Toolbox: A graph‑based workspace for linking documents and data—across local and shared knowledge—so you can query, explore, and build reports with clarity.

Built with a focus on user respect and transparency. Free‑software licensing for study and modification; paid hosting planned for convenience and reliability.

## Disclaimer

Please note: this is currently a hobby project provided "as is" (see the license for the full disclaimer) and is not suited for use for security critical, business critical, other important purposes.

## Licensing

This is licensed primarily under AGPL-3+. Parts of the code are reused under MIT license terms, see individual files for details.

Some old files in the docs/ folder from older versions of this project have mystery meat licensing; see the Guix packaging (packaging/hc.scm) for how the source is cleaned of generated sources and unknown licensing - delete those files for clean AGPL-3+ && MIT && Apache-2.0 license.

The soccer.* files in the docs/eite/implementation/platform-support/web/ folder are used under a mix of CC-BY-SA 3.0 Unported and SIL OFL 1.1+. See docs/eite/implementation/platform-support/web/soccer-license.txt for attribution and license text.

## Dev notes

- Installing build dependencies: See the comments in the `build` script
- Updating Rust: `rustup update`
- Updating dependencies: `cd ~/hc/ctoolbox || exit 1; cargo update`
- Checking for unused dependencies: `cd ~/hc/ctoolbox || exit 1; cargo install cargo-udeps --locked; cargo +nightly udeps --all-targets`
- Updating dependencies past unstable version (requires `cargo install cargo-edit`): `cd ~/hc/ctoolbox || exit 1; cargo upgrade -i allow --dry-run` or `cd ~/hc/ctoolbox || exit 1; cargo upgrade -i allow` to save them
  - Note that this will *not* work if the "edition" is not set to the latest in Cargo.toml, so make sure the edition is up to date.
- Checking dependencies for license issues: `cd ~/hc/ctoolbox || exit 1; cargo deny check`
- Checking what cat dragged in what unwanted dependency: `cd ~/hc/ctoolbox; cargo tree --invert (dependency-name)` or `cd ~/hc/ctoolbox || exit 1; cargo tree -e features --invert (dependency-name)`
- Automatically fix some lints (may need `cargo clippy --fix --broken-code`): `( pushd ~/hc/ctoolbox || exit 1; cargo fix || exit 1; git add .; git commit -m format; cargo fix --lib -p ctoolbox --tests || exit 1; git add .; git commit -m format; cargo fix --lib -p ctoolbox || exit 1; git add .; git commit -m format; cargo clippy --fix || exit 1; git add .; git commit -m format; cargo clippy --fix --lib -p ctoolbox --tests || exit 1; git add .; git commit -m format; cargo clippy --fix --lib -p ctoolbox || exit 1; git add .; git commit -m format; cargo fmt || exit 1; git add .; git commit -m format; popd; )`
   - Ditto, but for ctb_test_macro sub-crate: `( pushd ~/hc/ctoolbox/src/utilities/ctb_test_macro/ || exit 1; cargo fix || exit 1; git add .; git commit -m format; cargo fix --lib -p ctb-test-macro --tests || exit 1; git add .; git commit -m format; cargo fix --lib -p ctb-test-macro || exit 1; git add .; git commit -m format; cargo clippy --fix || exit 1; git add .; git commit -m format; cargo clippy --fix --lib -p ctb-test-macro --tests || exit 1; git add .; git commit -m format; cargo clippy --fix --lib -p ctb-test-macro || exit 1; git add .; git commit -m format; cargo fmt || exit 1; git add .; git commit -m format; popd; )`
- Saving dependencies: `cd ~/ctb-vendored || exit 1; ./scripts/vendor-dependencies`
- Update Guix package: `cd ~/hc || exit 1; cp packaging/guix/rust-crates.tmpl packaging/guix/generated/hc-workspace-rust-crates.scm; guix import --insert=packaging/guix/generated/hc-workspace-rust-crates.scm crate --lockfile=ctoolbox/Cargo.lock hc-workspace`
- Build with Guix: `cd ~/hc || exit 1; ./packaging/guix-build`
- Guix debugging: `cd /tmp/guix-build-hc-0.1.0.drv-0 || exit 1; guix shell --no-grafts -f ~/hc/packaging/guix/generated/hc.scm -C -D strace`
- Macro troubleshooting: `pushd ctoolbox || exit 1; cargo expand --lib 'io::webui::controllers::graph' | less; popd` (but this is less useful because "macro hygiene" rules mean what visually looks like the expanded code is not actually how it's interpreted)
- Hot reload may become possible using https://docs.rs/subsecond/0.7.0-alpha.1/subsecond/
- Installing cargo-vet: `cargo install --locked cargo-vet`
- Importing cargo-vet rules: `cargo vet import mozilla`
- Running cargo-vet: `cargo vet` (output looks something like `Vetting Succeeded (79 fully audited, 526 exempted)`)
- Installing cargo-nextest (slower, but allows seeing slow tests): `cargo install cargo-nextest --locked` and then uncomment the `cargo nextest` commands in build script and comment out the `cargo test` ones
- Installing cargo bloat: `cargo install cargo-bloat`
- Seeing largest functions: `cd ~/hc/ctoolbox || exit 1; cargo bloat --release -n 20`
- Seeing largest dependencies: `cd ~/hc/ctoolbox || exit 1; cargo bloat --release --crates -n 150`
- Seeing largest source: `cd ~/hc/ctoolbox/src || exit 1; shopt -s globstar; wc -l **/*`

- Handlebars `{{ var }}` is escaped; `{{{ var }}}` is unescaped.

### Running

- Running with some extra debug information: `RUST_LOG="warn,ctoolbox=debug,tower_http=debug,hyper=warn,axum::rejection=trace" ctoolbox`
- Running with lots of extra debug information (every HTTP request): `RUST_LOG="debug,ctoolbox=debug,tower_http=debug" ./deploy/ctoolbox`

### Deploying

- Set up the server along the lines of what's in `setup-permissions-group.sh` (only need to do this once)
- Save the deployer username into your `~/ctb-deploy.username`
- Save the sudoer username into your `~/ctb-deploy.sudoer-username`
- Save the server user's username into your `~/ctb-deploy.server-username`
- Save the server IP into your `~/ctb-deploy.ip`
- Save the server SSH port into your `~/ctb-deploy.port`
- Upload the configuration to ~/.local/share/collectivetoolbox/config/pc_settings.json
- Run the `deploy` script

### Platforms

With the caveat that this software is unfinished:

| Platform | Known issues, if any |
|----------|----------|
| Linux | OK |
| Native Windows, Mac, iOS... | ? Probably not simple to build without Win/Mac machines handy |
| Webkit; Blink    | Pausing web version for now as due to lack of normal Rust threading, it will presumably need emulation instead (perhaps blocked by https://github.com/copy/v86/issues/133) |
| Firefox | Broken because of https://bugzil.la/1360870; https://bugzil.la/1320796 |
| PWA (iOS/Android) | No blockers, but unimplemented |

### Pregenerated and blobs

Not comprehensive. I'm letting auto-generated *library bindings* slide as that seems like a different case.

- ICU4X: https://codeberg.org/guix/guix/issues/2401
- unicode-width (pregenerated)
- webview2-com-sys (blobs)
- winapi (blobs)
