// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::MessageHeaders;
use glib::translate::*;
use std::ptr;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct Multipart(Boxed<ffi::SoupMultipart>);

    match fn {
        copy => |ptr| glib::gobject_ffi::g_boxed_copy(ffi::soup_multipart_get_type(), ptr as *mut _) as *mut ffi::SoupMultipart,
        free => |ptr| glib::gobject_ffi::g_boxed_free(ffi::soup_multipart_get_type(), ptr as *mut _),
        type_ => || ffi::soup_multipart_get_type(),
    }
}

impl Multipart {
    #[doc(alias = "soup_multipart_new")]
    pub fn new(mime_type: &str) -> Multipart {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::soup_multipart_new(mime_type.to_glib_none().0)) }
    }

    #[doc(alias = "soup_multipart_new_from_message")]
    #[doc(alias = "new_from_message")]
    pub fn from_message(headers: &MessageHeaders, body: &glib::Bytes) -> Option<Multipart> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_multipart_new_from_message(
                headers.to_glib_none().0,
                body.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_multipart_append_form_file")]
    pub fn append_form_file(
        &mut self,
        control_name: &str,
        filename: Option<&str>,
        content_type: Option<&str>,
        body: &glib::Bytes,
    ) {
        unsafe {
            ffi::soup_multipart_append_form_file(
                self.to_glib_none_mut().0,
                control_name.to_glib_none().0,
                filename.to_glib_none().0,
                content_type.to_glib_none().0,
                body.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_multipart_append_form_string")]
    pub fn append_form_string(&mut self, control_name: &str, data: &str) {
        unsafe {
            ffi::soup_multipart_append_form_string(
                self.to_glib_none_mut().0,
                control_name.to_glib_none().0,
                data.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_multipart_append_part")]
    pub fn append_part(&mut self, headers: &MessageHeaders, body: &glib::Bytes) {
        unsafe {
            ffi::soup_multipart_append_part(
                self.to_glib_none_mut().0,
                headers.to_glib_none().0,
                body.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_multipart_get_length")]
    #[doc(alias = "get_length")]
    pub fn length(&mut self) -> i32 {
        unsafe { ffi::soup_multipart_get_length(self.to_glib_none_mut().0) }
    }

    #[doc(alias = "soup_multipart_get_part")]
    #[doc(alias = "get_part")]
    pub fn part(&mut self, part: i32) -> Option<(MessageHeaders, glib::Bytes)> {
        unsafe {
            let mut headers = ptr::null_mut();
            let mut body = ptr::null_mut();
            let ret = from_glib(ffi::soup_multipart_get_part(
                self.to_glib_none_mut().0,
                part,
                &mut headers,
                &mut body,
            ));
            if ret {
                Some((from_glib_none(headers), from_glib_none(body)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "soup_multipart_to_message")]
    pub fn to_message(&mut self, dest_headers: &MessageHeaders) -> glib::Bytes {
        unsafe {
            let mut dest_body = ptr::null_mut();
            ffi::soup_multipart_to_message(
                self.to_glib_none_mut().0,
                dest_headers.to_glib_none().0,
                &mut dest_body,
            );
            from_glib_full(dest_body)
        }
    }
}
