use super::prelude::*;

#[tokio::test]
async fn nowrap() -> Result<()> {
	let mut child = CommandWrap::with_new("powershell.exe", |command| {
		command.arg("/C").arg("echo hello").stdout(Stdio::null());
	})
	.spawn()?;

	let status = child.wait().await?;
	assert!(status.success());

	let status = child.wait().await?;
	assert!(status.success());

	Ok(())
}

#[tokio::test]
async fn job_object() -> Result<()> {
	let mut child = CommandWrap::with_new("powershell.exe", |command| {
		command.arg("/C").arg("echo hello").stdout(Stdio::null());
	})
	.wrap(JobObject)
	.spawn()?;

	let status = child.wait().await?;
	assert!(status.success());

	let status = child.wait().await?;
	assert!(status.success());

	Ok(())
}
