//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementdomnodekey?language=objc)
    #[deprecated]
    pub static WebElementDOMNodeKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementframekey?language=objc)
    #[deprecated]
    pub static WebElementFrameKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementimagealtstringkey?language=objc)
    #[deprecated]
    pub static WebElementImageAltStringKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementimagekey?language=objc)
    #[deprecated]
    pub static WebElementImageKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementimagerectkey?language=objc)
    #[deprecated]
    pub static WebElementImageRectKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementimageurlkey?language=objc)
    #[deprecated]
    pub static WebElementImageURLKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementisselectedkey?language=objc)
    #[deprecated]
    pub static WebElementIsSelectedKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementlinkurlkey?language=objc)
    #[deprecated]
    pub static WebElementLinkURLKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementlinktargetframekey?language=objc)
    #[deprecated]
    pub static WebElementLinkTargetFrameKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementlinktitlekey?language=objc)
    #[deprecated]
    pub static WebElementLinkTitleKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webelementlinklabelkey?language=objc)
    #[deprecated]
    pub static WebElementLinkLabelKey: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewprogressstartednotification?language=objc)
    #[deprecated]
    pub static WebViewProgressStartedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewprogressestimatechangednotification?language=objc)
    #[deprecated]
    pub static WebViewProgressEstimateChangedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewprogressfinishednotification?language=objc)
    #[deprecated]
    pub static WebViewProgressFinishedNotification: Option<&'static NSString>;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "objc2-app-kit")]
    #[cfg(target_os = "macos")]
    #[deprecated = "No longer supported; please adopt WKWebView."]
    pub struct WebView;
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAccessibility for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSCoding for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSDraggingDestination for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSObjectProtocol for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for WebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        /// Checks if the WebKit can show content of a certain MIME type.
        ///
        /// Parameter `MIMEType`: The MIME type to check.
        ///
        /// Returns: YES if the WebKit can show content with MIMEtype.
        ///
        /// # Safety
        ///
        /// `mime_type` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canShowMIMEType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canShowMIMEType(mime_type: Option<&NSString>, mtm: MainThreadMarker) -> bool;

        /// Checks if the MIME type is a type that the WebKit will interpret as HTML.
        ///
        /// Parameter `MIMEType`: The MIME type to check.
        ///
        /// Returns: YES if the MIMEtype in an HTML type.
        ///
        /// # Safety
        ///
        /// `mime_type` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canShowMIMETypeAsHTML:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canShowMIMETypeAsHTML(
            mime_type: Option<&NSString>,
            mtm: MainThreadMarker,
        ) -> bool;

        /// Returns: Returns an array of NSStrings that describe the MIME types
        /// WebKit will attempt to render as HTML.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(MIMETypesShownAsHTML))]
        #[unsafe(method_family = none)]
        pub unsafe fn MIMETypesShownAsHTML(mtm: MainThreadMarker) -> Option<Retained<NSArray>>;

        /// Sets the array of NSString MIME types that WebKit will
        /// attempt to render as HTML.  Typically you will retrieve the built-in
        /// array using MIMETypesShownAsHTML and add additional MIME types to that
        /// array.
        ///
        /// # Safety
        ///
        /// - `mime_types` generic should be of the correct type.
        /// - `mime_types` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setMIMETypesShownAsHTML:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMIMETypesShownAsHTML(mime_types: Option<&NSArray>, mtm: MainThreadMarker);

        /// Returns a URL from a pasteboard
        ///
        /// Parameter `pasteboard`: The pasteboard with a URL
        ///
        /// Returns: A URL if the pasteboard has one. Nil if it does not.
        ///
        /// This method differs than NSURL's URLFromPasteboard method in that it tries multiple pasteboard types
        /// including NSURLPboardType to find a URL on the pasteboard.
        ///
        /// # Safety
        ///
        /// `pasteboard` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(URLFromPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLFromPasteboard(
            pasteboard: Option<&NSPasteboard>,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSURL>>;

        /// Returns a URL title from a pasteboard
        ///
        /// Parameter `pasteboard`: The pasteboard with a URL title
        ///
        /// Returns: A URL title if the pasteboard has one. Nil if it does not.
        ///
        /// This method returns a title that refers a URL on the pasteboard. An example of this is the link label
        /// which is the text inside the anchor tag.
        ///
        /// # Safety
        ///
        /// `pasteboard` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(URLTitleFromPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLTitleFromPasteboard(
            pasteboard: Option<&NSPasteboard>,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSString>>;

        /// Adds the scheme to the list of schemes to be treated as local.
        ///
        /// Parameter `scheme`: The scheme to register
        ///
        /// # Safety
        ///
        /// `scheme` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(registerURLSchemeAsLocal:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerURLSchemeAsLocal(scheme: Option<&NSString>, mtm: MainThreadMarker);

        /// The designated initializer for WebView.
        ///
        /// Initialize a WebView with the supplied parameters. This method will
        /// create a main WebFrame with the view. Passing a top level frame name is useful if you
        /// handle a targetted frame navigation that would normally open a window in some other
        /// way that still ends up creating a new WebView.
        ///
        /// Parameter `frame`: The frame used to create the view.
        ///
        /// Parameter `frameName`: The name to use for the top level frame. May be nil.
        ///
        /// Parameter `groupName`: The name of the webView set to which this webView will be added.  May be nil.
        ///
        /// Returns: Returns an initialized WebView.
        ///
        /// # Safety
        ///
        /// - `frame_name` might not allow `None`.
        /// - `group_name` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(initWithFrame:frameName:groupName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame_frameName_groupName(
            this: Allocated<Self>,
            frame: NSRect,
            frame_name: Option<&NSString>,
            group_name: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        /// Closes the receiver, unloading its web page and canceling any pending loads.
        /// Once the receiver has closed, it will no longer respond to requests or fire delegate methods.
        /// (However, the -close method itself may fire delegate methods.)
        ///
        /// A garbage collected application is required to call close when the receiver is no longer needed.
        /// The close method will be called automatically when the window or hostWindow closes and shouldCloseWithWindow returns YES.
        /// A non-garbage collected application can still call close, providing a convenient way to prevent receiver
        /// from doing any more loading and firing any future delegate methods.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(close))]
        #[unsafe(method_family = none)]
        pub unsafe fn close(&self);

        /// Whether the receiver closes when either it's window or hostWindow closes.
        ///
        /// Defaults to YES in garbage collected applications, otherwise NO to maintain backwards compatibility.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(shouldCloseWithWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldCloseWithWindow(&self) -> bool;

        /// Setter for [`shouldCloseWithWindow`][Self::shouldCloseWithWindow].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setShouldCloseWithWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldCloseWithWindow(&self, should_close_with_window: bool);

        #[cfg(feature = "WebUIDelegate")]
        /// The WebView's WebUIDelegate.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(UIDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn UIDelegate(&self) -> Option<Retained<ProtocolObject<dyn WebUIDelegate>>>;

        #[cfg(feature = "WebUIDelegate")]
        /// Setter for [`UIDelegate`][Self::UIDelegate].
        ///
        /// # Safety
        ///
        /// - `ui_delegate` might not allow `None`.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setUIDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUIDelegate(&self, ui_delegate: Option<&ProtocolObject<dyn WebUIDelegate>>);

        #[cfg(feature = "WebResourceLoadDelegate")]
        /// The WebView's WebResourceLoadDelegate.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(resourceLoadDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn resourceLoadDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WebResourceLoadDelegate>>>;

        #[cfg(feature = "WebResourceLoadDelegate")]
        /// Setter for [`resourceLoadDelegate`][Self::resourceLoadDelegate].
        ///
        /// # Safety
        ///
        /// - `resource_load_delegate` might not allow `None`.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setResourceLoadDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResourceLoadDelegate(
            &self,
            resource_load_delegate: Option<&ProtocolObject<dyn WebResourceLoadDelegate>>,
        );

        #[cfg(feature = "WebDownload")]
        /// The WebView's WebDownloadDelegate.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(downloadDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn downloadDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WebDownloadDelegate>>>;

        #[cfg(feature = "WebDownload")]
        /// Setter for [`downloadDelegate`][Self::downloadDelegate].
        ///
        /// # Safety
        ///
        /// - `download_delegate` might not allow `None`.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setDownloadDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDownloadDelegate(
            &self,
            download_delegate: Option<&ProtocolObject<dyn WebDownloadDelegate>>,
        );

        #[cfg(feature = "WebFrameLoadDelegate")]
        /// The WebView's WebFrameLoadDelegate delegate.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(frameLoadDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameLoadDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WebFrameLoadDelegate>>>;

        #[cfg(feature = "WebFrameLoadDelegate")]
        /// Setter for [`frameLoadDelegate`][Self::frameLoadDelegate].
        ///
        /// # Safety
        ///
        /// - `frame_load_delegate` might not allow `None`.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setFrameLoadDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrameLoadDelegate(
            &self,
            frame_load_delegate: Option<&ProtocolObject<dyn WebFrameLoadDelegate>>,
        );

        #[cfg(feature = "WebPolicyDelegate")]
        /// The WebView's WebPolicyDelegate.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(policyDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn policyDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WebPolicyDelegate>>>;

        #[cfg(feature = "WebPolicyDelegate")]
        /// Setter for [`policyDelegate`][Self::policyDelegate].
        ///
        /// # Safety
        ///
        /// - `policy_delegate` might not allow `None`.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setPolicyDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPolicyDelegate(
            &self,
            policy_delegate: Option<&ProtocolObject<dyn WebPolicyDelegate>>,
        );

        #[cfg(feature = "WebFrame")]
        /// The top level frame.
        ///
        /// Note that even documents that are not framesets will have a mainFrame.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(mainFrame))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainFrame(&self) -> Option<Retained<WebFrame>>;

        #[cfg(feature = "WebFrame")]
        /// The frame that has the active selection.
        ///
        /// Returns the frame that contains the first responder, if any. Otherwise returns the
        /// frame that contains a non-zero-length selection, if any. Returns nil if no frame meets these criteria.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(selectedFrame))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedFrame(&self) -> Option<Retained<WebFrame>>;

        #[cfg(feature = "WebBackForwardList")]
        /// The backforward list for this WebView.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(backForwardList))]
        #[unsafe(method_family = none)]
        pub unsafe fn backForwardList(&self) -> Option<Retained<WebBackForwardList>>;

        /// Enable or disable the use of a backforward list for this webView.
        ///
        /// Parameter `flag`: Turns use of the back forward list on or off
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setMaintainsBackForwardList:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaintainsBackForwardList(&self, flag: bool);

        /// Go back to the previous URL in the backforward list.
        ///
        /// Returns: YES if able to go back in the backforward list, NO otherwise.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(goBack))]
        #[unsafe(method_family = none)]
        pub unsafe fn goBack(&self) -> bool;

        /// Go forward to the next URL in the backforward list.
        ///
        /// Returns: YES if able to go forward in the backforward list, NO otherwise.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(goForward))]
        #[unsafe(method_family = none)]
        pub unsafe fn goForward(&self) -> bool;

        #[cfg(feature = "WebHistoryItem")]
        /// Go back or forward to an item in the backforward list.
        ///
        /// Returns: YES if able to go to the item, NO otherwise.
        ///
        /// # Safety
        ///
        /// `item` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(goToBackForwardItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn goToBackForwardItem(&self, item: Option<&WebHistoryItem>) -> bool;

        /// The text size multipler.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(textSizeMultiplier))]
        #[unsafe(method_family = none)]
        pub unsafe fn textSizeMultiplier(&self) -> c_float;

        /// Setter for [`textSizeMultiplier`][Self::textSizeMultiplier].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setTextSizeMultiplier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextSizeMultiplier(&self, text_size_multiplier: c_float);

        /// The name of the application as used in the user-agent string.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(applicationNameForUserAgent))]
        #[unsafe(method_family = none)]
        pub unsafe fn applicationNameForUserAgent(&self) -> Retained<NSString>;

        /// Setter for [`applicationNameForUserAgent`][Self::applicationNameForUserAgent].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setApplicationNameForUserAgent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setApplicationNameForUserAgent(
            &self,
            application_name_for_user_agent: Option<&NSString>,
        );

        /// The custom user-agent string or nil if no custom user-agent string has been set.
        ///
        /// Setting this means that the webView should use this user-agent string
        /// instead of constructing a user-agent string for each URL. Setting it to nil
        /// causes the webView to construct the user-agent string for each URL
        /// for best results rendering web pages
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(customUserAgent))]
        #[unsafe(method_family = none)]
        pub unsafe fn customUserAgent(&self) -> Retained<NSString>;

        /// Setter for [`customUserAgent`][Self::customUserAgent].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setCustomUserAgent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomUserAgent(&self, custom_user_agent: Option<&NSString>);

        /// Get the appropriate user-agent string for a particular URL.
        ///
        /// Parameter `URL`: The URL.
        ///
        /// Returns: The user-agent string for the supplied URL.
        ///
        /// # Safety
        ///
        /// `url` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(userAgentForURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn userAgentForURL(&self, url: Option<&NSURL>) -> Option<Retained<NSString>>;

        /// If the document view of the current web page can support different text encodings.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(supportsTextEncoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn supportsTextEncoding(&self) -> bool;

        /// The custom text encoding name or nil if no custom text encoding name has been set.
        ///
        /// Make the page display with a different text encoding; stops any load in progress.
        /// The text encoding passed in overrides the normal text encoding smarts including
        /// what's specified in a web page's header or HTTP response.
        /// The text encoding automatically goes back to the default when the top level frame
        /// changes to a new location.
        /// Setting the text encoding name to nil makes the webView use default encoding rules.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(customTextEncodingName))]
        #[unsafe(method_family = none)]
        pub unsafe fn customTextEncodingName(&self) -> Retained<NSString>;

        /// Setter for [`customTextEncodingName`][Self::customTextEncodingName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setCustomTextEncodingName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomTextEncodingName(
            &self,
            custom_text_encoding_name: Option<&NSString>,
        );

        /// The media style for the WebView.
        ///
        /// The mediaStyle will override the normal value
        /// of the CSS media property. Setting the value to nil will restore the normal value. The value will be nil unless explicitly set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(mediaStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn mediaStyle(&self) -> Retained<NSString>;

        /// Setter for [`mediaStyle`][Self::mediaStyle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setMediaStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMediaStyle(&self, media_style: Option<&NSString>);

        /// Parameter `script`: The text of the JavaScript.
        ///
        /// Returns: The result of the script, converted to a string, or nil for failure.
        ///
        /// # Safety
        ///
        /// `script` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(stringByEvaluatingJavaScriptFromString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByEvaluatingJavaScriptFromString(
            &self,
            script: Option<&NSString>,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "WebScriptObject")]
        /// A WebScriptObject that represents the
        /// window object from the script environment.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(windowScriptObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowScriptObject(&self) -> Option<Retained<WebScriptObject>>;

        #[cfg(feature = "WebPreferences")]
        /// The preferences used by this WebView.
        ///
        /// This method will return [WebPreferences standardPreferences] if no
        /// other instance of WebPreferences has been set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(preferences))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferences(&self) -> Option<Retained<WebPreferences>>;

        #[cfg(feature = "WebPreferences")]
        /// Setter for [`preferences`][Self::preferences].
        ///
        /// # Safety
        ///
        /// `preferences` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setPreferences:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferences(&self, preferences: Option<&WebPreferences>);

        /// The WebPreferences key prefix.
        ///
        /// If the WebPreferences for this WebView are stored in the user defaults database, this string will be used as a key prefix.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(preferencesIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferencesIdentifier(&self) -> Retained<NSString>;

        /// Setter for [`preferencesIdentifier`][Self::preferencesIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setPreferencesIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferencesIdentifier(&self, preferences_identifier: Option<&NSString>);

        /// The host window for the web view.
        ///
        /// Parts of WebKit (such as plug-ins and JavaScript) depend on a window to function
        /// properly. Set a host window so these parts continue to function even when the web view is
        /// not in an actual window.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(hostWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn hostWindow(&self) -> Option<Retained<NSWindow>>;

        /// Setter for [`hostWindow`][Self::hostWindow].
        ///
        /// # Safety
        ///
        /// `host_window` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setHostWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHostWindow(&self, host_window: Option<&NSWindow>);

        /// Searches a document view for a string and highlights the string if it is found.
        /// Starts the search from the current selection.  Will search across all frames.
        ///
        /// Parameter `string`: The string to search for.
        ///
        /// Parameter `forward`: YES to search forward, NO to seach backwards.
        ///
        /// Parameter `caseFlag`: YES to for case-sensitive search, NO for case-insensitive search.
        ///
        /// Returns: YES if found, NO if not found.
        ///
        /// # Safety
        ///
        /// `string` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(searchFor:direction:caseSensitive:wrap:))]
        #[unsafe(method_family = none)]
        pub unsafe fn searchFor_direction_caseSensitive_wrap(
            &self,
            string: Option<&NSString>,
            forward: bool,
            case_flag: bool,
            wrap_flag: bool,
        ) -> bool;

        /// Register classes that implement WebDocumentView and WebDocumentRepresentation respectively.
        /// A document class may register for a primary MIME type by excluding
        /// a subtype, i.e. "video/" will match the document class with
        /// all video types.  More specific matching takes precedence
        /// over general matching.
        ///
        /// Parameter `viewClass`: The WebDocumentView class to use to render data for a given MIME type.
        ///
        /// Parameter `representationClass`: The WebDocumentRepresentation class to use to represent data of the given MIME type.
        ///
        /// Parameter `MIMEType`: The MIME type to represent with an object of the given class.
        ///
        /// # Safety
        ///
        /// - `view_class` probably has further requirements.
        /// - `view_class` might not allow `None`.
        /// - `representation_class` probably has further requirements.
        /// - `representation_class` might not allow `None`.
        /// - `mime_type` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(registerViewClass:representationClass:forMIMEType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerViewClass_representationClass_forMIMEType(
            view_class: Option<&AnyClass>,
            representation_class: Option<&AnyClass>,
            mime_type: Option<&NSString>,
            mtm: MainThreadMarker,
        );

        /// The group name for this WebView.
        ///
        /// JavaScript may access named frames within the same group.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(groupName))]
        #[unsafe(method_family = none)]
        pub unsafe fn groupName(&self) -> Retained<NSString>;

        /// Setter for [`groupName`][Self::groupName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setGroupName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGroupName(&self, group_name: Option<&NSString>);

        /// An estimate of the percent complete for a document load.  This
        /// value will range from 0 to 1.0 and, once a load completes, will remain at 1.0
        /// until a new load starts, at which point it will be reset to 0.  The value is an
        /// estimate based on the total number of bytes expected to be received
        /// for a document, including all it's possible subresources.  For more accurate progress
        /// indication it is recommended that you implement a WebFrameLoadDelegate and a
        /// WebResourceLoadDelegate.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(estimatedProgress))]
        #[unsafe(method_family = none)]
        pub unsafe fn estimatedProgress(&self) -> c_double;

        /// Whether there are any pending loads in this WebView.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(isLoading))]
        #[unsafe(method_family = none)]
        pub unsafe fn isLoading(&self) -> bool;

        /// Parameter `point`: A point in the coordinates of the WebView
        ///
        /// Returns: An element dictionary describing the point
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(elementAtPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementAtPoint(&self, point: NSPoint) -> Option<Retained<NSDictionary>>;

        /// The pasteboard types that the WebView can use for the current selection
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(pasteboardTypesForSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteboardTypesForSelection(&self) -> Retained<NSArray>;

        /// Writes the current selection to the pasteboard
        ///
        /// Parameter `types`: The types that WebView will write to the pasteboard
        ///
        /// Parameter `pasteboard`: The pasteboard to write to
        ///
        /// # Safety
        ///
        /// - `types` generic should be of the correct type.
        /// - `types` might not allow `None`.
        /// - `pasteboard` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(writeSelectionWithPasteboardTypes:toPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeSelectionWithPasteboardTypes_toPasteboard(
            &self,
            types: Option<&NSArray>,
            pasteboard: Option<&NSPasteboard>,
        );

        /// Returns the pasteboard types that WebView can use for an element
        ///
        /// Parameter `element`: The element
        ///
        /// # Safety
        ///
        /// - `element` generic should be of the correct type.
        /// - `element` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(pasteboardTypesForElement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteboardTypesForElement(
            &self,
            element: Option<&NSDictionary>,
        ) -> Option<Retained<NSArray>>;

        /// Writes an element to the pasteboard
        ///
        /// Parameter `element`: The element to write to the pasteboard
        ///
        /// Parameter `types`: The types that WebView will write to the pasteboard
        ///
        /// Parameter `pasteboard`: The pasteboard to write to
        ///
        /// # Safety
        ///
        /// - `element` generic should be of the correct type.
        /// - `element` might not allow `None`.
        /// - `types` generic should be of the correct type.
        /// - `types` might not allow `None`.
        /// - `pasteboard` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(writeElement:withPasteboardTypes:toPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeElement_withPasteboardTypes_toPasteboard(
            &self,
            element: Option<&NSDictionary>,
            types: Option<&NSArray>,
            pasteboard: Option<&NSPasteboard>,
        );

        /// Parameter `point`: A point in the coordinates of the WebView
        ///
        /// This method moves the caret that shows where something being dragged will be dropped. It may cause the WebView to scroll
        /// to make the new position of the drag caret visible.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(moveDragCaretToPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveDragCaretToPoint(&self, point: NSPoint);

        /// Removes the drag caret from the WebView
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(removeDragCaret))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeDragCaret(&self);

        /// Whether the receiver draws a default white background when the loaded page has no background specified.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(drawsBackground))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawsBackground(&self) -> bool;

        /// Setter for [`drawsBackground`][Self::drawsBackground].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setDrawsBackground:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDrawsBackground(&self, draws_background: bool);

        /// Whether the WebView is always updated even when it is not in a window that is currently visible.
        ///
        /// If set to NO, then whenever the web view is not in a visible window, updates to the web page will not necessarily be rendered in the view.
        /// However, when the window is made visible, the view will be updated automatically. Not updating while hidden can improve performance. If set to is YES,
        /// hidden web views are always updated. This is the default.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(shouldUpdateWhileOffscreen))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldUpdateWhileOffscreen(&self) -> bool;

        /// Setter for [`shouldUpdateWhileOffscreen`][Self::shouldUpdateWhileOffscreen].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setShouldUpdateWhileOffscreen:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldUpdateWhileOffscreen(&self, should_update_while_offscreen: bool);

        /// The main frame's current URL.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(mainFrameURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainFrameURL(&self) -> Retained<NSString>;

        /// Setter for [`mainFrameURL`][Self::mainFrameURL].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setMainFrameURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMainFrameURL(&self, main_frame_url: Option<&NSString>);

        #[cfg(all(
            feature = "DOMDocument",
            feature = "DOMNode",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// The main frame's DOMDocument.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(mainFrameDocument))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainFrameDocument(&self) -> Option<Retained<DOMDocument>>;

        /// The main frame's title if any, otherwise an empty string.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(mainFrameTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainFrameTitle(&self) -> Retained<NSString>;

        /// The site icon for the current page loaded in the mainFrame, or nil.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(mainFrameIcon))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainFrameIcon(&self) -> Option<Retained<NSImage>>;
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// WebIBActions.
#[deprecated = "No longer supported; please adopt WKWebView."]
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(takeStringURLFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeStringURLFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(stopLoading:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopLoading(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(reload:))]
        #[unsafe(method_family = none)]
        pub unsafe fn reload(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(reloadFromOrigin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadFromOrigin(&self, sender: Option<&AnyObject>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canGoBack))]
        #[unsafe(method_family = none)]
        pub unsafe fn canGoBack(&self) -> bool;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(goBack:))]
        #[unsafe(method_family = none)]
        pub unsafe fn goBack_(&self, sender: Option<&AnyObject>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canGoForward))]
        #[unsafe(method_family = none)]
        pub unsafe fn canGoForward(&self) -> bool;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(goForward:))]
        #[unsafe(method_family = none)]
        pub unsafe fn goForward_(&self, sender: Option<&AnyObject>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canMakeTextLarger))]
        #[unsafe(method_family = none)]
        pub unsafe fn canMakeTextLarger(&self) -> bool;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(makeTextLarger:))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeTextLarger(&self, sender: Option<&AnyObject>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canMakeTextSmaller))]
        #[unsafe(method_family = none)]
        pub unsafe fn canMakeTextSmaller(&self) -> bool;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(makeTextSmaller:))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeTextSmaller(&self, sender: Option<&AnyObject>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(canMakeTextStandardSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn canMakeTextStandardSize(&self) -> bool;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(makeTextStandardSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeTextStandardSize(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(toggleContinuousSpellChecking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleContinuousSpellChecking(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(toggleSmartInsertDelete:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleSmartInsertDelete(&self, sender: Option<&AnyObject>);
    );
}

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for WebView {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewdidbegineditingnotification?language=objc)
    #[deprecated]
    pub static WebViewDidBeginEditingNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewdidchangenotification?language=objc)
    #[deprecated]
    pub static WebViewDidChangeNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewdidendeditingnotification?language=objc)
    #[deprecated]
    pub static WebViewDidEndEditingNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewdidchangetypingstylenotification?language=objc)
    #[deprecated]
    pub static WebViewDidChangeTypingStyleNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webviewdidchangeselectionnotification?language=objc)
    #[deprecated]
    pub static WebViewDidChangeSelectionNotification: Option<&'static NSString>;
}

/// WebViewCSS.
#[deprecated = "No longer supported; please adopt WKWebView."]
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        #[cfg(all(
            feature = "DOMCSSStyleDeclaration",
            feature = "DOMElement",
            feature = "DOMNode",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// # Safety
        ///
        /// - `element` might not allow `None`.
        /// - `pseudo_element` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(computedStyleForElement:pseudoElement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn computedStyleForElement_pseudoElement(
            &self,
            element: Option<&DOMElement>,
            pseudo_element: Option<&NSString>,
        ) -> Option<Retained<DOMCSSStyleDeclaration>>;
    );
}

/// WebViewEditing.
#[deprecated = "No longer supported; please adopt WKWebView."]
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        #[cfg(all(
            feature = "DOMObject",
            feature = "DOMRange",
            feature = "WebScriptObject"
        ))]
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(editableDOMRangeForPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn editableDOMRangeForPoint(&self, point: NSPoint)
            -> Option<Retained<DOMRange>>;

        #[cfg(all(
            feature = "DOMObject",
            feature = "DOMRange",
            feature = "WebScriptObject"
        ))]
        /// # Safety
        ///
        /// `range` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setSelectedDOMRange:affinity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedDOMRange_affinity(
            &self,
            range: Option<&DOMRange>,
            selection_affinity: NSSelectionAffinity,
        );

        #[cfg(all(
            feature = "DOMObject",
            feature = "DOMRange",
            feature = "WebScriptObject"
        ))]
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(selectedDOMRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedDOMRange(&self) -> Option<Retained<DOMRange>>;

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(selectionAffinity))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionAffinity(&self) -> NSSelectionAffinity;

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(maintainsInactiveSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn maintainsInactiveSelection(&self) -> bool;

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEditable(&self) -> bool;

        /// Setter for [`isEditable`][Self::isEditable].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setEditable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditable(&self, editable: bool);

        #[cfg(all(
            feature = "DOMCSSStyleDeclaration",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(typingStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn typingStyle(&self) -> Option<Retained<DOMCSSStyleDeclaration>>;

        #[cfg(all(
            feature = "DOMCSSStyleDeclaration",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// Setter for [`typingStyle`][Self::typingStyle].
        ///
        /// # Safety
        ///
        /// `typing_style` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setTypingStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTypingStyle(&self, typing_style: Option<&DOMCSSStyleDeclaration>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(smartInsertDeleteEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn smartInsertDeleteEnabled(&self) -> bool;

        /// Setter for [`smartInsertDeleteEnabled`][Self::smartInsertDeleteEnabled].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setSmartInsertDeleteEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSmartInsertDeleteEnabled(&self, smart_insert_delete_enabled: bool);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(isContinuousSpellCheckingEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isContinuousSpellCheckingEnabled(&self) -> bool;

        /// Setter for [`isContinuousSpellCheckingEnabled`][Self::isContinuousSpellCheckingEnabled].
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setContinuousSpellCheckingEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContinuousSpellCheckingEnabled(
            &self,
            continuous_spell_checking_enabled: bool,
        );

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(spellCheckerDocumentTag))]
        #[unsafe(method_family = none)]
        pub unsafe fn spellCheckerDocumentTag(&self) -> NSInteger;

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(undoManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn undoManager(&self) -> Option<Retained<NSUndoManager>>;

        #[cfg(feature = "WebEditingDelegate")]
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(editingDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn editingDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WebEditingDelegate>>>;

        #[cfg(feature = "WebEditingDelegate")]
        /// Setter for [`editingDelegate`][Self::editingDelegate].
        ///
        /// # Safety
        ///
        /// - `editing_delegate` might not allow `None`.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(setEditingDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditingDelegate(
            &self,
            editing_delegate: Option<&ProtocolObject<dyn WebEditingDelegate>>,
        );

        #[cfg(all(
            feature = "DOMCSSStyleDeclaration",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// # Safety
        ///
        /// `text` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(styleDeclarationWithText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn styleDeclarationWithText(
            &self,
            text: Option<&NSString>,
        ) -> Option<Retained<DOMCSSStyleDeclaration>>;
    );
}

/// WebViewUndoableEditing.
#[deprecated = "No longer supported; please adopt WKWebView."]
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        #[cfg(all(
            feature = "DOMNode",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// # Safety
        ///
        /// `node` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(replaceSelectionWithNode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceSelectionWithNode(&self, node: Option<&DOMNode>);

        /// # Safety
        ///
        /// `text` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(replaceSelectionWithText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceSelectionWithText(&self, text: Option<&NSString>);

        /// # Safety
        ///
        /// `markup_string` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(replaceSelectionWithMarkupString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceSelectionWithMarkupString(&self, markup_string: Option<&NSString>);

        #[cfg(feature = "WebArchive")]
        /// # Safety
        ///
        /// `archive` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(replaceSelectionWithArchive:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceSelectionWithArchive(&self, archive: Option<&WebArchive>);

        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(deleteSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteSelection(&self);

        #[cfg(all(
            feature = "DOMCSSStyleDeclaration",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// # Safety
        ///
        /// `style` might not allow `None`.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(applyStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn applyStyle(&self, style: Option<&DOMCSSStyleDeclaration>);
    );
}

/// WebViewEditingActions.
#[deprecated = "No longer supported; please adopt WKWebView."]
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WebView {
    extern_methods!(
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(copy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn copy(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(cut:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cut(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(paste:))]
        #[unsafe(method_family = none)]
        pub unsafe fn paste(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(copyFont:))]
        #[unsafe(method_family = none)]
        pub unsafe fn copyFont(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(pasteFont:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteFont(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(delete:))]
        #[unsafe(method_family = none)]
        pub unsafe fn delete(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(pasteAsPlainText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteAsPlainText(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(pasteAsRichText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteAsRichText(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(changeFont:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeFont(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(changeAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeAttributes(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(changeDocumentBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeDocumentBackgroundColor(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(changeColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeColor(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(alignCenter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignCenter(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(alignJustified:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignJustified(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(alignLeft:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignLeft(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(alignRight:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignRight(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(checkSpelling:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkSpelling(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(showGuessPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showGuessPanel(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(performFindPanelAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performFindPanelAction(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(startSpeaking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn startSpeaking(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(stopSpeaking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopSpeaking(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(moveToBeginningOfSentence:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveToBeginningOfSentence(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(moveToBeginningOfSentenceAndModifySelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveToBeginningOfSentenceAndModifySelection(
            &self,
            sender: Option<&AnyObject>,
        );

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(moveToEndOfSentence:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveToEndOfSentence(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(moveToEndOfSentenceAndModifySelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveToEndOfSentenceAndModifySelection(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(selectSentence:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectSentence(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[deprecated = "No longer supported; please adopt WKWebView."]
        #[unsafe(method(overWrite:))]
        #[unsafe(method_family = none)]
        pub unsafe fn overWrite(&self, sender: Option<&AnyObject>);
    );
}
