//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-javascript-core")]
use objc2_javascript_core::*;

use crate::*;

mod private_NSObjectWebScripting {
    pub trait Sealed {}
}

/// Category "WebScripting" on [`NSObject`].
#[doc(alias = "WebScripting")]
pub unsafe trait NSObjectWebScripting:
    ClassType + Sized + private_NSObjectWebScripting::Sealed
{
    extern_methods!(
        /// Parameter `selector`: The selector that will be exposed to the script environment.
        ///
        /// Use the returned string as the exported name for the selector
        /// in the script environment. It is the responsibility of the class to ensure
        /// uniqueness of the returned name. If nil is returned or this
        /// method is not implemented the default name for the selector will
        /// be used. The default name concatenates the components of the
        /// Objective-C selector name and replaces ':' with '_'.  '_' characters
        /// are escaped with an additional '$', i.e. '_' becomes "$_". '$' are
        /// also escaped, i.e.
        /// Objective-C name        Default script name
        /// moveTo::                move__
        /// moveTo_                 moveTo$_
        /// moveTo$_                moveTo$$$_
        ///
        /// Returns: Returns the name to be used to represent the specified selector in the
        /// scripting environment.
        ///
        /// # Safety
        ///
        /// `selector` must be a valid selector.
        #[unsafe(method(webScriptNameForSelector:))]
        #[unsafe(method_family = none)]
        unsafe fn webScriptNameForSelector(selector: Option<Sel>) -> Option<Retained<NSString>>;

        /// Parameter `selector`: The selector the will be exposed to the script environment.
        ///
        /// Return NO to export the selector to the script environment.
        /// Return YES to prevent the selector from being exported to the script environment.
        /// If this method is not implemented on the class no selectors will be exported.
        ///
        /// Returns: Returns YES to hide the selector, NO to export the selector.
        ///
        /// # Safety
        ///
        /// `selector` must be a valid selector.
        #[unsafe(method(isSelectorExcludedFromWebScript:))]
        #[unsafe(method_family = none)]
        unsafe fn isSelectorExcludedFromWebScript(selector: Option<Sel>) -> bool;

        /// Parameter `name`: The name of the instance variable that will be exposed to the
        /// script environment. Only instance variables that meet the export criteria will
        /// be exposed.
        ///
        /// Provide an alternate name for a property.
        ///
        /// Returns: Returns the name to be used to represent the specified property in the
        /// scripting environment.
        ///
        /// # Safety
        ///
        /// `name` must be a valid pointer.
        #[unsafe(method(webScriptNameForKey:))]
        #[unsafe(method_family = none)]
        unsafe fn webScriptNameForKey(name: *const c_char) -> Option<Retained<NSString>>;

        /// Parameter `name`: The name of the instance variable that will be exposed to the
        /// script environment.
        ///
        /// Return NO to export the property to the script environment.
        /// Return YES to prevent the property from being exported to the script environment.
        ///
        /// Returns: Returns YES to hide the property, NO to export the property.
        ///
        /// # Safety
        ///
        /// `name` must be a valid pointer.
        #[unsafe(method(isKeyExcludedFromWebScript:))]
        #[unsafe(method_family = none)]
        unsafe fn isKeyExcludedFromWebScript(name: *const c_char) -> bool;

        /// Parameter `name`: The name of the method to invoke.
        ///
        /// Parameter `arguments`: The arguments to pass the method.
        ///
        /// If a script attempts to invoke a method that is not exported,
        /// invokeUndefinedMethodFromWebScript:withArguments: will be called.
        ///
        /// Returns: The return value of the invocation. The value will be converted as appropriate
        /// for the script environment.
        ///
        /// # Safety
        ///
        /// - `name` might not allow `None`.
        /// - `arguments` generic should be of the correct type.
        /// - `arguments` might not allow `None`.
        #[unsafe(method(invokeUndefinedMethodFromWebScript:withArguments:))]
        #[unsafe(method_family = none)]
        unsafe fn invokeUndefinedMethodFromWebScript_withArguments(
            &self,
            name: Option<&NSString>,
            arguments: Option<&NSArray>,
        ) -> Option<Retained<AnyObject>>;

        /// Parameter `arguments`: The arguments to pass the method.
        ///
        /// If a script attempts to call an exposed object as a function,
        /// this method will be called.
        ///
        /// Returns: The return value of the call. The value will be converted as appropriate
        /// for the script environment.
        ///
        /// # Safety
        ///
        /// - `arguments` generic should be of the correct type.
        /// - `arguments` might not allow `None`.
        #[unsafe(method(invokeDefaultMethodWithArguments:))]
        #[unsafe(method_family = none)]
        unsafe fn invokeDefaultMethodWithArguments(
            &self,
            arguments: Option<&NSArray>,
        ) -> Option<Retained<AnyObject>>;

        /// finalizeForScript is called on objects exposed to the script
        /// environment just before the script environment garbage collects the object.
        /// Subsequently, any references to WebScriptObjects made by the exposed object will
        /// be invalid and have undefined consequences.
        #[unsafe(method(finalizeForWebScript))]
        #[unsafe(method_family = none)]
        unsafe fn finalizeForWebScript(&self);
    );
}

impl private_NSObjectWebScripting::Sealed for NSObject {}
unsafe impl NSObjectWebScripting for NSObject {}

extern_class!(
    /// WebScriptObjects are used to wrap script objects passed from
    /// script environments to Objective-C. WebScriptObjects cannot be created
    /// directly. In normal uses of WebKit, you gain access to the script
    /// environment using the "windowScriptObject" method on WebView.
    ///
    /// The following KVC methods are commonly used to access properties of the
    /// WebScriptObject:
    ///
    /// - (void)setValue:(id)value forKey:(NSString *)key
    /// - (id)valueForKey:(NSString *)key
    ///
    /// As it possible to remove attributes from web script objects, the following
    /// additional method augments the basic KVC methods:
    ///
    /// - (void)removeWebScriptKey:(NSString *)name;
    ///
    /// Also, since the sparse array access allowed in script objects doesn't map well
    /// to NSArray, the following methods can be used to access index based properties:
    ///
    /// - (id)webScriptValueAtIndex:(unsigned)index;
    /// - (void)setWebScriptValueAtIndex:(unsigned)index value:(id)value;
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webscriptobject?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebScriptObject;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WebScriptObject {}
);

impl WebScriptObject {
    extern_methods!(
        /// Throws an exception in the current script execution context.
        ///
        /// Returns: Either NO if an exception could not be raised, YES otherwise.
        ///
        /// # Safety
        ///
        /// `exception_message` might not allow `None`.
        #[deprecated]
        #[unsafe(method(throwException:))]
        #[unsafe(method_family = none)]
        pub unsafe fn throwException(exception_message: Option<&NSString>) -> bool;

        #[cfg(feature = "objc2-javascript-core")]
        /// Returns: The equivalent JSObjectRef for this WebScriptObject.
        ///
        /// Use this method to bridge between the WebScriptObject and
        /// JavaScriptCore APIs.
        #[unsafe(method(JSObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn JSObject(&self) -> JSObjectRef;

        /// Parameter `name`: The name of the method to call in the script environment.
        ///
        /// Parameter `arguments`: The arguments to pass to the script environment.
        ///
        /// Calls the specified method in the script environment using the
        /// specified arguments.
        ///
        /// Returns: Returns the result of calling the script method.
        /// Returns WebUndefined when an exception is thrown in the script environment.
        ///
        /// # Safety
        ///
        /// - `name` might not allow `None`.
        /// - `arguments` generic should be of the correct type.
        /// - `arguments` might not allow `None`.
        #[deprecated]
        #[unsafe(method(callWebScriptMethod:withArguments:))]
        #[unsafe(method_family = none)]
        pub unsafe fn callWebScriptMethod_withArguments(
            &self,
            name: Option<&NSString>,
            arguments: Option<&NSArray>,
        ) -> Option<Retained<AnyObject>>;

        /// Parameter `script`: The script to execute in the target script environment.
        ///
        /// The script will be executed in the target script environment. The format
        /// of the script is dependent of the target script environment.
        ///
        /// Returns: Returns the result of evaluating the script in the script environment.
        /// Returns WebUndefined when an exception is thrown in the script environment.
        ///
        /// # Safety
        ///
        /// `script` might not allow `None`.
        #[deprecated]
        #[unsafe(method(evaluateWebScript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn evaluateWebScript(
            &self,
            script: Option<&NSString>,
        ) -> Option<Retained<AnyObject>>;

        /// Parameter `name`: The name of the property to remove.
        ///
        /// Removes the property from the object in the script environment.
        ///
        /// # Safety
        ///
        /// `name` might not allow `None`.
        #[deprecated]
        #[unsafe(method(removeWebScriptKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeWebScriptKey(&self, name: Option<&NSString>);

        /// Converts the target object to a string representation. The coercion
        /// of non string objects type is dependent on the script environment.
        ///
        /// Returns: Returns the string representation of the object.
        #[deprecated]
        #[unsafe(method(stringRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringRepresentation(&self) -> Option<Retained<NSString>>;

        /// Parameter `index`: The index of the property to return.
        ///
        /// Gets the value of the property at the specified index.
        ///
        /// Returns: The value of the property. Returns WebUndefined when an exception is
        /// thrown in the script environment.
        #[deprecated]
        #[unsafe(method(webScriptValueAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn webScriptValueAtIndex(&self, index: c_uint) -> Option<Retained<AnyObject>>;

        /// Parameter `index`: The index of the property to set.
        ///
        /// Parameter `value`: The value of the property to set.
        ///
        /// Sets the property value at the specified index.
        ///
        /// # Safety
        ///
        /// - `value` should be of the correct type.
        /// - `value` might not allow `None`.
        #[deprecated]
        #[unsafe(method(setWebScriptValueAtIndex:value:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWebScriptValueAtIndex_value(
            &self,
            index: c_uint,
            value: Option<&AnyObject>,
        );

        /// Parameter `description`: The description of the exception.
        ///
        /// Raises an exception in the script environment in the context of the
        /// current object.
        ///
        /// # Safety
        ///
        /// `description` might not allow `None`.
        #[deprecated]
        #[unsafe(method(setException:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setException(&self, description: Option<&NSString>);

        #[cfg(feature = "objc2-javascript-core")]
        /// Returns: The equivalent Objective-C JSValue for this WebScriptObject.
        ///
        /// Use this method to bridge between the WebScriptObject and
        /// JavaScriptCore Objective-C APIs.
        #[deprecated]
        #[unsafe(method(JSValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn JSValue(&self) -> Option<Retained<JSValue>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WebScriptObject {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webundefined?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebUndefined;
);

extern_conformance!(
    unsafe impl NSCoding for WebUndefined {}
);

extern_conformance!(
    unsafe impl NSCopying for WebUndefined {}
);

unsafe impl CopyingHelper for WebUndefined {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WebUndefined {}
);

impl WebUndefined {
    extern_methods!(
        /// Returns: The WebUndefined shared instance.
        #[deprecated]
        #[unsafe(method(undefined))]
        #[unsafe(method_family = none)]
        pub unsafe fn undefined() -> Option<Retained<WebUndefined>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WebUndefined {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
