//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A WebResource represents a fully downloaded URL.
    /// It includes the data of the resource as well as the metadata associated with the resource.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webresource?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WebResource;
);

extern_conformance!(
    unsafe impl NSCoding for WebResource {}
);

extern_conformance!(
    unsafe impl NSCopying for WebResource {}
);

unsafe impl CopyingHelper for WebResource {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WebResource {}
);

impl WebResource {
    extern_methods!(
        /// The initializer for WebResource.
        ///
        /// Parameter `data`: The data of the resource.
        ///
        /// Parameter `URL`: The URL of the resource.
        ///
        /// Parameter `MIMEType`: The MIME type of the resource.
        ///
        /// Parameter `textEncodingName`: The text encoding name of the resource (can be nil).
        ///
        /// Parameter `frameName`: The frame name of the resource if the resource represents the contents of an entire HTML frame (can be nil).
        ///
        /// Returns: An initialized WebResource.
        ///
        /// # Safety
        ///
        /// - `data` might not allow `None`.
        /// - `url` might not allow `None`.
        /// - `mime_type` might not allow `None`.
        /// - `text_encoding_name` might not allow `None`.
        /// - `frame_name` might not allow `None`.
        #[unsafe(method(initWithData:URL:MIMEType:textEncodingName:frameName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithData_URL_MIMEType_textEncodingName_frameName(
            this: Allocated<Self>,
            data: Option<&NSData>,
            url: Option<&NSURL>,
            mime_type: Option<&NSString>,
            text_encoding_name: Option<&NSString>,
            frame_name: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        /// The data of the resource.
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub unsafe fn data(&self) -> Retained<NSData>;

        /// The URL of the resource.
        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub unsafe fn URL(&self) -> Option<Retained<NSURL>>;

        /// The MIME type of the resource.
        #[unsafe(method(MIMEType))]
        #[unsafe(method_family = none)]
        pub unsafe fn MIMEType(&self) -> Retained<NSString>;

        /// The text encoding name of the resource (can be nil).
        #[unsafe(method(textEncodingName))]
        #[unsafe(method_family = none)]
        pub unsafe fn textEncodingName(&self) -> Retained<NSString>;

        /// The frame name of the resource if the resource represents the contents of an entire HTML frame (can be nil).
        #[unsafe(method(frameName))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameName(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WebResource {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
