//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Specifies a usage model for a WebView, which WebKit will use to
/// determine its caching behavior.
///
/// a fixed document -- like a splash screen, a chat document, or a word processing
/// document -- with no UI for navigation. The WebView will behave like any other
/// view, releasing resources when they are no longer referenced. Remote resources,
/// if any, will be cached to disk. This is the most memory-efficient setting.
///
/// Examples: iChat, Mail, TextMate, Growl.
///
/// a browsable series of documents with a UI for navigating between them -- for
/// example, a reference materials browser or a website designer. The WebView will
/// cache a reasonable number of resources and previously viewed documents in
/// memory and/or on disk.
///
/// Examples: Dictionary, Help Viewer, Coda.
///
/// application that acts as the user's primary web browser. The WebView will cache
/// a very large number of resources and previously viewed documents in memory
/// and/or on disk.
///
/// Examples: Safari, OmniWeb, Shiira.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webcachemodel?language=objc)
// NS_ENUM
#[deprecated]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WebCacheModel(pub NSUInteger);
impl WebCacheModel {
    #[doc(alias = "WebCacheModelDocumentViewer")]
    #[deprecated]
    pub const DocumentViewer: Self = Self(0);
    #[doc(alias = "WebCacheModelDocumentBrowser")]
    #[deprecated]
    pub const DocumentBrowser: Self = Self(1);
    #[doc(alias = "WebCacheModelPrimaryWebBrowser")]
    #[deprecated]
    pub const PrimaryWebBrowser: Self = Self(2);
}

unsafe impl Encode for WebCacheModel {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for WebCacheModel {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webpreferenceschangednotification?language=objc)
    #[deprecated]
    pub static WebPreferencesChangedNotification: Option<&'static NSString>;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webpreferences?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebPreferences;
);

extern_conformance!(
    unsafe impl NSCoding for WebPreferences {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WebPreferences {}
);

impl WebPreferences {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(standardPreferences))]
        #[unsafe(method_family = none)]
        pub unsafe fn standardPreferences() -> Option<Retained<WebPreferences>>;

        /// Parameter `anIdentifier`: A string used to identify the WebPreferences.
        ///
        /// WebViews can share instances of WebPreferences by using an instance of WebPreferences with
        /// the same identifier.  Typically, instance are not created directly.  Instead you set the preferences
        /// identifier on a WebView.  The identifier is used as a prefix that is added to the user defaults keys
        /// for the WebPreferences.
        ///
        /// Returns: Returns a new instance of WebPreferences or a previously allocated instance with the same identifier.
        ///
        /// # Safety
        ///
        /// `an_identifier` might not allow `None`.
        #[deprecated]
        #[unsafe(method(initWithIdentifier:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIdentifier(
            this: Allocated<Self>,
            an_identifier: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        /// Returns: Returns the identifier for this WebPreferences.
        #[deprecated]
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn identifier(&self) -> Retained<NSString>;

        #[deprecated]
        #[unsafe(method(standardFontFamily))]
        #[unsafe(method_family = none)]
        pub unsafe fn standardFontFamily(&self) -> Retained<NSString>;

        /// Setter for [`standardFontFamily`][Self::standardFontFamily].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setStandardFontFamily:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStandardFontFamily(&self, standard_font_family: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(fixedFontFamily))]
        #[unsafe(method_family = none)]
        pub unsafe fn fixedFontFamily(&self) -> Retained<NSString>;

        /// Setter for [`fixedFontFamily`][Self::fixedFontFamily].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setFixedFontFamily:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFixedFontFamily(&self, fixed_font_family: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(serifFontFamily))]
        #[unsafe(method_family = none)]
        pub unsafe fn serifFontFamily(&self) -> Retained<NSString>;

        /// Setter for [`serifFontFamily`][Self::serifFontFamily].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setSerifFontFamily:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSerifFontFamily(&self, serif_font_family: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(sansSerifFontFamily))]
        #[unsafe(method_family = none)]
        pub unsafe fn sansSerifFontFamily(&self) -> Retained<NSString>;

        /// Setter for [`sansSerifFontFamily`][Self::sansSerifFontFamily].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setSansSerifFontFamily:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSansSerifFontFamily(&self, sans_serif_font_family: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(cursiveFontFamily))]
        #[unsafe(method_family = none)]
        pub unsafe fn cursiveFontFamily(&self) -> Retained<NSString>;

        /// Setter for [`cursiveFontFamily`][Self::cursiveFontFamily].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setCursiveFontFamily:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCursiveFontFamily(&self, cursive_font_family: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(fantasyFontFamily))]
        #[unsafe(method_family = none)]
        pub unsafe fn fantasyFontFamily(&self) -> Retained<NSString>;

        /// Setter for [`fantasyFontFamily`][Self::fantasyFontFamily].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setFantasyFontFamily:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFantasyFontFamily(&self, fantasy_font_family: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(defaultFontSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultFontSize(&self) -> c_int;

        /// Setter for [`defaultFontSize`][Self::defaultFontSize].
        #[deprecated]
        #[unsafe(method(setDefaultFontSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultFontSize(&self, default_font_size: c_int);

        #[deprecated]
        #[unsafe(method(defaultFixedFontSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultFixedFontSize(&self) -> c_int;

        /// Setter for [`defaultFixedFontSize`][Self::defaultFixedFontSize].
        #[deprecated]
        #[unsafe(method(setDefaultFixedFontSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultFixedFontSize(&self, default_fixed_font_size: c_int);

        #[deprecated]
        #[unsafe(method(minimumFontSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumFontSize(&self) -> c_int;

        /// Setter for [`minimumFontSize`][Self::minimumFontSize].
        #[deprecated]
        #[unsafe(method(setMinimumFontSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMinimumFontSize(&self, minimum_font_size: c_int);

        #[deprecated]
        #[unsafe(method(minimumLogicalFontSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumLogicalFontSize(&self) -> c_int;

        /// Setter for [`minimumLogicalFontSize`][Self::minimumLogicalFontSize].
        #[deprecated]
        #[unsafe(method(setMinimumLogicalFontSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMinimumLogicalFontSize(&self, minimum_logical_font_size: c_int);

        #[deprecated]
        #[unsafe(method(defaultTextEncodingName))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultTextEncodingName(&self) -> Retained<NSString>;

        /// Setter for [`defaultTextEncodingName`][Self::defaultTextEncodingName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setDefaultTextEncodingName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultTextEncodingName(
            &self,
            default_text_encoding_name: Option<&NSString>,
        );

        #[deprecated]
        #[unsafe(method(userStyleSheetEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn userStyleSheetEnabled(&self) -> bool;

        /// Setter for [`userStyleSheetEnabled`][Self::userStyleSheetEnabled].
        #[deprecated]
        #[unsafe(method(setUserStyleSheetEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserStyleSheetEnabled(&self, user_style_sheet_enabled: bool);

        /// The location of the user style sheet.
        #[deprecated]
        #[unsafe(method(userStyleSheetLocation))]
        #[unsafe(method_family = none)]
        pub unsafe fn userStyleSheetLocation(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`userStyleSheetLocation`][Self::userStyleSheetLocation].
        ///
        /// # Safety
        ///
        /// `user_style_sheet_location` might not allow `None`.
        #[deprecated]
        #[unsafe(method(setUserStyleSheetLocation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserStyleSheetLocation(&self, user_style_sheet_location: Option<&NSURL>);

        /// Deprecated function that does nothing and always returns false.
        #[deprecated]
        #[unsafe(method(isJavaEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isJavaEnabled(&self) -> bool;

        /// Setter for [`isJavaEnabled`][Self::isJavaEnabled].
        #[deprecated]
        #[unsafe(method(setJavaEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setJavaEnabled(&self, java_enabled: bool);

        #[deprecated]
        #[unsafe(method(isJavaScriptEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isJavaScriptEnabled(&self) -> bool;

        /// Setter for [`isJavaScriptEnabled`][Self::isJavaScriptEnabled].
        #[deprecated]
        #[unsafe(method(setJavaScriptEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setJavaScriptEnabled(&self, java_script_enabled: bool);

        #[deprecated]
        #[unsafe(method(javaScriptCanOpenWindowsAutomatically))]
        #[unsafe(method_family = none)]
        pub unsafe fn javaScriptCanOpenWindowsAutomatically(&self) -> bool;

        /// Setter for [`javaScriptCanOpenWindowsAutomatically`][Self::javaScriptCanOpenWindowsAutomatically].
        #[deprecated]
        #[unsafe(method(setJavaScriptCanOpenWindowsAutomatically:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setJavaScriptCanOpenWindowsAutomatically(
            &self,
            java_script_can_open_windows_automatically: bool,
        );

        #[deprecated]
        #[unsafe(method(arePlugInsEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn arePlugInsEnabled(&self) -> bool;

        /// Setter for [`arePlugInsEnabled`][Self::arePlugInsEnabled].
        #[deprecated]
        #[unsafe(method(setPlugInsEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPlugInsEnabled(&self, plug_ins_enabled: bool);

        #[deprecated]
        #[unsafe(method(allowsAnimatedImages))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsAnimatedImages(&self) -> bool;

        /// Setter for [`allowsAnimatedImages`][Self::allowsAnimatedImages].
        #[deprecated]
        #[unsafe(method(setAllowsAnimatedImages:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsAnimatedImages(&self, allows_animated_images: bool);

        #[deprecated]
        #[unsafe(method(allowsAnimatedImageLooping))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsAnimatedImageLooping(&self) -> bool;

        /// Setter for [`allowsAnimatedImageLooping`][Self::allowsAnimatedImageLooping].
        #[deprecated]
        #[unsafe(method(setAllowsAnimatedImageLooping:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsAnimatedImageLooping(&self, allows_animated_image_looping: bool);

        #[deprecated]
        #[unsafe(method(loadsImagesAutomatically))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadsImagesAutomatically(&self) -> bool;

        /// Setter for [`loadsImagesAutomatically`][Self::loadsImagesAutomatically].
        #[deprecated]
        #[unsafe(method(setLoadsImagesAutomatically:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLoadsImagesAutomatically(&self, loads_images_automatically: bool);

        /// If autosaves is YES the settings represented by
        /// WebPreferences will be stored in the user defaults database.
        #[deprecated]
        #[unsafe(method(autosaves))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosaves(&self) -> bool;

        /// Setter for [`autosaves`][Self::autosaves].
        #[deprecated]
        #[unsafe(method(setAutosaves:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutosaves(&self, autosaves: bool);

        #[deprecated]
        #[unsafe(method(shouldPrintBackgrounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldPrintBackgrounds(&self) -> bool;

        /// Setter for [`shouldPrintBackgrounds`][Self::shouldPrintBackgrounds].
        #[deprecated]
        #[unsafe(method(setShouldPrintBackgrounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldPrintBackgrounds(&self, should_print_backgrounds: bool);

        /// If private browsing is enabled, WebKit will not store information
        /// about sites the user visits.
        #[deprecated]
        #[unsafe(method(privateBrowsingEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn privateBrowsingEnabled(&self) -> bool;

        /// Setter for [`privateBrowsingEnabled`][Self::privateBrowsingEnabled].
        #[deprecated]
        #[unsafe(method(setPrivateBrowsingEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrivateBrowsingEnabled(&self, private_browsing_enabled: bool);

        /// If tabsToLinks is YES, the tab key will focus links and form controls.
        /// The option key temporarily reverses this preference.
        #[deprecated]
        #[unsafe(method(tabsToLinks))]
        #[unsafe(method_family = none)]
        pub unsafe fn tabsToLinks(&self) -> bool;

        /// Setter for [`tabsToLinks`][Self::tabsToLinks].
        #[deprecated]
        #[unsafe(method(setTabsToLinks:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTabsToLinks(&self, tabs_to_links: bool);

        /// Whether the receiver's associated WebViews use the shared
        /// page cache.
        ///
        /// Pages are cached as they are added to a WebBackForwardList, and
        /// removed from the cache as they are removed from a WebBackForwardList. Because
        /// the page cache is global, caching a page in one WebBackForwardList may cause
        /// a page in another WebBackForwardList to be evicted from the cache.
        #[deprecated]
        #[unsafe(method(usesPageCache))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesPageCache(&self) -> bool;

        /// Setter for [`usesPageCache`][Self::usesPageCache].
        #[deprecated]
        #[unsafe(method(setUsesPageCache:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesPageCache(&self, uses_page_cache: bool);

        /// Specifies a usage model for a WebView, which WebKit will use to
        /// determine its caching behavior. If necessary, WebKit
        /// will prune its caches to match cacheModel when set.
        ///
        ///
        /// Research indicates that users tend to browse within clusters of
        /// documents that hold resources in common, and to revisit previously visited
        /// documents. WebKit and the frameworks below it include built-in caches that take
        /// advantage of these patterns, substantially improving document load speed in
        /// browsing situations. The WebKit cache model controls the behaviors of all of
        /// these caches, including NSURLCache and the various WebCore caches.
        ///
        /// Applications with a browsing interface can improve document load speed
        /// substantially by specifying WebCacheModelDocumentBrowser. Applications without
        /// a browsing interface can reduce memory usage substantially by specifying
        /// WebCacheModelDocumentViewer.
        ///
        /// If cacheModel is not set, WebKit will select a cache model automatically.
        #[deprecated]
        #[unsafe(method(cacheModel))]
        #[unsafe(method_family = none)]
        pub unsafe fn cacheModel(&self) -> WebCacheModel;

        /// Setter for [`cacheModel`][Self::cacheModel].
        #[deprecated]
        #[unsafe(method(setCacheModel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCacheModel(&self, cache_model: WebCacheModel);

        #[deprecated]
        #[unsafe(method(suppressesIncrementalRendering))]
        #[unsafe(method_family = none)]
        pub unsafe fn suppressesIncrementalRendering(&self) -> bool;

        /// Setter for [`suppressesIncrementalRendering`][Self::suppressesIncrementalRendering].
        #[deprecated]
        #[unsafe(method(setSuppressesIncrementalRendering:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSuppressesIncrementalRendering(
            &self,
            suppresses_incremental_rendering: bool,
        );

        #[deprecated]
        #[unsafe(method(allowsAirPlayForMediaPlayback))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsAirPlayForMediaPlayback(&self) -> bool;

        /// Setter for [`allowsAirPlayForMediaPlayback`][Self::allowsAirPlayForMediaPlayback].
        #[deprecated]
        #[unsafe(method(setAllowsAirPlayForMediaPlayback:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsAirPlayForMediaPlayback(
            &self,
            allows_air_play_for_media_playback: bool,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl WebPreferences {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
