//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

mod private_NSObjectWebPlugIn {
    pub trait Sealed {}
}

/// Category "WebPlugIn" on [`NSObject`].
///
/// WebPlugIn is an informal protocol that enables interaction between an application
/// and web related plug-ins it may contain.
#[doc(alias = "WebPlugIn")]
pub unsafe trait NSObjectWebPlugIn:
    ClassType + Sized + private_NSObjectWebPlugIn::Sealed
{
    extern_methods!(
        /// Tell the plug-in to perform one-time initialization.
        ///
        /// This method must be only called once per instance of the plug-in
        /// object and must be called before any other methods in this protocol.
        #[unsafe(method(webPlugInInitialize))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInInitialize(&self);

        /// Tell the plug-in to start normal operation.
        ///
        /// The plug-in usually begins drawing, playing sounds and/or
        /// animation in this method.  This method must be called before calling webPlugInStop.
        /// This method may called more than once, provided that the application has
        /// already called webPlugInInitialize and that each call to webPlugInStart is followed
        /// by a call to webPlugInStop.
        #[unsafe(method(webPlugInStart))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInStart(&self);

        /// Tell the plug-in to stop normal operation.
        ///
        /// webPlugInStop must be called before this method.  This method may be
        /// called more than once, provided that the application has already called
        /// webPlugInInitialize and that each call to webPlugInStop is preceded by a call to
        /// webPlugInStart.
        #[unsafe(method(webPlugInStop))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInStop(&self);

        /// Tell the plug-in perform cleanup and prepare to be deallocated.
        ///
        /// The plug-in typically releases memory and other resources in this
        /// method.  If the plug-in has retained the WebPlugInContainer, it must release
        /// it in this mehthod.  This method must be only called once per instance of the
        /// plug-in object.  No other methods in this interface may be called after the
        /// application has called webPlugInDestroy.
        #[unsafe(method(webPlugInDestroy))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInDestroy(&self);

        /// Informs the plug-in whether or not it is selected.  This is typically
        /// used to allow the plug-in to alter it's appearance when selected.
        #[unsafe(method(webPlugInSetIsSelected:))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInSetIsSelected(&self, is_selected: bool);

        /// objectForWebScript is used to expose a plug-in's scripting interface.  The
        /// methods of the object are exposed to the script environment.  See the WebScripting
        /// informal protocol for more details.
        ///
        /// Returns: Returns the object that exposes the plug-in's interface.  The class of this
        /// object can implement methods from the WebScripting informal protocol.
        #[unsafe(method(objectForWebScript))]
        #[unsafe(method_family = none)]
        unsafe fn objectForWebScript(&self) -> Option<Retained<AnyObject>>;

        /// Called on the plug-in when WebKit receives -connection:didReceiveResponse:
        /// for the plug-in's main resource.
        ///
        /// This method is only sent to the plug-in if the
        /// WebPlugInShouldLoadMainResourceKey argument passed to the plug-in was NO.
        ///
        /// # Safety
        ///
        /// `response` might not allow `None`.
        #[unsafe(method(webPlugInMainResourceDidReceiveResponse:))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInMainResourceDidReceiveResponse(&self, response: Option<&NSURLResponse>);

        /// Called on the plug-in when WebKit recieves -connection:didReceiveData:
        /// for the plug-in's main resource.
        ///
        /// This method is only sent to the plug-in if the
        /// WebPlugInShouldLoadMainResourceKey argument passed to the plug-in was NO.
        ///
        /// # Safety
        ///
        /// `data` might not allow `None`.
        #[unsafe(method(webPlugInMainResourceDidReceiveData:))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInMainResourceDidReceiveData(&self, data: Option<&NSData>);

        /// Called on the plug-in when WebKit receives -connection:didFailWithError:
        /// for the plug-in's main resource.
        ///
        /// This method is only sent to the plug-in if the
        /// WebPlugInShouldLoadMainResourceKey argument passed to the plug-in was NO.
        ///
        /// # Safety
        ///
        /// `error` might not allow `None`.
        #[unsafe(method(webPlugInMainResourceDidFailWithError:))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInMainResourceDidFailWithError(&self, error: Option<&NSError>);

        /// Called on the plug-in when WebKit receives -connectionDidFinishLoading:
        /// for the plug-in's main resource.
        ///
        /// This method is only sent to the plug-in if the
        /// WebPlugInShouldLoadMainResourceKey argument passed to the plug-in was NO.
        #[unsafe(method(webPlugInMainResourceDidFinishLoading))]
        #[unsafe(method_family = none)]
        unsafe fn webPlugInMainResourceDidFinishLoading(&self);
    );
}

impl private_NSObjectWebPlugIn::Sealed for NSObject {}
unsafe impl NSObjectWebPlugIn for NSObject {}
