//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistoryitemsaddednotification?language=objc)
    #[deprecated]
    pub static WebHistoryItemsAddedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistoryitemsremovednotification?language=objc)
    #[deprecated]
    pub static WebHistoryItemsRemovedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistoryallitemsremovednotification?language=objc)
    #[deprecated]
    pub static WebHistoryAllItemsRemovedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistoryloadednotification?language=objc)
    #[deprecated]
    pub static WebHistoryLoadedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistorysavednotification?language=objc)
    #[deprecated]
    pub static WebHistorySavedNotification: Option<&'static NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistoryitemskey?language=objc)
    #[deprecated]
    pub static WebHistoryItemsKey: Option<&'static NSString>;
}

extern_class!(
    /// WebHistory is used to track pages that have been loaded
    /// by WebKit.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webhistory?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebHistory;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WebHistory {}
);

impl WebHistory {
    extern_methods!(
        /// Returns a shared WebHistory instance initialized with the default history file.
        ///
        /// Returns: A WebHistory object.
        #[deprecated]
        #[unsafe(method(optionalSharedHistory))]
        #[unsafe(method_family = none)]
        pub unsafe fn optionalSharedHistory() -> Option<Retained<WebHistory>>;

        /// Parameter `history`: The history to use for the global WebHistory.
        ///
        /// # Safety
        ///
        /// `history` might not allow `None`.
        #[deprecated]
        #[unsafe(method(setOptionalSharedHistory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOptionalSharedHistory(history: Option<&WebHistory>);

        /// Parameter `URL`: The URL to use to initialize the WebHistory.
        ///
        /// Parameter `error`: Set to nil or an NSError instance if an error occurred.
        ///
        /// The designated initializer for WebHistory.
        ///
        /// Returns: Returns YES if successful, NO otherwise.
        ///
        /// # Safety
        ///
        /// - `url` might not allow `None`.
        /// - `error` might not allow `None`.
        #[deprecated]
        #[unsafe(method(loadFromURL:error:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadFromURL_error(
            &self,
            url: Option<&NSURL>,
            error: Option<&mut Option<Retained<NSError>>>,
        ) -> bool;

        /// Save history to URL. It is the client's responsibility to call this at appropriate times.
        ///
        /// Parameter `URL`: The URL to use to save the WebHistory.
        ///
        /// Parameter `error`: Set to nil or an NSError instance if an error occurred.
        ///
        /// Returns: Returns YES if successful, NO otherwise.
        ///
        /// # Safety
        ///
        /// - `url` might not allow `None`.
        /// - `error` might not allow `None`.
        #[deprecated]
        #[unsafe(method(saveToURL:error:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveToURL_error(
            &self,
            url: Option<&NSURL>,
            error: Option<&mut Option<Retained<NSError>>>,
        ) -> bool;

        /// Parameter `newItems`: An array of WebHistoryItems to add to the WebHistory.
        ///
        /// # Safety
        ///
        /// - `new_items` generic should be of the correct type.
        /// - `new_items` might not allow `None`.
        #[deprecated]
        #[unsafe(method(addItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addItems(&self, new_items: Option<&NSArray>);

        /// Parameter `items`: An array of WebHistoryItems to remove from the WebHistory.
        ///
        /// # Safety
        ///
        /// - `items` generic should be of the correct type.
        /// - `items` might not allow `None`.
        #[deprecated]
        #[unsafe(method(removeItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeItems(&self, items: Option<&NSArray>);

        #[deprecated]
        #[unsafe(method(removeAllItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllItems(&self);

        /// An array of NSCalendarDates for which history items exist in the WebHistory.
        ///
        /// An array of NSCalendarDates, each one representing a unique day that contains one
        /// or more history items, ordered from most recent to oldest.
        #[deprecated]
        #[unsafe(method(orderedLastVisitedDays))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderedLastVisitedDays(&self) -> Retained<NSArray>;

        /// # Safety
        ///
        /// `calendar_date` might not allow `None`.
        #[deprecated]
        #[unsafe(method(orderedItemsLastVisitedOnDay:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderedItemsLastVisitedOnDay(
            &self,
            calendar_date: Option<&NSCalendarDate>,
        ) -> Option<Retained<NSArray>>;

        #[cfg(feature = "WebHistoryItem")]
        /// Get an item for a specific URL
        ///
        /// Parameter `URL`: The URL of the history item to search for
        ///
        /// Returns: Returns an item matching the URL
        ///
        /// # Safety
        ///
        /// `url` might not allow `None`.
        #[deprecated]
        #[unsafe(method(itemForURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemForURL(&self, url: Option<&NSURL>) -> Option<Retained<WebHistoryItem>>;

        /// The maximum number of items that will be stored by the WebHistory.
        #[deprecated]
        #[unsafe(method(historyItemLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn historyItemLimit(&self) -> c_int;

        /// Setter for [`historyItemLimit`][Self::historyItemLimit].
        #[deprecated]
        #[unsafe(method(setHistoryItemLimit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHistoryItemLimit(&self, history_item_limit: c_int);

        /// The maximum number of days to be read from stored history.
        #[deprecated]
        #[unsafe(method(historyAgeInDaysLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn historyAgeInDaysLimit(&self) -> c_int;

        /// Setter for [`historyAgeInDaysLimit`][Self::historyAgeInDaysLimit].
        #[deprecated]
        #[unsafe(method(setHistoryAgeInDaysLimit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHistoryAgeInDaysLimit(&self, history_age_in_days_limit: c_int);
    );
}

/// Methods declared on superclass `NSObject`.
impl WebHistory {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
