//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-javascript-core")]
use objc2_javascript_core::*;

use crate::*;

extern_protocol!(
    /// A WebView's WebFrameLoadDelegate tracks the loading progress of its frames.
    /// When a data source of a frame starts to load, the data source is considered "provisional".
    /// Once at least one byte is received, the data source is considered "committed". This is done
    /// so the contents of the frame will not be lost if the new data source fails to successfully load.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webframeloaddelegate?language=objc)
    #[deprecated]
    pub unsafe trait WebFrameLoadDelegate: NSObjectProtocol {
        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the provisional load of a frame has started
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame for which the provisional load has started
        ///
        /// This method is called after the provisional data source of a frame
        /// has started to load.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didStartProvisionalLoadForFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didStartProvisionalLoadForFrame(
            &self,
            sender: Option<&WebView>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that a server redirect occurred during the provisional load
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame for which the redirect occurred
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didReceiveServerRedirectForProvisionalLoadForFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didReceiveServerRedirectForProvisionalLoadForFrame(
            &self,
            sender: Option<&WebView>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the provisional load has failed
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `error`: The error that occurred
        ///
        /// Parameter `frame`: The frame for which the error occurred
        ///
        /// This method is called after the provisional data source has failed to load.
        /// The frame will continue to display the contents of the committed data source if there is one.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `error` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didFailProvisionalLoadWithError:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didFailProvisionalLoadWithError_forFrame(
            &self,
            sender: Option<&WebView>,
            error: Option<&NSError>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the load has changed from provisional to committed
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame for which the load has committed
        ///
        /// This method is called after the provisional data source has become the
        /// committed data source.
        ///
        /// In some cases, a single load may be committed more than once. This happens
        /// in the case of multipart/x-mixed-replace, also known as "server push". In this case,
        /// a single location change leads to multiple documents that are loaded in sequence. When
        /// this happens, a new commit will be sent for each document.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didCommitLoadForFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didCommitLoadForFrame(
            &self,
            sender: Option<&WebView>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the page title for a frame has been received
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `title`: The new page title
        ///
        /// Parameter `frame`: The frame for which the title has been received
        ///
        /// The title may update during loading; clients should be prepared for this.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `title` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didReceiveTitle:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didReceiveTitle_forFrame(
            &self,
            sender: Option<&WebView>,
            title: Option<&NSString>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that a page icon image for a frame has been received
        ///
        /// Parameter `webView`: The WebView sending the message
        ///
        /// Parameter `image`: The icon image. Also known as a "favicon".
        ///
        /// Parameter `frame`: The frame for which a page icon has been received
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `image` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didReceiveIcon:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didReceiveIcon_forFrame(
            &self,
            sender: Option<&WebView>,
            image: Option<&NSImage>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the committed load of a frame has completed
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame that finished loading
        ///
        /// This method is called after the committed data source of a frame has successfully loaded
        /// and will only be called when all subresources such as images and stylesheets are done loading.
        /// Plug-In content and JavaScript-requested loads may occur after this method is called.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didFinishLoadForFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didFinishLoadForFrame(
            &self,
            sender: Option<&WebView>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the committed load of a frame has failed
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `error`: The error that occurred
        ///
        /// Parameter `frame`: The frame that failed to load
        ///
        /// This method is called after a data source has committed but failed to completely load.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `error` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didFailLoadWithError:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didFailLoadWithError_forFrame(
            &self,
            sender: Option<&WebView>,
            error: Option<&NSError>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the scroll position in a frame has changed
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame that scrolled
        ///
        /// This method is called when anchors within a page have been clicked.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didChangeLocationWithinPageForFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didChangeLocationWithinPageForFrame(
            &self,
            sender: Option<&WebView>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that a frame will perform a client-side redirect
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `URL`: The URL to be redirected to
        ///
        /// Parameter `seconds`: Seconds in which the redirect will happen
        ///
        /// Parameter `date`: The fire date
        ///
        /// Parameter `frame`: The frame on which the redirect will occur
        ///
        /// This method can be used to continue progress feedback while a client-side
        /// redirect is pending.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `url` might not allow `None`.
        /// - `date` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:willPerformClientRedirectToURL:delay:fireDate:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_willPerformClientRedirectToURL_delay_fireDate_forFrame(
            &self,
            sender: Option<&WebView>,
            url: Option<&NSURL>,
            seconds: NSTimeInterval,
            date: Option<&NSDate>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that a pending client-side redirect has been cancelled
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame for which the pending redirect was cancelled
        ///
        /// A client-side redirect can be cancelled if a frame changes location before the timeout.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didCancelClientRedirectForFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didCancelClientRedirectForFrame(
            &self,
            sender: Option<&WebView>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(feature = "WebFrame", feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that a frame will be closed
        ///
        /// Parameter `sender`: The WebView sending the message
        ///
        /// Parameter `frame`: The frame that will be closed
        ///
        /// This method is called right before WebKit is done with the frame
        /// and the objects that it contains.
        ///
        /// # Safety
        ///
        /// - `sender` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:willCloseFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_willCloseFrame(&self, sender: Option<&WebView>, frame: Option<&WebFrame>);

        #[cfg(all(
            feature = "WebFrame",
            feature = "WebScriptObject",
            feature = "WebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the JavaScript window object in a frame has
        /// been cleared in preparation for a new load. This is the preferred place to set custom
        /// properties on the window object using the WebScriptObject and JavaScriptCore APIs.
        ///
        /// Parameter `webView`: The webView sending the message.
        ///
        /// Parameter `windowObject`: The WebScriptObject representing the frame's JavaScript window object.
        ///
        /// Parameter `frame`: The WebFrame to which windowObject belongs.
        ///
        /// If a delegate implements both webView:didClearWindowObject:forFrame:
        /// and webView:windowScriptObjectAvailable:, only webView:didClearWindowObject:forFrame:
        /// will be invoked. This enables a delegate to implement both methods for backwards
        /// compatibility with older versions of WebKit.
        ///
        /// # Safety
        ///
        /// - `web_view` might not allow `None`.
        /// - `window_object` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didClearWindowObject:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didClearWindowObject_forFrame(
            &self,
            web_view: Option<&WebView>,
            window_object: Option<&WebScriptObject>,
            frame: Option<&WebFrame>,
        );

        #[cfg(all(
            feature = "WebScriptObject",
            feature = "WebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that the scripting object for a page is available.  This is called
        /// before the page is loaded.  It may be useful to allow delegates to bind native objects to the window.
        ///
        /// Parameter `webView`: The webView sending the message.
        ///
        /// Parameter `windowScriptObject`: The WebScriptObject for the window in the scripting environment.
        ///
        /// This method is deprecated. Consider using webView:didClearWindowObject:forFrame:
        /// instead.
        ///
        /// # Safety
        ///
        /// - `web_view` might not allow `None`.
        /// - `window_script_object` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:windowScriptObjectAvailable:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_windowScriptObjectAvailable(
            &self,
            web_view: Option<&WebView>,
            window_script_object: Option<&WebScriptObject>,
        );

        #[cfg(all(
            feature = "WebFrame",
            feature = "WebView",
            feature = "objc2-app-kit",
            feature = "objc2-javascript-core"
        ))]
        #[cfg(target_os = "macos")]
        /// Notifies the delegate that a new JavaScript context has been created created.
        ///
        /// Parameter `webView`: The WebView sending the message.
        ///
        /// Parameter `context`: The JSContext representing the frame's JavaScript window object.
        ///
        /// Parameter `frame`: The WebFrame to which the context belongs.
        ///
        /// If a delegate implements webView:didCreateJavaScriptContext:forFrame: along with either
        /// webView:didClearWindowObject:forFrame: or webView:windowScriptObjectAvailable:, only
        /// webView:didCreateJavaScriptContext:forFrame will be invoked. This enables a delegate to implement
        /// multiple versions to maintain backwards compatibility with older versions of WebKit.
        ///
        /// # Safety
        ///
        /// - `web_view` might not allow `None`.
        /// - `context` might not allow `None`.
        /// - `frame` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(webView:didCreateJavaScriptContext:forFrame:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didCreateJavaScriptContext_forFrame(
            &self,
            web_view: Option<&WebView>,
            context: Option<&JSContext>,
            frame: Option<&WebFrame>,
        );
    }
);
