//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-javascript-core")]
use objc2_javascript_core::*;

use crate::*;

extern_class!(
    /// Every web page is represented by at least one WebFrame.  A WebFrame
    /// has a WebFrameView and a WebDataSource.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webframe?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebFrame;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WebFrame {}
);

impl WebFrame {
    extern_methods!(
        #[cfg(all(
            feature = "WebFrameView",
            feature = "WebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// The designated initializer of WebFrame.
        ///
        /// WebFrames are normally created for you by the WebView.  You should
        /// not need to invoke this method directly.
        ///
        /// Parameter `name`: The name of the frame.
        ///
        /// Parameter `view`: The WebFrameView for the frame.
        ///
        /// Parameter `webView`: The WebView that manages the frame.
        ///
        /// Returns: Returns an initialized WebFrame.
        ///
        /// # Safety
        ///
        /// - `name` might not allow `None`.
        /// - `view` might not allow `None`.
        /// - `web_view` might not allow `None`.
        #[deprecated]
        #[unsafe(method(initWithName:webFrameView:webView:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName_webFrameView_webView(
            this: Allocated<Self>,
            name: Option<&NSString>,
            view: Option<&WebFrameView>,
            web_view: Option<&WebView>,
        ) -> Option<Retained<Self>>;

        /// The frame name.
        #[deprecated]
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSString>;

        #[cfg(all(feature = "WebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// The WebView for the document that includes this frame.
        #[deprecated]
        #[unsafe(method(webView))]
        #[unsafe(method_family = none)]
        pub unsafe fn webView(&self, mtm: MainThreadMarker) -> Option<Retained<WebView>>;

        #[cfg(all(feature = "WebFrameView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// The WebFrameView for this frame.
        #[deprecated]
        #[unsafe(method(frameView))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameView(&self, mtm: MainThreadMarker) -> Option<Retained<WebFrameView>>;

        #[cfg(all(
            feature = "DOMDocument",
            feature = "DOMNode",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// The DOM document of the frame.
        /// Returns nil if the frame does not contain a DOM document such as a standalone image.
        #[deprecated]
        #[unsafe(method(DOMDocument))]
        #[unsafe(method_family = none)]
        pub unsafe fn DOMDocument(&self) -> Option<Retained<DOMDocument>>;

        #[cfg(all(
            feature = "DOMElement",
            feature = "DOMHTMLElement",
            feature = "DOMNode",
            feature = "DOMObject",
            feature = "WebScriptObject"
        ))]
        /// The frame element of the frame.
        /// The class of the result is either DOMHTMLFrameElement, DOMHTMLIFrameElement or DOMHTMLObjectElement.
        /// Returns nil if the frame is the main frame since there is no frame element for the frame in this case.
        #[deprecated]
        #[unsafe(method(frameElement))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameElement(&self) -> Option<Retained<DOMHTMLElement>>;

        /// Parameter `request`: The web request to load.
        ///
        /// # Safety
        ///
        /// `request` might not allow `None`.
        #[deprecated]
        #[unsafe(method(loadRequest:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadRequest(&self, request: Option<&NSURLRequest>);

        /// Parameter `data`: The data to use for the main page of the document.
        ///
        /// Parameter `MIMEType`: The MIME type of the data.
        ///
        /// Parameter `encodingName`: The encoding of the data.
        ///
        /// Parameter `URL`: The base URL to apply to relative URLs within the document.
        ///
        /// # Safety
        ///
        /// - `data` might not allow `None`.
        /// - `mime_type` might not allow `None`.
        /// - `encoding_name` might not allow `None`.
        /// - `url` might not allow `None`.
        #[deprecated]
        #[unsafe(method(loadData:MIMEType:textEncodingName:baseURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadData_MIMEType_textEncodingName_baseURL(
            &self,
            data: Option<&NSData>,
            mime_type: Option<&NSString>,
            encoding_name: Option<&NSString>,
            url: Option<&NSURL>,
        );

        /// Parameter `string`: The string to use for the main page of the document.
        ///
        /// Parameter `URL`: The base URL to apply to relative URLs within the document.
        ///
        /// # Safety
        ///
        /// - `string` might not allow `None`.
        /// - `url` might not allow `None`.
        #[deprecated]
        #[unsafe(method(loadHTMLString:baseURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadHTMLString_baseURL(&self, string: Option<&NSString>, url: Option<&NSURL>);

        /// Loads a page to display as a substitute for a URL that could not be reached.
        ///
        /// This allows clients to display page-loading errors in the webview itself.
        /// This is typically called while processing the WebFrameLoadDelegate method
        /// -webView:didFailProvisionalLoadWithError:forFrame: or one of the WebPolicyDelegate methods
        /// -webView:decidePolicyForMIMEType:request:frame:decisionListener: or
        /// -webView:unableToImplementPolicyWithError:frame:. If it is called from within one of those
        /// three delegate methods then the back/forward list will be maintained appropriately.
        ///
        /// Parameter `string`: The string to use for the main page of the document.
        ///
        /// Parameter `baseURL`: The baseURL to apply to relative URLs within the document.
        ///
        /// Parameter `unreachableURL`: The URL for which this page will serve as alternate content.
        ///
        /// # Safety
        ///
        /// - `string` might not allow `None`.
        /// - `base_url` might not allow `None`.
        /// - `unreachable_url` might not allow `None`.
        #[deprecated]
        #[unsafe(method(loadAlternateHTMLString:baseURL:forUnreachableURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadAlternateHTMLString_baseURL_forUnreachableURL(
            &self,
            string: Option<&NSString>,
            base_url: Option<&NSURL>,
            unreachable_url: Option<&NSURL>,
        );

        #[cfg(feature = "WebArchive")]
        /// Causes WebFrame to load a WebArchive.
        ///
        /// Parameter `archive`: The archive to be loaded.
        ///
        /// # Safety
        ///
        /// `archive` might not allow `None`.
        #[deprecated]
        #[unsafe(method(loadArchive:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadArchive(&self, archive: Option<&WebArchive>);

        #[cfg(feature = "WebDataSource")]
        /// The datasource for this frame.
        ///
        /// Returns the committed data source.  Will return nil if the
        /// provisional data source hasn't yet been loaded.
        #[deprecated]
        #[unsafe(method(dataSource))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataSource(&self) -> Option<Retained<WebDataSource>>;

        #[cfg(feature = "WebDataSource")]
        /// The provisional datasource of this frame.
        ///
        /// Will return the provisional data source.  The provisional data source will
        /// be nil if no data source has been set on the frame, or the data source
        /// has successfully transitioned to the committed data source.
        #[deprecated]
        #[unsafe(method(provisionalDataSource))]
        #[unsafe(method_family = none)]
        pub unsafe fn provisionalDataSource(&self) -> Option<Retained<WebDataSource>>;

        /// Stop any pending loads on the frame's data source,
        /// and its children.
        #[deprecated]
        #[unsafe(method(stopLoading))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopLoading(&self);

        /// Performs HTTP/1.1 end-to-end revalidation using cache-validating conditionals if possible.
        #[deprecated]
        #[unsafe(method(reload))]
        #[unsafe(method_family = none)]
        pub unsafe fn reload(&self);

        /// Performs HTTP/1.1 end-to-end reload.
        #[deprecated]
        #[unsafe(method(reloadFromOrigin))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadFromOrigin(&self);

        /// This method returns a frame with the given name. findFrameNamed returns self
        /// for _self and _current, the parent frame for _parent and the main frame for _top.
        /// findFrameNamed returns self for _parent and _top if the receiver is the mainFrame.
        /// findFrameNamed first searches from the current frame to all descending frames then the
        /// rest of the frames in the WebView. If still not found, findFrameNamed searches the
        /// frames of the other WebViews.
        ///
        /// Parameter `name`: The name of the frame to find.
        ///
        /// Returns: The frame matching the provided name. nil if the frame is not found.
        ///
        /// # Safety
        ///
        /// `name` might not allow `None`.
        #[deprecated]
        #[unsafe(method(findFrameNamed:))]
        #[unsafe(method_family = none)]
        pub unsafe fn findFrameNamed(&self, name: Option<&NSString>) -> Option<Retained<WebFrame>>;

        /// The frame containing this frame, or nil if this is a top level frame.
        #[deprecated]
        #[unsafe(method(parentFrame))]
        #[unsafe(method_family = none)]
        pub unsafe fn parentFrame(&self) -> Option<Retained<WebFrame>>;

        /// An array of WebFrame.
        ///
        /// The frames in the array are associated with a frame set or iframe.
        #[deprecated]
        #[unsafe(method(childFrames))]
        #[unsafe(method_family = none)]
        pub unsafe fn childFrames(&self) -> Retained<NSArray>;

        #[cfg(feature = "WebScriptObject")]
        /// The WebScriptObject representing the frame's JavaScript window object.
        #[deprecated]
        #[unsafe(method(windowObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowObject(&self) -> Option<Retained<WebScriptObject>>;

        #[cfg(feature = "objc2-javascript-core")]
        /// The frame's global JavaScript execution context.
        ///
        /// Use this method to bridge between the WebKit and JavaScriptCore APIs.
        #[deprecated]
        #[unsafe(method(globalContext))]
        #[unsafe(method_family = none)]
        pub unsafe fn globalContext(&self) -> JSGlobalContextRef;

        #[cfg(feature = "objc2-javascript-core")]
        /// The frame's global JavaScript execution context.
        ///
        /// Use this method to bridge between the WebKit and Objective-C JavaScriptCore API.
        #[deprecated]
        #[unsafe(method(javaScriptContext))]
        #[unsafe(method_family = none)]
        pub unsafe fn javaScriptContext(&self) -> Option<Retained<JSContext>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WebFrame {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
