//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A WebDownload works just like an NSURLDownload, with
    /// one extra feature: if you do not implement the
    /// authentication-related delegate methods, it will automatically
    /// prompt for authentication using the standard WebKit authentication
    /// panel, as either a sheet or window. It provides no extra methods,
    /// but does have one additional delegate method.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webdownload?language=objc)
    #[unsafe(super(NSURLDownload, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebDownload;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WebDownload {}
);

impl WebDownload {
    extern_methods!();
}

/// Methods declared on superclass `NSURLDownload`.
impl WebDownload {
    extern_methods!(
        /// Initializes a NSURLDownload object and starts the download.
        ///
        /// Parameter `request`: The request to download. Must not be nil.
        ///
        /// Parameter `delegate`: The delegate of the download.
        ///
        /// Returns: An initialized NSURLDownload object.
        #[deprecated = "Use NSURLSession downloadTask (see NSURLSession.h)"]
        #[unsafe(method(initWithRequest:delegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRequest_delegate(
            this: Allocated<Self>,
            request: &NSURLRequest,
            delegate: Option<&ProtocolObject<dyn NSURLDownloadDelegate>>,
        ) -> Retained<Self>;

        /// Initializes a NSURLDownload object for resuming a previous download.
        ///
        /// Parameter `resumeData`: The resume data from the previous download.
        ///
        /// Parameter `delegate`: The delegate of the download.
        ///
        /// Parameter `path`: The path of the incomplete downloaded file.
        ///
        /// Returns: An initialized NSURLDownload object.
        #[deprecated = "Use NSURLSession downloadTask (see NSURLSession.h)"]
        #[unsafe(method(initWithResumeData:delegate:path:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithResumeData_delegate_path(
            this: Allocated<Self>,
            resume_data: &NSData,
            delegate: Option<&ProtocolObject<dyn NSURLDownloadDelegate>>,
            path: &NSString,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WebDownload {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// The WebDownloadDelegate delegate has one extra method used to choose
    /// the right window when automatically prompting with a sheet.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webdownloaddelegate?language=objc)
    #[deprecated]
    pub unsafe trait WebDownloadDelegate: NSURLDownloadDelegate {
        #[cfg(feature = "objc2-app-kit")]
        #[cfg(target_os = "macos")]
        /// # Safety
        ///
        /// `download` might not allow `None`.
        #[deprecated]
        #[optional]
        #[unsafe(method(downloadWindowForAuthenticationSheet:))]
        #[unsafe(method_family = none)]
        unsafe fn downloadWindowForAuthenticationSheet(
            &self,
            download: Option<&WebDownload>,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSWindow>>;
    }
);
