//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// The pasteboard type constant used when adding or accessing a WebArchive on the pasteboard.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webarchivepboardtype?language=objc)
    #[deprecated]
    pub static WebArchivePboardType: Option<&'static NSString>;
}

extern_class!(
    /// WebArchive represents a main resource as well as all the subresources and subframes associated with the main resource.
    /// The main resource can be an entire web page, a portion of a web page, or some other kind of data such as an image.
    /// This class can be used for saving standalone web pages, representing portions of a web page on the pasteboard, or any other
    /// application where one class is needed to represent rich web content.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/webarchive?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct WebArchive;
);

extern_conformance!(
    unsafe impl NSCoding for WebArchive {}
);

extern_conformance!(
    unsafe impl NSCopying for WebArchive {}
);

unsafe impl CopyingHelper for WebArchive {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WebArchive {}
);

impl WebArchive {
    extern_methods!(
        #[cfg(feature = "WebResource")]
        /// The initializer for WebArchive.
        ///
        /// Parameter `mainResource`: The main resource of the archive.
        ///
        /// Parameter `subresources`: The subresources of the archive (can be nil).
        ///
        /// Parameter `subframeArchives`: The archives representing the subframes of the archive (can be nil).
        ///
        /// Returns: An initialized WebArchive.
        ///
        /// # Safety
        ///
        /// - `main_resource` might not allow `None`.
        /// - `subresources` generic should be of the correct type.
        /// - `subresources` might not allow `None`.
        /// - `subframe_archives` generic should be of the correct type.
        /// - `subframe_archives` might not allow `None`.
        #[deprecated]
        #[unsafe(method(initWithMainResource:subresources:subframeArchives:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMainResource_subresources_subframeArchives(
            this: Allocated<Self>,
            main_resource: Option<&WebResource>,
            subresources: Option<&NSArray>,
            subframe_archives: Option<&NSArray>,
        ) -> Option<Retained<Self>>;

        /// The initializer for creating a WebArchive from data.
        ///
        /// Parameter `data`: The data representing the archive. This can be obtained using WebArchive's data method.
        ///
        /// Returns: An initialized WebArchive.
        ///
        /// # Safety
        ///
        /// `data` might not allow `None`.
        #[deprecated]
        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithData(
            this: Allocated<Self>,
            data: Option<&NSData>,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "WebResource")]
        /// The main resource of the archive.
        #[deprecated]
        #[unsafe(method(mainResource))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainResource(&self) -> Option<Retained<WebResource>>;

        /// The subresource of the archive (can be nil).
        #[deprecated]
        #[unsafe(method(subresources))]
        #[unsafe(method_family = none)]
        pub unsafe fn subresources(&self) -> Retained<NSArray>;

        /// The archives representing the subframes of the archive (can be nil).
        #[deprecated]
        #[unsafe(method(subframeArchives))]
        #[unsafe(method_family = none)]
        pub unsafe fn subframeArchives(&self) -> Retained<NSArray>;

        /// The data representation of the archive.
        ///
        /// The data returned by this method can be used to save a web archive to a file or to place a web archive on the pasteboard
        /// using WebArchivePboardType. To create a WebArchive using the returned data, call initWithData:.
        #[deprecated]
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub unsafe fn data(&self) -> Retained<NSData>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WebArchive {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
