//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A WKWebsiteDataStore represents various types of data that a website might
    /// make use of. This includes cookies, disk and memory caches, and persistent data such as WebSQL,
    /// IndexedDB databases, and local storage.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebsitedatastore?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebsiteDataStore;
);

extern_conformance!(
    unsafe impl NSCoding for WKWebsiteDataStore {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebsiteDataStore {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for WKWebsiteDataStore {}
);

impl WKWebsiteDataStore {
    extern_methods!(
        #[unsafe(method(defaultDataStore))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultDataStore(mtm: MainThreadMarker) -> Retained<WKWebsiteDataStore>;

        /// Returns a new non-persistent data store.
        ///
        /// If a WKWebView is associated with a non-persistent data store, no data will
        /// be written to the file system. This is useful for implementing "private browsing" in a web view.
        #[unsafe(method(nonPersistentDataStore))]
        #[unsafe(method_family = none)]
        pub unsafe fn nonPersistentDataStore(mtm: MainThreadMarker)
            -> Retained<WKWebsiteDataStore>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(&self) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Whether the data store is persistent or not.
        #[unsafe(method(isPersistent))]
        #[unsafe(method_family = none)]
        pub unsafe fn isPersistent(&self) -> bool;

        /// Returns a set of all available website data types.
        #[unsafe(method(allWebsiteDataTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allWebsiteDataTypes(mtm: MainThreadMarker) -> Retained<NSSet<NSString>>;

        #[cfg(all(feature = "WKWebsiteDataRecord", feature = "block2"))]
        /// Fetches data records containing the given website data types.
        ///
        /// Parameter `dataTypes`: The website data types to fetch records for.
        ///
        /// Parameter `completionHandler`: A block to invoke when the data records have been fetched.
        #[unsafe(method(fetchDataRecordsOfTypes:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchDataRecordsOfTypes_completionHandler(
            &self,
            data_types: &NSSet<NSString>,
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<NSArray<WKWebsiteDataRecord>>)>,
        );

        #[cfg(all(feature = "WKWebsiteDataRecord", feature = "block2"))]
        /// Removes website data of the given types for the given data records.
        ///
        /// Parameter `dataTypes`: The website data types that should be removed.
        ///
        /// Parameter `dataRecords`: The website data records to delete website data for.
        ///
        /// Parameter `completionHandler`: A block to invoke when the website data for the records has been removed.
        #[unsafe(method(removeDataOfTypes:forDataRecords:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeDataOfTypes_forDataRecords_completionHandler(
            &self,
            data_types: &NSSet<NSString>,
            data_records: &NSArray<WKWebsiteDataRecord>,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(feature = "block2")]
        /// Removes all website data of the given types that has been modified since the given date.
        ///
        /// Parameter `dataTypes`: The website data types that should be removed.
        ///
        /// Parameter `date`: A date. All website data modified after this date will be removed.
        ///
        /// Parameter `completionHandler`: A block to invoke when the website data has been removed.
        #[unsafe(method(removeDataOfTypes:modifiedSince:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeDataOfTypes_modifiedSince_completionHandler(
            &self,
            data_types: &NSSet<NSString>,
            date: &NSDate,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(feature = "WKHTTPCookieStore")]
        /// Returns the cookie store representing HTTP cookies in this website data store.
        #[unsafe(method(httpCookieStore))]
        #[unsafe(method_family = none)]
        pub unsafe fn httpCookieStore(&self) -> Retained<WKHTTPCookieStore>;

        /// Get identifier for a data store.
        ///
        /// Returns nil for default and non-persistent data store .
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn identifier(&self) -> Option<Retained<NSUUID>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(fetchDataOfTypes:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchDataOfTypes_completionHandler(
            &self,
            data_types: &NSSet<NSString>,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSData, *mut NSError)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(restoreData:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreData_completionHandler(
            &self,
            data: &NSData,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        /// Get a persistent data store.
        ///
        /// Parameter `identifier`: An identifier that is used to uniquely identify the data store.
        ///
        /// If a data store with this identifier does not exist yet, it will be created. Throws exception if identifier
        /// is 0.
        #[unsafe(method(dataStoreForIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataStoreForIdentifier(
            identifier: &NSUUID,
            mtm: MainThreadMarker,
        ) -> Retained<WKWebsiteDataStore>;

        #[cfg(feature = "block2")]
        /// Delete a persistent data store.
        ///
        /// Parameter `identifier`: An identifier that is used to uniquely identify the data store.
        ///
        /// Parameter `completionHandler`: A block to invoke with optional error when the operation completes.
        ///
        /// This should be called when the data store is not used any more. Returns error if removal fails
        /// to complete. WKWebView using the data store must be released before removal.
        #[unsafe(method(removeDataStoreForIdentifier:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeDataStoreForIdentifier_completionHandler(
            identifier: &NSUUID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        /// Fetch all data stores identifiers.
        ///
        /// Parameter `completionHandler`: A block to invoke with an array of identifiers when the operation completes.
        ///
        /// Default or non-persistent data store do not have an identifier.
        #[unsafe(method(fetchAllDataStoreIdentifiers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchAllDataStoreIdentifiers(
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<NSArray<NSUUID>>)>,
            mtm: MainThreadMarker,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl WKWebsiteDataStore {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new_class(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
