//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// A content mode represents the type of content to load, as well as
/// additional layout and rendering adaptations that are applied as a result of
/// loading the content
///
///
///
///
/// WKContentModeRecommended behaves like WKContentModeMobile on iPhone and iPad mini
/// and WKContentModeDesktop on other iPad models as well as Mac.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkcontentmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKContentMode(pub NSInteger);
impl WKContentMode {
    #[doc(alias = "WKContentModeRecommended")]
    pub const Recommended: Self = Self(0);
    #[doc(alias = "WKContentModeMobile")]
    pub const Mobile: Self = Self(1);
    #[doc(alias = "WKContentModeDesktop")]
    pub const Desktop: Self = Self(2);
}

unsafe impl Encode for WKContentMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKContentMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A secure navigation policy represents whether or not there is a
/// preference for loading a webpage with https, and how failures should be
/// handled.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebpagepreferencesupgradetohttpspolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebpagePreferencesUpgradeToHTTPSPolicy(pub NSInteger);
impl WKWebpagePreferencesUpgradeToHTTPSPolicy {
    #[doc(alias = "WKWebpagePreferencesUpgradeToHTTPSPolicyKeepAsRequested")]
    pub const KeepAsRequested: Self = Self(0);
    #[doc(alias = "WKWebpagePreferencesUpgradeToHTTPSPolicyAutomaticFallbackToHTTP")]
    pub const AutomaticFallbackToHTTP: Self = Self(1);
    #[doc(alias = "WKWebpagePreferencesUpgradeToHTTPSPolicyUserMediatedFallbackToHTTP")]
    pub const UserMediatedFallbackToHTTP: Self = Self(2);
    #[doc(alias = "WKWebpagePreferencesUpgradeToHTTPSPolicyErrorOnFailure")]
    pub const ErrorOnFailure: Self = Self(3);
}

unsafe impl Encode for WKWebpagePreferencesUpgradeToHTTPSPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebpagePreferencesUpgradeToHTTPSPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A WKWebpagePreferences object is a collection of properties that
    /// determine the preferences to use when loading and rendering a page.
    ///
    /// Contains properties used to determine webpage preferences.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebpagepreferences?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebpagePreferences;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebpagePreferences {}
);

impl WKWebpagePreferences {
    extern_methods!(
        /// A WKContentMode indicating the content mode to prefer
        /// when loading and rendering a webpage.
        ///
        /// The default value is WKContentModeRecommended. The stated
        /// preference is ignored on subframe navigation
        #[unsafe(method(preferredContentMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredContentMode(&self) -> WKContentMode;

        /// Setter for [`preferredContentMode`][Self::preferredContentMode].
        #[unsafe(method(setPreferredContentMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredContentMode(&self, preferred_content_mode: WKContentMode);

        #[unsafe(method(allowsContentJavaScript))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsContentJavaScript(&self) -> bool;

        /// Setter for [`allowsContentJavaScript`][Self::allowsContentJavaScript].
        #[unsafe(method(setAllowsContentJavaScript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsContentJavaScript(&self, allows_content_java_script: bool);

        /// A boolean indicating whether lockdown mode is enabled.
        ///
        /// This mode trades off performance and compatibility in favor of security.
        /// The default value depends on the system setting.
        #[unsafe(method(isLockdownModeEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isLockdownModeEnabled(&self) -> bool;

        /// Setter for [`isLockdownModeEnabled`][Self::isLockdownModeEnabled].
        #[unsafe(method(setLockdownModeEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLockdownModeEnabled(&self, lockdown_mode_enabled: bool);

        /// A WKWebpagePreferencesUpgradeToHTTPSPolicy indicating the desired mode
        /// used when performing a top-level navigation to a webpage.
        ///
        /// The default value is WKWebpagePreferencesUpgradeToHTTPSPolicyKeepAsRequested.
        /// The stated preference is ignored on subframe navigation, and it may be ignored based on
        /// system configuration. The upgradeKnownHostsToHTTPS property on WKWebViewConfiguration
        /// supercedes this policy for known hosts.
        #[unsafe(method(preferredHTTPSNavigationPolicy))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredHTTPSNavigationPolicy(
            &self,
        ) -> WKWebpagePreferencesUpgradeToHTTPSPolicy;

        /// Setter for [`preferredHTTPSNavigationPolicy`][Self::preferredHTTPSNavigationPolicy].
        #[unsafe(method(setPreferredHTTPSNavigationPolicy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredHTTPSNavigationPolicy(
            &self,
            preferred_https_navigation_policy: WKWebpagePreferencesUpgradeToHTTPSPolicy,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl WKWebpagePreferences {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
