//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// The policy used to determine the directionality of user interface elements inside a web view.
///
/// specifications.
///
/// userInterfaceLayoutDirection property
///
/// When WKUserInterfaceDirectionPolicyContent is specified, the directionality of user interface
/// elements is affected by the "dir" attribute or the "direction" CSS property. When
/// WKUserInterfaceDirectionPolicySystem is specified, the directionality of user interface elements is
/// affected by the direction of the view.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkuserinterfacedirectionpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKUserInterfaceDirectionPolicy(pub NSInteger);
impl WKUserInterfaceDirectionPolicy {
    #[doc(alias = "WKUserInterfaceDirectionPolicyContent")]
    pub const Content: Self = Self(0);
    #[doc(alias = "WKUserInterfaceDirectionPolicySystem")]
    pub const System: Self = Self(1);
}

unsafe impl Encode for WKUserInterfaceDirectionPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKUserInterfaceDirectionPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The types of audiovisual media which will require a user gesture to begin playing.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkaudiovisualmediatypes?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKAudiovisualMediaTypes(pub NSUInteger);
bitflags::bitflags! {
    impl WKAudiovisualMediaTypes: NSUInteger {
        #[doc(alias = "WKAudiovisualMediaTypeNone")]
        const None = 0;
        #[doc(alias = "WKAudiovisualMediaTypeAudio")]
        const Audio = 1<<0;
        #[doc(alias = "WKAudiovisualMediaTypeVideo")]
        const Video = 1<<1;
        #[doc(alias = "WKAudiovisualMediaTypeAll")]
        const All = NSUIntegerMax as _;
    }
}

unsafe impl Encode for WKAudiovisualMediaTypes {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for WKAudiovisualMediaTypes {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A WKWebViewConfiguration object is a collection of properties with
    /// which to initialize a web view.
    ///
    /// Contains properties used to configure a
    ///
    /// ```text
    ///  WKWebView
    /// ```
    ///
    /// .
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebviewconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebViewConfiguration;
);

extern_conformance!(
    unsafe impl NSCoding for WKWebViewConfiguration {}
);

extern_conformance!(
    unsafe impl NSCopying for WKWebViewConfiguration {}
);

unsafe impl CopyingHelper for WKWebViewConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebViewConfiguration {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for WKWebViewConfiguration {}
);

impl WKWebViewConfiguration {
    extern_methods!(
        #[cfg(feature = "WKProcessPool")]
        /// The process pool from which to obtain the view's web content
        /// process.
        ///
        /// When a web view is initialized, a new web content process
        /// will be created for it from the specified pool, or an existing process in
        /// that pool will be used.
        #[deprecated = "Creating and using multiple instances of WKProcessPool no longer has any effect."]
        #[unsafe(method(processPool))]
        #[unsafe(method_family = none)]
        pub unsafe fn processPool(&self) -> Retained<WKProcessPool>;

        #[cfg(feature = "WKProcessPool")]
        /// Setter for [`processPool`][Self::processPool].
        #[deprecated = "Creating and using multiple instances of WKProcessPool no longer has any effect."]
        #[unsafe(method(setProcessPool:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProcessPool(&self, process_pool: &WKProcessPool);

        #[cfg(feature = "WKPreferences")]
        /// The preference settings to be used by the web view.
        #[unsafe(method(preferences))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferences(&self) -> Retained<WKPreferences>;

        #[cfg(feature = "WKPreferences")]
        /// Setter for [`preferences`][Self::preferences].
        #[unsafe(method(setPreferences:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferences(&self, preferences: &WKPreferences);

        #[cfg(feature = "WKUserContentController")]
        /// The user content controller to associate with the web view.
        #[unsafe(method(userContentController))]
        #[unsafe(method_family = none)]
        pub unsafe fn userContentController(&self) -> Retained<WKUserContentController>;

        #[cfg(feature = "WKUserContentController")]
        /// Setter for [`userContentController`][Self::userContentController].
        #[unsafe(method(setUserContentController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserContentController(
            &self,
            user_content_controller: &WKUserContentController,
        );

        #[cfg(feature = "WKWebExtensionController")]
        /// The web extension controller to associate with the web view.
        #[unsafe(method(webExtensionController))]
        #[unsafe(method_family = none)]
        pub unsafe fn webExtensionController(&self) -> Option<Retained<WKWebExtensionController>>;

        #[cfg(feature = "WKWebExtensionController")]
        /// Setter for [`webExtensionController`][Self::webExtensionController].
        #[unsafe(method(setWebExtensionController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWebExtensionController(
            &self,
            web_extension_controller: Option<&WKWebExtensionController>,
        );

        #[cfg(feature = "WKWebsiteDataStore")]
        /// The website data store to be used by the web view.
        #[unsafe(method(websiteDataStore))]
        #[unsafe(method_family = none)]
        pub unsafe fn websiteDataStore(&self) -> Retained<WKWebsiteDataStore>;

        #[cfg(feature = "WKWebsiteDataStore")]
        /// Setter for [`websiteDataStore`][Self::websiteDataStore].
        #[unsafe(method(setWebsiteDataStore:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWebsiteDataStore(&self, website_data_store: &WKWebsiteDataStore);

        /// A Boolean value indicating whether the web view suppresses
        /// content rendering until it is fully loaded into memory.
        ///
        /// The default value is NO.
        #[unsafe(method(suppressesIncrementalRendering))]
        #[unsafe(method_family = none)]
        pub unsafe fn suppressesIncrementalRendering(&self) -> bool;

        /// Setter for [`suppressesIncrementalRendering`][Self::suppressesIncrementalRendering].
        #[unsafe(method(setSuppressesIncrementalRendering:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSuppressesIncrementalRendering(
            &self,
            suppresses_incremental_rendering: bool,
        );

        /// The name of the application as used in the user agent string.
        #[unsafe(method(applicationNameForUserAgent))]
        #[unsafe(method_family = none)]
        pub unsafe fn applicationNameForUserAgent(&self) -> Option<Retained<NSString>>;

        /// Setter for [`applicationNameForUserAgent`][Self::applicationNameForUserAgent].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setApplicationNameForUserAgent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setApplicationNameForUserAgent(
            &self,
            application_name_for_user_agent: Option<&NSString>,
        );

        /// A Boolean value indicating whether AirPlay is allowed.
        ///
        /// The default value is YES.
        #[unsafe(method(allowsAirPlayForMediaPlayback))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsAirPlayForMediaPlayback(&self) -> bool;

        /// Setter for [`allowsAirPlayForMediaPlayback`][Self::allowsAirPlayForMediaPlayback].
        #[unsafe(method(setAllowsAirPlayForMediaPlayback:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsAirPlayForMediaPlayback(
            &self,
            allows_air_play_for_media_playback: bool,
        );

        /// A Boolean value indicating whether the System Screen Time blocking view should be shown.
        ///
        /// The default value is YES.
        #[unsafe(method(showsSystemScreenTimeBlockingView))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsSystemScreenTimeBlockingView(&self) -> bool;

        /// Setter for [`showsSystemScreenTimeBlockingView`][Self::showsSystemScreenTimeBlockingView].
        #[unsafe(method(setShowsSystemScreenTimeBlockingView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsSystemScreenTimeBlockingView(
            &self,
            shows_system_screen_time_blocking_view: bool,
        );

        /// A Boolean value indicating whether HTTP requests to servers known to support HTTPS should be automatically upgraded to HTTPS requests.
        ///
        /// The default value is YES.
        #[unsafe(method(upgradeKnownHostsToHTTPS))]
        #[unsafe(method_family = none)]
        pub unsafe fn upgradeKnownHostsToHTTPS(&self) -> bool;

        /// Setter for [`upgradeKnownHostsToHTTPS`][Self::upgradeKnownHostsToHTTPS].
        #[unsafe(method(setUpgradeKnownHostsToHTTPS:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUpgradeKnownHostsToHTTPS(&self, upgrade_known_hosts_to_https: bool);

        #[unsafe(method(mediaTypesRequiringUserActionForPlayback))]
        #[unsafe(method_family = none)]
        pub unsafe fn mediaTypesRequiringUserActionForPlayback(&self) -> WKAudiovisualMediaTypes;

        /// Setter for [`mediaTypesRequiringUserActionForPlayback`][Self::mediaTypesRequiringUserActionForPlayback].
        #[unsafe(method(setMediaTypesRequiringUserActionForPlayback:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMediaTypesRequiringUserActionForPlayback(
            &self,
            media_types_requiring_user_action_for_playback: WKAudiovisualMediaTypes,
        );

        #[cfg(feature = "WKWebpagePreferences")]
        /// The set of default webpage preferences to use when loading and rendering content.
        ///
        /// These default webpage preferences are additionally passed to the navigation delegate
        /// in -webView:decidePolicyForNavigationAction:preferences:decisionHandler:.
        #[unsafe(method(defaultWebpagePreferences))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultWebpagePreferences(&self) -> Retained<WKWebpagePreferences>;

        #[cfg(feature = "WKWebpagePreferences")]
        /// Setter for [`defaultWebpagePreferences`][Self::defaultWebpagePreferences].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDefaultWebpagePreferences:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultWebpagePreferences(
            &self,
            default_webpage_preferences: Option<&WKWebpagePreferences>,
        );

        #[unsafe(method(limitsNavigationsToAppBoundDomains))]
        #[unsafe(method_family = none)]
        pub unsafe fn limitsNavigationsToAppBoundDomains(&self) -> bool;

        /// Setter for [`limitsNavigationsToAppBoundDomains`][Self::limitsNavigationsToAppBoundDomains].
        #[unsafe(method(setLimitsNavigationsToAppBoundDomains:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLimitsNavigationsToAppBoundDomains(
            &self,
            limits_navigations_to_app_bound_domains: bool,
        );

        /// A Boolean value indicating whether inline predictions are allowed.
        ///
        /// The default value is `NO`. If false, inline predictions
        /// are disabled regardless of the system setting. If true, they are enabled based
        /// on the system setting.
        #[unsafe(method(allowsInlinePredictions))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsInlinePredictions(&self) -> bool;

        /// Setter for [`allowsInlinePredictions`][Self::allowsInlinePredictions].
        #[unsafe(method(setAllowsInlinePredictions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsInlinePredictions(&self, allows_inline_predictions: bool);

        /// The directionality of user interface elements.
        ///
        /// Possible values are described in WKUserInterfaceDirectionPolicy.
        /// The default value is WKUserInterfaceDirectionPolicyContent.
        #[unsafe(method(userInterfaceDirectionPolicy))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInterfaceDirectionPolicy(&self) -> WKUserInterfaceDirectionPolicy;

        /// Setter for [`userInterfaceDirectionPolicy`][Self::userInterfaceDirectionPolicy].
        #[unsafe(method(setUserInterfaceDirectionPolicy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInterfaceDirectionPolicy(
            &self,
            user_interface_direction_policy: WKUserInterfaceDirectionPolicy,
        );

        #[cfg(feature = "WKURLSchemeHandler")]
        #[unsafe(method(setURLSchemeHandler:forURLScheme:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setURLSchemeHandler_forURLScheme(
            &self,
            url_scheme_handler: Option<&ProtocolObject<dyn WKURLSchemeHandler>>,
            url_scheme: &NSString,
        );

        #[cfg(feature = "WKURLSchemeHandler")]
        #[unsafe(method(urlSchemeHandlerForURLScheme:))]
        #[unsafe(method_family = none)]
        pub unsafe fn urlSchemeHandlerForURLScheme(
            &self,
            url_scheme: &NSString,
        ) -> Option<Retained<ProtocolObject<dyn WKURLSchemeHandler>>>;

        /// A Boolean value indicating whether insertion of adaptive image glyphs is allowed.
        ///
        /// The default value is `NO`. If `NO`, adaptive image glyphs are inserted as regular
        /// images. If `YES`, they are inserted with the full adaptive sizing behavior.
        #[unsafe(method(supportsAdaptiveImageGlyph))]
        #[unsafe(method_family = none)]
        pub unsafe fn supportsAdaptiveImageGlyph(&self) -> bool;

        /// Setter for [`supportsAdaptiveImageGlyph`][Self::supportsAdaptiveImageGlyph].
        #[unsafe(method(setSupportsAdaptiveImageGlyph:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSupportsAdaptiveImageGlyph(&self, supports_adaptive_image_glyph: bool);
    );
}

/// Methods declared on superclass `NSObject`.
impl WKWebViewConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
