//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-security")]
use objc2_security::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkmediaplaybackstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKMediaPlaybackState(pub NSInteger);
impl WKMediaPlaybackState {
    #[doc(alias = "WKMediaPlaybackStateNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "WKMediaPlaybackStatePlaying")]
    pub const Playing: Self = Self(1);
    #[doc(alias = "WKMediaPlaybackStatePaused")]
    pub const Paused: Self = Self(2);
    #[doc(alias = "WKMediaPlaybackStateSuspended")]
    pub const Suspended: Self = Self(3);
}

unsafe impl Encode for WKMediaPlaybackState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKMediaPlaybackState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkmediacapturestate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKMediaCaptureState(pub NSInteger);
impl WKMediaCaptureState {
    #[doc(alias = "WKMediaCaptureStateNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "WKMediaCaptureStateActive")]
    pub const Active: Self = Self(1);
    #[doc(alias = "WKMediaCaptureStateMuted")]
    pub const Muted: Self = Self(2);
}

unsafe impl Encode for WKMediaCaptureState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKMediaCaptureState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkfullscreenstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKFullscreenState(pub NSInteger);
impl WKFullscreenState {
    #[doc(alias = "WKFullscreenStateNotInFullscreen")]
    pub const NotInFullscreen: Self = Self(0);
    #[doc(alias = "WKFullscreenStateEnteringFullscreen")]
    pub const EnteringFullscreen: Self = Self(1);
    #[doc(alias = "WKFullscreenStateInFullscreen")]
    pub const InFullscreen: Self = Self(2);
    #[doc(alias = "WKFullscreenStateExitingFullscreen")]
    pub const ExitingFullscreen: Self = Self(3);
}

unsafe impl Encode for WKFullscreenState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKFullscreenState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebviewdatatype?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebViewDataType(pub NSUInteger);
bitflags::bitflags! {
    impl WKWebViewDataType: NSUInteger {
        #[doc(alias = "WKWebViewDataTypeSessionStorage")]
        const SessionStorage = 1<<0;
    }
}

unsafe impl Encode for WKWebViewDataType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for WKWebViewDataType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "objc2-app-kit")]
    #[cfg(target_os = "macos")]
    pub struct WKWebView;
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAccessibility for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSCoding for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSDraggingDestination for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for WKWebView {}
);

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!(
        #[cfg(feature = "WKWebViewConfiguration")]
        /// A copy of the configuration with which the web view was
        /// initialized.
        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration(&self) -> Retained<WKWebViewConfiguration>;

        #[cfg(feature = "WKNavigationDelegate")]
        /// The web view's navigation delegate.
        #[unsafe(method(navigationDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn navigationDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WKNavigationDelegate>>>;

        #[cfg(feature = "WKNavigationDelegate")]
        /// Setter for [`navigationDelegate`][Self::navigationDelegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setNavigationDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNavigationDelegate(
            &self,
            navigation_delegate: Option<&ProtocolObject<dyn WKNavigationDelegate>>,
        );

        #[cfg(feature = "WKUIDelegate")]
        /// The web view's user interface delegate.
        #[unsafe(method(UIDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn UIDelegate(&self) -> Option<Retained<ProtocolObject<dyn WKUIDelegate>>>;

        #[cfg(feature = "WKUIDelegate")]
        /// Setter for [`UIDelegate`][Self::UIDelegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setUIDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUIDelegate(&self, ui_delegate: Option<&ProtocolObject<dyn WKUIDelegate>>);

        #[cfg(feature = "WKBackForwardList")]
        /// The web view's back-forward list.
        #[unsafe(method(backForwardList))]
        #[unsafe(method_family = none)]
        pub unsafe fn backForwardList(&self) -> Retained<WKBackForwardList>;

        #[cfg(all(feature = "WKWebViewConfiguration", feature = "objc2-core-foundation"))]
        /// Returns a web view initialized with a specified frame and
        /// configuration.
        ///
        /// Parameter `frame`: The frame for the new web view.
        ///
        /// Parameter `configuration`: The configuration for the new web view.
        ///
        /// Returns: An initialized web view, or nil if the object could not be
        /// initialized.
        ///
        /// This is a designated initializer. You can use
        ///
        /// ```text
        ///  -initWithFrame:
        /// ```
        ///
        /// to initialize an instance with the default
        /// configuration. The initializer copies the specified configuration, so
        /// mutating the configuration after invoking the initializer has no effect
        /// on the web view.
        #[unsafe(method(initWithFrame:configuration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame_configuration(
            this: Allocated<Self>,
            frame: CGRect,
            configuration: &WKWebViewConfiguration,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "WKNavigation")]
        /// Navigates to a requested URL.
        ///
        /// Parameter `request`: The request specifying the URL to which to navigate.
        ///
        /// Returns: A new navigation for the given request.
        #[unsafe(method(loadRequest:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadRequest(&self, request: &NSURLRequest) -> Option<Retained<WKNavigation>>;

        #[cfg(feature = "WKNavigation")]
        /// Navigates to the requested file URL on the filesystem.
        ///
        /// Parameter `URL`: The file URL to which to navigate.
        ///
        /// Parameter `readAccessURL`: The URL to allow read access to.
        ///
        /// If readAccessURL references a single file, only that file may be loaded by WebKit.
        /// If readAccessURL references a directory, files inside that file may be loaded by WebKit.
        ///
        /// Returns: A new navigation for the given file URL.
        #[unsafe(method(loadFileURL:allowingReadAccessToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadFileURL_allowingReadAccessToURL(
            &self,
            url: &NSURL,
            read_access_url: &NSURL,
        ) -> Option<Retained<WKNavigation>>;

        #[cfg(feature = "WKNavigation")]
        /// Sets the webpage contents and base URL.
        ///
        /// Parameter `string`: The string to use as the contents of the webpage.
        ///
        /// Parameter `baseURL`: A URL that is used to resolve relative URLs within the document.
        ///
        /// Returns: A new navigation.
        #[unsafe(method(loadHTMLString:baseURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadHTMLString_baseURL(
            &self,
            string: &NSString,
            base_url: Option<&NSURL>,
        ) -> Option<Retained<WKNavigation>>;

        #[cfg(feature = "WKNavigation")]
        /// Sets the webpage contents and base URL.
        ///
        /// Parameter `data`: The data to use as the contents of the webpage.
        ///
        /// Parameter `MIMEType`: The MIME type of the data.
        ///
        /// Parameter `characterEncodingName`: The data's character encoding name.
        ///
        /// Parameter `baseURL`: A URL that is used to resolve relative URLs within the document.
        ///
        /// Returns: A new navigation.
        #[unsafe(method(loadData:MIMEType:characterEncodingName:baseURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadData_MIMEType_characterEncodingName_baseURL(
            &self,
            data: &NSData,
            mime_type: &NSString,
            character_encoding_name: &NSString,
            base_url: &NSURL,
        ) -> Option<Retained<WKNavigation>>;

        #[cfg(all(feature = "WKBackForwardListItem", feature = "WKNavigation"))]
        /// Navigates to an item from the back-forward list and sets it
        /// as the current item.
        ///
        /// Parameter `item`: The item to which to navigate. Must be one of the items in the
        /// web view's back-forward list.
        ///
        /// Returns: A new navigation to the requested item, or nil if it is already
        /// the current item or is not part of the web view's back-forward list.
        ///
        /// See also: backForwardList
        #[unsafe(method(goToBackForwardListItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn goToBackForwardListItem(
            &self,
            item: &WKBackForwardListItem,
        ) -> Option<Retained<WKNavigation>>;

        /// The page title.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Option<Retained<NSString>>;

        /// The active URL.
        ///
        /// This is the URL that should be reflected in the user
        /// interface.
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant for this
        /// property.
        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub unsafe fn URL(&self) -> Option<Retained<NSURL>>;

        /// A Boolean value indicating whether the view is currently
        /// loading content.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        #[unsafe(method(isLoading))]
        #[unsafe(method_family = none)]
        pub unsafe fn isLoading(&self) -> bool;

        /// An estimate of what fraction of the current navigation has been completed.
        ///
        /// This value ranges from 0.0 to 1.0 based on the total number of
        /// bytes expected to be received, including the main document and all of its
        /// potential subresources. After a navigation completes, the value remains at 1.0
        /// until a new navigation starts, at which point it is reset to 0.0.
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant for this
        /// property.
        #[unsafe(method(estimatedProgress))]
        #[unsafe(method_family = none)]
        pub unsafe fn estimatedProgress(&self) -> c_double;

        /// A Boolean value indicating whether all resources on the page
        /// have been loaded over securely encrypted connections.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        #[unsafe(method(hasOnlySecureContent))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasOnlySecureContent(&self) -> bool;

        #[cfg(feature = "objc2-security")]
        /// A SecTrustRef for the currently committed navigation.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        #[unsafe(method(serverTrust))]
        #[unsafe(method_family = none)]
        pub unsafe fn serverTrust(&self) -> Option<Retained<SecTrust>>;

        /// A Boolean value indicating whether there is a back item in
        /// the back-forward list that can be navigated to.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        ///
        /// See also: backForwardList.
        #[unsafe(method(canGoBack))]
        #[unsafe(method_family = none)]
        pub unsafe fn canGoBack(&self) -> bool;

        /// A Boolean value indicating whether there is a forward item in
        /// the back-forward list that can be navigated to.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        ///
        /// See also: backForwardList.
        #[unsafe(method(canGoForward))]
        #[unsafe(method_family = none)]
        pub unsafe fn canGoForward(&self) -> bool;

        #[cfg(feature = "WKNavigation")]
        /// Navigates to the back item in the back-forward list.
        ///
        /// Returns: A new navigation to the requested item, or nil if there is no back
        /// item in the back-forward list.
        #[unsafe(method(goBack))]
        #[unsafe(method_family = none)]
        pub unsafe fn goBack(&self) -> Option<Retained<WKNavigation>>;

        #[cfg(feature = "WKNavigation")]
        /// Navigates to the forward item in the back-forward list.
        ///
        /// Returns: A new navigation to the requested item, or nil if there is no
        /// forward item in the back-forward list.
        #[unsafe(method(goForward))]
        #[unsafe(method_family = none)]
        pub unsafe fn goForward(&self) -> Option<Retained<WKNavigation>>;

        #[cfg(feature = "WKNavigation")]
        /// Reloads the current page.
        ///
        /// Returns: A new navigation representing the reload.
        #[unsafe(method(reload))]
        #[unsafe(method_family = none)]
        pub unsafe fn reload(&self) -> Option<Retained<WKNavigation>>;

        #[cfg(feature = "WKNavigation")]
        /// Reloads the current page, performing end-to-end revalidation
        /// using cache-validating conditionals if possible.
        ///
        /// Returns: A new navigation representing the reload.
        #[unsafe(method(reloadFromOrigin))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadFromOrigin(&self) -> Option<Retained<WKNavigation>>;

        /// Stops loading all resources on the current page.
        #[unsafe(method(stopLoading))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopLoading(&self);

        #[cfg(feature = "block2")]
        #[unsafe(method(evaluateJavaScript:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn evaluateJavaScript_completionHandler(
            &self,
            java_script_string: &NSString,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSError)>>,
        );

        #[cfg(all(
            feature = "WKContentWorld",
            feature = "WKFrameInfo",
            feature = "block2"
        ))]
        #[unsafe(method(evaluateJavaScript:inFrame:inContentWorld:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn evaluateJavaScript_inFrame_inContentWorld_completionHandler(
            &self,
            java_script_string: &NSString,
            frame: Option<&WKFrameInfo>,
            content_world: &WKContentWorld,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSError)>>,
        );

        #[cfg(all(
            feature = "WKContentWorld",
            feature = "WKFrameInfo",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `arguments` generic should be of the correct type.
        #[unsafe(method(callAsyncJavaScript:arguments:inFrame:inContentWorld:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn callAsyncJavaScript_arguments_inFrame_inContentWorld_completionHandler(
            &self,
            function_body: &NSString,
            arguments: Option<&NSDictionary<NSString, AnyObject>>,
            frame: Option<&WKFrameInfo>,
            content_world: &WKContentWorld,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSError)>>,
        );

        #[cfg(feature = "block2")]
        /// Closes all out-of-window media presentations in a WKWebView.
        ///
        /// Includes picture-in-picture and fullscreen.
        #[unsafe(method(closeAllMediaPresentationsWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn closeAllMediaPresentationsWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[deprecated]
        #[unsafe(method(closeAllMediaPresentations))]
        #[unsafe(method_family = none)]
        pub unsafe fn closeAllMediaPresentations(&self);

        #[cfg(feature = "block2")]
        /// Pauses media playback in WKWebView.
        ///
        /// Pauses media playback. Media in the page can be restarted by calling play() on a media element or resume() on an AudioContext in JavaScript. A user can also use media controls to play media content after it has been paused.
        #[unsafe(method(pauseAllMediaPlaybackWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pauseAllMediaPlaybackWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        #[deprecated]
        #[unsafe(method(pauseAllMediaPlayback:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pauseAllMediaPlayback(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        /// Suspends or resumes all media playback in WKWebView.
        ///
        /// Parameter `suspended`: Whether media playback should be suspended or resumed.
        ///
        /// If suspended is true, this pauses media playback and blocks all attempts by the page or the user to resume until setAllMediaPlaybackSuspended is called again with suspended set to false. Media playback should always be suspended and resumed in pairs.
        #[unsafe(method(setAllMediaPlaybackSuspended:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllMediaPlaybackSuspended_completionHandler(
            &self,
            suspended: bool,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        #[deprecated]
        #[unsafe(method(resumeAllMediaPlayback:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resumeAllMediaPlayback(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        #[deprecated]
        #[unsafe(method(suspendAllMediaPlayback:))]
        #[unsafe(method_family = none)]
        pub unsafe fn suspendAllMediaPlayback(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        /// Get the current media playback state of a WKWebView.
        ///
        /// Parameter `completionHandler`: A block to invoke with the return value of the function call.
        ///
        /// If media playback exists, WKMediaPlaybackState will be one of three
        /// values: WKMediaPlaybackPaused, WKMediaPlaybackSuspended, or WKMediaPlaybackPlaying.
        /// If no media playback exists in the current WKWebView, WKMediaPlaybackState will equal
        /// WKMediaPlaybackStateNone.
        #[unsafe(method(requestMediaPlaybackStateWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn requestMediaPlaybackStateWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(WKMediaPlaybackState)>,
        );

        #[cfg(feature = "block2")]
        #[deprecated]
        #[unsafe(method(requestMediaPlaybackState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn requestMediaPlaybackState(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(WKMediaPlaybackState)>,
        );

        /// The state of camera capture on a web page.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        #[unsafe(method(cameraCaptureState))]
        #[unsafe(method_family = none)]
        pub unsafe fn cameraCaptureState(&self) -> WKMediaCaptureState;

        /// The state of microphone capture on a web page.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant
        /// for this property.
        #[unsafe(method(microphoneCaptureState))]
        #[unsafe(method_family = none)]
        pub unsafe fn microphoneCaptureState(&self) -> WKMediaCaptureState;

        #[cfg(feature = "block2")]
        /// Set camera capture state of a WKWebView.
        ///
        /// Parameter `state`: State to apply for capture.
        ///
        /// Parameter `completionHandler`: A block to invoke after the camera state has been changed.
        ///
        /// If value is WKMediaCaptureStateNone, this will stop any camera capture.
        /// If value is WKMediaCaptureStateMuted, any active camera capture will become muted.
        /// If value is WKMediaCaptureStateActive, any muted camera capture will become active.
        #[unsafe(method(setCameraCaptureState:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCameraCaptureState_completionHandler(
            &self,
            state: WKMediaCaptureState,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        /// Set microphone capture state of a WKWebView.
        ///
        /// Parameter `state`: state to apply for capture.
        ///
        /// Parameter `completionHandler`: A block to invoke after the microphone state has been changed.
        ///
        /// If value is WKMediaCaptureStateNone, this will stop any microphone capture.
        /// If value is WKMediaCaptureStateMuted, any active microphone capture will become muted.
        /// If value is WKMediaCaptureStateActive, any muted microphone capture will become active.
        #[unsafe(method(setMicrophoneCaptureState:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMicrophoneCaptureState_completionHandler(
            &self,
            state: WKMediaCaptureState,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(all(feature = "WKSnapshotConfiguration", feature = "block2"))]
        #[unsafe(method(takeSnapshotWithConfiguration:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeSnapshotWithConfiguration_completionHandler(
            &self,
            snapshot_configuration: Option<&WKSnapshotConfiguration>,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSImage, *mut NSError)>,
        );

        #[cfg(all(feature = "WKPDFConfiguration", feature = "block2"))]
        /// Create a PDF document representation from the web page currently displayed in the WKWebView
        ///
        /// Parameter `pdfConfiguration`: An object that specifies how the PDF capture is configured.
        ///
        /// Parameter `completionHandler`: A block to invoke when the pdf document data is ready.
        ///
        /// If the WKPDFConfiguration is nil, the method will create a PDF document representing the bounds of the currently displayed web page.
        /// The completionHandler is passed the resulting PDF document data or an error.
        /// The data can be used to create a PDFDocument object.
        /// If the data is written to a file the resulting file is a valid PDF document.
        #[unsafe(method(createPDFWithConfiguration:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn createPDFWithConfiguration_completionHandler(
            &self,
            pdf_configuration: Option<&WKPDFConfiguration>,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSData, *mut NSError)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(createWebArchiveDataWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn createWebArchiveDataWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSData, *mut NSError)>,
        );

        /// A Boolean value indicating whether horizontal swipe gestures
        /// will trigger back-forward list navigations.
        ///
        /// The default value is NO.
        #[unsafe(method(allowsBackForwardNavigationGestures))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsBackForwardNavigationGestures(&self) -> bool;

        /// Setter for [`allowsBackForwardNavigationGestures`][Self::allowsBackForwardNavigationGestures].
        #[unsafe(method(setAllowsBackForwardNavigationGestures:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsBackForwardNavigationGestures(
            &self,
            allows_back_forward_navigation_gestures: bool,
        );

        /// The custom user agent string or nil if no custom user agent string has been set.
        #[unsafe(method(customUserAgent))]
        #[unsafe(method_family = none)]
        pub unsafe fn customUserAgent(&self) -> Option<Retained<NSString>>;

        /// Setter for [`customUserAgent`][Self::customUserAgent].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCustomUserAgent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomUserAgent(&self, custom_user_agent: Option<&NSString>);

        /// A Boolean value indicating whether link preview is allowed for any
        /// links inside this WKWebView.
        ///
        /// The default value is YES on Mac and iOS.
        #[unsafe(method(allowsLinkPreview))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsLinkPreview(&self) -> bool;

        /// Setter for [`allowsLinkPreview`][Self::allowsLinkPreview].
        #[unsafe(method(setAllowsLinkPreview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsLinkPreview(&self, allows_link_preview: bool);

        #[unsafe(method(allowsMagnification))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsMagnification(&self) -> bool;

        /// Setter for [`allowsMagnification`][Self::allowsMagnification].
        #[unsafe(method(setAllowsMagnification:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsMagnification(&self, allows_magnification: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(magnification))]
        #[unsafe(method_family = none)]
        pub unsafe fn magnification(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`magnification`][Self::magnification].
        #[unsafe(method(setMagnification:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMagnification(&self, magnification: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setMagnification:centeredAtPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMagnification_centeredAtPoint(
            &self,
            magnification: CGFloat,
            point: CGPoint,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(pageZoom))]
        #[unsafe(method_family = none)]
        pub unsafe fn pageZoom(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`pageZoom`][Self::pageZoom].
        #[unsafe(method(setPageZoom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPageZoom(&self, page_zoom: CGFloat);

        #[cfg(all(
            feature = "WKFindConfiguration",
            feature = "WKFindResult",
            feature = "block2"
        ))]
        #[unsafe(method(findString:withConfiguration:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn findString_withConfiguration_completionHandler(
            &self,
            string: &NSString,
            configuration: Option<&WKFindConfiguration>,
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<WKFindResult>)>,
        );

        #[unsafe(method(handlesURLScheme:))]
        #[unsafe(method_family = none)]
        pub unsafe fn handlesURLScheme(url_scheme: &NSString, mtm: MainThreadMarker) -> bool;

        #[cfg(all(feature = "WKDownload", feature = "block2"))]
        #[unsafe(method(startDownloadUsingRequest:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn startDownloadUsingRequest_completionHandler(
            &self,
            request: &NSURLRequest,
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<WKDownload>)>,
        );

        #[cfg(all(feature = "WKDownload", feature = "block2"))]
        #[unsafe(method(resumeDownloadFromResumeData:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resumeDownloadFromResumeData_completionHandler(
            &self,
            resume_data: &NSData,
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<WKDownload>)>,
        );

        #[unsafe(method(mediaType))]
        #[unsafe(method_family = none)]
        pub unsafe fn mediaType(&self) -> Option<Retained<NSString>>;

        /// Setter for [`mediaType`][Self::mediaType].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMediaType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMediaType(&self, media_type: Option<&NSString>);

        #[unsafe(method(interactionState))]
        #[unsafe(method_family = none)]
        pub unsafe fn interactionState(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`interactionState`][Self::interactionState].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `interaction_state` should be of the correct type.
        #[unsafe(method(setInteractionState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInteractionState(&self, interaction_state: Option<&AnyObject>);

        /// A Boolean value indicating whether Screen Time blocking has occurred.
        #[unsafe(method(isBlockedByScreenTime))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBlockedByScreenTime(&self) -> bool;

        #[cfg(feature = "WKNavigation")]
        /// Sets the webpage contents from the passed data as if it was the
        /// response to the supplied request. The request is never actually sent to the
        /// supplied URL, though loads of resources defined in the NSData object would
        /// be performed.
        ///
        /// Parameter `request`: The request specifying the base URL and other loading details
        /// to be used while interpreting the supplied data object.
        ///
        /// Parameter `response`: A response that is used to interpret the supplied data object.
        ///
        /// Parameter `data`: The data to use as the contents of the webpage.
        ///
        /// Returns: A new navigation.
        #[unsafe(method(loadSimulatedRequest:response:responseData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadSimulatedRequest_response_responseData(
            &self,
            request: &NSURLRequest,
            response: &NSURLResponse,
            data: &NSData,
        ) -> Retained<WKNavigation>;

        #[cfg(feature = "WKNavigation")]
        #[deprecated]
        #[unsafe(method(loadSimulatedRequest:withResponse:responseData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadSimulatedRequest_withResponse_responseData(
            &self,
            request: &NSURLRequest,
            response: &NSURLResponse,
            data: &NSData,
        ) -> Retained<WKNavigation>;

        #[cfg(feature = "WKNavigation")]
        /// Navigates to the requested file URL on the filesystem.
        ///
        /// Parameter `request`: The request specifying the file URL to which to navigate.
        ///
        /// Parameter `readAccessURL`: The URL to allow read access to.
        ///
        /// If readAccessURL references a single file, only that file may be
        /// loaded by WebKit.
        /// If readAccessURL references a directory, files inside that file may be loaded by WebKit.
        ///
        /// Returns: A new navigation for the given file URL.
        #[unsafe(method(loadFileRequest:allowingReadAccessToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadFileRequest_allowingReadAccessToURL(
            &self,
            request: &NSURLRequest,
            read_access_url: &NSURL,
        ) -> Retained<WKNavigation>;

        #[cfg(feature = "WKNavigation")]
        /// Sets the webpage contents from the passed HTML string as if it was
        /// the response to the supplied request. The request is never actually sent to the
        /// supplied URL, though loads of resources defined in the HTML string would be
        /// performed.
        ///
        /// Parameter `request`: The request specifying the base URL and other loading details
        /// to be used while interpreting the supplied data object.
        ///
        /// Parameter `string`: The data to use as the contents of the webpage.
        ///
        /// Returns: A new navigation.
        #[unsafe(method(loadSimulatedRequest:responseHTMLString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadSimulatedRequest_responseHTMLString(
            &self,
            request: &NSURLRequest,
            string: &NSString,
        ) -> Retained<WKNavigation>;

        #[cfg(feature = "WKNavigation")]
        #[deprecated]
        #[unsafe(method(loadSimulatedRequest:withResponseHTMLString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadSimulatedRequest_withResponseHTMLString(
            &self,
            request: &NSURLRequest,
            string: &NSString,
        ) -> Retained<WKNavigation>;

        #[unsafe(method(printOperationWithPrintInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn printOperationWithPrintInfo(
            &self,
            print_info: &NSPrintInfo,
        ) -> Retained<NSPrintOperation>;

        #[unsafe(method(themeColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn themeColor(&self) -> Option<Retained<NSColor>>;

        #[unsafe(method(underPageBackgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn underPageBackgroundColor(&self) -> Retained<NSColor>;

        /// Setter for [`underPageBackgroundColor`][Self::underPageBackgroundColor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setUnderPageBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUnderPageBackgroundColor(
            &self,
            under_page_background_color: Option<&NSColor>,
        );

        /// A WKWebView's fullscreen state.
        ///
        ///
        /// ```text
        ///  WKWebView @link is key-value observing (KVO) compliant for this property. When an element
        ///  in the WKWebView enters fullscreen, WebKit will replace the WKWebView in the application view hierarchy with
        ///  a "placeholder" view, and move the WKWebView into a fullscreen window. When the element exits fullscreen later,
        ///  the WKWebView will be moved back into the application view hierarchy. An application may need to adjust/restore
        ///  its native UI components when the fullscreen state changes. The application should observe the fullscreenState
        ///  property of WKWebView in order to receive notifications regarding the fullscreen state change.
        ///  
        ///
        /// ```
        #[unsafe(method(fullscreenState))]
        #[unsafe(method_family = none)]
        pub unsafe fn fullscreenState(&self) -> WKFullscreenState;

        #[unsafe(method(minimumViewportInset))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumViewportInset(&self) -> NSEdgeInsets;

        #[unsafe(method(maximumViewportInset))]
        #[unsafe(method_family = none)]
        pub unsafe fn maximumViewportInset(&self) -> NSEdgeInsets;

        #[unsafe(method(setMinimumViewportInset:maximumViewportInset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMinimumViewportInset_maximumViewportInset(
            &self,
            minimum_viewport_inset: NSEdgeInsets,
            maximum_viewport_inset: NSEdgeInsets,
        );

        /// Controls whether this
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is inspectable in Web Inspector.
        ///
        /// The default value is NO.
        #[unsafe(method(isInspectable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isInspectable(&self) -> bool;

        /// Setter for [`isInspectable`][Self::isInspectable].
        #[unsafe(method(setInspectable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInspectable(&self, inspectable: bool);

        /// A Boolean value indicating whether Writing Tools is active for the view.
        ///
        ///
        /// ```text
        ///  WKWebView
        /// ```
        ///
        /// is key-value observing (KVO) compliant for this property.
        #[unsafe(method(isWritingToolsActive))]
        #[unsafe(method_family = none)]
        pub unsafe fn isWritingToolsActive(&self) -> bool;

        #[cfg(feature = "block2")]
        #[unsafe(method(fetchDataOfTypes:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchDataOfTypes_completionHandler(
            &self,
            data_types: WKWebViewDataType,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSData, *mut NSError)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(restoreData:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreData_completionHandler(
            &self,
            data: &NSData,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[unsafe(method(obscuredContentInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn obscuredContentInsets(&self) -> NSEdgeInsets;

        /// Setter for [`obscuredContentInsets`][Self::obscuredContentInsets].
        #[unsafe(method(setObscuredContentInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObscuredContentInsets(&self, obscured_content_insets: NSEdgeInsets);
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// WKIBActions.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!(
        /// Action method that navigates to the back item in the
        /// back-forward list.
        ///
        /// Parameter `sender`: The object that sent this message.
        ///
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(goBack:))]
        #[unsafe(method_family = none)]
        pub unsafe fn goBack_(&self, sender: Option<&AnyObject>);

        /// Action method that navigates to the forward item in the
        /// back-forward list.
        ///
        /// Parameter `sender`: The object that sent this message.
        ///
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(goForward:))]
        #[unsafe(method_family = none)]
        pub unsafe fn goForward_(&self, sender: Option<&AnyObject>);

        /// Action method that reloads the current page.
        ///
        /// Parameter `sender`: The object that sent this message.
        ///
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(reload:))]
        #[unsafe(method_family = none)]
        pub unsafe fn reload_(&self, sender: Option<&AnyObject>);

        /// Action method that reloads the current page, performing
        /// end-to-end revalidation using cache-validating conditionals if possible.
        ///
        /// Parameter `sender`: The object that sent this message.
        ///
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(reloadFromOrigin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadFromOrigin_(&self, sender: Option<&AnyObject>);

        /// Action method that stops loading all resources on the current
        /// page.
        ///
        /// Parameter `sender`: The object that sent this message.
        ///
        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(stopLoading:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopLoading_(&self, sender: Option<&AnyObject>);
    );
}

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for WKWebView {}
);

/// WKNSTextFinderClient.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!();
}

#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
extern_conformance!(
    unsafe impl NSTextFinderClient for WKWebView {}
);

/// WKDeprecated.
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
impl WKWebView {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(certificateChain))]
        #[unsafe(method_family = none)]
        pub unsafe fn certificateChain(&self) -> Retained<NSArray>;
    );
}
