//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A ``WKWebExtensionWindowConfiguration`` object encapsulates configuration options for a window in an extension.
    ///
    /// This class holds various options that influence the behavior and initial state of a window.
    /// The app retains the discretion to disregard any or all of these options, or even opt not to create a window.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionwindowconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionWindowConfiguration;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionWindowConfiguration {}
);

impl WKWebExtensionWindowConfiguration {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Indicates the window type for the window.
        #[unsafe(method(windowType))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowType(&self) -> WKWebExtensionWindowType;

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Indicates the window state for the window.
        #[unsafe(method(windowState))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowState(&self) -> WKWebExtensionWindowState;

        #[cfg(feature = "objc2-core-foundation")]
        /// Indicates the frame where the window should be positioned on the main screen.
        ///
        /// This frame should override the app's default window position and size.
        /// Individual components (e.g., `origin.x`, `size.width`) will be `NaN` if not specified.
        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub unsafe fn frame(&self) -> CGRect;

        /// Indicates the URLs that the window should initially load as tabs.
        ///
        /// If ``tabURLs`` and ``tabs`` are both empty, the app's default "start page" should appear in a tab.
        ///
        /// See also: tabs
        #[unsafe(method(tabURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn tabURLs(&self) -> Retained<NSArray<NSURL>>;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Indicates the existing tabs that should be moved to the window.
        ///
        /// If ``tabs`` and ``tabURLs`` are both empty, the app's default "start page" should appear in a tab.
        ///
        /// See also: tabURLs
        #[unsafe(method(tabs))]
        #[unsafe(method_family = none)]
        pub unsafe fn tabs(&self) -> Retained<NSArray<ProtocolObject<dyn WKWebExtensionTab>>>;

        /// Indicates whether the window should be focused.
        #[unsafe(method(shouldBeFocused))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldBeFocused(&self) -> bool;

        /// Indicates whether the window should be private.
        ///
        /// Note: To ensure proper isolation between private and non-private data, web views associated with private data must use a
        /// different ``WKUserContentController``. Likewise, to be identified as a private web view and to ensure that cookies and other
        /// website data is not shared, private web views must be configured to use a non-persistent ``WKWebsiteDataStore``.
        #[unsafe(method(shouldBePrivate))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldBePrivate(&self) -> bool;
    );
}
