//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// Constants used by ``WKWebExtensionWindow`` to indicate the type of a window.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionwindowtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionWindowType(pub NSInteger);
impl WKWebExtensionWindowType {
    #[doc(alias = "WKWebExtensionWindowTypeNormal")]
    pub const Normal: Self = Self(0);
    #[doc(alias = "WKWebExtensionWindowTypePopup")]
    pub const Popup: Self = Self(1);
}

unsafe impl Encode for WKWebExtensionWindowType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionWindowType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Constants used by ``WKWebExtensionWindow`` to indicate possible states of a window.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionwindowstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionWindowState(pub NSInteger);
impl WKWebExtensionWindowState {
    #[doc(alias = "WKWebExtensionWindowStateNormal")]
    pub const Normal: Self = Self(0);
    #[doc(alias = "WKWebExtensionWindowStateMinimized")]
    pub const Minimized: Self = Self(1);
    #[doc(alias = "WKWebExtensionWindowStateMaximized")]
    pub const Maximized: Self = Self(2);
    #[doc(alias = "WKWebExtensionWindowStateFullscreen")]
    pub const Fullscreen: Self = Self(3);
}

unsafe impl Encode for WKWebExtensionWindowState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionWindowState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A class conforming to the ``WKWebExtensionWindow`` protocol represents a window to web extensions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionwindow?language=objc)
    pub unsafe trait WKWebExtensionWindow: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "WKWebExtensionContext", feature = "WKWebExtensionTab"))]
        /// Called when the tabs are needed for the window.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: An array of tabs in the window.
        ///
        /// Defaults to an empty array if not implemented.
        #[optional]
        #[unsafe(method(tabsForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn tabsForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Retained<NSArray<ProtocolObject<dyn WKWebExtensionTab>>>;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "WKWebExtensionTab"))]
        /// Called when the active tab is needed for the window.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The active tab in the window, which represents the frontmost tab currently in view.
        ///
        /// Defaults to `nil` if not implemented.
        #[optional]
        #[unsafe(method(activeTabForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn activeTabForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<ProtocolObject<dyn WKWebExtensionTab>>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the type of the window is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The type of the window.
        ///
        /// Defaults to``WKWebExtensionWindowTypeNormal`` if not implemented.
        #[optional]
        #[unsafe(method(windowTypeForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn windowTypeForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> WKWebExtensionWindowType;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the state of the window is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The state of the window.
        ///
        /// Defaults to``WKWebExtensionWindowStateNormal`` if not implemented.
        #[optional]
        #[unsafe(method(windowStateForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn windowStateForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> WKWebExtensionWindowState;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set the state of the window.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `state`: The new state of the window.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// The implementation of ``windowStateForWebExtensionContext:`` is a prerequisite.
        /// Without it, this method will not be called.
        ///
        /// See also: windowStateForWebExtensionContext:
        #[optional]
        #[unsafe(method(setWindowState:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setWindowState_forWebExtensionContext_completionHandler(
            &self,
            state: WKWebExtensionWindowState,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the private state of the window is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the window is private, `NO` otherwise.
        ///
        /// Defaults to `NO` if not implemented. This value is cached and will not change for the duration of the window or its contained tabs.
        ///
        /// Note: To ensure proper isolation between private and non-private data, web views associated with private data must use a
        /// different ``WKUserContentController``. Likewise, to be identified as a private web view and to ensure that cookies and other
        /// website data is not shared, private web views must be configured to use a non-persistent ``WKWebsiteDataStore``.
        #[optional]
        #[unsafe(method(isPrivateForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isPrivateForWebExtensionContext(&self, context: &WKWebExtensionContext) -> bool;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "objc2-core-foundation"))]
        /// Called when the screen frame containing the window is needed.
        ///
        /// Parameter `context`: The context associated with the running web extension.
        ///
        /// Returns: The frame for the screen containing the window.
        ///
        /// Defaults to ``CGRectNull`` if not implemented.
        #[optional]
        #[unsafe(method(screenFrameForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn screenFrameForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> CGRect;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "objc2-core-foundation"))]
        /// Called when the frame of the window is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The frame of the window, in screen coordinates
        ///
        /// Defaults to ``CGRectNull`` if not implemented.
        #[optional]
        #[unsafe(method(frameForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn frameForWebExtensionContext(&self, context: &WKWebExtensionContext) -> CGRect;

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "block2",
            feature = "objc2-core-foundation"
        ))]
        /// Called to set the frame of the window.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `frame`: The new frame of the window, in screen coordinates.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// On macOS, the implementation of both ``frameForWebExtensionContext:`` and ``screenFrameForWebExtensionContext:``
        /// are prerequisites. On iOS, iPadOS, and visionOS, only ``frameForWebExtensionContext:`` is a prerequisite. Without the respective method(s),
        /// this method will not be called.
        ///
        /// See also: frameForWebExtensionContext:
        ///
        /// See also: screenFrameForWebExtensionContext:
        #[optional]
        #[unsafe(method(setFrame:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setFrame_forWebExtensionContext_completionHandler(
            &self,
            frame: CGRect,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to focus the window.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        #[optional]
        #[unsafe(method(focusForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn focusForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to close the window.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        #[optional]
        #[unsafe(method(closeForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn closeForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );
    }
);
