//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A ``WKWebExtensionTabConfiguration`` object encapsulates configuration options for a tab in an extension.
    ///
    /// This class holds various options that influence the behavior and initial state of a tab.
    /// The app retains the discretion to disregard any or all of these options, or even opt not to create a tab.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensiontabconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionTabConfiguration;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionTabConfiguration {}
);

impl WKWebExtensionTabConfiguration {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Indicates the window where the tab should be opened.
        ///
        /// If this property is `nil`, no window was specified.
        #[unsafe(method(window))]
        #[unsafe(method_family = none)]
        pub unsafe fn window(&self) -> Option<Retained<ProtocolObject<dyn WKWebExtensionWindow>>>;

        /// Indicates the position where the tab should be opened within the window.
        #[unsafe(method(index))]
        #[unsafe(method_family = none)]
        pub unsafe fn index(&self) -> NSUInteger;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Indicates the parent tab with which the tab should be related.
        ///
        /// If this property is `nil`, no parent tab was specified.
        #[unsafe(method(parentTab))]
        #[unsafe(method_family = none)]
        pub unsafe fn parentTab(&self) -> Option<Retained<ProtocolObject<dyn WKWebExtensionTab>>>;

        /// Indicates the initial URL for the tab.
        ///
        /// If this property is `nil`, the app's default "start page" should appear in the tab.
        #[unsafe(method(url))]
        #[unsafe(method_family = none)]
        pub unsafe fn url(&self) -> Option<Retained<NSURL>>;

        /// Indicates whether the tab should be the active tab.
        ///
        /// If this property is `YES`, the tab should be made active in the window, ensuring it is
        /// the frontmost tab. Being active implies the tab is also selected. If this property is `NO`, the tab shouldn't
        /// affect the currently active tab.
        #[unsafe(method(shouldBeActive))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldBeActive(&self) -> bool;

        /// Indicates whether the tab should be added to the current tab selection.
        ///
        /// If this property is `YES`, the tab should be part of the current selection, but not necessarily
        /// become the active tab unless ``shouldBeActive`` is also `YES`. If this property is `NO`, the tab shouldn't
        /// be part of the current selection.
        #[unsafe(method(shouldAddToSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldAddToSelection(&self) -> bool;

        /// Indicates whether the tab should be pinned.
        #[unsafe(method(shouldBePinned))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldBePinned(&self) -> bool;

        /// Indicates whether the tab should be muted.
        #[unsafe(method(shouldBeMuted))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldBeMuted(&self) -> bool;

        /// Indicates whether reader mode in the tab should be active.
        #[unsafe(method(shouldReaderModeBeActive))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldReaderModeBeActive(&self) -> bool;
    );
}
