//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// Constants used by ``WKWebExtensionController
/// @
/// /link and
///
/// ```text
///  WKWebExtensionContext`` to indicate tab changes.
///  @constant WKWebExtensionTabChangedPropertiesNone  Indicates nothing changed.
///  @constant WKWebExtensionTabChangedPropertiesLoading  Indicates the loading state changed.
///  @constant WKWebExtensionTabChangedPropertiesMuted  Indicates the muted state changed.
///  @constant WKWebExtensionTabChangedPropertiesPinned  Indicates the pinned state changed.
///  @constant WKWebExtensionTabChangedPropertiesPlayingAudio Indicates the audio playback state changed.
///  @constant WKWebExtensionTabChangedPropertiesReaderMode  Indicates the reader mode state changed.
///  @constant WKWebExtensionTabChangedPropertiesSize  Indicates the size changed.
///  @constant WKWebExtensionTabChangedPropertiesTitle  Indicates the title changed.
///  @constant WKWebExtensionTabChangedPropertiesURL  Indicates the URL changed.
///  @constant WKWebExtensionTabChangedPropertiesZoomFactor  Indicates the zoom factor changed.
///  
///
/// ```
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensiontabchangedproperties?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionTabChangedProperties(pub NSUInteger);
bitflags::bitflags! {
    impl WKWebExtensionTabChangedProperties: NSUInteger {
        #[doc(alias = "WKWebExtensionTabChangedPropertiesNone")]
        const None = 0;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesLoading")]
        const Loading = 1<<1;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesMuted")]
        const Muted = 1<<2;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesPinned")]
        const Pinned = 1<<3;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesPlayingAudio")]
        const PlayingAudio = 1<<4;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesReaderMode")]
        const ReaderMode = 1<<5;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesSize")]
        const Size = 1<<6;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesTitle")]
        const Title = 1<<7;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesURL")]
        const URL = 1<<8;
        #[doc(alias = "WKWebExtensionTabChangedPropertiesZoomFactor")]
        const ZoomFactor = 1<<9;
    }
}

unsafe impl Encode for WKWebExtensionTabChangedProperties {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionTabChangedProperties {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A class conforming to the ``WKWebExtensionTab`` protocol represents a tab to web extensions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensiontab?language=objc)
    pub unsafe trait WKWebExtensionTab: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "WKWebExtensionContext", feature = "WKWebExtensionWindow"))]
        /// Called when the window containing the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The window containing the tab.
        ///
        /// Defaults to `nil` if not implemented.
        #[optional]
        #[unsafe(method(windowForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn windowForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<ProtocolObject<dyn WKWebExtensionWindow>>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the index of the tab in the window is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The index of the tab in the window, or ``NSNotFound`` if the tab is not currently in a window.
        ///
        /// This method should be implemented for better performance. Defaults to the window's
        /// ``tabsForWebExtensionContext:`` method to find the index if not implemented.
        #[optional]
        #[unsafe(method(indexInWindowForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn indexInWindowForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> NSUInteger;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the parent tab for the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The parent tab of the tab, if the tab was opened from another tab.
        ///
        /// Defaults to `nil` if not implemented.
        ///
        /// See also: setParentTab:forWebExtensionContext:completionHandler:
        #[optional]
        #[unsafe(method(parentTabForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn parentTabForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<ProtocolObject<dyn WKWebExtensionTab>>>;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set or clear the parent tab for the tab.
        ///
        /// Parameter `parentTab`: The tab that should be set as the parent of the tab. If
        /// `nil`is provided, the current
        /// parent tab should be cleared.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        ///
        /// See also: parentTabForWebExtensionContext:
        #[optional]
        #[unsafe(method(setParentTab:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setParentTab_forWebExtensionContext_completionHandler(
            &self,
            parent_tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Called when the web view for the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The web view for the tab.
        ///
        /// The web view's ``WKWebViewConfiguration`` must have its ``webExtensionController`` property set to match
        /// the controller of the given context; otherwise `nil` will be used. Defaults to `nil` if not implemented. If `nil`, some critical features
        /// will not be available for this tab, such as content injection or modification.
        #[optional]
        #[unsafe(method(webViewForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn webViewForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<WKWebView>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the title of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The title of the tab.
        ///
        /// Defaults to ``title`` of the tab's web view if not implemented.
        #[optional]
        #[unsafe(method(titleForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn titleForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the pinned state of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the tab is pinned, `NO` otherwise.
        ///
        /// Defaults to `NO` if not implemented.
        ///
        /// See also: setPinned:forWebExtensionContext:completionHandler:
        #[optional]
        #[unsafe(method(isPinnedForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isPinnedForWebExtensionContext(&self, context: &WKWebExtensionContext) -> bool;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set the pinned state of the tab.
        ///
        /// Parameter `pinned`: A boolean value indicating whether to pin the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// This is equivalent to the user selecting to pin or unpin the tab through a menu item. When a tab is pinned,
        /// it should be moved to the front of the tab bar and usually reduced in size. When a tab is unpinned, it should be restored
        /// to a normal size and position in the tab bar. No action is performed if not implemented.
        ///
        /// See also: isPinnedForWebExtensionContext:
        #[optional]
        #[unsafe(method(setPinned:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setPinned_forWebExtensionContext_completionHandler(
            &self,
            pinned: bool,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to check if reader mode is available for the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if reader mode is available for the tab, `NO` otherwise.
        ///
        /// Defaults to `NO` if not implemented.
        ///
        /// See also: isReaderModeActiveForWebExtensionContext:
        #[optional]
        #[unsafe(method(isReaderModeAvailableForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isReaderModeAvailableForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> bool;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to check if the tab is currently showing reader mode.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the tab is showing reader mode, `NO` otherwise.
        ///
        /// Defaults to `NO` if not implemented.
        ///
        /// See also: isReaderModeAvailableForWebExtensionContext:
        #[optional]
        #[unsafe(method(isReaderModeActiveForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isReaderModeActiveForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> bool;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set the reader mode for the tab.
        ///
        /// Parameter `active`: A boolean value indicating whether to activate reader mode.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        ///
        /// See also: isReaderModeAvailableForWebExtensionContext:
        ///
        /// See also: isReaderModeActiveForWebExtensionContext:
        #[optional]
        #[unsafe(method(setReaderModeActive:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setReaderModeActive_forWebExtensionContext_completionHandler(
            &self,
            active: bool,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to check if the tab is currently playing audio.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the tab is playing audio, `NO` otherwise.
        ///
        /// Defaults to `NO` if not implemented.
        #[optional]
        #[unsafe(method(isPlayingAudioForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isPlayingAudioForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> bool;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to check if the tab is currently muted.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the tab is muted, `NO` otherwise.
        ///
        /// Defaults to `NO` if not implemented.
        ///
        /// See also: setMuted:forWebExtensionContext:completionHandler:
        #[optional]
        #[unsafe(method(isMutedForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isMutedForWebExtensionContext(&self, context: &WKWebExtensionContext) -> bool;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set the mute state of the tab.
        ///
        /// Parameter `muted`: A boolean indicating whether the tab should be muted.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        ///
        /// See also: isMutedForWebExtensionContext:
        #[optional]
        #[unsafe(method(setMuted:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setMuted_forWebExtensionContext_completionHandler(
            &self,
            muted: bool,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "objc2-core-foundation"))]
        /// Called when the size of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The size of the tab.
        ///
        /// Defaults to size of the tab's web view if not implemented.
        #[optional]
        #[unsafe(method(sizeForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn sizeForWebExtensionContext(&self, context: &WKWebExtensionContext) -> CGSize;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the zoom factor of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The zoom factor of the tab.
        ///
        /// Defaults to ``pageZoom`` of the tab's web view if not implemented.
        ///
        /// See also: setZoomFactor:forWebExtensionContext:completionHandler:
        #[optional]
        #[unsafe(method(zoomFactorForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn zoomFactorForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> c_double;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set the zoom factor of the tab.
        ///
        /// Parameter `zoomFactor`: The desired zoom factor for the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// Sets ``pageZoom`` of the tab's web view if not implemented.
        ///
        /// See also: zoomFactorForWebExtensionContext:
        #[optional]
        #[unsafe(method(setZoomFactor:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setZoomFactor_forWebExtensionContext_completionHandler(
            &self,
            zoom_factor: c_double,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the URL of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The URL of the tab.
        ///
        /// Defaults to `URL` of the tab's web view if not implemented.
        #[optional]
        #[unsafe(method(urlForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn urlForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<NSURL>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the pending URL of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: The pending URL of the tab.
        ///
        /// The pending URL is the URL of a page that is in the process of loading. If there is no pending URL, return `nil`.
        /// Defaults to `nil` if not implemented.
        #[optional]
        #[unsafe(method(pendingURLForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn pendingURLForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> Option<Retained<NSURL>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to check if the tab has finished loading.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the tab has finished loading, `NO` otherwise.
        ///
        /// Defaults to ``isLoading`` of the tab's web view if not implemented.
        #[optional]
        #[unsafe(method(isLoadingCompleteForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isLoadingCompleteForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> bool;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to detect the locale of the webpage currently loaded in the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. The block takes two arguments:
        /// the detected locale (or
        /// `nil`if the locale is unknown) and an error, which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        #[optional]
        #[unsafe(method(detectWebpageLocaleForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn detectWebpageLocaleForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSLocale, *mut NSError)>,
        );

        #[cfg(all(
            feature = "WKSnapshotConfiguration",
            feature = "WKWebExtensionContext",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        #[optional]
        #[unsafe(method(takeSnapshotUsingConfiguration:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn takeSnapshotUsingConfiguration_forWebExtensionContext_completionHandler(
            &self,
            configuration: &WKSnapshotConfiguration,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSImage, *mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to load a URL in the tab.
        ///
        /// Parameter `url`: The URL to be loaded in the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// If the tab is already loading a page, calling this method should stop the current page from loading and start
        /// loading the new URL. Loads the URL in the tab's web view via ``loadRequest:`` if not implemented.
        #[optional]
        #[unsafe(method(loadURL:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn loadURL_forWebExtensionContext_completionHandler(
            &self,
            url: &NSURL,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to reload the current page in the tab.
        ///
        /// Parameter `fromOrigin`: A boolean value indicating whether to reload the tab from the origin, bypassing the cache.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// Reloads the tab's web view via ``reload`` or ``reloadFromOrigin`` if not implemented.
        #[optional]
        #[unsafe(method(reloadFromOrigin:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn reloadFromOrigin_forWebExtensionContext_completionHandler(
            &self,
            from_origin: bool,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to navigate the tab to the previous page in its history.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// Navigates to the previous page in the tab's web view via ``goBack`` if not implemented.
        #[optional]
        #[unsafe(method(goBackForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn goBackForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to navigate the tab to the next page in its history.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// Navigates to the next page in the tab's web view via ``goForward`` if not implemented.
        #[optional]
        #[unsafe(method(goForwardForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn goForwardForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to activate the tab, making it frontmost.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// Upon activation, the tab should become the frontmost and either be the sole selected tab or
        /// be included among the selected tabs. No action is performed if not implemented.
        ///
        /// See also: setSelected:forWebExtensionContext:completionHandler:
        #[optional]
        #[unsafe(method(activateForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn activateForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called when the selected state of the tab is needed.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if the tab is selected, `NO` otherwise.
        ///
        /// Defaults to `YES` for the active tab and `NO` for other tabs if not implemented.
        #[optional]
        #[unsafe(method(isSelectedForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn isSelectedForWebExtensionContext(&self, context: &WKWebExtensionContext) -> bool;

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to set the selected state of the tab.
        ///
        /// Parameter `selected`: A boolean value indicating whether to select the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// This is equivalent to the user command-clicking on the tab to add it to or remove it from a selection.
        /// The method should update the tab's selection state without changing the active tab. No action is performed if not implemented.
        ///
        /// See also: isSelectedForWebExtensionContext:
        #[optional]
        #[unsafe(method(setSelected:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn setSelected_forWebExtensionContext_completionHandler(
            &self,
            selected: bool,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionTabConfiguration",
            feature = "block2"
        ))]
        /// Called to duplicate the tab.
        ///
        /// Parameter `configuration`: The tab configuration influencing the duplicated tab's properties.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes two arguments:
        /// the duplicated tab (or
        /// `nil`if no tab was created) and an error, which should be provided if any errors occurred.
        ///
        /// This is equivalent to the user selecting to duplicate the tab through a menu item, with the specified configuration.
        /// No action is performed if not implemented.
        #[optional]
        #[unsafe(method(duplicateUsingConfiguration:forWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn duplicateUsingConfiguration_forWebExtensionContext_completionHandler(
            &self,
            configuration: &WKWebExtensionTabConfiguration,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut ProtocolObject<dyn WKWebExtensionTab>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "WKWebExtensionContext", feature = "block2"))]
        /// Called to close the tab.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block that must be called upon completion. It takes a single error argument,
        /// which should be provided if any errors occurred.
        ///
        /// No action is performed if not implemented.
        #[optional]
        #[unsafe(method(closeForWebExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn closeForWebExtensionContext_completionHandler(
            &self,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to determine if permissions should be granted for the tab on user gesture.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` if permissions should be granted to the tab, `NO` otherwise.
        ///
        /// This method allows the app to control granting of permissions on a per-tab basis when triggered by a user
        /// gesture. Implementing this method enables the app to dynamically manage `activeTab` permissions based on the tab's
        /// current state, the content being accessed, or other custom criteria.
        #[optional]
        #[unsafe(method(shouldGrantPermissionsOnUserGestureForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn shouldGrantPermissionsOnUserGestureForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> bool;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Called to determine if the tab should bypass host permission checks.
        ///
        /// Parameter `context`: The context in which the web extension is running.
        ///
        /// Returns: `YES` to bypass host permission checks, `NO` to enforce them.
        ///
        /// This method allows the app to dynamically control whether a tab can bypass standard host permission checks.
        #[optional]
        #[unsafe(method(shouldBypassPermissionsForWebExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn shouldBypassPermissionsForWebExtensionContext(
            &self,
            context: &WKWebExtensionContext,
        ) -> bool;
    }
);
