//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Indicates a ``WKWebExtensionMessagePort`` error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmessageporterrordomain?language=objc)
    pub static WKWebExtensionMessagePortErrorDomain: &'static NSErrorDomain;
}

/// Constants used by ``NSError`` to indicate errors in the ``WKWebExtensionMessagePort`` domain.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmessageporterror?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionMessagePortError(pub NSInteger);
impl WKWebExtensionMessagePortError {
    #[doc(alias = "WKWebExtensionMessagePortErrorUnknown")]
    pub const Unknown: Self = Self(1);
    #[doc(alias = "WKWebExtensionMessagePortErrorNotConnected")]
    pub const NotConnected: Self = Self(2);
    #[doc(alias = "WKWebExtensionMessagePortErrorMessageInvalid")]
    pub const MessageInvalid: Self = Self(3);
}

unsafe impl Encode for WKWebExtensionMessagePortError {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionMessagePortError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A ``WKWebExtensionMessagePort`` object manages message-based communication with a web extension.
    ///
    /// Contains properties and methods to handle message exchanges with a web extension.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmessageport?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionMessagePort;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionMessagePort {}
);

impl WKWebExtensionMessagePort {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// The unique identifier for the app to which this port should be connected.
        ///
        /// This identifier is provided by the web extension and may or may not be used by the app.
        /// It's up to the app to decide how to interpret this identifier.
        #[unsafe(method(applicationIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn applicationIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "block2")]
        /// The block to be executed when a message is received from the web extension.
        ///
        /// An optional block to be invoked when a message is received, taking two parameters: the message and an optional error.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer or null.
        /// - The returned block's argument 2 must be a valid pointer or null.
        #[unsafe(method(messageHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn messageHandler(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`messageHandler`][Self::messageHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMessageHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMessageHandler(
            &self,
            message_handler: Option<&block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSError)>>,
        );

        #[cfg(feature = "block2")]
        /// The block to be executed when the port disconnects.
        ///
        /// An optional block to be invoked when the port disconnects, taking an optional error that indicates if the disconnection was caused by an error.
        ///
        /// # Safety
        ///
        /// The returned block's argument must be a valid pointer or null.
        #[unsafe(method(disconnectHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn disconnectHandler(&self) -> *mut block2::DynBlock<dyn Fn(*mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`disconnectHandler`][Self::disconnectHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDisconnectHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDisconnectHandler(
            &self,
            disconnect_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        /// Indicates whether the message port is disconnected.
        #[unsafe(method(isDisconnected))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDisconnected(&self) -> bool;

        #[cfg(feature = "block2")]
        /// Sends a message to the connected web extension.
        ///
        /// Parameter `message`: The JSON-serializable message to be sent.
        ///
        /// Parameter `completionHandler`: An optional block to be invoked after the message is sent, taking an optional error.
        ///
        /// Note: The message must be JSON-serializable according to ``NSJSONSerialization``.
        ///
        /// # Safety
        ///
        /// `message` should be of the correct type.
        #[unsafe(method(sendMessage:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sendMessage_completionHandler(
            &self,
            message: Option<&AnyObject>,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        /// Disconnects the port, terminating all further messages.
        #[unsafe(method(disconnect))]
        #[unsafe(method_family = none)]
        pub unsafe fn disconnect(&self);

        /// Disconnects the port, terminating all further messages with an optional error.
        ///
        /// Parameter `error`: An optional error indicating the reason for disconnection.
        #[unsafe(method(disconnectWithError:))]
        #[unsafe(method_family = none)]
        pub unsafe fn disconnectWithError(&self, error: Option<&NSError>);
    );
}
