//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Indicates a ``WKWebExtensionMatchPattern`` error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmatchpatternerrordomain?language=objc)
    pub static WKWebExtensionMatchPatternErrorDomain: &'static NSErrorDomain;
}

/// Constants used by ``NSError`` to indicate errors in the ``WKWebExtensionMatchPattern`` domain.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmatchpatternerror?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionMatchPatternError(pub NSInteger);
impl WKWebExtensionMatchPatternError {
    #[doc(alias = "WKWebExtensionMatchPatternErrorUnknown")]
    pub const Unknown: Self = Self(1);
    #[doc(alias = "WKWebExtensionMatchPatternErrorInvalidScheme")]
    pub const InvalidScheme: Self = Self(2);
    #[doc(alias = "WKWebExtensionMatchPatternErrorInvalidHost")]
    pub const InvalidHost: Self = Self(3);
    #[doc(alias = "WKWebExtensionMatchPatternErrorInvalidPath")]
    pub const InvalidPath: Self = Self(4);
}

unsafe impl Encode for WKWebExtensionMatchPatternError {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionMatchPatternError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Constants used by ``WKWebExtensionMatchPattern`` to indicate matching options.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmatchpatternoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionMatchPatternOptions(pub NSUInteger);
bitflags::bitflags! {
    impl WKWebExtensionMatchPatternOptions: NSUInteger {
        #[doc(alias = "WKWebExtensionMatchPatternOptionsNone")]
        const None = 0;
        #[doc(alias = "WKWebExtensionMatchPatternOptionsIgnoreSchemes")]
        const IgnoreSchemes = 1<<0;
        #[doc(alias = "WKWebExtensionMatchPatternOptionsIgnorePaths")]
        const IgnorePaths = 1<<1;
        #[doc(alias = "WKWebExtensionMatchPatternOptionsMatchBidirectionally")]
        const MatchBidirectionally = 1<<2;
    }
}

unsafe impl Encode for WKWebExtensionMatchPatternOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionMatchPatternOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A ``WKWebExtensionMatchPattern`` object represents a way to specify groups of URLs.
    ///
    /// All match patterns are specified as strings. Apart from the special `
    /// <all
    /// _urls>` pattern, match patterns
    /// consist of three parts: scheme, host, and path.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionmatchpattern?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionMatchPattern;
);

extern_conformance!(
    unsafe impl NSCoding for WKWebExtensionMatchPattern {}
);

extern_conformance!(
    unsafe impl NSCopying for WKWebExtensionMatchPattern {}
);

unsafe impl CopyingHelper for WKWebExtensionMatchPattern {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionMatchPattern {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for WKWebExtensionMatchPattern {}
);

impl WKWebExtensionMatchPattern {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Registers a custom URL scheme that can be used in match patterns.
        ///
        /// This method should be used to register any custom URL schemes used by the app for the extension base URLs,
        /// other than `webkit-extension`, or if extensions should have access to other supported URL schemes when using `
        /// <all
        /// _urls>`.
        ///
        /// Parameter `urlScheme`: The custom URL scheme to register.
        #[unsafe(method(registerCustomURLScheme:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerCustomURLScheme(url_scheme: &NSString, mtm: MainThreadMarker);

        /// Returns a pattern object for `
        /// <all
        /// _urls>`.
        #[unsafe(method(allURLsMatchPattern))]
        #[unsafe(method_family = none)]
        pub unsafe fn allURLsMatchPattern(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns a pattern object that has `*` for scheme, host, and path.
        #[unsafe(method(allHostsAndSchemesMatchPattern))]
        #[unsafe(method_family = none)]
        pub unsafe fn allHostsAndSchemesMatchPattern(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns a pattern object for the specified pattern string.
        ///
        /// Returns: Returns `nil` if the pattern string is invalid.
        ///
        /// See also: initWithString:error:
        #[unsafe(method(matchPatternWithString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchPatternWithString(
            string: &NSString,
            mtm: MainThreadMarker,
        ) -> Option<Retained<Self>>;

        /// Returns a pattern object for the specified scheme, host, and path strings.
        ///
        /// Returns: A pattern object, or `nil` if any of the strings are invalid.
        ///
        /// See also: initWithScheme:host:path:error:
        #[unsafe(method(matchPatternWithScheme:host:path:))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchPatternWithScheme_host_path(
            scheme: &NSString,
            host: &NSString,
            path: &NSString,
            mtm: MainThreadMarker,
        ) -> Option<Retained<Self>>;

        /// Returns a pattern object for the specified pattern string.
        ///
        /// Parameter `error`: Set to
        /// `nil`or an error instance if an error occurred.
        ///
        /// Returns: A pattern object, or `nil` if the pattern string is invalid and an error will be set.
        ///
        /// See also: initWithString:
        #[unsafe(method(initWithString:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString_error(
            this: Allocated<Self>,
            string: &NSString,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        /// Returns a pattern object for the specified scheme, host, and path strings.
        ///
        /// Parameter `error`: Set to
        /// `nil`or an error instance if an error occurred.
        ///
        /// Returns: A pattern object, or `nil` if any of the strings are invalid and an error will be set.
        ///
        /// See also: initWithScheme:host:path:
        #[unsafe(method(initWithScheme:host:path:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithScheme_host_path_error(
            this: Allocated<Self>,
            scheme: &NSString,
            host: &NSString,
            path: &NSString,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        /// The original pattern string.
        #[unsafe(method(string))]
        #[unsafe(method_family = none)]
        pub unsafe fn string(&self) -> Retained<NSString>;

        /// The scheme part of the pattern string, unless ``matchesAllURLs`` is `YES`.
        #[unsafe(method(scheme))]
        #[unsafe(method_family = none)]
        pub unsafe fn scheme(&self) -> Option<Retained<NSString>>;

        /// The host part of the pattern string, unless ``matchesAllURLs`` is `YES`.
        #[unsafe(method(host))]
        #[unsafe(method_family = none)]
        pub unsafe fn host(&self) -> Option<Retained<NSString>>;

        /// The path part of the pattern string, unless ``matchesAllURLs`` is `YES`.
        #[unsafe(method(path))]
        #[unsafe(method_family = none)]
        pub unsafe fn path(&self) -> Option<Retained<NSString>>;

        /// If the pattern is `
        /// <all
        /// _urls>`.
        #[unsafe(method(matchesAllURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesAllURLs(&self) -> bool;

        /// If the pattern is `
        /// <all
        /// _urls>` or has `*` as the host.
        #[unsafe(method(matchesAllHosts))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesAllHosts(&self) -> bool;

        /// Matches the reciever pattern against the specified URL.
        ///
        /// Parameter `url`: The URL to match the against the reciever pattern.
        ///
        /// Returns: A Boolean value indicating if pattern matches the specified URL.
        ///
        /// See also: matchesURL:options:
        #[unsafe(method(matchesURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesURL(&self, url: Option<&NSURL>) -> bool;

        /// Matches the reciever pattern against the specified URL with options.
        ///
        /// Parameter `url`: The URL to match the against the reciever pattern.
        ///
        /// Parameter `options`: The options to use while matching.
        ///
        /// Returns: A Boolean value indicating if pattern matches the specified URL.
        ///
        /// See also: matchesURL:
        #[unsafe(method(matchesURL:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesURL_options(
            &self,
            url: Option<&NSURL>,
            options: WKWebExtensionMatchPatternOptions,
        ) -> bool;

        /// Matches the receiver pattern against the specified pattern.
        ///
        /// Parameter `pattern`: The pattern to match against the receiver pattern.
        ///
        /// Returns: A Boolean value indicating if receiver pattern matches the specified pattern.
        ///
        /// See also: matchesPattern:options:
        #[unsafe(method(matchesPattern:))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesPattern(&self, pattern: Option<&WKWebExtensionMatchPattern>) -> bool;

        /// Matches the receiver pattern against the specified pattern with options.
        ///
        /// Parameter `pattern`: The pattern to match against the receiver pattern.
        ///
        /// Parameter `options`: The options to use while matching.
        ///
        /// Returns: A Boolean value indicating if receiver pattern matches the specified pattern.
        ///
        /// See also: matchesPattern:
        #[unsafe(method(matchesPattern:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesPattern_options(
            &self,
            pattern: Option<&WKWebExtensionMatchPattern>,
            options: WKWebExtensionMatchPatternOptions,
        ) -> bool;
    );
}
