//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Indicates a ``WKWebExtensionDataRecord`` error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensiondatarecorderrordomain?language=objc)
    pub static WKWebExtensionDataRecordErrorDomain: &'static NSErrorDomain;
}

/// Constants used by ``NSError`` to indicate errors in the ``WKWebExtensionDataRecord`` domain.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensiondatarecorderror?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionDataRecordError(pub NSInteger);
impl WKWebExtensionDataRecordError {
    #[doc(alias = "WKWebExtensionDataRecordErrorUnknown")]
    pub const Unknown: Self = Self(1);
    #[doc(alias = "WKWebExtensionDataRecordErrorLocalStorageFailed")]
    pub const LocalStorageFailed: Self = Self(2);
    #[doc(alias = "WKWebExtensionDataRecordErrorSessionStorageFailed")]
    pub const SessionStorageFailed: Self = Self(3);
    #[doc(alias = "WKWebExtensionDataRecordErrorSynchronizedStorageFailed")]
    pub const SynchronizedStorageFailed: Self = Self(4);
}

unsafe impl Encode for WKWebExtensionDataRecordError {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionDataRecordError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A ``WKWebExtensionDataRecord`` object represents a record of stored data for a specific web extension context.
    ///
    /// Contains properties and methods to query the data types and sizes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensiondatarecord?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionDataRecord;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionDataRecord {}
);

impl WKWebExtensionDataRecord {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// The display name for the web extension to which this data record belongs.
        #[unsafe(method(displayName))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayName(&self) -> Retained<NSString>;

        /// Unique identifier for the web extension context to which this data record belongs.
        #[unsafe(method(uniqueIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn uniqueIdentifier(&self) -> Retained<NSString>;

        #[cfg(feature = "WKWebExtensionDataType")]
        /// The set of data types contained in this data record.
        #[unsafe(method(containedDataTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn containedDataTypes(&self) -> Retained<NSSet<WKWebExtensionDataType>>;

        /// An array of errors that may have occurred when either calculating or deleting storage.
        #[unsafe(method(errors))]
        #[unsafe(method_family = none)]
        pub unsafe fn errors(&self) -> Retained<NSArray<NSError>>;

        /// The total size in bytes of all data types contained in this data record.
        ///
        /// See also: sizeInBytesOfTypes:
        #[unsafe(method(totalSizeInBytes))]
        #[unsafe(method_family = none)]
        pub unsafe fn totalSizeInBytes(&self) -> NSUInteger;

        #[cfg(feature = "WKWebExtensionDataType")]
        /// Retrieves the size in bytes of the specific data types in this data record.
        ///
        /// Parameter `dataTypes`: The set of data types to measure the size for.
        ///
        /// Returns: The total size of the specified data types.
        ///
        /// See also: totalSizeInBytes
        #[unsafe(method(sizeInBytesOfTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sizeInBytesOfTypes(
            &self,
            data_types: &NSSet<WKWebExtensionDataType>,
        ) -> NSUInteger;
    );
}
