//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontrollerdelegate?language=objc)
    pub unsafe trait WKWebExtensionControllerDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionWindow"
        ))]
        /// Called when an extension context requests the list of ordered open windows.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Returns: The array of ordered open windows.
        ///
        /// This method should be implemented by the app to provide the extension with the ordered open windows. Depending on your
        /// app's requirements, you may return different windows for each extension or the same windows for all extensions. The first window in the returned
        /// array must correspond to the currently focused window and match the result of ``webExtensionController:focusedWindowForExtensionContext:``.
        /// If ``webExtensionController:focusedWindowForExtensionContext:`` returns `nil`, indicating that no window has focus or the focused
        /// window is not visible to the extension, the first window in the list returned by this method will be considered the presumed focused window. An empty result
        /// indicates no open windows are available for the extension. Defaults to an empty array if not implemented.
        ///
        /// See also: webExtensionController:focusedWindowForExtensionContext:
        #[optional]
        #[unsafe(method(webExtensionController:openWindowsForExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_openWindowsForExtensionContext(
            &self,
            controller: &WKWebExtensionController,
            extension_context: &WKWebExtensionContext,
        ) -> Retained<NSArray<ProtocolObject<dyn WKWebExtensionWindow>>>;

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionWindow"
        ))]
        /// Called when an extension context requests the currently focused window.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Returns: The window that is currently focused, or `nil` if no window is focused or the focused window is not visible to the extension.
        ///
        /// This method can be optionally implemented by the app to designate the window currently in focus to the extension.
        /// If not implemented, the first window in the result of ``webExtensionController:openWindowsForExtensionContext:`` is used.
        ///
        /// See also: webExtensionController:openWindowsForExtensionContext:
        #[optional]
        #[unsafe(method(webExtensionController:focusedWindowForExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_focusedWindowForExtensionContext(
            &self,
            controller: &WKWebExtensionController,
            extension_context: &WKWebExtensionContext,
        ) -> Option<Retained<ProtocolObject<dyn WKWebExtensionWindow>>>;

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionWindow",
            feature = "WKWebExtensionWindowConfiguration",
            feature = "block2"
        ))]
        /// Called when an extension context requests a new window to be opened.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `configuration`: The configuration specifying how the new window should be created.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called with the newly created window or
        /// `nil`if the window wasn't created. An error should be
        /// provided if any errors occurred.
        ///
        /// This method should be implemented by the app to handle requests to open new windows. The app can decide how to handle the
        /// process based on the provided configuration and existing windows. Once handled, the app should call the completion handler with the opened window
        /// or `nil` if the request was declined or failed. If not implemented, the extension will be unable to open new windows.
        #[optional]
        #[unsafe(method(webExtensionController:openNewWindowUsingConfiguration:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_openNewWindowUsingConfiguration_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            configuration: &WKWebExtensionWindowConfiguration,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut ProtocolObject<dyn WKWebExtensionWindow>, *mut NSError),
            >,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionTab",
            feature = "WKWebExtensionTabConfiguration",
            feature = "block2"
        ))]
        /// Called when an extension context requests a new tab to be opened.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `configuration`: The configuration specifying how the new tab should be created.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called with the newly created tab or
        /// `nil`if the tab wasn't created. An error should be
        /// provided if any errors occurred.
        ///
        /// This method should be implemented by the app to handle requests to open new tabs. The app can decide how to handle the
        /// process based on the provided configuration and existing tabs. Once handled, the app should call the completion handler with the opened tab
        /// or `nil` if the request was declined or failed. If not implemented, the extension will be unable to open new tabs.
        #[optional]
        #[unsafe(method(webExtensionController:openNewTabUsingConfiguration:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_openNewTabUsingConfiguration_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            configuration: &WKWebExtensionTabConfiguration,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut ProtocolObject<dyn WKWebExtensionTab>, *mut NSError),
            >,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "block2"
        ))]
        /// Called when an extension context requests its options page to be opened.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called once the options page has been displayed or with an error if the page could not be shown.
        ///
        /// This method should be implemented by the app to handle requests to display the extension's options page. The app can decide
        /// how and where to display the options page (e.g., in a new tab or a separate window). The app should call the completion handler once the options
        /// page is visible to the user, or with an error if the operation was declined or failed. If not implemented, the options page will be opened in a new tab
        /// using the ``webExtensionController:openNewTabUsingConfiguration:forExtensionContext:completionHandler:`` delegate method.
        #[optional]
        #[unsafe(method(webExtensionController:openOptionsPageForExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_openOptionsPageForExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionPermission",
            feature = "WKWebExtensionTab",
            feature = "block2"
        ))]
        /// Called when an extension context requests permissions.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `permissions`: The set of permissions being requested by the extension.
        ///
        /// Parameter `tab`: The tab in which the extension is running, or
        /// `nil`if the request is not specific to a tab.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called with the set of allowed permissions and an optional expiration date.
        ///
        /// This method should be implemented by the app to prompt the user for permission and call the completion handler with the
        /// set of permissions that were granted and an optional expiration date. If not implemented or the completion handler is not called within a reasonable
        /// amount of time, the request is assumed to have been denied. The expiration date can be used to specify when the permissions expire. If `nil`,
        /// permissions are assumed to not expire.
        #[optional]
        #[unsafe(method(webExtensionController:promptForPermissions:inTab:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_promptForPermissions_inTab_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            permissions: &NSSet<WKWebExtensionPermission>,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<
                dyn Fn(NonNull<NSSet<WKWebExtensionPermission>>, *mut NSDate),
            >,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionTab",
            feature = "block2"
        ))]
        /// Called when an extension context requests access to a set of URLs.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `urls`: The set of URLs that the extension is requesting access to.
        ///
        /// Parameter `tab`: The tab in which the extension is running, or
        /// `nil`if the request is not specific to a tab.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called with the set of allowed URLs and an optional expiration date.
        ///
        /// This method should be implemented by the app to prompt the user for permission and call the completion handler with the
        /// set of URLs that were granted access to and an optional expiration date. If not implemented or the completion handler is not called within a
        /// reasonable amount of time, the request is assumed to have been denied. The expiration date can be used to specify when the URLs expire.
        /// If `nil`, URLs are assumed to not expire.
        #[optional]
        #[unsafe(method(webExtensionController:promptForPermissionToAccessURLs:inTab:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_promptForPermissionToAccessURLs_inTab_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            urls: &NSSet<NSURL>,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<NSSet<NSURL>>, *mut NSDate)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionMatchPattern",
            feature = "WKWebExtensionTab",
            feature = "block2"
        ))]
        /// Called when an extension context requests access to a set of match patterns.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `matchPatterns`: The set of match patterns that the extension is requesting access to.
        ///
        /// Parameter `tab`: The tab in which the extension is running, or
        /// `nil`if the request is not specific to a tab.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called with the set of allowed match patterns and an optional expiration date.
        ///
        /// This method should be implemented by the app to prompt the user for permission and call the completion handler with the
        /// set of match patterns that were granted access to and an optional expiration date. If not implemented or the completion handler is not called
        /// within a reasonable amount of time, the request is assumed to have been denied. The expiration date can be used to specify when the match
        /// patterns expire. If `nil`, match patterns are assumed to not expire.
        #[optional]
        #[unsafe(method(webExtensionController:promptForPermissionMatchPatterns:inTab:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_promptForPermissionMatchPatterns_inTab_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            match_patterns: &NSSet<WKWebExtensionMatchPattern>,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<
                dyn Fn(NonNull<NSSet<WKWebExtensionMatchPattern>>, *mut NSDate),
            >,
        );

        #[cfg(all(
            feature = "WKWebExtensionAction",
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController"
        ))]
        /// Called when an action's properties are updated.
        ///
        /// Parameter `controller`: The web extension controller initiating the request.
        ///
        /// Parameter `action`: The web extension action whose properties are updated.
        ///
        /// Parameter `context`: The context within which the web extension is running.
        ///
        /// This method is called when an action's properties are updated and should be reflected in the app's user interface.
        /// The app should ensure that any visible changes, such as icons and labels, are updated accordingly.
        #[optional]
        #[unsafe(method(webExtensionController:didUpdateAction:forExtensionContext:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_didUpdateAction_forExtensionContext(
            &self,
            controller: &WKWebExtensionController,
            action: &WKWebExtensionAction,
            context: &WKWebExtensionContext,
        );

        #[cfg(all(
            feature = "WKWebExtensionAction",
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "block2"
        ))]
        /// Called when a popup is requested to be displayed for a specific action.
        ///
        /// Parameter `controller`: The web extension controller initiating the request.
        ///
        /// Parameter `action`: The action for which the popup is requested.
        ///
        /// Parameter `context`: The context within which the web extension is running.
        ///
        /// Parameter `completionHandler`: A block to be called once the popup display operation is completed.
        ///
        /// This method is called in response to the extension's scripts or when invoking ``performActionForTab:`` if the action has a popup.
        /// The associated tab, if applicable, can be located through the ``associatedTab`` property of the ``action`` parameter. This delegate method is
        /// called when the web view for the popup is fully loaded and ready to display. Implementing this method is needed if the app intends to support
        /// programmatically showing the popup by the extension, although it is recommended for handling both programmatic and user-initiated cases.
        #[optional]
        #[unsafe(method(webExtensionController:presentPopupForAction:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_presentPopupForAction_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            action: &WKWebExtensionAction,
            context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "block2"
        ))]
        /// Called when an extension context wants to send a one-time message to an application.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `message`: The message to be sent.
        ///
        /// Parameter `applicationIdentifier`: The unique identifier for the application, or
        /// `nil`if none was specified.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `replyHandler`: A block to be called with a JSON-serializable reply message or an error.
        ///
        /// This method should be implemented by the app to handle one-off messages to applications.
        /// If not implemented, the default behavior is to pass the message to the app extension handler within the extension's bundle,
        /// if the extension was loaded from an app extension bundle; otherwise, no action is performed if not implemented.
        ///
        /// Note: The reply message must be JSON-serializable according to ``NSJSONSerialization``.
        ///
        /// # Safety
        ///
        /// `message` should be of the correct type.
        #[optional]
        #[unsafe(method(webExtensionController:sendMessage:toApplicationWithIdentifier:forExtensionContext:replyHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_sendMessage_toApplicationWithIdentifier_forExtensionContext_replyHandler(
            &self,
            controller: &WKWebExtensionController,
            message: &AnyObject,
            application_identifier: Option<&NSString>,
            extension_context: &WKWebExtensionContext,
            reply_handler: &block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSError)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionController",
            feature = "WKWebExtensionMessagePort",
            feature = "block2"
        ))]
        /// Called when an extension context wants to establish a persistent connection to an application.
        ///
        /// Parameter `controller`: The web extension controller that is managing the extension.
        ///
        /// Parameter `extensionContext`: The context in which the web extension is running.
        ///
        /// Parameter `port`: A port object for handling the message exchange.
        ///
        /// Parameter `completionHandler`: A block to be called when the connection is ready to use, taking an optional error.
        /// If the connection is successfully established, the error should be
        /// `nil.`
        /// This method should be implemented by the app to handle establishing connections to applications.
        /// The provided ``WKWebExtensionPort`` object can be used to handle message sending, receiving, and disconnection.
        /// You should retain the port object for as long as the connection remains active. Releasing the port will disconnect it.
        /// If not implemented, the default behavior is to pass the messages to the app extension handler within the extension's bundle,
        /// if the extension was loaded from an app extension bundle; otherwise, no action is performed if not implemented.
        #[optional]
        #[unsafe(method(webExtensionController:connectUsingMessagePort:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webExtensionController_connectUsingMessagePort_forExtensionContext_completionHandler(
            &self,
            controller: &WKWebExtensionController,
            port: &WKWebExtensionMessagePort,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );
    }
);
