//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A ``WKWebExtensionControllerConfiguration`` object with which to initialize a web extension controller.
    ///
    /// Contains properties used to configure a ``WKWebExtensionController``.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontrollerconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionControllerConfiguration;
);

extern_conformance!(
    unsafe impl NSCoding for WKWebExtensionControllerConfiguration {}
);

extern_conformance!(
    unsafe impl NSCopying for WKWebExtensionControllerConfiguration {}
);

unsafe impl CopyingHelper for WKWebExtensionControllerConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionControllerConfiguration {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for WKWebExtensionControllerConfiguration {}
);

impl WKWebExtensionControllerConfiguration {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Returns a new default configuration that is persistent and not unique.
        ///
        /// If a ``WKWebExtensionController`` is associated with a persistent configuration,
        /// data will be written to the file system in a common location. When using multiple extension controllers, each
        /// controller should use a unique configuration to avoid conflicts.
        ///
        /// See also: configurationWithIdentifier:
        #[unsafe(method(defaultConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns a new non-persistent configuration.
        ///
        /// If a ``WKWebExtensionController`` is associated with a non-persistent configuration,
        /// no data will be written to the file system. This is useful for extensions in "private browsing" situations.
        #[unsafe(method(nonPersistentConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn nonPersistentConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns a new configuration that is persistent and unique for the specified identifier.
        ///
        /// If a ``WKWebExtensionController`` is associated with a unique persistent configuration,
        /// data will be written to the file system in a unique location based on the specified identifier.
        ///
        /// See also: defaultConfiguration
        #[unsafe(method(configurationWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithIdentifier(
            identifier: &NSUUID,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// A Boolean value indicating if this context will write data to the the file system.
        #[unsafe(method(isPersistent))]
        #[unsafe(method_family = none)]
        pub unsafe fn isPersistent(&self) -> bool;

        /// The unique identifier used for persistent configuration storage, or `nil` when it is the default or not persistent.
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn identifier(&self) -> Option<Retained<NSUUID>>;

        #[cfg(feature = "WKWebViewConfiguration")]
        /// The web view configuration to be used as a basis for configuring web views in extension contexts.
        #[unsafe(method(webViewConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn webViewConfiguration(&self) -> Retained<WKWebViewConfiguration>;

        #[cfg(feature = "WKWebViewConfiguration")]
        /// Setter for [`webViewConfiguration`][Self::webViewConfiguration].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setWebViewConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWebViewConfiguration(
            &self,
            web_view_configuration: Option<&WKWebViewConfiguration>,
        );

        #[cfg(feature = "WKWebsiteDataStore")]
        /// The default data store for website data and cookie access in extension contexts.
        ///
        /// This property sets the primary data store for managing website data, including cookies, which extensions can access,
        /// subject to the granted permissions within the extension contexts. Defaults to ``WKWebsiteDataStore.defaultDataStore``.
        ///
        /// Note: In addition to this data store, extensions can also access other data stores, such as non-persistent ones, for any open tabs.
        #[unsafe(method(defaultWebsiteDataStore))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultWebsiteDataStore(&self) -> Option<Retained<WKWebsiteDataStore>>;

        #[cfg(feature = "WKWebsiteDataStore")]
        /// Setter for [`defaultWebsiteDataStore`][Self::defaultWebsiteDataStore].
        ///
        /// # Safety
        ///
        /// `default_website_data_store` might not allow `None`.
        #[unsafe(method(setDefaultWebsiteDataStore:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultWebsiteDataStore(
            &self,
            default_website_data_store: Option<&WKWebsiteDataStore>,
        );
    );
}
