//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A ``WKWebExtensionController`` object manages a set of loaded extension contexts.
    ///
    /// You can have one or more extension controller instances, allowing different parts of the app to use different sets of extensions.
    /// A controller is associated with ``WKWebView`` via the ``webExtensionController`` property on ``WKWebViewConfiguration``.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontroller?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionController;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionController {}
);

impl WKWebExtensionController {
    extern_methods!(
        /// Returns a web extension controller initialized with the default configuration.
        ///
        /// Returns: An initialized web extension controller, or nil if the object could not be initialized.
        ///
        /// This is a designated initializer. You can use ``initWithConfiguration:`` to
        /// initialize an instance with a configuration.
        ///
        /// See also: initWithConfiguration:
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "WKWebExtensionControllerConfiguration")]
        /// Returns a web extension controller initialized with the specified configuration.
        ///
        /// Parameter `configuration`: The configuration for the new web extension controller.
        ///
        /// Returns: An initialized web extension controller, or nil if the object could not be initialized.
        ///
        /// This is a designated initializer. You can use ``init:`` to initialize an
        /// instance with the default configuration. The initializer copies the specified configuration, so mutating
        /// the configuration after invoking the initializer has no effect on the web extension controller.
        ///
        /// See also: init
        #[unsafe(method(initWithConfiguration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithConfiguration(
            this: Allocated<Self>,
            configuration: &WKWebExtensionControllerConfiguration,
        ) -> Retained<Self>;

        #[cfg(feature = "WKWebExtensionControllerDelegate")]
        /// The extension controller delegate.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WKWebExtensionControllerDelegate>>>;

        #[cfg(feature = "WKWebExtensionControllerDelegate")]
        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn WKWebExtensionControllerDelegate>>,
        );

        #[cfg(feature = "WKWebExtensionControllerConfiguration")]
        /// A copy of the configuration with which the web extension controller was initialized.
        ///
        /// Mutating the configuration has no effect on the web extension controller.
        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration(&self) -> Retained<WKWebExtensionControllerConfiguration>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Loads the specified extension context.
        ///
        /// Causes the context to start, loading any background content, and injecting any content into relevant tabs.
        ///
        /// Parameter `error`: Set to
        /// `nil`or an
        /// `NSError`instance if an error occurred.
        ///
        /// Returns: A Boolean value indicating if the context was successfully loaded.
        ///
        /// See also: loadExtensionContext:
        #[unsafe(method(loadExtensionContext:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadExtensionContext_error(
            &self,
            extension_context: &WKWebExtensionContext,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Unloads the specified extension context.
        ///
        /// Causes the context to stop running.
        ///
        /// Parameter `error`: Set to
        /// `nil`or an
        /// `NSError`instance if an error occurred.
        ///
        /// Returns: A Boolean value indicating if the context was successfully unloaded.
        ///
        /// See also: unloadExtensionContext:
        #[unsafe(method(unloadExtensionContext:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unloadExtensionContext_error(
            &self,
            extension_context: &WKWebExtensionContext,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "WKWebExtension", feature = "WKWebExtensionContext"))]
        /// Returns a loaded extension context for the specified extension.
        ///
        /// Parameter `extension`: An extension to lookup.
        ///
        /// Returns: An extension context or `nil` if no match was found.
        ///
        /// See also: extensions
        #[unsafe(method(extensionContextForExtension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensionContextForExtension(
            &self,
            extension: &WKWebExtension,
        ) -> Option<Retained<WKWebExtensionContext>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// Returns a loaded extension context matching the specified URL.
        ///
        /// Parameter `URL`: The URL to lookup.
        ///
        /// Returns: An extension context or `nil` if no match was found.
        ///
        /// This method is useful for determining the extension context to use when about to navigate to an extension URL. For example,
        /// you could use this method to retrieve the appropriate extension context and then use its ``webViewConfiguration`` property to configure a
        /// web view for loading that URL.
        #[unsafe(method(extensionContextForURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensionContextForURL(
            &self,
            url: &NSURL,
        ) -> Option<Retained<WKWebExtensionContext>>;

        #[cfg(feature = "WKWebExtension")]
        /// A set of all the currently loaded extensions.
        ///
        /// See also: extensionContexts
        #[unsafe(method(extensions))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensions(&self) -> Retained<NSSet<WKWebExtension>>;

        #[cfg(feature = "WKWebExtensionContext")]
        /// A set of all the currently loaded extension contexts.
        ///
        /// See also: extensions
        #[unsafe(method(extensionContexts))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensionContexts(&self) -> Retained<NSSet<WKWebExtensionContext>>;

        #[cfg(feature = "WKWebExtensionDataType")]
        /// Returns a set of all available extension data types.
        #[unsafe(method(allExtensionDataTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allExtensionDataTypes(
            mtm: MainThreadMarker,
        ) -> Retained<NSSet<WKWebExtensionDataType>>;

        #[cfg(all(
            feature = "WKWebExtensionDataRecord",
            feature = "WKWebExtensionDataType",
            feature = "block2"
        ))]
        /// Fetches data records containing the given extension data types for all known extensions.
        ///
        /// Parameter `dataTypes`: The extension data types to fetch records for.
        ///
        /// Parameter `completionHandler`: A block to invoke when the data records have been fetched.
        ///
        /// Note: The extension does not need to be loaded to be included in the result.
        #[unsafe(method(fetchDataRecordsOfTypes:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchDataRecordsOfTypes_completionHandler(
            &self,
            data_types: &NSSet<WKWebExtensionDataType>,
            completion_handler: &block2::DynBlock<
                dyn Fn(NonNull<NSArray<WKWebExtensionDataRecord>>),
            >,
        );

        #[cfg(all(
            feature = "WKWebExtensionContext",
            feature = "WKWebExtensionDataRecord",
            feature = "WKWebExtensionDataType",
            feature = "block2"
        ))]
        /// Fetches a data record containing the given extension data types for a specific known web extension context.
        ///
        /// Parameter `dataTypes`: The extension data types to fetch records for.
        ///
        /// Parameter `extensionContext`: The specific web extension context to fetch records for.
        ///
        /// Parameter `completionHandler`: A block to invoke when the data record has been fetched.
        ///
        /// Note: The extension does not need to be loaded to be included in the result.
        #[unsafe(method(fetchDataRecordOfTypes:forExtensionContext:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchDataRecordOfTypes_forExtensionContext_completionHandler(
            &self,
            data_types: &NSSet<WKWebExtensionDataType>,
            extension_context: &WKWebExtensionContext,
            completion_handler: &block2::DynBlock<dyn Fn(*mut WKWebExtensionDataRecord)>,
        );

        #[cfg(all(
            feature = "WKWebExtensionDataRecord",
            feature = "WKWebExtensionDataType",
            feature = "block2"
        ))]
        /// Removes extension data of the given types for the given data records.
        ///
        /// Parameter `dataTypes`: The extension data types that should be removed.
        ///
        /// Parameter `dataRecords`: The extension data records to delete data from.
        ///
        /// Parameter `completionHandler`: A block to invoke when the data has been removed.
        #[unsafe(method(removeDataOfTypes:fromDataRecords:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeDataOfTypes_fromDataRecords_completionHandler(
            &self,
            data_types: &NSSet<WKWebExtensionDataType>,
            data_records: &NSArray<WKWebExtensionDataRecord>,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Should be called by the app when a new window is opened to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `newWindow`: The newly opened window.
        ///
        /// This method informs all loaded extensions of the opening of a new window, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        ///
        /// See also: didCloseWindow:
        #[unsafe(method(didOpenWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didOpenWindow(&self, new_window: &ProtocolObject<dyn WKWebExtensionWindow>);

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Should be called by the app when a window is closed to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `newWindow`: The window that was closed.
        ///
        /// This method informs all loaded extensions of the closure of a window, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        ///
        /// See also: didOpenWindow:
        #[unsafe(method(didCloseWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didCloseWindow(
            &self,
            closed_window: &ProtocolObject<dyn WKWebExtensionWindow>,
        );

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Should be called by the app when a window gains focus to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `focusedWindow`: The window that gained focus, or
        /// `nil`if no window has focus or a window has focus that is not visible to extensions.
        ///
        /// This method informs all loaded extensions of the focused window, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        #[unsafe(method(didFocusWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didFocusWindow(
            &self,
            focused_window: Option<&ProtocolObject<dyn WKWebExtensionWindow>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a new tab is opened to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `newTab`: The newly opened tab.
        ///
        /// This method informs all loaded extensions of the opening of a new tab, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        ///
        /// See also: didCloseTab:
        #[unsafe(method(didOpenTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didOpenTab(&self, new_tab: &ProtocolObject<dyn WKWebExtensionTab>);

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a tab is closed to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `closedTab`: The tab that was closed.
        ///
        /// Parameter `windowIsClosing`: A boolean value indicating whether the window containing the tab is also closing.
        ///
        /// This method informs all loaded extensions of the closing of a tab, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        ///
        /// See also: didOpenTab:
        #[unsafe(method(didCloseTab:windowIsClosing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didCloseTab_windowIsClosing(
            &self,
            closed_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            window_is_closing: bool,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a tab is activated to notify all loaded web extensions.
        ///
        /// Parameter `activatedTab`: The tab that has become active.
        ///
        /// Parameter `previousTab`: The tab that was active before. This parameter can be
        /// `nil`if there was no previously active tab.
        ///
        /// This method informs all loaded extensions of the tab activation, ensuring consistent state awareness across extensions.
        /// If the intention is to inform only a specific extension, use the respective method on that extension's context instead.
        #[unsafe(method(didActivateTab:previousActiveTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didActivateTab_previousActiveTab(
            &self,
            activated_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            previous_tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when tabs are selected to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `selectedTabs`: The set of tabs that were selected.
        ///
        /// This method informs all loaded extensions that tabs have been selected, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        #[unsafe(method(didSelectTabs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didSelectTabs(
            &self,
            selected_tabs: &NSArray<ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when tabs are deselected to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `deselectedTabs`: The set of tabs that were deselected.
        ///
        /// This method informs all loaded extensions that tabs have been deselected, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        #[unsafe(method(didDeselectTabs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didDeselectTabs(
            &self,
            deselected_tabs: &NSArray<ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(all(feature = "WKWebExtensionTab", feature = "WKWebExtensionWindow"))]
        /// Should be called by the app when a tab is moved to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `movedTab`: The tab that was moved.
        ///
        /// Parameter `index`: The old index of the tab within the window.
        ///
        /// Parameter `oldWindow`: The window that the tab was moved from, or
        /// `nil`if the tab is moving from no open window.
        ///
        /// This method informs all loaded extensions of the movement of a tab, ensuring consistent understanding across extensions.
        /// If the window is staying the same, the current window should be specified. If the intention is to inform only a specific extension,
        /// use the respective method on that extension's context instead.
        #[unsafe(method(didMoveTab:fromIndex:inWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didMoveTab_fromIndex_inWindow(
            &self,
            moved_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            index: NSUInteger,
            old_window: Option<&ProtocolObject<dyn WKWebExtensionWindow>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a tab is replaced by another tab to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `oldTab`: The tab that was replaced.
        ///
        /// Parameter `newTab`: The tab that replaced the old tab.
        ///
        /// This method informs all loaded extensions of the replacement of a tab, ensuring consistent understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        #[unsafe(method(didReplaceTab:withTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didReplaceTab_withTab(
            &self,
            old_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            new_tab: &ProtocolObject<dyn WKWebExtensionTab>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when the properties of a tab are changed to fire appropriate events with all loaded web extensions.
        ///
        /// Parameter `properties`: The properties of the tab that were changed.
        ///
        /// Parameter `changedTab`: The tab whose properties were changed.
        ///
        /// This method informs all loaded extensions of changes to tab properties, ensuring a unified understanding across extensions.
        /// If the intention is to inform only a specific extension, you should use the respective method on that extension's context instead.
        #[unsafe(method(didChangeTabProperties:forTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didChangeTabProperties_forTab(
            &self,
            properties: WKWebExtensionTabChangedProperties,
            changed_tab: &ProtocolObject<dyn WKWebExtensionTab>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl WKWebExtensionController {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
