//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Indicates a ``WKWebExtensionContext`` error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontexterrordomain?language=objc)
    pub static WKWebExtensionContextErrorDomain: &'static NSErrorDomain;
}

/// Constants used by ``NSError`` to indicate errors in the ``WKWebExtensionContext`` domain.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontexterror?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionContextError(pub NSInteger);
impl WKWebExtensionContextError {
    #[doc(alias = "WKWebExtensionContextErrorUnknown")]
    pub const Unknown: Self = Self(1);
    #[doc(alias = "WKWebExtensionContextErrorAlreadyLoaded")]
    pub const AlreadyLoaded: Self = Self(2);
    #[doc(alias = "WKWebExtensionContextErrorNotLoaded")]
    pub const NotLoaded: Self = Self(3);
    #[doc(alias = "WKWebExtensionContextErrorBaseURLAlreadyInUse")]
    pub const BaseURLAlreadyInUse: Self = Self(4);
    #[doc(alias = "WKWebExtensionContextErrorNoBackgroundContent")]
    pub const NoBackgroundContent: Self = Self(5);
    #[doc(alias = "WKWebExtensionContextErrorBackgroundContentFailedToLoad")]
    pub const BackgroundContentFailedToLoad: Self = Self(6);
}

unsafe impl Encode for WKWebExtensionContextError {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionContextError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has new errors or errors were cleared.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontexterrorsdidupdatenotification?language=objc)
    pub static WKWebExtensionContextErrorsDidUpdateNotification: &'static NSNotificationName;
}

/// Constants used to indicate permission status in ``WKWebExtensionContext``.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextpermissionstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionContextPermissionStatus(pub NSInteger);
impl WKWebExtensionContextPermissionStatus {
    #[doc(alias = "WKWebExtensionContextPermissionStatusDeniedExplicitly")]
    pub const DeniedExplicitly: Self = Self(-3);
    #[doc(alias = "WKWebExtensionContextPermissionStatusDeniedImplicitly")]
    pub const DeniedImplicitly: Self = Self(-2);
    #[doc(alias = "WKWebExtensionContextPermissionStatusRequestedImplicitly")]
    pub const RequestedImplicitly: Self = Self(-1);
    #[doc(alias = "WKWebExtensionContextPermissionStatusUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "WKWebExtensionContextPermissionStatusRequestedExplicitly")]
    pub const RequestedExplicitly: Self = Self(1);
    #[doc(alias = "WKWebExtensionContextPermissionStatusGrantedImplicitly")]
    pub const GrantedImplicitly: Self = Self(2);
    #[doc(alias = "WKWebExtensionContextPermissionStatusGrantedExplicitly")]
    pub const GrantedExplicitly: Self = Self(3);
}

unsafe impl Encode for WKWebExtensionContextPermissionStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionContextPermissionStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly granted permissions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextpermissionsweregrantednotification?language=objc)
    pub static WKWebExtensionContextPermissionsWereGrantedNotification: &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly denied permissions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextpermissionsweredeniednotification?language=objc)
    pub static WKWebExtensionContextPermissionsWereDeniedNotification: &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly removed granted permissions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextgrantedpermissionswereremovednotification?language=objc)
    pub static WKWebExtensionContextGrantedPermissionsWereRemovedNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly removed denied permissions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextdeniedpermissionswereremovednotification?language=objc)
    pub static WKWebExtensionContextDeniedPermissionsWereRemovedNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly granted permission match patterns.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextpermissionmatchpatternsweregrantednotification?language=objc)
    pub static WKWebExtensionContextPermissionMatchPatternsWereGrantedNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly denied permission match patterns.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextpermissionmatchpatternsweredeniednotification?language=objc)
    pub static WKWebExtensionContextPermissionMatchPatternsWereDeniedNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly removed granted permission match patterns.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextgrantedpermissionmatchpatternswereremovednotification?language=objc)
    pub static WKWebExtensionContextGrantedPermissionMatchPatternsWereRemovedNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// This notification is sent whenever a ``WKWebExtensionContext`` has newly removed denied permission match patterns.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextdeniedpermissionmatchpatternswereremovednotification?language=objc)
    pub static WKWebExtensionContextDeniedPermissionMatchPatternsWereRemovedNotification:
        &'static NSNotificationName;
}

/// Constants for specifying ``WKWebExtensionContext`` information in notifications.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextnotificationuserinfokey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type WKWebExtensionContextNotificationUserInfoKey = NSString;

extern "C" {
    /// The corresponding value represents the affected permissions in ``WKWebExtensionContext`` notifications.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextnotificationuserinfokeypermissions?language=objc)
    pub static WKWebExtensionContextNotificationUserInfoKeyPermissions:
        &'static WKWebExtensionContextNotificationUserInfoKey;
}

extern "C" {
    /// The corresponding value represents the affected permission match patterns in ``WKWebExtensionContext`` notifications.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontextnotificationuserinfokeymatchpatterns?language=objc)
    pub static WKWebExtensionContextNotificationUserInfoKeyMatchPatterns:
        &'static WKWebExtensionContextNotificationUserInfoKey;
}

extern_class!(
    /// A ``WKWebExtensionContext`` object represents the runtime environment for a web extension.
    ///
    /// This class provides methods for managing the extension's permissions, allowing it to inject content, run
    /// background logic, show popovers, and display other web-based UI to the user.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensioncontext?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtensionContext;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtensionContext {}
);

impl WKWebExtensionContext {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "WKWebExtension")]
        /// Returns a web extension context initialized with the specified extension.
        ///
        /// Parameter `extension`: The extension to use for the new web extension context.
        ///
        /// Returns: An initialized web extension context.
        #[unsafe(method(contextForExtension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextForExtension(extension: &WKWebExtension) -> Retained<Self>;

        #[cfg(feature = "WKWebExtension")]
        /// Returns a web extension context initialized with a specified extension.
        ///
        /// Parameter `extension`: The extension to use for the new web extension context.
        ///
        /// Returns: An initialized web extension context.
        ///
        /// This is a designated initializer.
        #[unsafe(method(initForExtension:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initForExtension(
            this: Allocated<Self>,
            extension: &WKWebExtension,
        ) -> Retained<Self>;

        #[cfg(feature = "WKWebExtension")]
        /// The extension this context represents.
        #[unsafe(method(webExtension))]
        #[unsafe(method_family = none)]
        pub unsafe fn webExtension(&self) -> Retained<WKWebExtension>;

        #[cfg(feature = "WKWebExtensionController")]
        /// The extension controller this context is loaded in, otherwise `nil` if it isn't loaded.
        #[unsafe(method(webExtensionController))]
        #[unsafe(method_family = none)]
        pub unsafe fn webExtensionController(&self) -> Option<Retained<WKWebExtensionController>>;

        /// A Boolean value indicating if this context is loaded in an extension controller.
        #[unsafe(method(isLoaded))]
        #[unsafe(method_family = none)]
        pub unsafe fn isLoaded(&self) -> bool;

        /// All errors that occurred in the extension context.
        ///
        /// Provides an array of all parse-time and runtime errors for the extension and extension context, with repeat errors
        /// consolidated into a single entry for the original occurrence. If no errors occurred, an empty array is returned.
        #[unsafe(method(errors))]
        #[unsafe(method_family = none)]
        pub unsafe fn errors(&self) -> Retained<NSArray<NSError>>;

        /// The base URL the context uses for loading extension resources or injecting content into webpages.
        ///
        /// The default value is a unique URL using the `webkit-extension` scheme.
        /// The base URL can be set to any URL, but only the scheme and host will be used. The scheme cannot be a scheme that is
        /// already supported by ``WKWebView`` (e.g. http, https, etc.) Setting is only allowed when the context is not loaded.
        #[unsafe(method(baseURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn baseURL(&self) -> Retained<NSURL>;

        /// Setter for [`baseURL`][Self::baseURL].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBaseURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBaseURL(&self, base_url: &NSURL);

        /// A unique identifier used to distinguish the extension from other extensions and target it for messages.
        ///
        /// The default value is a unique value that matches the host in the default base URL. The identifier can be any
        /// value that is unique. Setting is only allowed when the context is not loaded. This value is accessible by the extension via
        /// `browser.runtime.id` and is used for messaging the extension via `browser.runtime.sendMessage()`.
        #[unsafe(method(uniqueIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn uniqueIdentifier(&self) -> Retained<NSString>;

        /// Setter for [`uniqueIdentifier`][Self::uniqueIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setUniqueIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUniqueIdentifier(&self, unique_identifier: &NSString);

        /// Determines whether Web Inspector can inspect the ``WKWebView`` instances for this context.
        ///
        /// A context can control multiple ``WKWebView`` instances, from the background content, to the popover.
        /// You should set this to `YES` when needed for debugging purposes. The default value is `NO`.
        #[unsafe(method(isInspectable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isInspectable(&self) -> bool;

        /// Setter for [`isInspectable`][Self::isInspectable].
        #[unsafe(method(setInspectable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInspectable(&self, inspectable: bool);

        /// The name shown when inspecting the background web view.
        ///
        /// This is the text that will appear when inspecting the background web view.
        #[unsafe(method(inspectionName))]
        #[unsafe(method_family = none)]
        pub unsafe fn inspectionName(&self) -> Option<Retained<NSString>>;

        /// Setter for [`inspectionName`][Self::inspectionName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setInspectionName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInspectionName(&self, inspection_name: Option<&NSString>);

        /// Specifies unsupported APIs for this extension, making them `undefined` in JavaScript.
        ///
        /// This property allows the app to specify a subset of web extension APIs that it chooses not to support, effectively making
        /// these APIs `undefined` within the extension's JavaScript contexts. This enables extensions to employ feature detection techniques
        /// for unsupported APIs, allowing them to adapt their behavior based on the APIs actually supported by the app. Setting is only allowed when
        /// the context is not loaded. Only certain APIs can be specified here, particularly those within the `browser` namespace and other dynamic
        /// functions and properties, anything else will be silently ignored.
        ///
        /// Note: For example, specifying `"browser.windows.create"` and `"browser.storage"` in this set will result in the
        /// `browser.windows.create()` function and `browser.storage` property being `undefined`.
        #[unsafe(method(unsupportedAPIs))]
        #[unsafe(method_family = none)]
        pub unsafe fn unsupportedAPIs(&self) -> Retained<NSSet<NSString>>;

        /// Setter for [`unsupportedAPIs`][Self::unsupportedAPIs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setUnsupportedAPIs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUnsupportedAPIs(&self, unsupported_ap_is: Option<&NSSet<NSString>>);

        #[cfg(feature = "WKWebViewConfiguration")]
        /// The web view configuration to use for web views that load pages from this extension.
        ///
        /// Returns a customized copy of the configuration, originally set in the web extension controller configuration, for this extension.
        /// The app must use this configuration when initializing web views intended to navigate to a URL originating from this extension's base URL.
        /// The app must also swap web views in tabs when navigating to and from web extension URLs. This property returns `nil` if the context isn't
        /// associated with a web extension controller. The returned configuration copy can be customized prior to web view initialization.
        ///
        /// Note: Navigations will fail if a web view using this configuration attempts to navigate to a URL that doesn't originate from this extension's
        /// base URL. Similarly, navigations will be canceled if a web view not configured with this configuration attempts to navigate to a URL that does
        /// originate from this extension's base URL.
        #[unsafe(method(webViewConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn webViewConfiguration(&self) -> Option<Retained<WKWebViewConfiguration>>;

        /// The URL of the extension's options page, if the extension has one.
        ///
        /// Provides the URL for the dedicated options page, if provided by the extension; otherwise `nil` if no page is defined.
        /// The app should provide access to this page through a user interface element.
        ///
        /// Note: Navigation to the options page is only possible after this extension has been loaded.
        ///
        /// See also: webViewConfiguration
        #[unsafe(method(optionsPageURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn optionsPageURL(&self) -> Option<Retained<NSURL>>;

        /// The URL to use as an alternative to the default new tab page, if the extension has one.
        ///
        /// Provides the URL for a new tab page, if provided by the extension; otherwise `nil` if no page is defined.
        /// The app should prompt the user for permission to use the extension's new tab page as the default.
        ///
        /// Note: Navigation to the override new tab page is only possible after this extension has been loaded.
        ///
        /// See also: webViewConfiguration
        #[unsafe(method(overrideNewTabPageURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn overrideNewTabPageURL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// The currently granted permissions and their expiration dates.
        ///
        /// Permissions that don't expire will have a distant future date. This will never include expired entries at time of access.
        /// Setting this property will replace all existing entries. Use this property for saving and restoring permission status in bulk.
        /// Permissions in this dictionary should be explicitly granted by the user before being added. Any permissions in this collection will not be
        /// presented for approval again until they expire. This value should be saved and restored as needed by the app.
        ///
        /// See also: setPermissionStatus:forPermission:
        ///
        /// See also: setPermissionStatus:forPermission:expirationDate:
        #[unsafe(method(grantedPermissions))]
        #[unsafe(method_family = none)]
        pub unsafe fn grantedPermissions(
            &self,
        ) -> Retained<NSDictionary<WKWebExtensionPermission, NSDate>>;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// Setter for [`grantedPermissions`][Self::grantedPermissions].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setGrantedPermissions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGrantedPermissions(
            &self,
            granted_permissions: &NSDictionary<WKWebExtensionPermission, NSDate>,
        );

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// The currently granted permission match patterns and their expiration dates.
        ///
        /// Match patterns that don't expire will have a distant future date. This will never include expired entries at time of access.
        /// Setting this property will replace all existing entries. Use this property for saving and restoring permission status in bulk.
        /// Match patterns in this dictionary should be explicitly granted by the user before being added. Any match pattern in this collection will not be
        /// presented for approval again until they expire. This value should be saved and restored as needed by the app.
        ///
        /// See also: setPermissionStatus:forMatchPattern:
        ///
        /// See also: setPermissionStatus:forMatchPattern:expirationDate:
        #[unsafe(method(grantedPermissionMatchPatterns))]
        #[unsafe(method_family = none)]
        pub unsafe fn grantedPermissionMatchPatterns(
            &self,
        ) -> Retained<NSDictionary<WKWebExtensionMatchPattern, NSDate>>;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// Setter for [`grantedPermissionMatchPatterns`][Self::grantedPermissionMatchPatterns].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setGrantedPermissionMatchPatterns:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGrantedPermissionMatchPatterns(
            &self,
            granted_permission_match_patterns: &NSDictionary<WKWebExtensionMatchPattern, NSDate>,
        );

        #[cfg(feature = "WKWebExtensionPermission")]
        /// The currently denied permissions and their expiration dates.
        ///
        /// Permissions that don't expire will have a distant future date. This will never include expired entries at time of access.
        /// Setting this property will replace all existing entries. Use this property for saving and restoring permission status in bulk.
        /// Permissions in this dictionary should be explicitly denied by the user before being added. Any match pattern in this collection will not be
        /// presented for approval again until they expire. This value should be saved and restored as needed by the app.
        ///
        /// See also: setPermissionStatus:forPermission:
        ///
        /// See also: setPermissionStatus:forPermission:expirationDate:
        #[unsafe(method(deniedPermissions))]
        #[unsafe(method_family = none)]
        pub unsafe fn deniedPermissions(
            &self,
        ) -> Retained<NSDictionary<WKWebExtensionPermission, NSDate>>;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// Setter for [`deniedPermissions`][Self::deniedPermissions].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDeniedPermissions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDeniedPermissions(
            &self,
            denied_permissions: &NSDictionary<WKWebExtensionPermission, NSDate>,
        );

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// The currently denied permission match patterns and their expiration dates.
        ///
        /// Match patterns that don't expire will have a distant future date. This will never include expired entries at time of access.
        /// Setting this property will replace all existing entries. Use this property for saving and restoring permission status in bulk.
        /// Match patterns in this dictionary should be explicitly denied by the user before being added. Any match pattern in this collection will not be
        /// presented for approval again until they expire. This value should be saved and restored as needed by the app.
        ///
        /// See also: setPermissionStatus:forMatchPattern:
        ///
        /// See also: setPermissionStatus:forMatchPattern:expirationDate:
        #[unsafe(method(deniedPermissionMatchPatterns))]
        #[unsafe(method_family = none)]
        pub unsafe fn deniedPermissionMatchPatterns(
            &self,
        ) -> Retained<NSDictionary<WKWebExtensionMatchPattern, NSDate>>;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// Setter for [`deniedPermissionMatchPatterns`][Self::deniedPermissionMatchPatterns].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDeniedPermissionMatchPatterns:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDeniedPermissionMatchPatterns(
            &self,
            denied_permission_match_patterns: &NSDictionary<WKWebExtensionMatchPattern, NSDate>,
        );

        /// A Boolean value indicating if the extension has requested optional access to all hosts.
        ///
        /// If this property is `YES`, the extension has asked for access to all hosts in a call to `browser.runtime.permissions.request()`,
        /// and future permission checks will present discrete hosts for approval as being implicitly requested. This value should be saved and restored as needed by the app.
        #[unsafe(method(hasRequestedOptionalAccessToAllHosts))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasRequestedOptionalAccessToAllHosts(&self) -> bool;

        /// Setter for [`hasRequestedOptionalAccessToAllHosts`][Self::hasRequestedOptionalAccessToAllHosts].
        #[unsafe(method(setHasRequestedOptionalAccessToAllHosts:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHasRequestedOptionalAccessToAllHosts(
            &self,
            has_requested_optional_access_to_all_hosts: bool,
        );

        /// A Boolean value indicating if the extension has access to private data.
        ///
        /// If this property is `YES`, the extension is granted permission to interact with private windows, tabs, and cookies. Access to private data
        /// should be explicitly allowed by the user before setting this property. This value should be saved and restored as needed by the app.
        ///
        /// Note: To ensure proper isolation between private and non-private data, web views associated with private data must use a
        /// different ``WKUserContentController``. Likewise, to be identified as a private web view and to ensure that cookies and other
        /// website data is not shared, private web views must be configured to use a non-persistent ``WKWebsiteDataStore``.
        #[unsafe(method(hasAccessToPrivateData))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAccessToPrivateData(&self) -> bool;

        /// Setter for [`hasAccessToPrivateData`][Self::hasAccessToPrivateData].
        #[unsafe(method(setHasAccessToPrivateData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHasAccessToPrivateData(&self, has_access_to_private_data: bool);

        #[cfg(feature = "WKWebExtensionPermission")]
        /// The currently granted permissions that have not expired.
        ///
        /// See also: grantedPermissions
        #[unsafe(method(currentPermissions))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentPermissions(&self) -> Retained<NSSet<WKWebExtensionPermission>>;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// The currently granted permission match patterns that have not expired.
        ///
        /// See also: grantedPermissionMatchPatterns
        #[unsafe(method(currentPermissionMatchPatterns))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentPermissionMatchPatterns(
            &self,
        ) -> Retained<NSSet<WKWebExtensionMatchPattern>>;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// Checks the specified permission against the currently granted permissions.
        ///
        /// Parameter `permission`: The permission for which to return the status.
        ///
        /// See also: currentPermissions
        ///
        /// See also: hasPermission:inTab:
        ///
        /// See also: permissionStatusForPermission:
        ///
        /// See also: permissionStatusForPermission:inTab:
        #[unsafe(method(hasPermission:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasPermission(&self, permission: &WKWebExtensionPermission) -> bool;

        #[cfg(all(feature = "WKWebExtensionPermission", feature = "WKWebExtensionTab"))]
        /// Checks the specified permission against the currently granted permissions in a specific tab.
        ///
        /// Parameter `permission`: The permission for which to return the status.
        ///
        /// Parameter `tab`: The tab in which to return the permission status, or
        /// `nil`if the tab is not known or the global status is desired.
        ///
        /// Permissions can be granted on a per-tab basis. When the tab is known, permission checks should always use this method.
        ///
        /// See also: currentPermissions
        ///
        /// See also: hasPermission:
        ///
        /// See also: permissionStatusForPermission:
        ///
        /// See also: permissionStatusForPermission:inTab:
        #[unsafe(method(hasPermission:inTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasPermission_inTab(
            &self,
            permission: &WKWebExtensionPermission,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        ) -> bool;

        /// Checks the specified URL against the currently granted permission match patterns.
        ///
        /// Parameter `url`: The URL for which to return the status.
        ///
        /// See also: currentPermissionMatchPatterns
        ///
        /// See also: hasAccessToURL:inTab:
        ///
        /// See also: permissionStatusForURL:
        ///
        /// See also: permissionStatusForURL:inTab:
        ///
        /// See also: permissionStatusForMatchPattern:
        ///
        /// See also: permissionStatusForMatchPattern:inTab:
        #[unsafe(method(hasAccessToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAccessToURL(&self, url: &NSURL) -> bool;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Checks the specified URL against the currently granted permission match patterns in a specific tab.
        ///
        /// Parameter `url`: The URL for which to return the status.
        ///
        /// Parameter `tab`: The tab in which to return the permission status, or
        /// `nil`if the tab is not known or the global status is desired.
        ///
        /// Some match patterns can be granted on a per-tab basis. When the tab is known, access checks should always use this method.
        ///
        /// See also: currentPermissionMatchPatterns
        ///
        /// See also: hasAccessToURL:
        ///
        /// See also: permissionStatusForURL:
        ///
        /// See also: permissionStatusForURL:inTab:
        ///
        /// See also: permissionStatusForMatchPattern:
        ///
        /// See also: permissionStatusForMatchPattern:inTab:
        #[unsafe(method(hasAccessToURL:inTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAccessToURL_inTab(
            &self,
            url: &NSURL,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        ) -> bool;

        /// A Boolean value indicating if the currently granted permission match patterns set contains the `
        /// <all
        /// _urls>` pattern.
        ///
        /// This does not check for any `*` host patterns. In most cases you should use the broader ``hasAccessToAllHosts``.
        ///
        /// See also: currentPermissionMatchPatterns
        ///
        /// See also: hasAccessToAllHosts
        #[unsafe(method(hasAccessToAllURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAccessToAllURLs(&self) -> bool;

        /// A Boolean value indicating if the currently granted permission match patterns set contains the `
        /// <all
        /// _urls>` pattern or any `*` host patterns.
        ///
        /// See also: currentPermissionMatchPatterns
        ///
        /// See also: hasAccessToAllURLs
        #[unsafe(method(hasAccessToAllHosts))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAccessToAllHosts(&self) -> bool;

        /// A Boolean value indicating whether the extension has script or stylesheet content that can be injected into webpages.
        ///
        /// If this property is `YES`, the extension has content that can be injected by matching against the extension's requested match patterns.
        ///
        /// See also: hasInjectedContentForURL:
        #[unsafe(method(hasInjectedContent))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasInjectedContent(&self) -> bool;

        /// Checks if the extension has script or stylesheet content that can be injected into the specified URL.
        ///
        /// Parameter `url`: The webpage URL to check.
        ///
        /// Returns: Returns `YES` if the extension has content that can be injected by matching the URL against the extension's requested match patterns.
        ///
        /// The extension context will still need to be loaded and have granted website permissions for its content to actually be injected.
        #[unsafe(method(hasInjectedContentForURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasInjectedContentForURL(&self, url: &NSURL) -> bool;

        /// A boolean value indicating whether the extension includes rules used for content modification or blocking.
        ///
        /// This includes both static rules available in the extension's manifest and dynamic rules applied during a browsing session.
        #[unsafe(method(hasContentModificationRules))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasContentModificationRules(&self) -> bool;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// Checks the specified permission against the currently denied, granted, and requested permissions.
        ///
        /// Parameter `permission`: The permission for which to return the status.
        ///
        /// Permissions can be granted on a per-tab basis. When the tab is known, access checks should always use the method that checks in a tab.
        ///
        /// See also: permissionStatusForPermission:inTab:
        ///
        /// See also: hasPermission:
        #[unsafe(method(permissionStatusForPermission:))]
        #[unsafe(method_family = none)]
        pub unsafe fn permissionStatusForPermission(
            &self,
            permission: &WKWebExtensionPermission,
        ) -> WKWebExtensionContextPermissionStatus;

        #[cfg(all(feature = "WKWebExtensionPermission", feature = "WKWebExtensionTab"))]
        /// Checks the specified permission against the currently denied, granted, and requested permissions.
        ///
        /// Parameter `permission`: The permission for which to return the status.
        ///
        /// Parameter `tab`: The tab in which to return the permission status, or
        /// `nil`if the tab is not known or the global status is desired.
        ///
        /// Permissions can be granted on a per-tab basis. When the tab is known, access checks should always specify the tab.
        ///
        /// See also: permissionStatusForPermission:
        ///
        /// See also: hasPermission:inTab:
        #[unsafe(method(permissionStatusForPermission:inTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn permissionStatusForPermission_inTab(
            &self,
            permission: &WKWebExtensionPermission,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        ) -> WKWebExtensionContextPermissionStatus;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// Sets the status of a permission with a distant future expiration date.
        ///
        /// Parameter `status`: The new permission status to set for the given permission.
        ///
        /// Parameter `permission`: The permission for which to set the status.
        ///
        /// This method will update ``grantedPermissions`` and ``deniedPermissions``. Use this method for changing a single permission's status.
        /// Only ``WKWebExtensionContextPermissionStatusDeniedExplicitly``, ``WKWebExtensionContextPermissionStatusUnknown``, and ``WKWebExtensionContextPermissionStatusGrantedExplicitly``
        /// states are allowed to be set using this method.
        ///
        /// See also: setPermissionStatus:forPermission:expirationDate:
        ///
        /// See also: setPermissionStatus:forPermission:inTab:
        #[unsafe(method(setPermissionStatus:forPermission:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermissionStatus_forPermission(
            &self,
            status: WKWebExtensionContextPermissionStatus,
            permission: &WKWebExtensionPermission,
        );

        #[cfg(feature = "WKWebExtensionPermission")]
        /// Sets the status of a permission with a specific expiration date.
        ///
        /// Parameter `status`: The new permission status to set for the given permission.
        ///
        /// Parameter `permission`: The permission for which to set the status.
        ///
        /// Parameter `expirationDate`: The expiration date for the new permission status, or
        /// `nil`for distant future.
        ///
        /// This method will update ``grantedPermissions`` and ``deniedPermissions``. Use this method for changing a single permission's status.
        /// Passing a `nil` expiration date will be treated as a distant future date. Only ``WKWebExtensionContextPermissionStatusDeniedExplicitly``, ``WKWebExtensionContextPermissionStatusUnknown``,
        /// and ``WKWebExtensionContextPermissionStatusGrantedExplicitly`` states are allowed to be set using this method.
        ///
        /// See also: setPermissionStatus:forPermission:
        ///
        /// See also: setPermissionStatus:forPermission:inTab:
        #[unsafe(method(setPermissionStatus:forPermission:expirationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermissionStatus_forPermission_expirationDate(
            &self,
            status: WKWebExtensionContextPermissionStatus,
            permission: &WKWebExtensionPermission,
            expiration_date: Option<&NSDate>,
        );

        /// Checks the specified URL against the currently denied, granted, and requested permission match patterns.
        ///
        /// Parameter `url`: The URL for which to return the status.
        ///
        /// URLs and match patterns can be granted on a per-tab basis. When the tab is known, access checks should always use the method that checks in a tab.
        ///
        /// See also: permissionStatusForURL:inTab:
        ///
        /// See also: hasAccessToURL:
        #[unsafe(method(permissionStatusForURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn permissionStatusForURL(
            &self,
            url: &NSURL,
        ) -> WKWebExtensionContextPermissionStatus;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Checks the specified URL against the currently denied, granted, and requested permission match patterns.
        ///
        /// Parameter `url`: The URL for which to return the status.
        ///
        /// Parameter `tab`: The tab in which to return the permission status, or
        /// `nil`if the tab is not known or the global status is desired.
        ///
        /// URLs and match patterns can be granted on a per-tab basis. When the tab is known, access checks should always use this method.
        ///
        /// See also: permissionStatusForURL:
        ///
        /// See also: hasAccessToURL:inTab:
        #[unsafe(method(permissionStatusForURL:inTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn permissionStatusForURL_inTab(
            &self,
            url: &NSURL,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        ) -> WKWebExtensionContextPermissionStatus;

        /// Sets the permission status of a URL with a distant future expiration date.
        ///
        /// Parameter `status`: The new permission status to set for the given URL.
        ///
        /// Parameter `url`: The URL for which to set the status.
        ///
        /// The URL is converted into a match pattern and will update ``grantedPermissionMatchPatterns`` and ``deniedPermissionMatchPatterns``. Use this method for changing a single URL's status.
        /// Only ``WKWebExtensionContextPermissionStatusDeniedExplicitly``, ``WKWebExtensionContextPermissionStatusUnknown``, and ``WKWebExtensionContextPermissionStatusGrantedExplicitly``
        /// states are allowed to be set using this method.
        ///
        /// See also: setPermissionStatus:forURL:expirationDate:
        ///
        /// See also: setPermissionStatus:forURL:inTab:
        #[unsafe(method(setPermissionStatus:forURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermissionStatus_forURL(
            &self,
            status: WKWebExtensionContextPermissionStatus,
            url: &NSURL,
        );

        /// Sets the permission status of a URL with a distant future expiration date.
        ///
        /// Parameter `status`: The new permission status to set for the given URL.
        ///
        /// Parameter `url`: The URL for which to set the status.
        ///
        /// Parameter `expirationDate`: The expiration date for the new permission status, or
        /// `nil`for distant future.
        ///
        /// The URL is converted into a match pattern and will update ``grantedPermissionMatchPatterns`` and ``deniedPermissionMatchPatterns``. Use this method for changing a single URL's status.
        /// Passing a `nil` expiration date will be treated as a distant future date. Only ``WKWebExtensionContextPermissionStatusDeniedExplicitly``, ``WKWebExtensionContextPermissionStatusUnknown``,
        /// and ``WKWebExtensionContextPermissionStatusGrantedExplicitly`` states are allowed to be set using this method.
        ///
        /// See also: setPermissionStatus:forURL:
        ///
        /// See also: setPermissionStatus:forURL:inTab:
        #[unsafe(method(setPermissionStatus:forURL:expirationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermissionStatus_forURL_expirationDate(
            &self,
            status: WKWebExtensionContextPermissionStatus,
            url: &NSURL,
            expiration_date: Option<&NSDate>,
        );

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// Checks the specified match pattern against the currently denied, granted, and requested permission match patterns.
        ///
        /// Parameter `pattern`: The pattern for which to return the status.
        ///
        /// Match patterns can be granted on a per-tab basis. When the tab is known, access checks should always use the method that checks in a tab.
        ///
        /// See also: permissionStatusForMatchPattern:inTab:
        ///
        /// See also: hasAccessToURL:inTab:
        #[unsafe(method(permissionStatusForMatchPattern:))]
        #[unsafe(method_family = none)]
        pub unsafe fn permissionStatusForMatchPattern(
            &self,
            pattern: &WKWebExtensionMatchPattern,
        ) -> WKWebExtensionContextPermissionStatus;

        #[cfg(all(feature = "WKWebExtensionMatchPattern", feature = "WKWebExtensionTab"))]
        /// Checks the specified match pattern against the currently denied, granted, and requested permission match patterns.
        ///
        /// Parameter `pattern`: The pattern for which to return the status.
        ///
        /// Parameter `tab`: The tab in which to return the permission status, or
        /// `nil`if the tab is not known or the global status is desired.
        ///
        /// Match patterns can be granted on a per-tab basis. When the tab is known, access checks should always use this method.
        ///
        /// See also: permissionStatusForMatchPattern:
        ///
        /// See also: hasAccessToURL:inTab:
        #[unsafe(method(permissionStatusForMatchPattern:inTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn permissionStatusForMatchPattern_inTab(
            &self,
            pattern: &WKWebExtensionMatchPattern,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        ) -> WKWebExtensionContextPermissionStatus;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// Sets the status of a match pattern with a distant future expiration date.
        ///
        /// Parameter `status`: The new permission status to set for the given match pattern.
        ///
        /// Parameter `pattern`: The match pattern for which to set the status.
        ///
        /// This method will update ``grantedPermissionMatchPatterns`` and ``deniedPermissionMatchPatterns``. Use this method for changing a single match pattern's status.
        /// Only ``WKWebExtensionContextPermissionStatusDeniedExplicitly``, ``WKWebExtensionContextPermissionStatusUnknown``, and ``WKWebExtensionContextPermissionStatusGrantedExplicitly``
        /// states are allowed to be set using this method.
        ///
        /// See also: setPermissionStatus:forMatchPattern:expirationDate:
        ///
        /// See also: setPermissionStatus:forMatchPattern:inTab:
        #[unsafe(method(setPermissionStatus:forMatchPattern:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermissionStatus_forMatchPattern(
            &self,
            status: WKWebExtensionContextPermissionStatus,
            pattern: &WKWebExtensionMatchPattern,
        );

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// Sets the status of a match pattern with a specific expiration date.
        ///
        /// Parameter `status`: The new permission status to set for the given match pattern.
        ///
        /// Parameter `pattern`: The match pattern for which to set the status.
        ///
        /// Parameter `expirationDate`: The expiration date for the new permission status, or
        /// `nil`for distant future.
        ///
        /// This method will update ``grantedPermissionMatchPatterns`` and ``deniedPermissionMatchPatterns``. Use this method for changing a single match pattern's status.
        /// Passing a `nil` expiration date will be treated as a distant future date. Only ``WKWebExtensionContextPermissionStatusDeniedExplicitly``, ``WKWebExtensionContextPermissionStatusUnknown``,
        /// and ``WKWebExtensionContextPermissionStatusGrantedExplicitly`` states are allowed to be set using this method.
        ///
        /// See also: setPermissionStatus:forMatchPattern:
        ///
        /// See also: setPermissionStatus:forMatchPattern:inTab:
        #[unsafe(method(setPermissionStatus:forMatchPattern:expirationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPermissionStatus_forMatchPattern_expirationDate(
            &self,
            status: WKWebExtensionContextPermissionStatus,
            pattern: &WKWebExtensionMatchPattern,
            expiration_date: Option<&NSDate>,
        );

        #[cfg(feature = "block2")]
        /// Loads the background content if needed for the extension.
        ///
        /// Parameter `completionHandler`: A block to be called upon completion of the loading process, with an optional error.
        ///
        /// This method forces the loading of the background content for the extension that will otherwise be loaded on-demand during specific events.
        /// It is useful when the app requires the background content to be loaded for other reasons. If the background content is already loaded, the completion handler
        /// will be called immediately. An error will occur if the extension does not have any background content to load or loading fails.
        #[unsafe(method(loadBackgroundContentWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadBackgroundContentWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "WKWebExtensionAction", feature = "WKWebExtensionTab"))]
        /// Retrieves the extension action for a given tab, or the default action if `nil` is passed.
        ///
        /// Parameter `tab`: The tab for which to retrieve the extension action, or `nil` to get the default action.
        ///
        /// The returned object represents the action specific to the tab when provided; otherwise, it returns the default action. The default
        /// action is useful when the context is unrelated to a specific tab. When possible, specify the tab to get the most context-relevant action.
        ///
        /// See also: performActionForTab:
        #[unsafe(method(actionForTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn actionForTab(
            &self,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        ) -> Option<Retained<WKWebExtensionAction>>;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Performs the extension action associated with the specified tab or performs the default action if `nil` is passed.
        ///
        /// Parameter `tab`: The tab for which to perform the extension action, or `nil` to perform the default action.
        ///
        /// Performing the action will mark the tab, if specified, as having an active user gesture. When the ``tab`` parameter is `nil`,
        /// the default action is performed. The action can either trigger an event or display a popup, depending on how the extension is configured.
        /// If the action is configured to display a popup, implementing the appropriate web extension controller delegate method is required; otherwise,
        /// no action is performed for popup actions.
        #[unsafe(method(performActionForTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performActionForTab(
            &self,
            tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(feature = "WKWebExtensionCommand")]
        /// The commands associated with the extension.
        ///
        /// Provides all commands registered within the extension. Each command represents an action or behavior available for the web extension.
        ///
        /// See also: performCommand:
        #[unsafe(method(commands))]
        #[unsafe(method_family = none)]
        pub unsafe fn commands(&self) -> Retained<NSArray<WKWebExtensionCommand>>;

        #[cfg(feature = "WKWebExtensionCommand")]
        /// Performs the specified command, triggering events specific to this extension.
        ///
        /// Parameter `command`: The command to be performed.
        ///
        /// This method performs the given command as if it was triggered by a user gesture within the context of the focused window and active tab.
        #[unsafe(method(performCommand:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performCommand(&self, command: &WKWebExtensionCommand);

        #[cfg(feature = "objc2-app-kit")]
        #[cfg(target_os = "macos")]
        /// Performs the command associated with the given event.
        ///
        /// This method checks for a command corresponding to the provided event and performs it, if available. The app should use this method to perform
        /// any extension commands at an appropriate time in the app's event handling, like in ``sendEvent:`` of ``NSApplication`` or ``NSWindow`` subclasses.
        ///
        /// Parameter `event`: The event representing the user input.
        ///
        /// Returns: Returns `YES` if a command corresponding to the event was found and performed, `NO` otherwise.
        #[unsafe(method(performCommandForEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performCommandForEvent(&self, event: &NSEvent) -> bool;

        #[cfg(all(feature = "WKWebExtensionCommand", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Retrieves the command associated with the given event without performing it.
        ///
        /// Returns the command that corresponds to the provided event, if such a command exists. This provides a way to programmatically
        /// determine what action would occur for a given event, without triggering the command.
        ///
        /// Parameter `event`: The event for which to retrieve the corresponding command.
        ///
        /// Returns: The command associated with the event, or `nil` if there is no such command.
        #[unsafe(method(commandForEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn commandForEvent(
            &self,
            event: &NSEvent,
        ) -> Option<Retained<WKWebExtensionCommand>>;

        #[cfg(all(feature = "WKWebExtensionTab", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        #[unsafe(method(menuItemsForTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn menuItemsForTab(
            &self,
            tab: &ProtocolObject<dyn WKWebExtensionTab>,
        ) -> Retained<NSArray<NSMenuItem>>;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a user gesture is performed in a specific tab.
        ///
        /// Parameter `tab`: The tab in which the user gesture was performed.
        ///
        /// When a user gesture is performed in a tab, this method should be called to update the extension context.
        /// This enables the extension to be aware of the user gesture, potentially granting it access to features that require user interaction,
        /// such as `activeTab`. Not required if using ``performActionForTab:``.
        ///
        /// See also: hasActiveUserGestureInTab:
        #[unsafe(method(userGesturePerformedInTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn userGesturePerformedInTab(&self, tab: &ProtocolObject<dyn WKWebExtensionTab>);

        #[cfg(feature = "WKWebExtensionTab")]
        /// Indicates if a user gesture is currently active in the specified tab.
        ///
        /// Parameter `tab`: The tab for which to check for an active user gesture.
        ///
        /// An active user gesture may influence the availability of certain permissions, such as `activeTab`. User gestures can
        /// be triggered by various user interactions with the web extension, including clicking on extension menu items, executing extension commands,
        /// or interacting with extension actions. A tab as having an active user gesture enables the extension to access features that require user interaction.
        ///
        /// See also: userGesturePerformedInTab:
        #[unsafe(method(hasActiveUserGestureInTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasActiveUserGestureInTab(
            &self,
            tab: &ProtocolObject<dyn WKWebExtensionTab>,
        ) -> bool;

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app to clear a user gesture in a specific tab.
        ///
        /// Parameter `tab`: The tab from which the user gesture should be cleared.
        ///
        /// When a user gesture is no longer relevant in a tab, this method should be called to update the extension context.
        /// This will revoke the extension's access to features that require active user interaction, such as `activeTab`. User gestures are
        /// automatically cleared during navigation in certain scenarios; this method is needed if the app intends to clear the gesture more aggressively.
        ///
        /// See also: userGesturePerformedInTab:
        #[unsafe(method(clearUserGestureInTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearUserGestureInTab(&self, tab: &ProtocolObject<dyn WKWebExtensionTab>);

        #[cfg(feature = "WKWebExtensionWindow")]
        /// The open windows that are exposed to this extension.
        ///
        /// Provides the windows that are open and visible to the extension, as updated by the ``didOpenWindow:`` and ``didCloseWindow:`` methods.
        /// Initially populated by the windows returned by the extension controller delegate method ``webExtensionController:openWindowsForExtensionContext:``.
        ///
        /// See also: didOpenWindow:
        ///
        /// See also: didCloseWindow:
        #[unsafe(method(openWindows))]
        #[unsafe(method_family = none)]
        pub unsafe fn openWindows(
            &self,
        ) -> Retained<NSArray<ProtocolObject<dyn WKWebExtensionWindow>>>;

        #[cfg(feature = "WKWebExtensionWindow")]
        /// The window that currently has focus for this extension.
        ///
        /// Provides the window that currently has focus, as set by the ``didFocusWindow:`` method.
        /// It will be `nil` if no window has focus or if a window has focus that is not visible to the extension. Initially populated by the window
        /// returned by the extension controller delegate method ``webExtensionController:focusedWindowForExtensionContext:``.
        ///
        /// See also: didFocusWindow:
        #[unsafe(method(focusedWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusedWindow(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn WKWebExtensionWindow>>>;

        #[cfg(feature = "WKWebExtensionTab")]
        /// A set of open tabs in all open windows that are exposed to this extension.
        ///
        /// Provides a set of tabs in all open windows that are visible to the extension, as updated by the ``didOpenTab:`` and ``didCloseTab:`` methods.
        /// Initially populated by the tabs in the windows returned by the extension controller delegate method ``webExtensionController:openWindowsForExtensionContext:``.
        ///
        /// See also: didOpenTab:
        ///
        /// See also: didCloseTab:
        #[unsafe(method(openTabs))]
        #[unsafe(method_family = none)]
        pub unsafe fn openTabs(&self) -> Retained<NSSet<ProtocolObject<dyn WKWebExtensionTab>>>;

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Should be called by the app when a new window is opened to fire appropriate events with only this extension.
        ///
        /// Parameter `newWindow`: The newly opened window.
        ///
        /// This method informs only the specific extension of the opening of a new window. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        ///
        /// See also: didCloseWindow:
        ///
        /// See also: openWindows
        #[unsafe(method(didOpenWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didOpenWindow(&self, new_window: &ProtocolObject<dyn WKWebExtensionWindow>);

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Should be called by the app when a window is closed to fire appropriate events with only this extension.
        ///
        /// Parameter `newWindow`: The window that was closed.
        ///
        /// This method informs only the specific extension of the closure of a window. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        ///
        /// See also: didOpenWindow:
        ///
        /// See also: openWindows
        #[unsafe(method(didCloseWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didCloseWindow(
            &self,
            closed_window: &ProtocolObject<dyn WKWebExtensionWindow>,
        );

        #[cfg(feature = "WKWebExtensionWindow")]
        /// Should be called by the app when a window gains focus to fire appropriate events with only this extension.
        ///
        /// Parameter `focusedWindow`: The window that gained focus, or
        /// `nil`if no window has focus or a window has focus that is not visible to this extension.
        ///
        /// This method informs only the specific extension that a window has gained focus. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        #[unsafe(method(didFocusWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didFocusWindow(
            &self,
            focused_window: Option<&ProtocolObject<dyn WKWebExtensionWindow>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a new tab is opened to fire appropriate events with only this extension.
        ///
        /// Parameter `newTab`: The newly opened tab.
        ///
        /// This method informs only the specific extension of the opening of a new tab. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        ///
        /// See also: didCloseTab:
        ///
        /// See also: openTabs
        #[unsafe(method(didOpenTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didOpenTab(&self, new_tab: &ProtocolObject<dyn WKWebExtensionTab>);

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a tab is closed to fire appropriate events with only this extension.
        ///
        /// Parameter `closedTab`: The tab that was closed.
        ///
        /// Parameter `windowIsClosing`: A boolean value indicating whether the window containing the tab is also closing.
        ///
        /// This method informs only the specific extension of the closure of a tab. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        ///
        /// See also: didOpenTab:
        ///
        /// See also: openTabs
        #[unsafe(method(didCloseTab:windowIsClosing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didCloseTab_windowIsClosing(
            &self,
            closed_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            window_is_closing: bool,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a tab is activated to notify only this specific extension.
        ///
        /// Parameter `activatedTab`: The tab that has become active.
        ///
        /// Parameter `previousTab`: The tab that was active before. This parameter can be
        /// `nil`if there was no previously active tab.
        ///
        /// This method informs only the specific extension of the tab activation. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        #[unsafe(method(didActivateTab:previousActiveTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didActivateTab_previousActiveTab(
            &self,
            activated_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            previous_tab: Option<&ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when tabs are selected to fire appropriate events with only this extension.
        ///
        /// Parameter `selectedTabs`: The set of tabs that were selected.
        ///
        /// This method informs only the specific extension that tabs have been selected. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        #[unsafe(method(didSelectTabs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didSelectTabs(
            &self,
            selected_tabs: &NSArray<ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when tabs are deselected to fire appropriate events with only this extension.
        ///
        /// Parameter `deselectedTabs`: The set of tabs that were deselected.
        ///
        /// This method informs only the specific extension that tabs have been deselected. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        #[unsafe(method(didDeselectTabs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didDeselectTabs(
            &self,
            deselected_tabs: &NSArray<ProtocolObject<dyn WKWebExtensionTab>>,
        );

        #[cfg(all(feature = "WKWebExtensionTab", feature = "WKWebExtensionWindow"))]
        /// Should be called by the app when a tab is moved to fire appropriate events with only this extension.
        ///
        /// Parameter `movedTab`: The tab that was moved.
        ///
        /// Parameter `index`: The old index of the tab within the window.
        ///
        /// Parameter `oldWindow`: The window that the tab was moved from, or
        /// `nil`if the tab is moving from no open window.
        ///
        /// If the window is staying the same, the current window should be specified. This method informs only the specific extension
        /// that a tab has been moved. If the intention is to inform all loaded extensions consistently, you should use the respective method on
        /// the extension controller instead.
        #[unsafe(method(didMoveTab:fromIndex:inWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didMoveTab_fromIndex_inWindow(
            &self,
            moved_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            index: NSUInteger,
            old_window: Option<&ProtocolObject<dyn WKWebExtensionWindow>>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when a tab is replaced by another tab to fire appropriate events with only this extension.
        ///
        /// Parameter `oldTab`: The tab that was replaced.
        ///
        /// Parameter `newTab`: The tab that replaced the old tab.
        ///
        /// This method informs only the specific extension that a tab has been replaced. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        #[unsafe(method(didReplaceTab:withTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didReplaceTab_withTab(
            &self,
            old_tab: &ProtocolObject<dyn WKWebExtensionTab>,
            new_tab: &ProtocolObject<dyn WKWebExtensionTab>,
        );

        #[cfg(feature = "WKWebExtensionTab")]
        /// Should be called by the app when the properties of a tab are changed to fire appropriate events with only this extension.
        ///
        /// Parameter `properties`: The properties of the tab that were changed.
        ///
        /// Parameter `changedTab`: The tab whose properties were changed.
        ///
        /// This method informs only the specific extension of the changes to a tab's properties. If the intention is to inform all loaded
        /// extensions consistently, you should use the respective method on the extension controller instead.
        #[unsafe(method(didChangeTabProperties:forTab:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didChangeTabProperties_forTab(
            &self,
            properties: WKWebExtensionTabChangedProperties,
            changed_tab: &ProtocolObject<dyn WKWebExtensionTab>,
        );
    );
}
