//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-app-kit")]
#[cfg(target_os = "macos")]
use objc2_app_kit::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Indicates a ``WKWebExtension`` error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionerrordomain?language=objc)
    pub static WKWebExtensionErrorDomain: &'static NSErrorDomain;
}

/// Constants used by ``NSError`` to indicate errors in the ``WKWebExtension`` domain.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextensionerror?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKWebExtensionError(pub NSInteger);
impl WKWebExtensionError {
    #[doc(alias = "WKWebExtensionErrorUnknown")]
    pub const Unknown: Self = Self(1);
    #[doc(alias = "WKWebExtensionErrorResourceNotFound")]
    pub const ResourceNotFound: Self = Self(2);
    #[doc(alias = "WKWebExtensionErrorInvalidResourceCodeSignature")]
    pub const InvalidResourceCodeSignature: Self = Self(3);
    #[doc(alias = "WKWebExtensionErrorInvalidManifest")]
    pub const InvalidManifest: Self = Self(4);
    #[doc(alias = "WKWebExtensionErrorUnsupportedManifestVersion")]
    pub const UnsupportedManifestVersion: Self = Self(5);
    #[doc(alias = "WKWebExtensionErrorInvalidManifestEntry")]
    pub const InvalidManifestEntry: Self = Self(6);
    #[doc(alias = "WKWebExtensionErrorInvalidDeclarativeNetRequestEntry")]
    pub const InvalidDeclarativeNetRequestEntry: Self = Self(7);
    #[doc(alias = "WKWebExtensionErrorInvalidBackgroundPersistence")]
    pub const InvalidBackgroundPersistence: Self = Self(8);
    #[doc(alias = "WKWebExtensionErrorInvalidArchive")]
    pub const InvalidArchive: Self = Self(9);
}

unsafe impl Encode for WKWebExtensionError {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKWebExtensionError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A ``WKWebExtension`` object encapsulates a web extension’s resources that are defined by a `manifest.json`` file.
    ///
    /// This class handles the reading and parsing of the manifest file along with the supporting resources like icons and localizations.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkwebextension?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKWebExtension;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKWebExtension {}
);

impl WKWebExtension {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "block2")]
        /// Returns a web extension initialized with a specified app extension bundle.
        ///
        /// Parameter `appExtensionBundle`: The bundle to use for the new web extension.
        ///
        /// Parameter `completionHandler`: A block to be called with an initialized web extension, or
        /// `nil`if the object could not be initialized due to an error.
        ///
        /// The app extension bundle must contain a `manifest.json` file in its resources directory. If the manifest is invalid or missing,
        /// or the bundle is otherwise improperly configured, an error will be returned.
        #[unsafe(method(extensionWithAppExtensionBundle:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensionWithAppExtensionBundle_completionHandler(
            app_extension_bundle: &NSBundle,
            completion_handler: &block2::DynBlock<dyn Fn(*mut WKWebExtension, *mut NSError)>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        /// Returns a web extension initialized with a specified resource base URL, which can point to either a directory or a ZIP archive.
        ///
        /// Parameter `resourceBaseURL`: The file URL to use for the new web extension.
        ///
        /// Parameter `completionHandler`: A block to be called with an initialized web extension, or
        /// `nil`if the object could not be initialized due to an error.
        ///
        /// The URL must be a file URL that points to either a directory with a `manifest.json` file or a ZIP archive containing a `manifest.json` file.
        /// If the manifest is invalid or missing, or the URL points to an unsupported format or invalid archive, an error will be returned.
        #[unsafe(method(extensionWithResourceBaseURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensionWithResourceBaseURL_completionHandler(
            resource_base_url: &NSURL,
            completion_handler: &block2::DynBlock<dyn Fn(*mut WKWebExtension, *mut NSError)>,
            mtm: MainThreadMarker,
        );

        /// An array of all errors that occurred during the processing of the extension.
        ///
        /// Provides an array of all parse-time errors for the extension, with repeat errors consolidated into a single entry for the original
        /// occurrence only. If no errors occurred, an empty array is returned.
        ///
        /// Note: Once the extension is loaded, use the ``errors`` property on an extension context to monitor any runtime errors, as they can occur
        /// after the extension is loaded.
        #[unsafe(method(errors))]
        #[unsafe(method_family = none)]
        pub unsafe fn errors(&self) -> Retained<NSArray<NSError>>;

        /// The parsed manifest as a dictionary.
        #[unsafe(method(manifest))]
        #[unsafe(method_family = none)]
        pub unsafe fn manifest(&self) -> Retained<NSDictionary<NSString, AnyObject>>;

        /// The parsed manifest version, or `0` if there is no version specified in the manifest.
        ///
        /// Note: An ``WKWebExtensionErrorUnsupportedManifestVersion`` error will be reported if the manifest version isn't specified.
        #[unsafe(method(manifestVersion))]
        #[unsafe(method_family = none)]
        pub unsafe fn manifestVersion(&self) -> c_double;

        /// Checks if a manifest version is supported by the extension.
        ///
        /// Parameter `manifestVersion`: The version number to check.
        ///
        /// Returns: Returns `YES` if the extension specified a manifest version that is greater than or equal to `manifestVersion`.
        #[unsafe(method(supportsManifestVersion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn supportsManifestVersion(&self, manifest_version: c_double) -> bool;

        /// The default locale for the extension. Returns `nil` if there was no default locale specified.
        #[unsafe(method(defaultLocale))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultLocale(&self) -> Option<Retained<NSLocale>>;

        /// The localized extension name. Returns `nil` if there was no name specified.
        #[unsafe(method(displayName))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayName(&self) -> Option<Retained<NSString>>;

        /// The localized extension short name. Returns `nil` if there was no short name specified.
        #[unsafe(method(displayShortName))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayShortName(&self) -> Option<Retained<NSString>>;

        /// The localized extension display version. Returns `nil` if there was no display version specified.
        #[unsafe(method(displayVersion))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayVersion(&self) -> Option<Retained<NSString>>;

        /// The localized extension description. Returns `nil` if there was no description specified.
        #[unsafe(method(displayDescription))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayDescription(&self) -> Option<Retained<NSString>>;

        /// The default localized extension action label. Returns `nil` if there was no default action label specified.
        ///
        /// This label serves as a default and should be used to represent the extension in contexts like action sheets or toolbars prior to
        /// the extension being loaded into an extension context. Once the extension is loaded, use the ``actionForTab:`` API to get the tab-specific label.
        #[unsafe(method(displayActionLabel))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayActionLabel(&self) -> Option<Retained<NSString>>;

        /// The extension version. Returns `nil` if there was no version specified.
        #[unsafe(method(version))]
        #[unsafe(method_family = none)]
        pub unsafe fn version(&self) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "objc2-app-kit", feature = "objc2-core-foundation"))]
        #[cfg(target_os = "macos")]
        #[unsafe(method(iconForSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn iconForSize(&self, size: CGSize) -> Option<Retained<NSImage>>;

        #[cfg(all(feature = "objc2-app-kit", feature = "objc2-core-foundation"))]
        #[cfg(target_os = "macos")]
        #[unsafe(method(actionIconForSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn actionIconForSize(&self, size: CGSize) -> Option<Retained<NSImage>>;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// The set of permissions that the extension requires for its base functionality.
        #[unsafe(method(requestedPermissions))]
        #[unsafe(method_family = none)]
        pub unsafe fn requestedPermissions(&self) -> Retained<NSSet<WKWebExtensionPermission>>;

        #[cfg(feature = "WKWebExtensionPermission")]
        /// The set of permissions that the extension may need for optional functionality. These permissions can be requested by the extension at a later time.
        #[unsafe(method(optionalPermissions))]
        #[unsafe(method_family = none)]
        pub unsafe fn optionalPermissions(&self) -> Retained<NSSet<WKWebExtensionPermission>>;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// The set of websites that the extension requires access to for its base functionality.
        #[unsafe(method(requestedPermissionMatchPatterns))]
        #[unsafe(method_family = none)]
        pub unsafe fn requestedPermissionMatchPatterns(
            &self,
        ) -> Retained<NSSet<WKWebExtensionMatchPattern>>;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// The set of websites that the extension may need access to for optional functionality. These match patterns can be requested by the extension at a later time.
        #[unsafe(method(optionalPermissionMatchPatterns))]
        #[unsafe(method_family = none)]
        pub unsafe fn optionalPermissionMatchPatterns(
            &self,
        ) -> Retained<NSSet<WKWebExtensionMatchPattern>>;

        #[cfg(feature = "WKWebExtensionMatchPattern")]
        /// The set of websites that the extension requires access to for injected content and for receiving messages from websites.
        #[unsafe(method(allRequestedMatchPatterns))]
        #[unsafe(method_family = none)]
        pub unsafe fn allRequestedMatchPatterns(
            &self,
        ) -> Retained<NSSet<WKWebExtensionMatchPattern>>;

        /// A Boolean value indicating whether the extension has background content that can run when needed.
        ///
        /// If this property is `YES`, the extension can run in the background even when no webpages are open.
        #[unsafe(method(hasBackgroundContent))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasBackgroundContent(&self) -> bool;

        /// A Boolean value indicating whether the extension has background content that stays in memory as long as the extension is loaded.
        ///
        /// Note: Note that extensions are only allowed to have persistent background content on macOS. An ``WKWebExtensionErrorInvalidBackgroundPersistence``
        /// error will be reported on iOS, iPadOS, and visionOS if an attempt is made to load a persistent extension.
        #[unsafe(method(hasPersistentBackgroundContent))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasPersistentBackgroundContent(&self) -> bool;

        /// A Boolean value indicating whether the extension has script or stylesheet content that can be injected into webpages.
        ///
        /// If this property is `YES`, the extension has content that can be injected by matching against the extension's requested match patterns.
        ///
        /// Note: Once the extension is loaded, use the ``hasInjectedContent`` property on an extension context, as the injectable content can change after the extension is loaded.
        #[unsafe(method(hasInjectedContent))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasInjectedContent(&self) -> bool;

        /// A Boolean value indicating whether the extension has an options page.
        ///
        /// If this property is `YES`, the extension includes a dedicated options page where users can customize settings.
        /// The app should provide access to this page through a user interface element, which can be accessed via ``optionsPageURL`` on an extension context.
        #[unsafe(method(hasOptionsPage))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasOptionsPage(&self) -> bool;

        /// A Boolean value indicating whether the extension provides an alternative to the default new tab page.
        ///
        /// If this property is `YES`, the extension can specify a custom page that can be displayed when a new tab is opened in the app, instead of the default new tab page.
        /// The app should prompt the user for permission to use the extension's new tab page as the default, which can be accessed via ``overrideNewTabPageURL`` on an extension context.
        #[unsafe(method(hasOverrideNewTabPage))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasOverrideNewTabPage(&self) -> bool;

        /// A Boolean value indicating whether the extension includes commands that users can invoke.
        ///
        /// If this property is `YES`, the extension contains one or more commands that can be performed by the user. These commands should be accessible via keyboard shortcuts,
        /// menu items, or other user interface elements provided by the app. The list of commands can be accessed via ``commands`` on an extension context, and invoked via ``performCommand:``.
        #[unsafe(method(hasCommands))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasCommands(&self) -> bool;

        /// A boolean value indicating whether the extension includes rules used for content modification or blocking.
        #[unsafe(method(hasContentModificationRules))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasContentModificationRules(&self) -> bool;
    );
}
