//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// when a user script should be injected into a webpage.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkuserscriptinjectiontime?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKUserScriptInjectionTime(pub NSInteger);
impl WKUserScriptInjectionTime {
    #[doc(alias = "WKUserScriptInjectionTimeAtDocumentStart")]
    pub const AtDocumentStart: Self = Self(0);
    #[doc(alias = "WKUserScriptInjectionTimeAtDocumentEnd")]
    pub const AtDocumentEnd: Self = Self(1);
}

unsafe impl Encode for WKUserScriptInjectionTime {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKUserScriptInjectionTime {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A
    ///
    /// ```text
    ///  WKUserScript
    /// ```
    ///
    /// object represents a script that can be injected into webpages.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkuserscript?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKUserScript;
);

extern_conformance!(
    unsafe impl NSCopying for WKUserScript {}
);

unsafe impl CopyingHelper for WKUserScript {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WKUserScript {}
);

impl WKUserScript {
    extern_methods!(
        #[unsafe(method(source))]
        #[unsafe(method_family = none)]
        pub unsafe fn source(&self) -> Retained<NSString>;

        #[unsafe(method(injectionTime))]
        #[unsafe(method_family = none)]
        pub unsafe fn injectionTime(&self) -> WKUserScriptInjectionTime;

        #[unsafe(method(isForMainFrameOnly))]
        #[unsafe(method_family = none)]
        pub unsafe fn isForMainFrameOnly(&self) -> bool;

        /// Returns an initialized user script that can be added to a
        ///
        /// ```text
        ///  WKUserContentController
        /// ```
        ///
        /// .
        ///
        /// Parameter `source`: The script source.
        ///
        /// Parameter `injectionTime`: When the script should be injected.
        ///
        /// Parameter `forMainFrameOnly`: Whether the script should be injected into all frames or just the main frame.
        ///
        /// Calling this method is the same as calling `initWithSource:injectionTime:forMainFrameOnly:inContentWorld:` with a `contentWorld` value of `WKContentWorld.pageWorld`
        #[unsafe(method(initWithSource:injectionTime:forMainFrameOnly:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSource_injectionTime_forMainFrameOnly(
            this: Allocated<Self>,
            source: &NSString,
            injection_time: WKUserScriptInjectionTime,
            for_main_frame_only: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "WKContentWorld")]
        /// Returns an initialized user script that can be added to a
        ///
        /// ```text
        ///  WKUserContentController
        /// ```
        ///
        /// .
        ///
        /// Parameter `source`: The script source.
        ///
        /// Parameter `injectionTime`: When the script should be injected.
        ///
        /// Parameter `forMainFrameOnly`: Whether the script should be injected into all frames or just the main frame.
        ///
        /// Parameter `contentWorld`: The WKContentWorld in which to inject the script.
        #[unsafe(method(initWithSource:injectionTime:forMainFrameOnly:inContentWorld:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSource_injectionTime_forMainFrameOnly_inContentWorld(
            this: Allocated<Self>,
            source: &NSString,
            injection_time: WKUserScriptInjectionTime,
            for_main_frame_only: bool,
            content_world: &WKContentWorld,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WKUserScript {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
