//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A WKUserContentController object provides a way for JavaScript to post
    /// messages to a web view.
    /// The user content controller associated with a web view is specified by its
    /// web view configuration.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkusercontentcontroller?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKUserContentController;
);

extern_conformance!(
    unsafe impl NSCoding for WKUserContentController {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKUserContentController {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for WKUserContentController {}
);

impl WKUserContentController {
    extern_methods!(
        #[cfg(feature = "WKUserScript")]
        /// The user scripts associated with this user content
        /// controller.
        #[unsafe(method(userScripts))]
        #[unsafe(method_family = none)]
        pub unsafe fn userScripts(&self) -> Retained<NSArray<WKUserScript>>;

        #[cfg(feature = "WKUserScript")]
        /// Adds a user script.
        ///
        /// Parameter `userScript`: The user script to add.
        #[unsafe(method(addUserScript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addUserScript(&self, user_script: &WKUserScript);

        /// Removes all associated user scripts.
        #[unsafe(method(removeAllUserScripts))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllUserScripts(&self);

        #[cfg(all(feature = "WKContentWorld", feature = "WKScriptMessageHandler"))]
        /// Adds a script message handler.
        ///
        /// Parameter `scriptMessageHandler`: The script message handler to add.
        ///
        /// Parameter `contentWorld`: The WKContentWorld in which to add the script message handler.
        ///
        /// Parameter `name`: The name of the message handler.
        ///
        /// Adding a script message handler adds a function
        /// window.webkit.messageHandlers.
        /// <name
        /// >.postMessage(
        /// <messageBody
        /// >) to all frames, available in the given WKContentWorld.
        ///
        /// The name argument must be a non-empty string.
        ///
        /// Each WKContentWorld can have any number of script message handlers, but only one per unique name.
        ///
        /// Once any script message handler has been added to a WKContentWorld for a given name, it is an error to add another
        /// script message handler to that WKContentWorld for that same name without first removing the previous script message handler.
        ///
        /// The above restriction applies to any type of script message handler - WKScriptMessageHandler and WKScriptMessageHandlerWithReply
        /// objects will conflict with each other if you try to add them to the same WKContentWorld with the same name.
        #[unsafe(method(addScriptMessageHandler:contentWorld:name:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addScriptMessageHandler_contentWorld_name(
            &self,
            script_message_handler: &ProtocolObject<dyn WKScriptMessageHandler>,
            world: &WKContentWorld,
            name: &NSString,
        );

        #[cfg(all(
            feature = "WKContentWorld",
            feature = "WKScriptMessageHandlerWithReply"
        ))]
        /// Adds a script message handler.
        ///
        /// Parameter `scriptMessageHandlerWithReply`: The script message handler to add.
        ///
        /// Parameter `contentWorld`: The WKContentWorld in which to add the script message handler.
        ///
        /// Parameter `name`: The name of the message handler.
        ///
        /// Adding a script message handler adds a function
        /// window.webkit.messageHandlers.
        /// <name
        /// >.postMessage(
        /// <messageBody
        /// >) to all frames, available in the given WKContentWorld.
        ///
        /// The name argument must be a non-empty string.
        ///
        /// Each WKContentWorld can have any number of script message handlers, but only one per unique name.
        ///
        /// Once any script message handler has been added to a WKContentWorld for a given name, it is an error to add another
        /// script message handler to that WKContentWorld for that same name without first removing the previous script message handler.
        ///
        /// The above restriction applies to any type of script message handler - WKScriptMessageHandlerWithReply and WKScriptMessageHandler
        /// objects will conflict with each other if you try to add them to the same WKContentWorld with the same name.
        ///
        /// Refer to the WKScriptMessageHandlerWithReply documentation for examples of how it is more flexible than WKScriptMessageHandler.
        #[unsafe(method(addScriptMessageHandlerWithReply:contentWorld:name:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addScriptMessageHandlerWithReply_contentWorld_name(
            &self,
            script_message_handler_with_reply: &ProtocolObject<dyn WKScriptMessageHandlerWithReply>,
            content_world: &WKContentWorld,
            name: &NSString,
        );

        #[cfg(feature = "WKScriptMessageHandler")]
        /// Adds a script message handler to the main world used by page content itself.
        ///
        /// Parameter `scriptMessageHandler`: The script message handler to add.
        ///
        /// Parameter `name`: The name of the message handler.
        ///
        /// Calling this method is equivalent to calling addScriptMessageHandler:contentWorld:name:
        /// with [WKContentWorld pageWorld] as the contentWorld argument.
        #[unsafe(method(addScriptMessageHandler:name:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addScriptMessageHandler_name(
            &self,
            script_message_handler: &ProtocolObject<dyn WKScriptMessageHandler>,
            name: &NSString,
        );

        #[cfg(feature = "WKContentWorld")]
        /// Removes a script message handler.
        ///
        /// Parameter `name`: The name of the message handler to remove.
        ///
        /// Parameter `contentWorld`: The WKContentWorld from which to remove the script message handler.
        #[unsafe(method(removeScriptMessageHandlerForName:contentWorld:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeScriptMessageHandlerForName_contentWorld(
            &self,
            name: &NSString,
            content_world: &WKContentWorld,
        );

        /// Removes a script message handler.
        ///
        /// Parameter `name`: The name of the message handler to remove.
        ///
        /// Calling this method is equivalent to calling removeScriptMessageHandlerForName:contentWorld:
        /// with [WKContentWorld pageWorld] as the contentWorld argument.
        #[unsafe(method(removeScriptMessageHandlerForName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeScriptMessageHandlerForName(&self, name: &NSString);

        #[cfg(feature = "WKContentWorld")]
        /// Removes all script message handlers from a given WKContentWorld.
        ///
        /// Parameter `contentWorld`: The WKContentWorld from which to remove all script message handlers.
        #[unsafe(method(removeAllScriptMessageHandlersFromContentWorld:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllScriptMessageHandlersFromContentWorld(
            &self,
            content_world: &WKContentWorld,
        );

        /// Removes all associated script message handlers.
        #[unsafe(method(removeAllScriptMessageHandlers))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllScriptMessageHandlers(&self);

        #[cfg(feature = "WKContentRuleList")]
        /// Adds a content rule list.
        ///
        /// Parameter `contentRuleList`: The content rule list to add.
        #[unsafe(method(addContentRuleList:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addContentRuleList(&self, content_rule_list: &WKContentRuleList);

        #[cfg(feature = "WKContentRuleList")]
        /// Removes a content rule list.
        ///
        /// Parameter `contentRuleList`: The content rule list to remove.
        #[unsafe(method(removeContentRuleList:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeContentRuleList(&self, content_rule_list: &WKContentRuleList);

        /// Removes all associated content rule lists.
        #[unsafe(method(removeAllContentRuleLists))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllContentRuleLists(&self);
    );
}

/// Methods declared on superclass `NSObject`.
impl WKUserContentController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
