//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkurlschemetask?language=objc)
    pub unsafe trait WKURLSchemeTask: NSObjectProtocol {
        /// The request to load for this task.
        #[unsafe(method(request))]
        #[unsafe(method_family = none)]
        unsafe fn request(&self) -> Retained<NSURLRequest>;

        /// Set the current response object for the task.
        ///
        /// Parameter `response`: The response to use.
        ///
        /// This method must be called at least once for each URL scheme handler task.
        /// Cross-origin requests require CORS header fields.
        /// An exception will be thrown if you try to send a new response object after the task has already been completed.
        /// An exception will be thrown if your app has been told to stop loading this task via the registered WKURLSchemeHandler object.
        #[unsafe(method(didReceiveResponse:))]
        #[unsafe(method_family = none)]
        unsafe fn didReceiveResponse(&self, response: &NSURLResponse);

        /// Add received data to the task.
        ///
        /// Parameter `data`: The data to add.
        ///
        /// After a URL scheme handler task's final response object is received you should
        /// start sending it data.
        /// Each time this method is called the data you send will be appended to all previous data.
        /// An exception will be thrown if you try to send the task any data before sending it a response.
        /// An exception will be thrown if you try to send the task any data after the task has already been completed.
        /// An exception will be thrown if your app has been told to stop loading this task via the registered WKURLSchemeHandler object.
        #[unsafe(method(didReceiveData:))]
        #[unsafe(method_family = none)]
        unsafe fn didReceiveData(&self, data: &NSData);

        /// Mark the task as successfully completed.
        ///
        /// An exception will be thrown if you try to finish the task before sending it a response.
        /// An exception will be thrown if you try to mark a task completed after it has already been marked completed or failed.
        /// An exception will be thrown if your app has been told to stop loading this task via the registered WKURLSchemeHandler object.
        #[unsafe(method(didFinish))]
        #[unsafe(method_family = none)]
        unsafe fn didFinish(&self);

        /// Mark the task as failed.
        ///
        /// Parameter `error`: A description of the error that caused the task to fail.
        ///
        /// An exception will be thrown if you try to mark a task failed after it has already been marked completed or failed.
        /// An exception will be thrown if your app has been told to stop loading this task via the registered WKURLSchemeHandler object.
        #[unsafe(method(didFailWithError:))]
        #[unsafe(method_family = none)]
        unsafe fn didFailWithError(&self, error: &NSError);
    }
);
