//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkpermissiondecision?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKPermissionDecision(pub NSInteger);
impl WKPermissionDecision {
    #[doc(alias = "WKPermissionDecisionPrompt")]
    pub const Prompt: Self = Self(0);
    #[doc(alias = "WKPermissionDecisionGrant")]
    pub const Grant: Self = Self(1);
    #[doc(alias = "WKPermissionDecisionDeny")]
    pub const Deny: Self = Self(2);
}

unsafe impl Encode for WKPermissionDecision {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKPermissionDecision {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkmediacapturetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKMediaCaptureType(pub NSInteger);
impl WKMediaCaptureType {
    #[doc(alias = "WKMediaCaptureTypeCamera")]
    pub const Camera: Self = Self(0);
    #[doc(alias = "WKMediaCaptureTypeMicrophone")]
    pub const Microphone: Self = Self(1);
    #[doc(alias = "WKMediaCaptureTypeCameraAndMicrophone")]
    pub const CameraAndMicrophone: Self = Self(2);
}

unsafe impl Encode for WKMediaCaptureType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKMediaCaptureType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Constants returned by showLockdownModeFirstUseMessage to indicate how WebKit should treat first use.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkdialogresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKDialogResult(pub NSInteger);
impl WKDialogResult {
    #[doc(alias = "WKDialogResultShowDefault")]
    pub const ShowDefault: Self = Self(1);
    #[doc(alias = "WKDialogResultAskAgain")]
    pub const AskAgain: Self = Self(2);
    #[doc(alias = "WKDialogResultHandled")]
    pub const Handled: Self = Self(3);
}

unsafe impl Encode for WKDialogResult {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKDialogResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A class conforming to the WKUIDelegate protocol provides methods for
    /// presenting native UI on behalf of a webpage.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkuidelegate?language=objc)
    pub unsafe trait WKUIDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(
            feature = "WKNavigationAction",
            feature = "WKWebView",
            feature = "WKWebViewConfiguration",
            feature = "WKWindowFeatures",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Creates a new web view.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `configuration`: The configuration to use when creating the new web
        /// view. This configuration is a copy of webView.configuration.
        ///
        /// Parameter `navigationAction`: The navigation action causing the new web view to
        /// be created.
        ///
        /// Parameter `windowFeatures`: Window features requested by the webpage.
        ///
        /// Returns: A new web view or nil.
        ///
        /// The web view returned must be created with the specified configuration. WebKit will load the request in the returned web view.
        ///
        /// If you do not implement this method, the web view will cancel the navigation.
        #[optional]
        #[unsafe(method(webView:createWebViewWithConfiguration:forNavigationAction:windowFeatures:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_createWebViewWithConfiguration_forNavigationAction_windowFeatures(
            &self,
            web_view: &WKWebView,
            configuration: &WKWebViewConfiguration,
            navigation_action: &WKNavigationAction,
            window_features: &WKWindowFeatures,
        ) -> Option<Retained<WKWebView>>;

        #[cfg(all(feature = "WKWebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Notifies your app that the DOM window object's close() method completed successfully.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Your app should remove the web view from the view hierarchy and update
        /// the UI as needed, such as by closing the containing browser tab or window.
        #[optional]
        #[unsafe(method(webViewDidClose:))]
        #[unsafe(method_family = none)]
        unsafe fn webViewDidClose(&self, web_view: &WKWebView);

        #[cfg(all(
            feature = "WKFrameInfo",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Displays a JavaScript alert panel.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `message`: The message to display.
        ///
        /// Parameter `frame`: Information about the frame whose JavaScript initiated this
        /// call.
        ///
        /// Parameter `completionHandler`: The completion handler to call after the alert
        /// panel has been dismissed.
        ///
        /// For user security, your app should call attention to the fact
        /// that a specific website controls the content in this panel. A simple forumla
        /// for identifying the controlling website is frame.request.URL.host.
        /// The panel should have a single OK button.
        ///
        /// If you do not implement this method, the web view will behave as if the user selected the OK button.
        #[optional]
        #[unsafe(method(webView:runJavaScriptAlertPanelWithMessage:initiatedByFrame:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_completionHandler(
            &self,
            web_view: &WKWebView,
            message: &NSString,
            frame: &WKFrameInfo,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(all(
            feature = "WKFrameInfo",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Displays a JavaScript confirm panel.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `message`: The message to display.
        ///
        /// Parameter `frame`: Information about the frame whose JavaScript initiated this call.
        ///
        /// Parameter `completionHandler`: The completion handler to call after the confirm
        /// panel has been dismissed. Pass YES if the user chose OK, NO if the user
        /// chose Cancel.
        ///
        /// For user security, your app should call attention to the fact
        /// that a specific website controls the content in this panel. A simple forumla
        /// for identifying the controlling website is frame.request.URL.host.
        /// The panel should have two buttons, such as OK and Cancel.
        ///
        /// If you do not implement this method, the web view will behave as if the user selected the Cancel button.
        #[optional]
        #[unsafe(method(webView:runJavaScriptConfirmPanelWithMessage:initiatedByFrame:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_completionHandler(
            &self,
            web_view: &WKWebView,
            message: &NSString,
            frame: &WKFrameInfo,
            completion_handler: &block2::DynBlock<dyn Fn(Bool)>,
        );

        #[cfg(all(
            feature = "WKFrameInfo",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Displays a JavaScript text input panel.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `prompt`: The prompt to display.
        ///
        /// Parameter `defaultText`: The initial text to display in the text entry field.
        ///
        /// Parameter `frame`: Information about the frame whose JavaScript initiated this call.
        ///
        /// Parameter `completionHandler`: The completion handler to call after the text
        /// input panel has been dismissed. Pass the entered text if the user chose
        /// OK, otherwise nil.
        ///
        /// For user security, your app should call attention to the fact
        /// that a specific website controls the content in this panel. A simple forumla
        /// for identifying the controlling website is frame.request.URL.host.
        /// The panel should have two buttons, such as OK and Cancel, and a field in
        /// which to enter text.
        ///
        /// If you do not implement this method, the web view will behave as if the user selected the Cancel button.
        #[optional]
        #[unsafe(method(webView:runJavaScriptTextInputPanelWithPrompt:defaultText:initiatedByFrame:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_runJavaScriptTextInputPanelWithPrompt_defaultText_initiatedByFrame_completionHandler(
            &self,
            web_view: &WKWebView,
            prompt: &NSString,
            default_text: Option<&NSString>,
            frame: &WKFrameInfo,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSString)>,
        );

        #[cfg(all(
            feature = "WKFrameInfo",
            feature = "WKSecurityOrigin",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// A delegate to request permission for microphone audio and camera video access.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `origin`: The origin of the page.
        ///
        /// Parameter `frame`: Information about the frame whose JavaScript initiated this call.
        ///
        /// Parameter `type`: The type of capture (camera, microphone).
        ///
        /// Parameter `decisionHandler`: The completion handler to call once the decision is made
        ///
        /// If not implemented, the result is the same as calling the decisionHandler with WKPermissionDecisionPrompt.
        #[optional]
        #[unsafe(method(webView:requestMediaCapturePermissionForOrigin:initiatedByFrame:type:decisionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_requestMediaCapturePermissionForOrigin_initiatedByFrame_type_decisionHandler(
            &self,
            web_view: &WKWebView,
            origin: &WKSecurityOrigin,
            frame: &WKFrameInfo,
            r#type: WKMediaCaptureType,
            decision_handler: &block2::DynBlock<dyn Fn(WKPermissionDecision)>,
        );

        #[cfg(all(
            feature = "WKFrameInfo",
            feature = "WKSecurityOrigin",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Allows your app to determine whether or not the given security origin should have access to the device's orientation and motion.
        ///
        /// Parameter `securityOrigin`: The security origin which requested access to the device's orientation and motion.
        ///
        /// Parameter `frame`: The frame that initiated the request.
        ///
        /// Parameter `decisionHandler`: The decision handler to call once the app has made its decision.
        #[optional]
        #[unsafe(method(webView:requestDeviceOrientationAndMotionPermissionForOrigin:initiatedByFrame:decisionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_requestDeviceOrientationAndMotionPermissionForOrigin_initiatedByFrame_decisionHandler(
            &self,
            web_view: &WKWebView,
            origin: &WKSecurityOrigin,
            frame: &WKFrameInfo,
            decision_handler: &block2::DynBlock<dyn Fn(WKPermissionDecision)>,
        );

        #[cfg(all(
            feature = "WKFrameInfo",
            feature = "WKOpenPanelParameters",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Displays a file upload panel.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `parameters`: Parameters describing the file upload control.
        ///
        /// Parameter `frame`: Information about the frame whose file upload control initiated this call.
        ///
        /// Parameter `completionHandler`: The completion handler to call after open panel has been dismissed. Pass the selected URLs if the user chose OK, otherwise nil.
        ///
        /// If you do not implement this method on macOS, the web view will behave as if the user selected the Cancel button.
        /// If you do not implement this method on iOS or visionOS, the web view will match the file upload behavior of Safari. If you desire
        /// the web view to act as if the user selected the Cancel button on iOS or visionOS, immediately call the completion handler with nil.
        #[optional]
        #[unsafe(method(webView:runOpenPanelWithParameters:initiatedByFrame:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_runOpenPanelWithParameters_initiatedByFrame_completionHandler(
            &self,
            web_view: &WKWebView,
            parameters: &WKOpenPanelParameters,
            frame: &WKFrameInfo,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSArray<NSURL>)>,
        );
    }
);
