//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// A class conforming to  the WKScriptMessageHandlerWithReply protocol provides a
    /// method for receiving messages from JavaScript running in a webpage and replying to them asynchronously.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkscriptmessagehandlerwithreply?language=objc)
    pub unsafe trait WKScriptMessageHandlerWithReply:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(all(
            feature = "WKScriptMessage",
            feature = "WKUserContentController",
            feature = "block2"
        ))]
        /// Invoked when a script message is received from a webpage.
        ///
        /// Parameter `userContentController`: The user content controller invoking the delegate method.
        ///
        /// Parameter `message`: The script message received.
        ///
        /// Parameter `replyHandler`: A block to be called with the result of processing the message.
        ///
        /// When the JavaScript running in your application's web content called window.webkit.messageHandlers.
        /// <name
        /// >.postMessage(
        /// <messageBody
        /// >),
        /// a JavaScript Promise object was returned. The values passed to the replyHandler are used to resolve that Promise.
        ///
        /// Passing a non-nil NSString value to the second parameter of the replyHandler signals an error.
        /// No matter what value you pass to the first parameter of the replyHandler,
        /// the Promise will be rejected with a JavaScript error object whose message property is set to that errorMessage string.
        ///
        /// If the second parameter to the replyHandler is nil, the first argument will be serialized into its JavaScript equivalent and the Promise will be fulfilled with the resulting value.
        /// If the first argument is nil then the Promise will be resolved with a JavaScript value of "undefined"
        ///
        /// Allowed non-nil result types are:
        /// NSNumber, NSNull, NSString, NSDate, NSArray, and NSDictionary.
        /// Any NSArray or NSDictionary containers can only contain objects of those types.
        ///
        /// The replyHandler can be called at most once.
        /// If the replyHandler is deallocated before it is called, the Promise will be rejected with a JavaScript Error object
        /// with an appropriate message indicating the handler was never called.
        ///
        /// Example:
        ///
        /// With a WKScriptMessageHandlerWithReply object installed with the name "testHandler", consider the following JavaScript:
        ///
        /// ```text
        ///      var promise = window.webkit.messageHandlers.testHandler.postMessage("Fulfill me with 42");
        ///      await p;
        ///      return p;
        /// ```
        ///
        /// And consider the following WKScriptMessageHandlerWithReply implementation:
        ///
        /// ```text
        ///      - (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message replyHandler:(void (^)(id, NSString *))replyHandler
        ///      {
        ///         if ([message.body isEqual:@"Fulfill me with 42"])
        ///             replyHandler(@42, nil);
        ///         else
        ///             replyHandler(nil, @"Unexpected message received");
        ///      }
        /// ```
        ///
        /// In this example:
        /// - The JavaScript code sends a message to your application code with the body
        /// "
        /// Fulfill me with 42"
        /// - JavaScript execution is suspended while waiting for the resulting promise to resolve.
        /// - Your message handler is invoked with that message and a block to call with the reply when ready.
        /// - Your message handler sends the value
        /// @
        /// 42 as a reply.
        /// - The JavaScript promise is fulfilled with the value 42.
        /// - JavaScript execution continues and the value 42 is returned.
        #[unsafe(method(userContentController:didReceiveScriptMessage:replyHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn userContentController_didReceiveScriptMessage_replyHandler(
            &self,
            user_content_controller: &WKUserContentController,
            message: &WKScriptMessage,
            reply_handler: &block2::DynBlock<dyn Fn(*mut AnyObject, *mut NSString)>,
        );
    }
);
