//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// The policy to pass back to the decision handler from the
/// webView:decidePolicyForNavigationAction:decisionHandler: method.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wknavigationactionpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKNavigationActionPolicy(pub NSInteger);
impl WKNavigationActionPolicy {
    #[doc(alias = "WKNavigationActionPolicyCancel")]
    pub const Cancel: Self = Self(0);
    #[doc(alias = "WKNavigationActionPolicyAllow")]
    pub const Allow: Self = Self(1);
    #[doc(alias = "WKNavigationActionPolicyDownload")]
    pub const Download: Self = Self(2);
}

unsafe impl Encode for WKNavigationActionPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKNavigationActionPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The policy to pass back to the decision handler from the webView:decidePolicyForNavigationResponse:decisionHandler: method.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wknavigationresponsepolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKNavigationResponsePolicy(pub NSInteger);
impl WKNavigationResponsePolicy {
    #[doc(alias = "WKNavigationResponsePolicyCancel")]
    pub const Cancel: Self = Self(0);
    #[doc(alias = "WKNavigationResponsePolicyAllow")]
    pub const Allow: Self = Self(1);
    #[doc(alias = "WKNavigationResponsePolicyDownload")]
    pub const Download: Self = Self(2);
}

unsafe impl Encode for WKNavigationResponsePolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKNavigationResponsePolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A class conforming to the WKNavigationDelegate protocol can provide
    /// methods for tracking progress for main frame navigations and for deciding
    /// policy for main frame and subframe navigations.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wknavigationdelegate?language=objc)
    pub unsafe trait WKNavigationDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(
            feature = "WKNavigationAction",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Decides whether to allow or cancel a navigation.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigationAction`: Descriptive information about the action
        /// triggering the navigation request.
        ///
        /// Parameter `decisionHandler`: The decision handler to call to allow or cancel the
        /// navigation. The argument is one of the constants of the enumerated type WKNavigationActionPolicy.
        ///
        /// If you do not implement this method, the web view will load the request or, if appropriate, forward it to another application.
        #[optional]
        #[unsafe(method(webView:decidePolicyForNavigationAction:decisionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_decidePolicyForNavigationAction_decisionHandler(
            &self,
            web_view: &WKWebView,
            navigation_action: &WKNavigationAction,
            decision_handler: &block2::DynBlock<dyn Fn(WKNavigationActionPolicy)>,
        );

        #[cfg(all(
            feature = "WKNavigationAction",
            feature = "WKWebView",
            feature = "WKWebpagePreferences",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Decides whether to allow or cancel a navigation.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigationAction`: Descriptive information about the action
        /// triggering the navigation request.
        ///
        /// Parameter `preferences`: The default set of webpage preferences. This may be
        /// changed by setting defaultWebpagePreferences on WKWebViewConfiguration.
        ///
        /// Parameter `decisionHandler`: The policy decision handler to call to allow or cancel
        /// the navigation. The arguments are one of the constants of the enumerated type
        /// WKNavigationActionPolicy, as well as an instance of WKWebpagePreferences.
        ///
        /// If you implement this method,
        /// -webView:decidePolicyForNavigationAction:decisionHandler: will not be called.
        #[optional]
        #[unsafe(method(webView:decidePolicyForNavigationAction:preferences:decisionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_decidePolicyForNavigationAction_preferences_decisionHandler(
            &self,
            web_view: &WKWebView,
            navigation_action: &WKNavigationAction,
            preferences: &WKWebpagePreferences,
            decision_handler: &block2::DynBlock<
                dyn Fn(WKNavigationActionPolicy, NonNull<WKWebpagePreferences>),
            >,
        );

        #[cfg(all(
            feature = "WKNavigationResponse",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Decides whether to allow or cancel a navigation after its
        /// response is known.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigationResponse`: Descriptive information about the navigation
        /// response.
        ///
        /// Parameter `decisionHandler`: The decision handler to call to allow or cancel the
        /// navigation. The argument is one of the constants of the enumerated type WKNavigationResponsePolicy.
        ///
        /// If you do not implement this method, the web view will allow the response, if the web view can show it.
        #[optional]
        #[unsafe(method(webView:decidePolicyForNavigationResponse:decisionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_decidePolicyForNavigationResponse_decisionHandler(
            &self,
            web_view: &WKWebView,
            navigation_response: &WKNavigationResponse,
            decision_handler: &block2::DynBlock<dyn Fn(WKNavigationResponsePolicy)>,
        );

        #[cfg(all(
            feature = "WKNavigation",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Invoked when a main frame navigation starts.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigation`: The navigation.
        ///
        /// # Safety
        ///
        /// `navigation` might not allow `None`.
        #[optional]
        #[unsafe(method(webView:didStartProvisionalNavigation:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didStartProvisionalNavigation(
            &self,
            web_view: &WKWebView,
            navigation: Option<&WKNavigation>,
        );

        #[cfg(all(
            feature = "WKNavigation",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Invoked when a server redirect is received for the main
        /// frame.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigation`: The navigation.
        ///
        /// # Safety
        ///
        /// `navigation` might not allow `None`.
        #[optional]
        #[unsafe(method(webView:didReceiveServerRedirectForProvisionalNavigation:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didReceiveServerRedirectForProvisionalNavigation(
            &self,
            web_view: &WKWebView,
            navigation: Option<&WKNavigation>,
        );

        #[cfg(all(
            feature = "WKNavigation",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Invoked when an error occurs while starting to load data for
        /// the main frame.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigation`: The navigation.
        ///
        /// Parameter `error`: The error that occurred.
        ///
        /// # Safety
        ///
        /// `navigation` might not allow `None`.
        #[optional]
        #[unsafe(method(webView:didFailProvisionalNavigation:withError:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didFailProvisionalNavigation_withError(
            &self,
            web_view: &WKWebView,
            navigation: Option<&WKNavigation>,
            error: &NSError,
        );

        #[cfg(all(
            feature = "WKNavigation",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Invoked when content starts arriving for the main frame.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigation`: The navigation.
        ///
        /// # Safety
        ///
        /// `navigation` might not allow `None`.
        #[optional]
        #[unsafe(method(webView:didCommitNavigation:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didCommitNavigation(
            &self,
            web_view: &WKWebView,
            navigation: Option<&WKNavigation>,
        );

        #[cfg(all(
            feature = "WKNavigation",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Invoked when a main frame navigation completes.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigation`: The navigation.
        ///
        /// # Safety
        ///
        /// `navigation` might not allow `None`.
        #[optional]
        #[unsafe(method(webView:didFinishNavigation:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didFinishNavigation(
            &self,
            web_view: &WKWebView,
            navigation: Option<&WKNavigation>,
        );

        #[cfg(all(
            feature = "WKNavigation",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        /// Invoked when an error occurs during a committed main frame
        /// navigation.
        ///
        /// Parameter `webView`: The web view invoking the delegate method.
        ///
        /// Parameter `navigation`: The navigation.
        ///
        /// Parameter `error`: The error that occurred.
        ///
        /// # Safety
        ///
        /// `navigation` might not allow `None`.
        #[optional]
        #[unsafe(method(webView:didFailNavigation:withError:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didFailNavigation_withError(
            &self,
            web_view: &WKWebView,
            navigation: Option<&WKNavigation>,
            error: &NSError,
        );

        #[cfg(all(feature = "WKWebView", feature = "block2", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Invoked when the web view needs to respond to an authentication challenge.
        ///
        /// Parameter `webView`: The web view that received the authentication challenge.
        ///
        /// Parameter `challenge`: The authentication challenge.
        ///
        /// Parameter `completionHandler`: The completion handler you must invoke to respond to the challenge. The
        /// disposition argument is one of the constants of the enumerated type
        /// NSURLSessionAuthChallengeDisposition. When disposition is NSURLSessionAuthChallengeUseCredential,
        /// the credential argument is the credential to use, or nil to indicate continuing without a
        /// credential.
        ///
        /// If you do not implement this method, the web view will respond to the authentication challenge with the NSURLSessionAuthChallengeRejectProtectionSpace disposition.
        #[optional]
        #[unsafe(method(webView:didReceiveAuthenticationChallenge:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_didReceiveAuthenticationChallenge_completionHandler(
            &self,
            web_view: &WKWebView,
            challenge: &NSURLAuthenticationChallenge,
            completion_handler: &block2::DynBlock<
                dyn Fn(NSURLSessionAuthChallengeDisposition, *mut NSURLCredential),
            >,
        );

        #[cfg(all(feature = "WKWebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Invoked when the web view's web content process is terminated.
        ///
        /// Parameter `webView`: The web view whose underlying web content process was terminated.
        #[optional]
        #[unsafe(method(webViewWebContentProcessDidTerminate:))]
        #[unsafe(method_family = none)]
        unsafe fn webViewWebContentProcessDidTerminate(&self, web_view: &WKWebView);

        #[cfg(all(feature = "WKWebView", feature = "block2", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// Invoked when the web view is establishing a network connection using a deprecated version of TLS.
        ///
        /// Parameter `webView`: The web view initiating the connection.
        ///
        /// Parameter `challenge`: The authentication challenge.
        ///
        /// Parameter `decisionHandler`: The decision handler you must invoke to respond to indicate whether or not to continue with the connection establishment.
        #[optional]
        #[unsafe(method(webView:authenticationChallenge:shouldAllowDeprecatedTLS:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_authenticationChallenge_shouldAllowDeprecatedTLS(
            &self,
            web_view: &WKWebView,
            challenge: &NSURLAuthenticationChallenge,
            decision_handler: &block2::DynBlock<dyn Fn(Bool)>,
        );

        #[cfg(all(
            feature = "WKDownload",
            feature = "WKNavigationAction",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        #[optional]
        #[unsafe(method(webView:navigationAction:didBecomeDownload:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_navigationAction_didBecomeDownload(
            &self,
            web_view: &WKWebView,
            navigation_action: &WKNavigationAction,
            download: &WKDownload,
        );

        #[cfg(all(
            feature = "WKDownload",
            feature = "WKNavigationResponse",
            feature = "WKWebView",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        #[optional]
        #[unsafe(method(webView:navigationResponse:didBecomeDownload:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_navigationResponse_didBecomeDownload(
            &self,
            web_view: &WKWebView,
            navigation_response: &WKNavigationResponse,
            download: &WKDownload,
        );

        #[cfg(all(
            feature = "WKBackForwardListItem",
            feature = "WKWebView",
            feature = "block2",
            feature = "objc2-app-kit"
        ))]
        #[cfg(target_os = "macos")]
        #[optional]
        #[unsafe(method(webView:shouldGoToBackForwardListItem:willUseInstantBack:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn webView_shouldGoToBackForwardListItem_willUseInstantBack_completionHandler(
            &self,
            web_view: &WKWebView,
            back_forward_list_item: &WKBackForwardListItem,
            will_use_instant_back: bool,
            completion_handler: &block2::DynBlock<dyn Fn(Bool)>,
        );
    }
);
