//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkcookiepolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct WKCookiePolicy(pub NSInteger);
impl WKCookiePolicy {
    #[doc(alias = "WKCookiePolicyAllow")]
    pub const Allow: Self = Self(0);
    #[doc(alias = "WKCookiePolicyDisallow")]
    pub const Disallow: Self = Self(1);
}

unsafe impl Encode for WKCookiePolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for WKCookiePolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/webkit/wkhttpcookiestoreobserver?language=objc)
    pub unsafe trait WKHTTPCookieStoreObserver: NSObjectProtocol + MainThreadOnly {
        #[optional]
        #[unsafe(method(cookiesDidChangeInCookieStore:))]
        #[unsafe(method_family = none)]
        unsafe fn cookiesDidChangeInCookieStore(&self, cookie_store: &WKHTTPCookieStore);
    }
);

extern_class!(
    /// A WKHTTPCookieStore object allows managing the HTTP cookies associated with a particular WKWebsiteDataStore.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkhttpcookiestore?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKHTTPCookieStore;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKHTTPCookieStore {}
);

impl WKHTTPCookieStore {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "block2")]
        /// Fetches all stored cookies.
        ///
        /// Parameter `completionHandler`: A block to invoke with the fetched cookies.
        #[unsafe(method(getAllCookies:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getAllCookies(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(NonNull<NSArray<NSHTTPCookie>>)>,
        );

        #[cfg(feature = "block2")]
        /// Set a cookie.
        ///
        /// Parameter `cookie`: The cookie to set.
        ///
        /// Parameter `completionHandler`: A block to invoke once the cookie has been stored.
        #[unsafe(method(setCookie:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCookie_completionHandler(
            &self,
            cookie: &NSHTTPCookie,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        /// Set multiple cookies.
        ///
        /// Parameter `cookies`: An array of cookies to set.
        ///
        /// Parameter `completionHandler`: A block to invoke once the cookies have been stored.
        #[unsafe(method(setCookies:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCookies_completionHandler(
            &self,
            cookies: &NSArray<NSHTTPCookie>,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        /// Delete the specified cookie.
        ///
        /// Parameter `completionHandler`: A block to invoke once the cookie has been deleted.
        #[unsafe(method(deleteCookie:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteCookie_completionHandler(
            &self,
            cookie: &NSHTTPCookie,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        /// Adds a WKHTTPCookieStoreObserver object with the cookie store.
        ///
        /// Parameter `observer`: The observer object to add.
        ///
        /// The observer is not retained by the receiver. It is your responsibility
        /// to unregister the observer before it becomes invalid.
        #[unsafe(method(addObserver:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addObserver(&self, observer: &ProtocolObject<dyn WKHTTPCookieStoreObserver>);

        /// Removes a WKHTTPCookieStoreObserver object from the cookie store.
        ///
        /// Parameter `observer`: The observer to remove.
        #[unsafe(method(removeObserver:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeObserver(
            &self,
            observer: &ProtocolObject<dyn WKHTTPCookieStoreObserver>,
        );

        #[cfg(feature = "block2")]
        /// Set whether cookies are allowed.
        ///
        /// Parameter `policy`: A value indicating whether cookies are allowed. The default value is WKCookiePolicyAllow.
        ///
        /// Parameter `completionHandler`: A block to invoke once the cookie policy has been set.
        #[unsafe(method(setCookiePolicy:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCookiePolicy_completionHandler(
            &self,
            policy: WKCookiePolicy,
            completion_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        /// Get whether cookies are allowed.
        ///
        /// Parameter `completionHandler`: A block to invoke with the value of whether cookies are allowed.
        #[unsafe(method(getCookiePolicy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCookiePolicy(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(WKCookiePolicy)>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl WKHTTPCookieStore {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
