//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A WKFrameInfo object contains information about a frame on a webpage.
    ///
    /// An instance of this class is a transient, data-only object;
    /// it does not uniquely identify a frame across multiple delegate method
    /// calls.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkframeinfo?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKFrameInfo;
);

extern_conformance!(
    unsafe impl NSCopying for WKFrameInfo {}
);

unsafe impl CopyingHelper for WKFrameInfo {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for WKFrameInfo {}
);

impl WKFrameInfo {
    extern_methods!(
        /// A Boolean value indicating whether the frame is the main frame
        /// or a subframe.
        #[unsafe(method(isMainFrame))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMainFrame(&self) -> bool;

        /// The frame's current request.
        #[unsafe(method(request))]
        #[unsafe(method_family = none)]
        pub unsafe fn request(&self) -> Retained<NSURLRequest>;

        #[cfg(feature = "WKSecurityOrigin")]
        /// The frame's current security origin.
        #[unsafe(method(securityOrigin))]
        #[unsafe(method_family = none)]
        pub unsafe fn securityOrigin(&self) -> Retained<WKSecurityOrigin>;

        #[cfg(all(feature = "WKWebView", feature = "objc2-app-kit"))]
        #[cfg(target_os = "macos")]
        /// The web view of the webpage that contains this frame.
        #[unsafe(method(webView))]
        #[unsafe(method_family = none)]
        pub unsafe fn webView(&self) -> Option<Retained<WKWebView>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl WKFrameInfo {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
