//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A WKContentWorld object allows you to separate your application's interaction with content displayed in a WKWebView into different roles that cannot interfere with one another.
    ///
    /// WKContentWorld objects should be treated as namespaces. This is useful for keeping your application's web content environment separate from the environment of the web page content itself,
    /// as well as managing multiple different environments within your own application.
    /// For example:
    /// - If you have complex scripting logic to bridge your web content to your application but your web content also has complex scripting libraries of its own,
    /// you avoid possible conflicts by using a client WKContentWorld.
    /// - If you are writing a general purpose web browser that supports JavaScript extensions, you would use a different client WKContentWorld for each extension.
    ///
    /// Since a WKContentWorld object is a namespace it does not contain any data itself.
    /// For example:
    /// - If you store a variable in JavaScript in the scope of a particular WKContentWorld while viewing a particular web page document, after navigating to a new document that variable will be gone.
    /// - If you store a variable in JavaScript in the scope of a particular WKContentWorld in one WKWebView, that variable will not exist in the same world in another WKWebView.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/webkit/wkcontentworld?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct WKContentWorld;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for WKContentWorld {}
);

impl WKContentWorld {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Retrieve the main world that page content itself uses.
        ///
        /// When interacting with page content in a WKWebView using the page content world you can disrupt the operation of page content (e.g. by conflicting with variable names in JavaScript set by the web page content itself).
        #[unsafe(method(pageWorld))]
        #[unsafe(method_family = none)]
        pub unsafe fn pageWorld(mtm: MainThreadMarker) -> Retained<WKContentWorld>;

        /// Retrieve the default world for API client use.
        ///
        /// When using a content world different from the page content world you can still manipulate the DOM and built-in DOM APIs but without conflicting with other aspects of the page content (e.g. JavaScript from the web page content itself)
        /// Repeated calls will retrieve the same WKContentWorld instance.
        #[unsafe(method(defaultClientWorld))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultClientWorld(mtm: MainThreadMarker) -> Retained<WKContentWorld>;

        /// Retrieves a named content world for API client use.
        ///
        /// Parameter `name`: The name of the WKContentWorld to retrieve.
        ///
        /// When using a content world different from the page content world you can still manipulate the DOM and built-in DOM APIs but without conflicting with other aspects of the page content (e.g. JavaScript from the web page content itself)
        /// As long as a particular named WKContentWorld instance has not been deallocated, repeated calls with the same name will retrieve that same WKContentWorld instance.
        /// Each named content world is distinct from all other named content worlds, the defaultClientWorld, and the pageWorld.
        /// The name can be used to keep distinct worlds identifiable anywhere a world might be surfaced in a user interface. For example, the different worlds used in your application will be surfaced by name in the WebKit Web Inspector.
        #[unsafe(method(worldWithName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn worldWithName(
            name: &NSString,
            mtm: MainThreadMarker,
        ) -> Retained<WKContentWorld>;

        /// The name of the WKContentWorld
        ///
        /// The pageWorld and defaultClientWorld instances will have a nil name.
        /// All other instances will have the non-nil name they were accessed by.
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Option<Retained<NSString>>;
    );
}
