// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use itertools::Itertools;
use malachite_base::strings::ToDebugString;
use malachite_q::exhaustive::exhaustive_negative_rationals;

#[test]
fn test_exhaustive_negative_rationals() {
    assert_eq!(
        exhaustive_negative_rationals()
            .take(20)
            .collect_vec()
            .to_debug_string(),
        "[-1, -1/2, -2, -1/3, -3/2, -2/3, -3, -1/4, -4/3, -3/5, -5/2, -2/5, -5/3, -3/4, -4, -1/5, \
        -5/4, -4/7, -7/3, -3/8]"
    );
}
