// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use itertools::Itertools;
use malachite_base::num::random::striped::StripedBitSource;
use malachite_base::random::EXAMPLE_SEED;
use malachite_base::strings::ToDebugString;
use malachite_nz::natural::random::get_striped_random_natural_with_up_to_bits;

fn get_striped_random_natural_with_up_to_bits_helper(
    m_numerator: u64,
    m_denominator: u64,
    bits: u64,
    out: &str,
) {
    let mut bit_source = StripedBitSource::new(EXAMPLE_SEED, m_numerator, m_denominator);
    let xs = (0..10)
        .map(|_| get_striped_random_natural_with_up_to_bits(&mut bit_source, bits))
        .collect_vec();
    assert_eq!(xs.to_debug_string(), out);
}

#[test]
fn test_get_striped_random_natural_with_up_to_bits() {
    get_striped_random_natural_with_up_to_bits_helper(2, 1, 0, "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0]");
    get_striped_random_natural_with_up_to_bits_helper(2, 1, 1, "[0, 0, 0, 1, 0, 1, 0, 0, 0, 1]");
    get_striped_random_natural_with_up_to_bits_helper(
        2,
        1,
        10,
        "[204, 684, 662, 251, 286, 317, 768, 732, 24, 541]",
    );
    get_striped_random_natural_with_up_to_bits_helper(
        2,
        1,
        100,
        "[756308944479610176770360563916, 511893378796631990364418200242, \
        446479956742998294289234529360, 173892505765242981097567362471, \
        1215845349850185248466264185684, 189123428420118759301761040685, \
        955700757257715004518140113132, 832461439248077413553063350320, \
        1242643020761038901934578711610, 488312687132791313623062140817]",
    );
    get_striped_random_natural_with_up_to_bits_helper(
        2,
        1,
        1000,
        "[5302820982294529215866185111327055517244217675166185603676375596884934292920305919547313\
        397807621409756790898297593901473840098546243409160554985560709769081990616677721618124140\
        633144482861862817944190912524600105600870980017006153101609664050197435761380970654049260\
        967366504273137971882485916981452, \
        451422532374337810156996211920710197359298121002851763744111774723019221741197487536552137\
        441891257122655004212896724384177694268489068590218478554429805905364237124314190530761286\
        405220939632145040358782558873699401940490293184219141415291024175612265799475421066864757\
        7711010282817878917709700403886, \
        328973417267649650038984028995599137457468722662497899904226074891574791062985916069985853\
        648332298559640013389542567489103085574506879416017545403787073275584859078240305004208301\
        923778325271860697149197025050165991983366539207622870215729309525729924918778456731981704\
        929268252259716871877534659692, \
        758830907466434071959666860937945102677771418528458236060516770128040285772163826421306107\
        069853863334698116336945744601463639747199523669413845254638599625980012214050809846459478\
        559098934176586233093238956124608709775991202493060441152475782277782012828793855484827036\
        1411929636489612968071552336405, \
        445102130540832453160219335700323042686653540415728760912629486602395793920885692296415616\
        066959429176505917104809378470553959684288306437386478148216974171209001264677464825444901\
        960843306455654296724092328420267049608359359080788746300244379626829069633890752630816253\
        2758344359964169380716341098880, \
        358549244520313090430359983216591888268921826019761298865730362537580500519046229619379667\
        541757327355789565016353008061673905838974550325174736459980946329267051076739150503691661\
        371944463902665345241381162370361591943901176507049154002365951861761529140115300096870050\
        0000811854571849211562809990411, \
        438737766677756544721886069203513091775105013325653031838786046150183322957183097705704738\
        463586306953921236723237323013267328617149319214443759577999182534615674811164847392702407\
        147548571635038747744048561846525019831916866756754841548468500364830638692769954452857420\
        0393000565584191241111348915940, \
        645130850234339503642007350857138479917399859387095109454794616985938391311231126744661800\
        420543794746031491748493862132931262497139684250480230073784453843645088983023718012240528\
        683824553139343195888019854863909746543574579361265915812174560716242126991285521565613433\
        2466523138255580920562084028294, \
        103348981278117743347659685458024425851090003873328972353943876503642331864268476584622834\
        771804716540071910947628116585563492033622988994718273459748870409051443873813666778001704\
        443987702534839202423000943611973000165770624024091217695509335795498343407652970551134766\
        4434861083176910365144082745336, \
        510684705927052351679212082636107036464810921159437157458948509337412320407947949922554657\
        238580604776987667035866633761965104848956467866634135362496712791303540030856375498171483\
        831259576893709723741565585383647648004405829978866534704177730031770836216853668734789059\
        4588929931084078577444892255901]",
    );

    get_striped_random_natural_with_up_to_bits_helper(10, 1, 0, "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0]");
    get_striped_random_natural_with_up_to_bits_helper(10, 1, 1, "[0, 0, 0, 1, 0, 1, 0, 0, 0, 1]");
    get_striped_random_natural_with_up_to_bits_helper(
        10,
        1,
        10,
        "[1016, 992, 1016, 255, 0, 1, 1020, 0, 1016, 1023]",
    );
    get_striped_random_natural_with_up_to_bits_helper(
        10,
        1,
        100,
        "[316912612278197474676665499640, 1109194416875305772521657204608, \
        14860115584411442377526345726, 1248153346840921551430087606303, \
        198065872776943853719234265088, 1267650600228229401359297740927, \
        950739156735808420047682273024, 638776758039873373851420326912, \
        9864985213488985894722518976, 37718485715515157557238824959]",
    );
    get_striped_random_natural_with_up_to_bits_helper(
        10,
        1,
        1000,
        "[6227021789445427263039113655730921918572951006503066538950149639959423752662851068863842\
        846174931899135470014771225146998068867182969950386903035779357388391986981527506826577962\
        959351510323326328854575809360361506384979516224625856987797041368114938422133105481271143\
        13802727213763684707371859960, \
        418149324987486545728941348682392045128729012336127607687109371117310119731075741621132811\
        712941491708845808992563601927247951850776072839137275117758244023796842459924562393751724\
        619611544927470362694941669661324507923822529817884467037192087699059800062580597484680330\
        40558838272520165980165373952, \
        101290238602722604813770149769557584827903636411333092403947212265322573720448584292412719\
        007546084038865810128075811761725057540901084282221804825717671524392231618089092521834579\
        302971634982176370935906367582384527889995332318295053733664142471797384264691816494972562\
        2408516333805710606334, \
        613140855310127563710847637107211483373522756531352582924325324369473352782306879549961499\
        829404362274878071222125070886882784952276431978326685623926423305714969567238612410647924\
        930743503806003239444825615154756542772421562094019613522428848711219387743538927178994800\
        765564734856735165291438079, \
        100656671761770967200809514408313411282491427879094391861152015262204431791194203727185921\
        026045038825035836776620646775627513583957795766207833861462739511509698818541011638004365\
        409989389341031372058994101918102834059849507520841606970888386863725907172131052360271284\
        55992101445905914436525739998208, \
        107149228544600635260212788419695526657434400429968676165634060825808436991969085650247279\
        650596133663598434482129668133099616635115467318010721467086518060004035373781135234642383\
        205702114144671525516391055691812453033688242812694582953965743513229924054172419365064495\
        42173396641692237011907449425727, \
        107150860693727448661794856915575585277857852731679120989819290845002348669070050613296455\
        734254692011706809018756806353158106462995138380031851002523766291502961737781576247555759\
        035185454502873048780305065230433793569807065690804749332353542464565681262222119583879742\
        48405282741635132994030678311166, \
        107150835221766756970390016554040088032382955997319930334779105385220088376881426554895494\
        540316762324972302835401791427607201669829855912974990784820455466307137336628823875387612\
        135057991945407277136587896193153151600433435164863822917290693842788118252951172684773421\
        70526384435574180443755489763328, \
        259458997502575090388504772996598528946724376087674101871067524134626069164625241231590514\
        153111280709253894067065950748627250265168604059093486305290952481954858209544512531987544\
        580061950939088894276064731362781063403971101745154263948986687899279303585684102284869355\
        693627487928044157407224, \
        127717813072756195965071628365863751639879810870737425013385130468804848982545562276364724\
        641904754943259319042883222370280844399168602997515222248629586365103060904858985377224746\
        007756101627928195178193946172906161993893729193567644459857171007317377644350722620326222\
        3742148978782762923552931827]",
    );

    get_striped_random_natural_with_up_to_bits_helper(11, 10, 0, "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0]");
    get_striped_random_natural_with_up_to_bits_helper(11, 10, 1, "[0, 0, 0, 1, 0, 1, 0, 0, 0, 1]");
    get_striped_random_natural_with_up_to_bits_helper(
        11,
        10,
        10,
        "[682, 842, 668, 341, 350, 341, 338, 340, 682, 341]",
    );
    get_striped_random_natural_with_up_to_bits_helper(
        11,
        10,
        100,
        "[1063803140432100403291953916586, 739462850133133817539732346028, \
        422653360565040988003415446874, 848401573590247656481079600469, \
        422550200075885064135585999530, 419242579033418664700359912277, \
        422556546887486595830538392914, 422551811989467209878519567698, \
        422550300869175806062669146794, 845074597043259864052961293645]",
    );
    get_striped_random_natural_with_up_to_bits_helper(
        11,
        10,
        1000,
        "[3571694931298766658148597579133500396805055718890904755849421801691105675639698924085475\
        217186818671377861364341116537204961881442236045088337279057826912458138650691199761612988\
        883058581411133147888461600627501281537742872135974381226302429036852682145804929027180283\
        412215635242948169473448721083050, \
        312523503440022226256539017547297068869208682155149110042905762496761319540243094457594343\
        859089236690554960456013552907255074371626319073357480048727266774116430788333390913446465\
        619104644972187472443285017414346567664962457858577864857410322417792561934834339345113775\
        9657317068961411710233409661610, \
        865019756446950496269040354104481059118747029066357336244807909203888902108435832283590666\
        775170346004501865878924553107381908132495592609080661684475732927817570636420740556716013\
        168924877758128333222159346949341194770681937489066179441860633805186064044811420594280896\
        906074342076344282184605324666, \
        893011037585013007271439602956526972024707806627477311937832595287305307343362049808812372\
        867697432889627779970803417048478482882370003668394928455851950345620310470241544275541047\
        354242013397873563064543296718018003131524951605807454956556860189105716328731797732674596\
        4570601733436095071743763633493, \
        714337697986576114077307239016734314472779437227875536493177724277496357242071140467095878\
        368847036684840951410204114568419486398409897184525378525275704002748768137539106304824083\
        362036096433222952552023855753638427465829477635653011302870027782444701974201225532101310\
        2549204865443174861708377533098, \
        717129479744396200344184597459955775324063665344347322215427784911546292557185067124997476\
        300110608871594211005211148242437189627028361260715625731282067311558916993444457603008618\
        146383526538195175746094394556394170673628321139601154519945289775172095900192878319082649\
        5453320605634381639129320740181, \
        712943875305246933549449117163766092515737565613814773068912395757448666817082911895780847\
        326837660502284270497684787917665238088905925731656976408461765235806743263267139181463148\
        004431439157535144190810911719314309577264591245575456701925751321667869578190443322813012\
        0138648732293712628634064954698, \
        892880942227156526968373917452622274287516410008666161523034951090805186930790904719943631\
        023279485226392520031870194759074725254789440380488049235603947036487803727696933564597255\
        812777037968411285945062427246430458697274335300861633278805179074880855146539152265137509\
        2760519788829492124624878217898, \
        357191338288297448157760779693006292584925495383947130217069796802263562301019332603664015\
        518999932844210923242642143426207768942951692715733850908225274836460166873351326253496823\
        316044766823056126756948620431307852877994605207198329719827145721619069940836945855738629\
        5164803095064098046522145712854, \
        712949327932932700218621033804526985196291897563252301818755627637478824989877935042325873\
        291167136650626866176302303072095225803612799473142905508378017958979111144644566257625076\
        950893722575069628745776862688326045350363911106097574031678159885821711577125514250680212\
        9840859041388985930050461586805]",
    );
}
