// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use itertools::Itertools;
use malachite_base::num::random::random_primitive_ints;
use malachite_base::random::EXAMPLE_SEED;
use malachite_base::strings::ToDebugString;
use malachite_nz::natural::random::get_random_natural_with_up_to_bits;

fn get_random_natural_with_up_to_bits_helper(bits: u64, out: &str) {
    let mut xs = random_primitive_ints(EXAMPLE_SEED);
    let xs = (0..10)
        .map(|_| get_random_natural_with_up_to_bits(&mut xs, bits))
        .collect_vec();
    assert_eq!(xs.to_debug_string(), out);
}

#[test]
fn test_get_random_natural_with_up_to_bits() {
    get_random_natural_with_up_to_bits_helper(0, "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0]");
    get_random_natural_with_up_to_bits_helper(1, "[1, 1, 1, 1, 1, 1, 0, 0, 0, 1]");
    get_random_natural_with_up_to_bits_helper(
        10,
        "[881, 87, 93, 629, 519, 1001, 626, 360, 242, 491]",
    );
    get_random_natural_with_up_to_bits_helper(
        100,
        "[976558340558744279591984426865, 576918226645715638312116799581, \
        987622786528174742128034915847, 395023941773322845238884806258, \
        636224214690002338734404794610, 450196837879184968684924239956, \
        17435191279278630704240704430, 938596277659014096812502469654, \
        1027696177399334210658775892715, 581701596982962479138691742835]",
    );
    get_random_natural_with_up_to_bits_helper(
        1000,
        "[4514012557380051978988542783272938919466346333057205129609115504104624520707181791148145\
        116162200520751727277816528182754455803315977010218275020882256456155559081083019035440674\
        861063088574997103889275814652181065472567123951639934465326552296915719864303048134395585\
        398519592187655255240600759693169, \
        791294226283400338116725266395415668811492351726967595517985462290683501988325067570154247\
        916466497696906715377685810324362572568643782805454526919199743597748426287793605950177843\
        400312249716517544116781742042345757038219051016833597591532327578014535369800683425719501\
        1222552384008059606354106024683, \
        603141122347678493875935496567523539943016200607299929590987513666029676151877700615600993\
        558206489004992870361727816768285331691513429048943961969079262017872532249009221429690429\
        173396464673970587747514162246269540847510994058348422653339211911977412158645139435582116\
        2135683154777550054864806973191, \
        918979157591718364955430394079794967293887473404422985188351315968507884008710649189160051\
        696207222829134675903387190115731463781015558345121417040971370267174581281652951730760301\
        188537459504910504772462880811654819707300024255167639013890736171444647445349859763886702\
        2577615653562903750479807977377, \
        111572687461737740972179127690146234696555179222163314101096773967066709517655767171878309\
        714795265932483373074372766941271203848445440692041743541444071334575583048636548630780379\
        654784928883387856318877942956686828284269101285405503564398810138003378288367546849089036\
        2629609700408636676786653462721, \
        413286773410710077640550954059506107026805562717811688512596913129726887154053125829557279\
        752469778687830348241832507501233919664776614723075400864600892395358734187916168714536489\
        757500767919678475917874220709912027871114552811172256853417244447773219018909637923687746\
        5529456143060746396136193762151, \
        454168511601958351933320983927901432045386117283349784234007393248763089278975378722318492\
        098684013232277593559488367845504127870331519232198282129265452333252322596673029101245772\
        088399256264035393011101930123492624807554792057688136037363218242763429781232008094150936\
        6341078937585757961142329673259, \
        560430875586881451021986079137268355719860392640168705312566874574524151511315309194440525\
        432541907755646531766496361640227195372967955930947529029583706599432734589617900554403438\
        972135775666804402920199247213229036374355559526777099281829864834361213138370127732279617\
        7830548383897263545487627313816, \
        720065541054961972011583961812848583296488373271030088954463141993615444346538158171558470\
        943290363288119622411137484846471960195846056652355166336277311121087837341367287653275764\
        490758022824785119425052859821502269331172567569772316254052480618615748020739002109347009\
        610600157440739796313675873274, \
        512273427562960628318380020315282815848930799741471178399555982574526345205226688949997916\
        491181053881404445397402324918567816645228840962653080743185831707594741095028537692109119\
        025493945819901114069446103425248770628953196173304392551501939485956420588398992610335191\
        9613354173095778943682256245318]",
    );
}
