// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use itertools::Itertools;
use malachite_base::num::random::random_primitive_ints;
use malachite_base::random::EXAMPLE_SEED;
use malachite_base::strings::ToDebugString;
use malachite_nz::natural::random::get_random_natural_with_bits;

fn get_random_natural_with_bits_helper(bits: u64, out: &str) {
    let mut xs = random_primitive_ints(EXAMPLE_SEED);
    let xs = (0..10)
        .map(|_| get_random_natural_with_bits(&mut xs, bits))
        .collect_vec();
    assert_eq!(xs.to_debug_string(), out);
}

#[test]
fn test_get_random_natural_with_bits() {
    get_random_natural_with_bits_helper(0, "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0]");
    get_random_natural_with_bits_helper(1, "[1, 1, 1, 1, 1, 1, 1, 1, 1, 1]");
    get_random_natural_with_bits_helper(10, "[881, 599, 605, 629, 519, 1001, 626, 872, 754, 1003]");
    get_random_natural_with_bits_helper(
        100,
        "[976558340558744279591984426865, 1210743526759830339060468402269, \
        987622786528174742128034915847, 1028849241887437545987236408946, \
        636224214690002338734404794610, 1084022137993299669433275842644, \
        651260491393393331452592307118, 938596277659014096812502469654, \
        1027696177399334210658775892715, 1215526897097077179887043345523]",
    );
    get_random_natural_with_bits_helper(
        1000,
        "[9871555593311388583730668028572947972273370391584873166827867445956379776331862403614137\
        010240679811389700642404293916880391529744438580436267309669605743557526364970431150933385\
        398365619760568042866366891175418557263537757651023714048098525335447177149901286977666669\
        228734508013967448659203593727857, \
        791294226283400338116725266395415668811492351726967595517985462290683501988325067570154247\
        916466497696906715377685810324362572568643782805454526919199743597748426287793605950177843\
        400312249716517544116781742042345757038219051016833597591532327578014535369800683425719501\
        1222552384008059606354106024683, \
        603141122347678493875935496567523539943016200607299929590987513666029676151877700615600993\
        558206489004992870361727816768285331691513429048943961969079262017872532249009221429690429\
        173396464673970587747514162246269540847510994058348422653339211911977412158645139435582116\
        2135683154777550054864806973191, \
        918979157591718364955430394079794967293887473404422985188351315968507884008710649189160051\
        696207222829134675903387190115731463781015558345121417040971370267174581281652951730760301\
        188537459504910504772462880811654819707300024255167639013890736171444647445349859763886702\
        2577615653562903750479807977377, \
        647326991054871401446391652220147139977257585074930117822971968152242235080123828418477499\
        122643194996280709533149340353864776491291597713840972420179000074772311437377760180051433\
        385038047440481754027985595280436007381332471223783461841596113991149106848191431176197419\
        2844525526720830095389487497409, \
        949041077003843738114763478589507012307507968570578492234472107314902412716521187076156469\
        160317707751627684700609080913827492307622771744874629743335821135555462576657380263807543\
        487753886476772373626981873033661206968177922749550215130614548300918947578733522250796129\
        5744371969372939814739027796839, \
        989922815195092012407533508457902337326088523136116587955882587433938614841443439968917681\
        506531942296074930018264941258097700513177676253997511008000381073449050985414240650516825\
        818652374821129290720209582447241803904618161996066094314560522095909158341055892421259319\
        6555994763897951379745163707947, \
        560430875586881451021986079137268355719860392640168705312566874574524151511315309194440525\
        432541907755646531766496361640227195372967955930947529029583706599432734589617900554403438\
        972135775666804402920199247213229036374355559526777099281829864834361213138370127732279617\
        7830548383897263545487627313816, \
        607760857698629857675370920711285763610351243179869812617321508384537069997121877063755036\
        502176965392609298699890321897240768662430762687034745512362659852305512122877940314598630\
        179328920839572409651612938305899406030180626695355189902602551915007303361897784538043083\
        9825515983752933214916509907962, \
        104802773115609428879259254484528372112963320559423798212143117675970187076769475019659710\
        589902898294520178185617889833116138928807499798445230962192076044779146948376974924138017\
        275574706437699501177855375574899794972601656611168235082869924333910214914822287693744357\
        49828269999407972362285090280006]",
    );
}
