// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use itertools::Itertools;
use malachite_base::strings::ToDebugString;
use malachite_nz::integer::exhaustive::exhaustive_nonzero_integers;

#[test]
fn test_exhaustive_nonzero_integers() {
    assert_eq!(
        exhaustive_nonzero_integers()
            .take(20)
            .collect_vec()
            .to_debug_string(),
        "[1, -1, 2, -2, 3, -3, 4, -4, 5, -5, 6, -6, 7, -7, 8, -8, 9, -9, 10, -10]"
    );
}
