// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use crate::natural::arithmetic::mul::fft::{
    MPNToFFTFunc, ModData, ProfileEntry, SerializedCRTData, SerializedContext, SerializedFFTContext,
};

pub_const_crate_test_const! {CONTEXT: SerializedContext = SerializedContext {
    ffts: [
        SerializedFFTContext {
            p: 4832221662680186888,
            pinv: 4382073923139863564,
            mod_data: ModData {
                n: 1108307720798209,
                ninv: 292805461487436291,
                norm: 14,
            },
            primitive_root: 11,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                14046483040696548224,
                14041266564791292416,
                14046654607898308576,
                14048474171345687056,
                4825280988129212736,
                4823070262100768512,
                4825145705455639920,
                14048719511357028512,
                4813041419429792512,
                14047460680378998560,
                4823932171918830848,
                14048012741190537504,
                14049414971616717552,
                14040214421382992192,
                14050594040212820512,
                14048118403069104272,
                14051037750155633584,
                4826427714660192064,
                14042408583631808640,
                4815500119549053952,
                14048055777734951184,
                14044695660409383360,
                4819649398905565088,
                14045427149334620256,
                4823381304004007728,
                4815599231986874624,
                14049509440854704336,
                14047614079244213184,
                14042020442567623936,
                4823837246712104864,
                14047202918495667568,
                4824606943046356768,
                14046144365724386304,
                4826338243139809296,
                4825776016666020752,
                14041974982291700928,
                4821075954353764384,
                4818934199985439168,
                4826844709835937088,
                14045053681550184064,
                4825846602928402784,
                14048339714062651280,
                14048236519775616432,
                4813167748879223040,
                4814427186749045568,
                4801993905695418880,
                14047921481845181584,
                4800715846833548288,
                14050051937776320720,
                14047329130950929136,
                4825192028434603936,
                14033557391598349440,
                4811583918684201600,
                4826394491523750912,
                4827607900400231040,
                4815035465331248256,
                14050309097969302944,
                4826895466358131152,
                4822554631046226720,
                14036931337007205248,
                4825205012118472032,
                4825308579084571232,
                14045241352176863040,
                4810918236012237824,
                4797249783404725248,
                4827236163907204256,
                14047069118495169488,
                14049026285404870560,
                4818738903444956800,
                14045230990509550592,
                14031635412619855616,
                4827474457339444832,
                4824129028022177616,
                4823340064380744192,
                14044739687417710432,
                14045128433022754176,
                14047993490571051712,
                14045870974207516800,
                4813634929117924736,
                4825324746932035648,
                14039469803807068096,
                4820611054736759936,
                4822256754287614912,
                14021738051791665152,
                4825010562180111408,
                14048190222917392928,
                4819182008851661728,
                4826030548176723616,
                14046692545027997760,
                4819198852482536064,
                4815055146123290688,
                4820857779201672672,
                4826571770796088800,
                4824763373960046432,
                4826207330779558000,
                4815138139495074624,
                4824204430389702192,
                14049556824142364176,
                4824454081787068800,
                14049189919930928896,
                14044179955986812000,
                14046271736812641696,
                4824060318425401312,
                14050747509266926912,
                4825142450362155552,
                4816533874169214976,
                4827160896341891104,
                4820570784529409856,
                4821137938370792928,
                14049846250466738816,
                4826774199463379360,
                14030945197938521856,
                14049603588453280640,
                14043351094687337600,
                4824626990036934288,
                14031802698386156288,
                4822255187199184928,
                14048726292367537312,
                4823397034388116864,
                4826762790423412384,
                14049636050427273072,
                4819718048613067424,
                4825536657712000208,
                14048626728823809376,
                4819184994000744512,
                14045446525187476192,
                4827104583110771904,
                4818006370840631488,
                4818680646777312000,
                4827071932865285376,
                4827445384756072704,
                4817780525507956992,
                4817161839406250816,
                4824195591743519120,
                14043192498422708128,
                14051017367425719104,
                14048200105821986928,
                4825004025033499872,
                4819844802597583264,
                14047050195186803632,
                4824163142215258384,
                4824248279185254512,
                4820199679800643328,
                4823002747338444320,
                4824075640393983264,
                14038926028439106752,
                4808013985434214144,
                14049668227092583920,
                4819620504808480992,
                4824559823719753504,
                4825286829547784608,
                4810092177519262464,
                4825087873481068240,
                4823714322660276192,
                14038645532674298624,
                14040020995286578688,
                4825599849329234928,
                4813819847671611520,
                14048896310852447216,
                14045384088795470912,
                4805668865339335424,
                14048576381293985696,
                4824781826700605200,
                4822357966667501056,
                4824073675312833952,
                4824461384396031488,
                14041618821648592640,
                4820424204835760288,
                14049446565963314096,
                4825914703018903344,
                4824320050456920240,
                14047216851637180048,
                4826845605120967488,
                14046990281984208896,
                4803301096677755392,
                14048087048487187312,
                14048267125598031568,
                14049219203991515232,
                4823791154502875456,
                4824813478518749264,
                4826761756073767856,
                14045890088146478048,
                14047127224416405504,
                4825308406718036624,
                4826524740619734384,
                14039473079911134080,
                14051006953175174096,
                4822044751034231200,
                14045192674302691168,
                4821202192697375744,
                4819313830282205792,
                4824199172058020496,
                4824128930307876912,
                4815704995150873728,
                4824923227130951120,
                4822596689055455808,
                4823049360411012608,
                4819306590744902016,
                4826591080181301456,
                14049635164099591392,
                14030468778628478464,
                4827052116848378224,
                4819206832265809568,
                4825055614504367120,
                4823918165860660496,
                14042633715279387808,
                14049596467118077264,
                4825263238083522368,
                14031413503257703936,
                4815679279413013824,
                14038672289249759872,
                14038909836703556160,
                14038242927481553280,
                14047635090853167248,
                14051018802502624176,
                14042983528167630848,
                4805682748104838912,
                14039978362163436608,
                14048792868698251440,
                14034098702346825344,
                4820243268433542592,
                4819910547530873024,
                4824173475856074032,
                14048139949516686880,
                14037002837738441856,
                14035085540317849216,
                4820329208711005184,
                4818481772245505984,
                14046160799527187488,
                14037689673424876800,
                4823583889208340128,
                4826155876156847680,
                14050588077073411760,
                14043231202974999008,
                14044835822719360000,
                14050162147253726352,
                4825994224944672832,
                14036443957070478976,
                14049322393135056224,
                4827593390471561312,
                4810251343749604352,
                4825452261412231632,
                4826216935547207120,
                14045481310938361856,
                14047172324274992944,
                14049403413423105552,
                14042745788132748640,
                4822179390531901216,
                4817091570614064960,
                4817032356022110656,
                14050750681875133904,
                14044068818421252416,
                4825073596177150656,
                4821524366611283232,
                4825245299496273760,
                14048522608956380368,
                14047269914571844320,
                14026979281596195328,
                14048637741933060032,
                4812924759510915456,
                4823791571623482416,
                4819364326935767520,
                14048615469363975744,
                14048223789395992496,
                4822067875914460928,
                4812844665382721408,
                14047185591090111504,
                14048278565984707120,
                14042266618224066208,
                14046140076805973664,
                4822011185608477568,
                4821375973811010784,
                14045850264554840448,
                4825253119507244880,
                14050856228650986592,
                14039727714170773888,
                14041667864897455872,
                14050661261201644784,
                14041751979740895808,
                14046874492511972464,
                14043800344359399840,
                14048457429015702784,
                14048917430359400128,
                14042764907603421984,
                14042382814754304160,
                14029268887713520384,
                14050944396847437904,
                4815176157982052608,
                4826823196257196448,
                14045365898906697056,
                4819172934441799744,
                14045936955907546368,
                4823566126366426288,
                14050209728573336256,
                14046986837514138704,
                4814904289452726912,
                4820746400431198912,
                4820784338626452896,
                14047590789083965024,
                14050165047405310016,
                4818140992688887424,
                4815407965458868736,
                14042371101755937088,
                4820627440088072544,
                14043470953967812096,
                14049107355544595424,
                4819505155127182240,
                14046183897776881952,
                4822936423049905632,
                4823971831127090240,
                14043135196912923744,
                14049182014391677296,
                14034046123976283136,
                14046811435933691632,
                14022498559883549696,
                4824763649716131600,
                14048257837414730656,
                14034119430308336384,
                4823856510552235008,
                14043255227566739200,
                4826998889025437824,
                14046546893774345312,
                14044554777814164864,
                4820417871504712192,
                4824097658741020752,
                14048265955335196560,
                14048723582937471984,
                4811351800357217664,
                14049621229982541584,
                14048269579186701840,
                4822731413398345664,
                14048568447829647504,
                14047272161047292352,
                4825958042234336112,
                4824953413136992880,
                14049793694230404512,
                4824858220134808816,
                4825694514610506336,
                14051076155048251232,
                14047583081180249024,
                4821226398019722720,
                4815936484729315584,
                4806342673533014016,
                14035013194025497600,
                14047809908198516608,
                14040392727468692096,
                4827411667643419792,
                4814282660731462656,
                14050087885837953632,
                14044912089655399392,
                14049311980611036608,
                4816333361033769856,
                14049386058612116992,
                14042232823497699424,
                14041619273212419200,
                14047287722435667584,
                14050118733590641840,
                4823849828665473648,
                14046824244044652064,
                14047657990103172176,
                14045276687864563680,
                14047370000355839712,
                14047308608616217264,
                4827682614884533744,
                14047319421821095872,
                4815919970748835904,
                4825492136127470800,
                14047530779696310976,
                14040786623432398784,
                4825522590368690448,
                4810010342263356032,
                14049378355821000400,
                14043790937380510144,
                14042591317386920288,
                14042693356712405856,
                4826427066641869376,
                4823486517647396592,
                4816793397773071168,
                14047837490033714352,
                14049709592061729072,
                14050022679623089984,
                14050152793643129040,
                14049847128285324384,
                4819442534710903776,
                14038772444489239552,
                4821821467032183200,
                14042798754962017344,
                14041244107263114880,
                4827512962414264224,
                14047472473965405456,
                4825329610943058128,
                14049900603450083040,
                14049934082860131360,
                4814455544346235200,
                14047142381153297520,
                4826644084028141856,
                14047085174347850784,
                14034063809682956416,
                4823099380073302400,
                14012223001864626176,
                4825074551368201440,
                4824858100641346352,
                14049041245033723072,
                4822373292844632416,
                14050204891093079520,
                4815076031447749504,
                14047584520893664336,
                14040320315309779264,
                14046337944112227456,
                14047877078142909248,
                14035466038416465536,
                14050478143558961360,
                14049260042868949536,
                14037672082656803968,
                4824963523432087232,
                14049340336395875664,
                14046910530902793104,
                14045444748947415648,
                14047177271606125312,
                4821990434795555200,
                14044419518738293344,
                4819945184119759648,
                14041032232841913728,
                14048763430668217488,
                4823619084349412576,
                14042801532148048256,
                14042347407205647616,
                4825621341096362400,
                14048040123758626192,
                4824682598948631008,
                14038564188098452480,
                14050638994166165504,
                14035505984064535808,
                4823533888126971008,
                4806675099723725056,
                4817865399384972352,
                14049297014298640768,
                4824259560240576528,
                14049611781423650688,
                14029959399145138688,
                14037242542246288896,
                4825751297384132848,
                14046850998927723312,
                4826211820473417808,
                14030498426865137152,
                4814705398582830784,
                14034450775430002176,
                4823706404100106736,
                4822157538441493216,
                4823426478537610624,
                14049146411892380512,
                14044219782276401984,
                14050670223392374624,
                14051028838390376768,
                14045915779506876064,
                4823558930160020128,
                4825244377568960640,
                4807591992296692480,
                4823758301839896160,
                4826142634230447840,
                4819088486472748480,
                14042685438782441216,
                4824822936255775984,
                14031749427877780736,
                4823324524495060576,
                14049289602396136640,
                4827146294076208352,
                4816847446884583616,
                4824446731668680448,
                14043542548998325984,
                14047173703129147072,
                4824118336375205616,
                14050641862556008704,
                14047751130241162976,
                4806693690923252992,
                4827586275371484976,
                4822678311433221440,
                4826573937920286992,
                14048153007760356912,
                14049004955509556128,
                4824778240945409696,
                14036529543114140416,
                4824945237162002112,
                14050310219556371632,
                4818989118935674304,
                14049132194814866272,
                14043852533528500864,
                14046127599306224672,
                14046755170205931376,
                14038084636413186432,
                14045762785437682496,
                14046731548459908768,
                4822132427385229408,
                4822456890616758080,
                4810418936055242368,
                4822718343374728704,
                4827637059920517616,
                4819427585591130880,
                14043691531324087648,
                14037383153404967552,
                4820563762056005280,
                14050819228458052688,
                4827095853942521792,
                14045971781255204352,
                14043014250328850784,
                14039548785370054656,
                14049753755436084336,
                14044911373014465248,
                14035462916292590848,
                4822053619758865600,
                14038080494600610560,
                14048389317093962048,
                14035193936213624704,
                14050250939632282608,
                4819008650820837120,
                14036592514031676160,
                4816931626055282816,
                4813566330015433088,
                14044351404457903264,
                4825322526433315104,
                4824771951280955344,
                14038805418786009984,
                14048890978650719680,
                14050468113100330848,
                4821828605537414112,
                14047174553190971664,
                14049425161611228672,
                4823837449135753024,
                14048056088373853408,
                14045038441127697920,
                4822734584214799744,
                4825994138165977392,
                14039327426371662208,
                14047363506710856576,
                4818444698442537664,
                14031089761854012672,
                14049871459928539312,
                4824321216613372160,
                4825649307690949872,
                4796988492555425792,
                14041251693586588288,
                4821024448229029184,
                4826919181845170944,
                14048341116163477984,
                14045399563606076608,
                4817900579996075136,
                14049030473429325072,
                4825276324930707024,
                4824572232687531584,
                14050576318790848720,
                14048973466044014944,
                4821922910084220320,
                4821750207397119200,
                4825603708836400080,
                14043133702734724288,
                14035176049538710144,
                14046895249368355328,
                14043003277378234752,
                4823947386255577152,
                4824896708370961632,
                14047205499523794016,
                4821717118544614656,
                14044833001674968960,
                14038717957195825216,
                14049164410395341536,
                14048782641585623056,
                4792448378576891904,
                14050208830239565808,
                14030361909789717760,
                14048055817760640912,
                14046243174679042816,
                14050008850696821200,
                14049931393597862912,
                14048134459644229184,
                4823601079135387488,
                4820591677239373888,
                4827081636870501520,
                14050995059743268320,
                14043784197742915776,
                4825812946351759632,
                4826970763627606240,
                14030044983182958848,
                14044139643617881632,
                4824726842733191920,
                14049740409859275952,
                4827680076108604192,
                14044917199660457984,
                14034940658526484608,
                4808463339559038208,
                14045422847133900608,
                4825854603158192128,
                4818081818263350784,
                4821344529459973952,
                4813619312253060736,
                14043652839812545248,
                4827437810137513424,
                4821669099732525696,
                14039369361079539456,
                14049156464208464256,
                14048195764173334656,
                14050522863552142784,
                4824938742031900752,
                4824928488290445872,
                4814871612147637696,
                14015311739133556736,
                14041908890339829760,
                4824144497432211968,
                4818382806586852096,
                14040099449000027712,
                14042951673715602912,
                14040778137255815104,
                4825062764527490384,
                4817303522963686912,
                14050085523192606944,
                14049518587648221616,
                4827670732149058192,
                4823145697700376000,
                14044260934986973664,
                14049696201554602640,
                14048108127626746032,
                4826179626828927232,
                14025411070459712512,
                14043126295386998272,
                14042215012924440576,
                4817138123172843072,
                14039659159559786624,
                4827465257896231840,
                14048700151011937152,
                14044145462090976832,
                14044240267743751168,
                14051014947497155792,
                4825792464940578096,
                14045429016722256896,
                4820419454094284960,
                4816881735781510912,
                14040636933071128448,
                14042687405981482496,
                14031602415484818432,
                14043159942599446208,
                4823680538966477888,
                4826944835012779808,
                4826603141001502816,
                4826478223155301520,
                14048128849987772736,
                4822322466570815616,
                14049218559407890512,
                14047304711675162112,
                14042094920924952256,
                4817824202519944000,
                4825189996172164608,
                4818421383587950080,
                4823833599386250000,
                4816562725450519104,
                14034691421119442432,
                4824993328069840064,
                14043245000696696352,
                4797625995430700032,
                14048526673318310592,
                4824286505259134480,
                14042053994169972480,
                4812300173882833152,
                4827082155612445760,
                14049381679719453920,
                14049274138105394912,
                14044913171158146112,
                14050373527917723984,
                14048316983198268272,
                4817876332410355840,
                14049032695401610784,
                14050097281675712128,
                4821460861520460672,
                4823737627459473552,
                4823982265570123936,
                4820056428764819712,
                14049353536247509456,
                14050472218798172352,
                4826755432408624016,
                4824803968710798544,
                4820031489267798592,
                4821967137830257824,
                4825015224569409792,
                4824838961161096688,
                4825800065348432656,
                14049952585096929616,
                4827104314850334688,
                14042705266240876928,
                4819926754454714560,
                4824018972128983168,
                14050795241954013984,
                4805014905477674496,
                14050038971813359200,
                4822044814930407040,
                4820411605327367744,
                14049688902799295104,
                4819142804284420768,
                4825886917665679248,
                14048747937899510416,
                14042037124403658304,
                14049176071280358352,
                14044055017356814816,
                4825469840564567632,
                4824905342407590544,
                4818504074420354816,
                4815458176558902464,
                4815188453051336448,
                14036807263994892160,
                4827498343826201664,
                14049119379953410128,
                4823302775604405376,
                14043016715203301664,
                4827495641790033104,
                4823363857277762688,
                14038033438167736064,
                4814847157876722496,
                4814251124741317248,
                4819195415170804448,
                14050528980015152576,
                4825411202855366608,
                14047125621080780672,
                14047959588196616240,
                4825051940528699280,
                14050521634850489216,
                14050017475456693200,
                4820379686704611264,
                14035910600422123136,
                14047326493300457424,
                14050571215156938256,
                4823652418888649696,
                14050417988381761264,
                4820387977337772736,
                4818314072083754240,
                14051017487741226912,
                14037050973462570112,
                4823704255755433136,
                14049427498142413264,
                14040878793519066496,
                4824929473640154320,
                14047664547066175872,
                4818037308111769600,
                4826743500546108048,
                14044957773744784448,
                4810005278012207744,
                4823919620547018928,
                4820321268535672416,
                4818908408295628128,
                14043313622182274368,
                14044813162330105760,
                4813160655793087872,
                4823385822014157392,
                14046760915264564288,
                4823786982390816112,
                4827296165539996304,
                4823642076546874576,
                14042724646872466528,
                14048553575357552560,
                14047780490992593744,
                14046445349514871488,
                14047521390871206144,
                4820418130056209440,
                4826057571897478464,
                14038613586342552960,
                4818400212677276096,
                4826763177360602672,
                14047467554376226640,
                14048174401070517808,
                14044467821834138496,
                14042917213813070048,
                4823973937344713312,
                4824802598723866432,
                4810374765008782848,
                4823313025639697728,
                14047663970055997744,
                14042087037471012800,
                4820438914229217856,
                14049376909377142672,
                14033903211948548224,
                4825987015351910048,
                14041826251995452288,
                14034672944557374464,
                4806721659360261632,
                4823504542259255104,
                14049386929894760304,
                14042167594739367872,
                4819735892051179072,
                4826234150372706352,
                4825635028466205696,
                4825682256751671408,
                4826055702446774672,
                4821388320759786848,
                4821631503468549312,
                4821239842242658848,
                14044068914730140320,
                14048039872714796704,
                14047720135151209552,
                14043322227654425504,
                4825120915116238928,
                4824561218852411520,
                4799089433073063936,
                14041671799794458944,
                14045470044109872608,
                4819833243804254816,
                14050818584461557184,
                14011000164004884480,
                4821574614677297728,
                4818409231908242944,
                14047772101476957008,
                14028656681432691712,
                4826369189318387600,
                4826047476251163104,
                4826626888858870256,
                4827179954026736880,
                14044775829680114976,
                14044398407826933440,
                4814560448369338496,
                4819574707907834176,
                14050221278744849424,
                14050489287540949120,
                14047444516093491344,
                14050910635606165344,
                14047856588118826768,
                14050830839860001552,
                4821056253933807904,
                4822526238105877088,
                4823136705466425216,
                4824598052275447584,
                14046721130553494464,
                14030105928680120064,
                14050129392130375760,
                14048399179017431104,
                4822062910989996128,
                14045832027205446304,
                4827426182310374864,
                4826803922508817136,
                4824725648271379040,
                14034047469209378176,
                14031946455468987136,
                14040993140600164736,
                14043883714586794240,
                14049753207724580032,
                14040274828053123904,
                14038075165461151488,
                14048394431476414240,
                4819914078759153664,
                14048700303594925936,
                14048319457910827600,
                14031159189659777792,
                4810951811591987584,
                14047736580788544352,
                14050220993756874384,
                14047994611929683824,
                4812993739683130880,
                14050612673831094928,
                4823077962950726880,
                14049324931122414224,
                4807056624159824128,
                4822181562188094144,
                14049500243183956304,
                4825066038008814960,
                4821520350432733632,
                4826360018397011440,
                14033543939808361344,
                4826441453874137008,
                14049470627390374496,
                4823491673007346512,
                14049306039481578160,
                14049318778861924688,
                14049433456593114432,
                4815193853112816128,
                4824208031904870272,
                4822978959369136000,
                14050129686200503776,
                14048301535758838144,
                4824038246796583168,
                14019990247193713664,
                14047173327800554336,
                4827005370443939232,
                4819059803056283136,
                14050985684827130912,
                14049692948841202048,
                14038741239917574400,
                4823981374889807680,
                14042558626126699168,
                14040184482525000000,
                4824731944975032352,
                14047108356132470864,
                14049050995698017840,
                4822353234150518592,
                4826298778478247248,
                4827074656938274112,
                14040027358764133888,
                4809399905530755072,
                14048245229180783072,
                4824278461063835232,
                4818264080879098624,
                14042573514164921184,
                14046780630583738992,
                14048342525722425392,
                4817603500973679680,
                4819355347407624384,
                14032021090460038400,
                4824782255042232384,
                14045389521665389504,
                14024409243401035776,
                4823739530006398416,
                4827190975852845184,
                14050460958769218208,
                14047972934133372160,
                14043237056584784160,
                14045246492667673408,
                14048248890478175024,
                4824033266785191440,
                14041306932511527680,
                4824201948414407648,
                14035746306137014784,
                4826608797457487136,
                4825804477667002240,
                14043458486220994944,
                14039931440313117440,
                4825680090629775552,
                14038874845851296512,
                4827633008316686240,
                14049708630484377120,
                4825969499993660960,
                4827670181244286672,
                14046073782105463360,
                14032244290825528576,
                4820333566335309088,
                14001185667743121408,
                4826877747219171088,
                4810503667078950528,
                4815969264516539712,
                14046872477003629472,
                14050474979328471360,
                4823938516431877552,
                4822696416038111904,
                4825330112667078304,
                4817726654421807424,
                14049534591293289408,
                4819622695209296288,
                14036484605168766336,
                14040477302657828672,
                4827238155886872208,
                14047555417981665392,
                4823724132021569344,
                14050451441238069248,
                14043073339329737536,
                14043085447748119520,
                4822810482732216384,
                4811736601657569920,
                14040312215997210816,
                14043598447053454176,
                14045110381196836064,
                14046819728878511344,
                4823802266536485248,
                4823865206430002048,
                14049996697967239248,
                14044341517830000928,
                14049724357239109920,
                4820791278730805472,
                4825197387206310000,
                4825827918262292960,
                14044132766436536544,
                14041268228672924032,
                14047201944379888240,
                14032735196274474752,
                4809112834775911936,
                4818003131852559040,
                4802243099366344704,
                14050182649627319328,
                14047909231480107088,
                4812137897655606784,
                14049705564967831168,
                14033976512708240896,
                14027931435200795648,
                4824337775157688944,
                4821357004530333184,
                14048717017850817536,
                14048728071702574160,
                4827670279212212256,
                4824166125754012000,
                4822765038570455968,
                14037244243850448384,
                4803066520386499072,
                14042263836442361600,
                4796999112019733504,
                14046089892588727136,
                4825179684649838944,
                4823500156715498032,
                14048848520911285376,
                4818161119440225728,
                4822495930307914208,
                4826439904916876544,
                4827100542241410544,
                14050741909833905152,
                14050347714602958160,
                4822430311858673856,
                14025262676021335552,
                4824211547973375648,
                14050974329678990624,
                14042676524287139040,
                4817472113258527424,
                14047610723732217488,
                14049946287408552704,
                4803674739935610368,
                4826087269076794352,
                4823267877903293472,
                4824223373330637536,
                4801118048153637888,
                4816149158066276800,
                14049850220279978576,
                14047638012785179888,
                4827670034037597360,
                4808599677359184384,
                4825199449878897232,
                14050497912851002416,
                14041591445852857088,
                4820637808789058688,
                4811178381842720640,
                14044426604533850592,
                14048055342465439344,
                4827641084103665792,
                4823634593854848704,
                4827135429311388656,
                4811421929041603072,
                4824264860205137088,
                14049235855245066656,
                4809994195048449792,
                4812398687601299200,
                4799737892864008192,
                4812639104270494336,
                4821783757551691904,
                4823762185457199696,
                14049391731391316272,
                14043795866412463072,
                4819163028129517024,
                4826311011295981904,
                14048864487497926672,
                4814216756732007168,
                14045091618957046176,
                4820679856320506528,
                14042133889935211136,
                4804794786083888640,
                14049247742810533296,
                14033200741560652288,
                14045367357496828544,
                14043088686934028256,
                14043594812964895840,
                14041441548351936128,
                4823459811836453168,
                14042586208531821408,
                4826111767986921904,
                14047777047226615312,
                4818990093768923616,
                14040054768560402240,
                14046476804754734560,
                14043510144205915616,
                4819940633648600928,
                4823753316141818048,
                14050881073941911744,
                4824885911148528304,
                14046698637174888160,
                14047458767313100800,
                4806398597017638656,
                4813942231709614592,
                4824232339651744880,
                14048730126332423680,
                4818714442459357824,
                14049366445346794016,
                4826312939247337696,
                14048006279033415440,
                14042782612048154592,
                14048740776264692208,
                14042881147351247296,
                14042065059306533760,
                4824096451484427520,
                14050610853646856784,
                14048397085743005952,
                4813789006044855296,
                4821801979214705824,
                14043520699521108992,
                4802840056561442304,
                4823864102796060576,
                4823525999223474000,
                4824706085613404320,
                4820295627894130080,
                4823544168582647904,
                4804994324847129600,
                14043494716301654336,
                4821997976030029024,
                14047881418499838864,
                14049388816561862624,
                4825922794789602800,
                14046012998850089856,
                14038799663733567232,
                14048053782188155056,
                14050968423657705712,
                14047423957593545168,
                4820943035580785376,
                4826980164489391808,
                14045044462552138496,
                4812702268248144512,
                4821826116850782496,
                14042649674563675360,
                14047887038785699920,
                4825847111692139040,
                4825083159516926544,
                14050282990916501840,
                14047371306406156496,
                4813624770547960448,
                14041107897071280064,
                4818179172666332032,
                4806607923258368256,
                14047972280383725456,
                14047710483752884880,
                4825566470899741280,
                4827633472773783312,
                14048895436467717776,
                4826526829160628560,
                14047821533715008400,
                4826356385626289264,
                4818623174480530944,
                4820126229807775296,
                4816559678143028352,
                4826763985400077600,
                14048591364024177664,
                4824736719850303744,
                14048281471776530400,
                4815193594621049408,
                14029521606013841408,
                14046942316399706224,
                14049141353658527552,
                14048790086622898752,
                14043365918462265920,
                14035295414311566848,
                4825513921554817664,
                4825769449850664080,
                14035287333485237632,
                14039068086671078272,
                4823804547424765136,
                4823648732167960784,
                14031442911559868928,
                4796686174254595072,
                4814678091057292928,
                14048307304165791136,
                4818885944091279936,
                4827404505191560288,
                4811071555081036032,
                4821483615965647360,
                4824590594527788928,
                4823492577593275104,
                4824474008253487152,
                4821850323476073984,
                4817773315630970752,
                14048305156564457984,
                14050699803713024544,
                14045885427511678752,
                14042798892269549728,
                4822115307729688448,
                14045145185572353024,
                14047929644166078320,
                14050114217549470640,
                4823389360071748304,
                4825285574720321392,
                4824059602368387536,
                14048566002654176976,
                14048142872528450400,
                4826379947123452064,
                14047550402831225648,
                4826313022610942096,
                14038574554613437248,
                14017387027466635264,
                14045938320822787712,
                14046924477127197904,
                4820543124300843328,
                4826984292151300880,
                4820780794260132832,
                4820311018256293600,
                4821088497043329920,
                14031285923684652288,
                14050208023762320720,
                4823154468781830496,
                14024221014024868864,
                4827545810710818544,
                4803770425606217728,
                4815833483577915328,
                14047948581737379344,
                14035830390547190784,
                4826536315839360752,
                4820373725338630752,
                4823793970031509152,
                4820612029768570976,
                4807861656405345536,
                4825785990719501568,
                4823931299084811600,
                4826487899239145904,
                4824929895976138192,
                4823687050699006352,
                14035270889360028416,
                4817085968707752192,
                14047221565498090064,
                4827608698755319856,
                14022965825106377728,
                4826023156446274000,
                4822774230966204640,
                4826662755377551888,
                14045246278306345504,
                14045210904717919680,
                14050255574983527728,
                4819753640331101632,
                4817379519334513152,
                14044090049767361344,
                14048182622205039440,
                4823988193033827344,
                4826097815083829792,
                14042726040813921536,
                14049672100162419040,
                14034763801898471552,
                4812792188198274048,
                4826961330126910000,
                4822540034503062848,
                4820897453194200320,
                14048772375141864976,
                14049181354669862912,
                14050759248192090848,
                14042834203342692544,
                4819669466011728768,
                4816083940476311808,
                14048499021916310880,
                4808405822684878080,
                4824984268712939808,
                4824118205980250352,
                14050668975253147040,
                14048707224589576464,
                4827183255647135648,
                4826151874233119008,
                14046983094248641696,
                14049301561251323280,
                4818115213590563584,
                14044673444400616992,
                14047443406712906304,
                14031027101722540800,
                4824097134306830640,
                14031316359760125184,
                14046891485875874064,
                14047220734626503520,
                4821102982322572000,
                14041247686193285440,
                14047011331989882624,
                4822142354097115840,
                4826338805104120080,
                4825404623007600288,
                4822459353770083424,
                4808020038486670080,
                14050974077795101984,
                14046790294847422416,
                14049249972180910768,
                14047241068169001024,
                14050543760247434784,
                4816902829497605504,
                4805751018085177088,
                4823948647611760176,
                4827394871616739472,
                14049674043206788736,
                4825810122965890496,
                4819911126381611136,
                4815925995176838720,
                4823371458677150352,
                14042717089041157536,
                14032455400918530048,
                4827411287266581296,
                4820652585886907232,
                4825077981930103536,
                4819555259465834080,
                14040875238305174784,
                4817766492375635072,
                4822669011838381696,
                4827466219917713328,
                4827048618674559392,
                4824897529043500592,
                4824874891956432880,
                4824200863393844464,
                14040308079211922304,
                4818370054817360832,
                14042519095379283264,
                4816653920016617472,
                14043663008969520032,
                4823511258765714320,
                14039392752081414208,
                4826036898486457840,
                4825402200590193440,
                14027938839169893888,
                4823728344907461936,
                14045664793858061920,
                14038107196253930048,
                4815301754434298688,
                4825258778408648688,
                14045857112140246080,
                14043390724342676544,
                4815849137218845696,
                4826649084435575456,
                4805958791929560832,
                14048537968184792592,
                14049091228753016912,
                14036186466028463744,
                14039261025174243904,
                4826319658239455152,
                4820065375866440416,
                14047371851533913408,
                4826106825619478128,
                14048013833904203760,
                4826035994409429280,
                14015058383664095232,
                14043838777961254528,
                4824202454094419232,
                14048351032218719888,
                14046198107125211232,
                4816121044939971328,
                14049226478982094880,
                4814848534768442688,
                14038520142436121472,
                14038246757609779968,
                4826476906199083168,
                4809462203309062656,
                14047161664700644032,
                4823376409147757712,
                14046607631393091904,
                4823242148841808416,
                14044824267096326048,
                4822786214030842400,
                4827418661768953936,
                14049422066138325600,
                4814964056013024448,
                14043383934020347520,
                14047864846296047472,
                14043513789210561856,
                4820026682781140288,
                14030960717774562816,
                4811873976512967936,
                14045044059703654624,
                4823527423684777584,
                14047528149116157872,
                4823835791738285472,
                4823896730670086000,
                14049469981769096080,
                14047832717898471024,
                4825369438676787488,
                4827191782322799008,
                4825057605352803264,
                4820756585569507040,
                4808084823852582144,
                14045051186973999008,
                14047145195118349104,
                14036643925099944448,
                4814941830252912000,
                14050973286917179088,
                14042685647050006304,
                14039065486163422464,
                4821855905304276000,
                14049924940458569888,
                4825952151283509504,
                14042961181224440448,
                4804605176609667072,
                14049913132331992832,
                4824827504858597456,
                4822773597922257984,
                14040026980928625216,
                4826779941577806976,
                4815960767651894720,
                14036631522244737920,
                14039093758150116096,
                14050549914943705984,
                14051001522018262064,
                14040313834729597184,
                14048640518487531040,
                4824010406447783472,
                14048797096208923088,
                4827168991544262768,
                4821583906004469760,
                14030744967826738176,
                14049394615343466864,
                14045782442650237664,
                4825099293470491120,
                4818957323014426752,
                14038630476874445568,
                4826603945834925680,
                4826131358529539744,
                14048236112110473024,
                14051035493720566448,
                4814630088838820224,
                4820989018267810976,
                14048246886449846912,
                4826471765553943744,
                14040209684948417984,
                14048587924311158400,
                4811772396496130816,
                14038200391603697024,
                14046633568261573248,
                4822092685938815168,
                4824621315641089520,
                14047214195608651968,
                4819010212900246592,
                4809127000458138368,
                4816728096965108352,
                4821412288747976320,
                14043488377933560448,
                4823733951057920928,
                14050089753909609680,
                4822838457933772896,
                4822803359764372448,
                4819941737103643904,
                4823747831448535184,
                4827504327015385024,
                14051051056718676672,
                4824658099726637744,
                4825411260933834960,
                4823043002615955616,
                14048910447521457632,
                4811059987606457984,
                14049685749077831520,
                14048603028352395952,
                4824144463675470288,
                4827642918647245552,
                14041182725316451008,
                14043226584804013856,
                4824376221296616048,
                4824143174738645744,
                4819544534746024288,
                4819357397217110432,
                4821475286766059200,
                14051082127157782208,
                4822856974009252576,
                4817648785063775488,
                14043881878702764224,
                14041782930361304256,
                4823512157551936768,
                14022263306753145856,
                4826711052921488784,
                4819230706615873056,
                14047975792163191008,
                4811307173663393664,
                14048415312568857584,
                14031965883123745792,
                4826855737456213168,
                4808721559732013568,
                4824860569998859408,
                14045602767638314912,
                4822539963520467360,
                4823281430241485248,
                4814075181149041408,
                14027415616102775808,
                4816630093244011520,
                4817327204481828224,
                14042632846383276736,
                4827298496948764736,
                4824216370439993664,
                4824875883070530864,
                14051056959248631920,
                4827708255740512400,
                14047390629272803008,
                4824106277282720656,
                14041731834229461056,
                14046868792931710064,
                4820199782790721888,
                14039141845818192064,
                4821697901999706528,
                4826323686207068864,
                4820217808752684736,
                14038098233776185664,
                4827630130636869408,
                4827448787185918544,
                4821686207487274208,
                14039533057964429120,
                4822772496609909696,
                14045588520227685824,
                4815382937617482304,
                4827658186492441664,
                14033455317055026432,
                14043062359825904736,
                14050602729445589840,
                14046576125365225728,
                14050140227265044048,
                4821762868503691136,
                14038055881211665664,
                14045374949720539104,
                14048805945577493936,
                14046602041622258912,
                14049220179107149040,
                4825794462053744032,
                4822937066223620096,
                4826103508198147392,
                4816628568434180864,
                14040012361554649600,
                4823389924688200752,
                4822799382082689600,
                4820433380855794592,
                4823428114210331216,
                14044965541929404992,
                4826445539118309840,
                4819727460073753632,
                14017380542168121344,
                14050542271589125024,
                14035631237608591488,
                4818306784191398016,
                14048677121080367984,
                4826633669332172336,
                14042358042698410624,
                14038281643458277952,
                4801883021905472512,
                4825729462398887408,
                14047742637522574944,
                4825684679274142608,
                4825326523302221568,
                4821931566862920928,
                14046925427475931968,
                4822622403057852256,
                4824008119366823968,
                4825412246870318496,
                4814443743652895872,
                14045570833795369760,
                14036531238324141952,
                4827540081414505600,
                14047571202954087312,
                14045816147737524672,
                14046020380372169312,
                4826644568044572352,
                14035501766537650688,
                14050162292280528352,
                4823549234826249264,
                14049116307292674608,
                4817908452864409216,
                4819538173329123424,
                4807334874615023104,
                14047278227632520080,
                14050289513387397808,
                4813757782267819520,
                4820740961289909312,
                14047555562635806992,
                14049350418844801744,
                14048109124623256864,
                4825353928764013744,
                14045323485318942208,
                4823124540316155968,
                4826945668128171280,
                4812600737105759616,
                14048087404177149440,
                4821835838770093824,
                14046833059605891984,
                14044258118020022624,
                14049870430866339824,
                4816128397606519168,
                4817398809169279296,
                14044470459828437824,
                4823295078466394912,
                14038953643923701120,
                14045511321756949312,
                4822636253160679488,
                14048945516375699504,
                4820845912369012160,
                4820253679365997824,
                14040939353509877248,
                14048884198746175328,
                4818949865824361920,
                14041209950309868672,
                14044719304210324480,
                4826777336089560928,
                14043481839483825152,
                4823821105684543344,
                4822783255043803904,
                14049281732649294112,
                4825248220119865344,
                4821333000366636672,
                4823881024519973504,
                4824913348784392592,
                4818259024263396800,
                14032450027187251712,
                14046898721463804624,
                4824299014303891648,
                4821675762816370944,
                14040144928351822784,
                14044073059975003744,
                4826456315736606336,
                4814765110873584960,
                14042341214254781856,
                4825119399469174640,
                4819306516110165728,
                4823816956272018240,
                14047804251838868112,
                4825986531739597584,
                4817786160319507008,
                4824867828566145408,
                14050880528513780384,
                14043917704907488192,
                14036130547913246080,
                4822752087190713664,
                4827700593398496192,
                4819395347940782528,
                4816389306831085696,
                14046779516268288656,
                4819237370757801248,
                4800804938021174272,
                14021563430131771392,
                4825427096657175504,
                4823502588867530832,
                4818609538104890112,
                4825769672844657456,
                4826256650008051200,
                4810852091300554496,
                14050610256335269904,
                4826795460142347152,
                14041247008925071872,
                14036220111299612928,
                14048303144863796144,
                4813598234548998144,
                4819963595741132640,
                14048295403856279360,
                4827451367021476512,
                14048783298885132032,
                14047454131434375184,
                14043315376803241088,
                4823618581136908352,
                14049607457175579696,
                4819406522244055520,
                4826742818956699152,
                4826698289508748352,
                4814501787864231488,
                14043573233526010656,
                14039917697807371136,
                4824135265879415936,
                14049660427355387152,
                4794445503981279232,
                14050723597514702832,
                4815768972598708608,
                14047732750054641952,
                4820415654805654176,
                4817206566278107904,
                14045272609101309248,
                4823715358250807328,
                4825536955963543408,
                14044509227807849568,
                14047569418033310480,
                14047787329280058480,
                4824985852951599376,
                4825562841097208784,
                14050916608157128528,
                4818400025255088256,
                4823456282262852688,
                4811105345790366720,
                4811584187347914368,
                14031811081013298432,
                4818769723044596992,
                4820460926610461664,
                4815848166012674944,
                4820275576080913664,
                14050873393436755600,
                4824425879580314144,
                4824372893567186256,
                14047251161746509632,
                14044115041160724768,
                4823373125817114352,
                14049020671407397968,
                4793387164187516928,
                4824700864388409568,
                4819469392294336320,
                4813861749344003712,
                14049355181746156016,
                14038671019862213184,
                4799453382307109888,
                14047473053284071376,
                14035074230730264704,
                4789441156622323712,
                14049750095640513424,
                14028766377577940736,
                14044362760215333120,
                14048811573425986848,
                4825496545540172768,
                4818576125127002816,
                14002317238196781056,
                14038691195772444864,
                14048069196267150368,
                4822082814895215904,
                4815803962309064064,
                14027339280850575360,
                4827135305534509968,
                4814818124101868032,
                4813345373256541824,
                4817638647746724096,
                4824373030474564128,
                4825648653439495664,
                14049345770806273232,
                14049243472281443264,
                4827145263229278576,
                14049415116506242736,
                4825623018156637312,
                14049952156943357792,
                4825949819055276464,
                14039942214431684672,
                14047552189685927520,
                14049084433484129536,
                14033341594490121216,
                4827010506476908640,
                4818630732592711360,
                14049121257479556192,
                14047006154293683296,
                14048042991193559920,
                4826073845437503248,
                4826685808269654720,
                4818829496363635264,
                14050114020472834128,
                4826462260087830016,
                14049535119760430368,
                4825546559926265488,
                4824746670337213968,
                4817523703688575104,
                4827259814437917248,
                14042747410057185984,
                4826245894705949328,
                4819833622760730432,
                14048506405753240544,
                14045152059638856576,
                4826503398883375040,
                14049807727116798496,
                14050402678886026240,
                4818933267441513760,
                14042201592086615808,
                14046054339890160224,
                14047596103326278896,
                4826476310251226704,
                14045015639041745504,
                4805512153501563136,
                4818944150914046240,
                14047536185839953536,
                4814018051555214720,
                14045569331692669888,
                14031923946096272896,
                4822744718018811264,
                4813041749200906624,
                4823739002983875712,
                14050416099789506240,
                4812532390170866048,
                14044018607668059616,
                4812594222363244416,
                4824533827419506512,
                14047945508894542128,
                4825160357465678816,
                14044850966048374560,
                4821732301126715584,
                14048781142659208512,
                14045295458759605472,
                14045747937482891776,
                14049875747390274144,
                4826263784714438848,
                14045419806793099168,
                4816847734945561984,
                14050471988211152064,
                14034027783913372544,
                4811039969273479424,
                4826061620360441520,
                4826020893728525728,
                14050695307263748944,
                14040210327260752384,
                14046066411706034592,
                14048986597260644608,
                14048680064231740496,
                14034068088366424448,
                4815880263468846592,
                14050380068302458048,
                14050712827672616992,
                14041514622421967872,
                4811808016357075328,
                4821053480822345824,
                4822084757716810176,
                14034595235122872576,
                4823335848888561216,
                14046309064205824608,
                4827192738319963904,
                4815965535827510656,
                14047161583949895072,
                4825152738562587808,
                14049524903595168592,
                4807520680282924544,
                14014952280814137344,
                4819937128696271040,
                4819690794432981504,
                14044951262803899648,
                14050536497208329328,
                14050726497683702000,
                14047157075416915568,
                14050344951798916752,
                4821294569716946336,
                4826498010776526784,
                4810410287348127872,
                14050360672171799008,
                14050276586573855856,
                14049070813262950160,
                4822104404044246720,
                14041285704916763968,
                4814510634132239616,
                14048840496894155136,
                4817115272425660672,
                4826029144080926624,
                14050516695415704000,
                4813788770163077120,
                4811712358643152384,
                4822003623490960224,
                4826349453877262400,
                14020896018135100416,
                14050264276156357936,
                14042442432518723392,
                4821177593899727392,
                14048235998661582960,
                4823046834486961216,
                4802090634954478080,
                4823234803757015456,
                4823359912584577248,
                4798138492814368768,
                14037705807159493632,
                14040634568070943360,
                14048793475402835872,
                14047495603926305968,
                4825973246811017728,
                14029372530558797312,
                4827538921072190544,
                4815697206367026560,
                4825816215435880448,
                14042516384431609856,
                14048458169513524240,
                4826538547916483168,
                14045759692194711200,
                4823356392169040144,
                4826154477102249440,
                4814700885952551552,
                4826252183308865776,
                4824974757520155360,
                14048190175174438496,
                14046780224363057888,
                4824752379951631632,
                4824273186611894928,
                14048331081068352368,
                4811220580560222848,
                14042272568235610752,
                14042424494305154848,
                14032608611505335296,
                4824025893487889680,
                4824027966548269088,
                4823590363937651008,
                4814356610060848512,
                4826838467660879440,
                14044721877138426976,
                14043470233755728832,
                14049774152821533648,
                14040265088001192320,
                14047879387366574048,
                14050614733786296464,
                14050212279612829968,
                4826312285210207712,
                4823700262216313488,
                14033586002042470272,
                4802541170718196224,
                4813907315216517376,
                14035910052010553728,
                4825800464099422112,
                4820969367225557760,
                14049038840578138752,
                14049900830371037584,
                4823901587034998032,
                14048293997006090656,
                4824182657273064800,
                4823741987730466064,
                14044992982005551872,
                4823971155694406496,
                4824012131354625936,
                4810419183559103104,
                14039232665577073920,
                4823503002216754320,
                14048479922122598464,
                14045821635095769824,
                14032619406190974976,
                4826263072035324768,
                4825908837174979584,
                4824730955112305728,
                4823300671091514016,
                14049749821391910448,
                4827419749602629664,
                14043579820283284480,
                4820173794904810752,
                4824746101078912880,
                14048347833062625456,
                4823630418979936752,
                14032149438537020672,
                4816490517680249152,
                4823710088697930928,
                14037226153989010048,
                4802851431372572160,
                14050295528836265168,
                14026534686342483968,
                4823972278471873904,
                14048831944521334912,
                4823417418211768608,
                14038631889625598080,
                4824264453434680192,
                4827657067963844064,
                14049789466880124192,
                14050953137808377712,
                14038701017207764224,
                14044652475405505088,
                14050203842233181472,
                14025668692392048640,
                14047917883741893120,
                4825378123742632256,
                4819760767486964480,
                4819637858563459552,
                14042289796141181152,
                4822726670269952192,
                14047800645053939056,
                14045752520235844864,
                14031493106082523648,
                4825502782200421728,
                14046858860010065872,
                4818326939641915200,
                14050180241097002688,
                4823528937802000000,
                14047884438794068640,
                4820556805226138560,
                14042920202783121440,
                4809119854597300992,
                14043107100923736992,
                14050197377518432128,
                4813144646356519680,
                14039157615251800640,
                4820739080255024224,
                14038530291968152704,
                4817109036695824832,
                4810269873700408192,
                4826374684931792224,
                4817981061335538688,
                4825609053903741808,
                14037951083207326784,
                4821246643305950592,
                4823998090620773872,
                4825628602898931552,
                4814358593247632768,
                14047233835690411136,
                14042671400751724288,
                4824984488789790192,
                4827641642617006720,
                4814595523582769856,
                14041621114572618240,
                4822715435316322784,
                4821281605523032800,
                4824981848572901328,
                14049628629421054448,
                4825117417531266176,
                4826828645496426080,
                4810521467321621888,
                4801772399391783424,
                14046195818203651680,
                14048173351184043680,
                14040075043384437952,
                14034535372035786240,
                14037913214565410048,
                14050613723821736016,
                14047938634625013504,
                14043623817771747616,
                4811112362530416896,
                4817290454357732864,
                14047083115582902832,
                14048271140227889840,
                4808090717497775104,
                4827387335383872992,
                14045501921018674656,
                14045825954815159392,
                14047154605124648896,
                4823410539906505200,
                4826164532708620224,
                4823734664880947200,
                4826171033707836768,
                4824788422668330048,
                14047514839978030048,
                14049417132519270272,
                4826140779517619504,
                14049855918019013904,
                4819371684235387584,
                4826219031919154640,
                14045783381604152896,
                4811333879680225792,
                4825623414536728736,
                4825032680706994608,
                14048998262597218640,
                14041631406053670848,
                4814866568511247872,
                14035959184549976832,
                14051075047855447584,
                4826457870499446768,
                14049415331188041424,
                4814151555245021952,
                14043745520358470976,
                4823986348588245488,
                14043305856018952960,
                14040454147282728448,
                14035536714113912064,
                14027874297207997952,
                14047733285989575024,
                14038152840867900864,
                4825529851820564160,
                14028413230963145216,
                4812190226581242112,
                4816268091817225664,
                14030328950209231616,
                4822172364975014240,
                4826081343803695520,
                14050972247282182032,
                4821498934439557248,
                14044636428436912448,
                14042626498947446112,
                14047352162255241760,
                14047706225166302256,
                14049234248672795568,
                14048036411601144960,
                4822851661565697440,
                14048222720729285440,
                14045547016399182688,
                4824012405606903120,
                14049548482211983232,
                4806786551763581440,
                4820100274329244288,
                14048887797359332288,
                4826869046890293072,
                4826035734992846032,
                4825550577096920848,
                4819552821142361440,
                14050264143699670816,
                14050299240317652864,
                14032787871273484288,
                14029310519282707968,
                14029772401589264640,
                14036857108884439808,
                14042685422861408384,
                4826671868544077408,
                4824393569072236048,
                4827433708726031328,
                14047445532620181328,
                4824617460995290000,
                14048421672400906032,
                4824275415644965984,
                4818106584495411584,
                4811038908479089024,
                14046976420087815072,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4828632856727126024,
            pinv: 4385184981168167747,
            mod_data: ModData {
                n: 659706976665601,
                ninv: 13035699145421368753,
                norm: 14,
            },
            primitive_root: 11,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                14022680714634054656,
                4820712691211757408,
                4819249779558219328,
                4814848747229190976,
                14022729685023594496,
                4819165647952025408,
                14042771579763669792,
                14042347485588792416,
                4810322147605490176,
                4819746801432125088,
                14045876426525876800,
                14045422124162931744,
                4822911455828147456,
                14040501214504649280,
                4818246507580775360,
                14038295065953428160,
                4821876636497526944,
                14046070764013118464,
                14035753502278090368,
                14038717782756693184,
                4815949059311277952,
                4822672929233018816,
                4820769715554402368,
                14040796714214300352,
                4823374512110701792,
                14040765101311988096,
                14037964577281404480,
                14043374672138121056,
                14029609600473224192,
                4820470819738241184,
                4817534789551762112,
                14041395260030327168,
                4823329126402176672,
                4821463746447382432,
                14033287482559375872,
                14043057443239284960,
                14047337337290524352,
                4823271721378525536,
                4823103375123745344,
                14034740446563932928,
                14040343733629255616,
                14037159334362785792,
                4815131337730935872,
                4819499553550657824,
                14040361778298498304,
                4816889594662260544,
                14045507617035855776,
                14036692362406926848,
                4822010001847494400,
                4821374737789289472,
                14045139395684334368,
                14043715882869823872,
                14037049689699825024,
                4802708576056335360,
                4824028972484406336,
                14047303564099489504,
                14047434029246607456,
                14038094888762036160,
                4821847493476766848,
                14044077935175739104,
                4814535035013448960,
                14032569346990249984,
                14039102684246736256,
                4822516397464357760,
                4822393846196709536,
                4819968889018665632,
                4802111971169878016,
                14041330249657258752,
                14045847829584049344,
                4820038440796376416,
                4820040481785133088,
                14046920661922258320,
                14040268282486967936,
                14046522987992208384,
                4823683088334476528,
                14046746121206313248,
                14044940456568775744,
                4810734461243463168,
                4816744108380203904,
                4823527173842664176,
                14046857810758224752,
                4821062067491491936,
                4803443929230962176,
                4819717550856432384,
                4824084669763567392,
                14043025870045175936,
                4818747919521542848,
                14038502710830179136,
                4823386796571280784,
                14042327815495895840,
                4822111759078927008,
                4814977299231950912,
                4817588110536056832,
                14042279251053151712,
                4821840109955956096,
                14040653630420899264,
                4817930989932559296,
                14042622665069547872,
                14034721616857048064,
                4820074523136886144,
                4823707295292562272,
                4804482854961802752,
                14043161980881380672,
                14044718689173440288,
                14039631036301203904,
                4819820497643926656,
                14039994898299412160,
                14046909480325279984,
                4806584974209728512,
                4819109486192351232,
                4824112834507130432,
                14044689868337704224,
                14039765492989067840,
                14043041832818968352,
                14043727011455858880,
                14039034406029932352,
                4820811091750771168,
                4811003096932815488,
                14047111264276690432,
                4821175079436430912,
                4817287546362851264,
                14029505646696510720,
                4823484453479471888,
                14043740279272244128,
                4817944497882481792,
                4821050694690922208,
                14044521596829420544,
                14044790036724851904,
                4821982659053236288,
                4814547529164107712,
                4818740620071045760,
                14043968098221152352,
                14047287577677973056,
                4823601395070219872,
                14020765748402148352,
                14026516655440028672,
                14045047884142750080,
                14044993358829835040,
                4809209870993103360,
                4811412376222931456,
                4811886058664630272,
                14019215786600765440,
                4823462958103153136,
                4823290887582221664,
                4815895052336918592,
                4806919841636668672,
                14044463654034514112,
                14042255812751477280,
                14044086488879062528,
                14028218328931315712,
                14043039730882272640,
                14046925510749453168,
                4823577691849640512,
                14046643057261962208,
                14038438719733707008,
                4817916262237805760,
                14040252588598165760,
                14043202199643897120,
                14042361669199462304,
                14042613428712936960,
                14032438839976769792,
                4815469530610619904,
                4819138093917083328,
                14040352515635012544,
                4823883037538166208,
                4812470229139847680,
                14040507027709688192,
                14038639940949316224,
                4817983541071607168,
                4805509274672941568,
                14035408214278025216,
                14035036614773646464,
                14035739355815424512,
                4809312053682963456,
                14038282086058492608,
                14044014777021488256,
                4817945462026109248,
                4815657952001174016,
                14044470231760413280,
                4822556559184983776,
                4819731033665559360,
                14047059349763525248,
                14029206869563360768,
                14046309220833051808,
                4817602434335160896,
                14047114861219612880,
                4814650343617271936,
                4816193752358088896,
                14042464035020253472,
                4821849412880885248,
                14035428022684829568,
                14040069398432507520,
                4805383728751683840,
                4809882104865608192,
                4823341438746873568,
                14047103598397220528,
                4820262523631462304,
                14047008368067779072,
                14043092783527359840,
                4823704730762207056,
                4823686600044731456,
                4820535842771284928,
                14047289388162766768,
                4821441019148283232,
                14044132007970833120,
                4823592241207882784,
                4809097044155193600,
                14036553207955736064,
                4809170343200448768,
                4823690651786384848,
                14045568788876540032,
                14039839023848964928,
                4815495658276152384,
                14043142510096238880,
                14044667661348971520,
                4804377184246858240,
                14036559547074397056,
                14028947537588717056,
                4819939632983572832,
                4817123622609749632,
                4819758823408731680,
                4822922983748985248,
                14038763342059353984,
                4814548196696302656,
                4814595859187778304,
                4814293307734695552,
                14031451914127218176,
                14047454277665020400,
                14044547338072658336,
                14042676013325982400,
                4823950722660703104,
                14035859784584876160,
                4821711633490773088,
                14039137336233276864,
                14022833524913299456,
                4822874552451964928,
                4823007173792612640,
                14038119426893418560,
                4824117245655304768,
                4816205206434565952,
                14037070723215900800,
                4818368252873733312,
                14045919480036429120,
                14044749570872477728,
                14043364308773138592,
                4821660391531334880,
                4820256454065847104,
                4820231442658191552,
                14043934164815453120,
                4811819433064607232,
                14042356227007051488,
                14029094423779336192,
                14037660794830753024,
                14036996017993602816,
                14041046522910001024,
                14047116219678424336,
                14026177626017395712,
                4819050027016169728,
                4823781462658225664,
                14047129250563115648,
                14031851399433750784,
                14042146160743595648,
                14039974409580301248,
                4815403280020890240,
                4822328580842176960,
                4818040911621798208,
                14041710250584451968,
                14046315908512876320,
                4815464798232036800,
                14040808794125169408,
                4822016293584513120,
                14043308576447945120,
                14046693652007237440,
                14045577994213000000,
                14047380616614746368,
                4808718582135990272,
                14044982733111443008,
                14038238938183694336,
                4823738603176979456,
                4799411612127715328,
                4821047899071022816,
                14047490865833513408,
                14044035091755091712,
                14042410880368495520,
                4814756149736951360,
                14047007315568217152,
                14022376323223775232,
                14041707679464380864,
                14041186908778767232,
                4823078632967598208,
                4823447984648066288,
                14044699007395880416,
                4820524093171390432,
                14039322323836094208,
                4816303409342446080,
                4811196517421352064,
                4812607645670833152,
                4824118109127387280,
                4822486706433366048,
                14010746719618039808,
                4812813077972245376,
                4819912942786780384,
                14039393147862990208,
                4809261358601790464,
                4802578457651204096,
                4819055953343625216,
                14047306806092835520,
                14045653526069814496,
                14044582021905637600,
                14039755126784276352,
                4823389216414505968,
                4811203070307879296,
                14046226136989021888,
                4814472113709883520,
                4810905083817094144,
                14043393148676703840,
                14039797527143377088,
                14044995974956452096,
                14040477317544600576,
                14046269344125844416,
                4808030733178213888,
                14042348121230718816,
                14033346594218093696,
                14042637836856688512,
                14038943331040251200,
                14037114248785428992,
                14046807794943784000,
                14036201226957750912,
                4823895618915669072,
                14038556340029466368,
                4822956377903820992,
                4824069573376912528,
                14043135066660958176,
                14026604451271281152,
                14038363321840365120,
                14043693197255255296,
                14046883884765863664,
                4814912756393204480,
                4814069497504095360,
                14034051250771085824,
                4822820909601806144,
                14042100848433460608,
                14036500234451803904,
                4816568041285323008,
                14045721196433563840,
                14047090746736507552,
                14047215162764973408,
                4822789089314390496,
                4822083451364898016,
                4819881468059480192,
                4808515797837834752,
                4821483981221378048,
                4816320040953219072,
                4817573936067886592,
                4818410623036340224,
                4815636977908845312,
                4811763508050834176,
                4803173088059140608,
                4813852541820428032,
                4818165827782973696,
                4819013970154393984,
                14037813247431430720,
                4813242321747934592,
                14040296650756964736,
                4822457889284067840,
                4814142798008455168,
                14044750594843946528,
                14047161291673777728,
                4810329483713191552,
                14036074716735492736,
                14038171602412163456,
                14039941072745809216,
                14042477070087347168,
                14043210864203278592,
                4815105309413393024,
                14007481333521776640,
                4818975111574063968,
                4813357892706549248,
                14047116615475173248,
                14036506338757299200,
                4818008438152944960,
                4818421194522831808,
                4813408541245848064,
                4810675467103056000,
                4823711764081777168,
                14045282608274164736,
                14046437406945342208,
                4789675703982116864,
                4814226727953549184,
                14045480468658618560,
                14046643121006720032,
                14043316343048022944,
                4819582568191330304,
                4820697580024568768,
                14026400404284275712,
                14038884436626239488,
                14039793353905564416,
                4821882382221644416,
                14046989453609375872,
                14028608346519543296,
                4813856374925788928,
                14046933272341906976,
                14041733291849840640,
                14046193338964718272,
                14029749416615012608,
                14008667499160313856,
                4821031463613096032,
                4821094240267533440,
                14043028777688811840,
                14045910274105611648,
                14023955125171160064,
                4822418739057433088,
                14046787177892432176,
                4818187363512031104,
                4817743609349753600,
                4820055930851207104,
                4819847234491765824,
                14044863838920091040,
                4823670922938214496,
                4822764973916805024,
                4808832116202588160,
                4811684220456504064,
                14046293438160036288,
                4820537689466184768,
                4821733830774473824,
                14046612066301586720,
                4817532712770942848,
                4822685744375756608,
                4818759157899174016,
                14028724347357063168,
                14041830198129768448,
                14036344666610436608,
                14040323179555480128,
                4823746133896211824,
                4823221511981163520,
                14046699740007808928,
                4822957187907335168,
                4819405699738379264,
                4819438318464273952,
                14044810232557298176,
                14046849905972347296,
                14042248634109431904,
                14044532864438065120,
                14035136877280465024,
                14046393352858336352,
                14039701827418801472,
                4822716368445853280,
                14039536497402850560,
                14039334523410160576,
                14039797141231677696,
                4823113715985570976,
                4817747628290547008,
                14042812082446271136,
                4813729698985979520,
                4820356605140550432,
                4809252862094656256,
                14046568441523315360,
                14046310566391754208,
                14039624299785957056,
                14031889117283188224,
                4819205760061489344,
                4821266245190442176,
                4823573256897809472,
                4818230664775002432,
                4761382017729822720,
                14046321782092180224,
                4823991330419029856,
                4816981208511728640,
                14046280676724399520,
                14043911203190585728,
                4821722909307034688,
                14042336350419369344,
                14043081597176352192,
                4822238989999752640,
                4813323622230135040,
                4819479969178453920,
                14046673775195096576,
                4822746454817367328,
                14037940523917228480,
                4808218210793240576,
                14044911857947482528,
                4822632405562891840,
                14047024327850261760,
                4824080957566290800,
                4823552086410294080,
                14044777830772381344,
                4819702949337907136,
                4816086063520677824,
                4820519969818823072,
                14022872577629170688,
                4818383745947697728,
                14046166513966093184,
                4820058378580902080,
                4817916270469662336,
                14042617394985060544,
                14044596089363140672,
                4818985421984799520,
                14046732240460260720,
                14043462475813731616,
                14037355457397961216,
                14044794232562871456,
                14028293322124921344,
                14045636679319878208,
                14042481863718810368,
                14047247491105393792,
                4822458750819063168,
                14030659778785043968,
                14043833472166895904,
                4822313669184477824,
                4817899473009487232,
                4803788293057803776,
                14043941681394536320,
                14042373463191821120,
                4823404759023487808,
                14044780914684384704,
                14039268276222143488,
                4816042300707062784,
                4815446149316687744,
                4815491395841920000,
                4820973370017418144,
                4822119801271255520,
                14021589681635712000,
                4809446134923886080,
                14042718051431356544,
                14044063165685195392,
                14047485897162058976,
                14037879433503924800,
                4823914357040724688,
                4824033705821649728,
                4814823466447710592,
                14041904958291630208,
                4822608577643321216,
                4800910610103177728,
                4810947297500713728,
                14030233436446985216,
                4816694488678761472,
                14047137913047852144,
                14045343311827569088,
                14046848596280512176,
                14040462067435045888,
                4823066754800109952,
                14034421534334573696,
                4813235632454499200,
                14032885324730906880,
                4822273038293927936,
                4822254081173935840,
                4820958755975331808,
                4824032060406757024,
                4823094704385835072,
                4824060563548864720,
                4819420339598795552,
                14015805132095299584,
                14046079983205059744,
                14036559663417226112,
                4822080860488830752,
                4810201547902970112,
                14038866180848913920,
                4820677051769647456,
                4814235200910405504,
                14046824661375750416,
                4813588912007940992,
                4823694568251371264,
                4814207448614980096,
                14031704389383817216,
                14033853494219613824,
                4817390739517288000,
                4816645688451000704,
                4817749826578561664,
                14038517610490541952,
                14046205303469157856,
                4822230337757929376,
                4806957836876844288,
                14047498789056107680,
                14047189667303467552,
                14039785431304624192,
                14044124348115237120,
                14041724116931741184,
                4824121870661311472,
                14035079847618938112,
                4821999107498541792,
                4822773613800314112,
                14041787110701319616,
                4813997316342108032,
                4819537219386131840,
                14036982043067753344,
                14046655010716349792,
                4822540567279174240,
                14047098073610125088,
                14040232473459531648,
                14038233256023442496,
                14039302519583481600,
                4820546647750909184,
                14047226175328405440,
                14035852088016843520,
                4823376094355464192,
                4823037186739420256,
                4819382521750075488,
                14046976765202420592,
                4815425452451253248,
                14043886071298983872,
                4821625471008554560,
                4816844333957271296,
                4822125858149512608,
                4820834062174058272,
                4823949622974739104,
                4823631853929970560,
                14046756020457365712,
                4824072775279631360,
                4823157691523098624,
                4819412561842715712,
                4821711787860576128,
                14044205723979976352,
                14042848964047274016,
                4815595288338732672,
                4811290605164790016,
                14041295940152597184,
                14044152556144923200,
                4823481078326404688,
                4819796360145091808,
                14040232337328770752,
                4819096611732257536,
                14042271352187171392,
                14046341208751328192,
                14043259704623333984,
                14039416569433984704,
                14035259146595790848,
                14043597587962598752,
                4823794061722747824,
                14045394402041258688,
                14041664318255492992,
                4824011715294152144,
                14047182850784171200,
                4818379432968531200,
                14040056253711039936,
                14024755683593077248,
                4815982009750323136,
                14043165812760657152,
                4799166218741269504,
                14046085610239732096,
                14039424292079066624,
                4822274694427205568,
                4794358408973070336,
                14046958810460073616,
                4807447807406093056,
                14018394255620046848,
                14038476758997304448,
                14045724555017076864,
                14037302522624510464,
                14046928604667483840,
                4822554717644761920,
                4822878774813976544,
                4820705277458645824,
                4816107349473405248,
                14043642712354907264,
                4823245056493711328,
                14045373716489657888,
                4819180148419784064,
                14045163509224132768,
                14043817140837482112,
                14025791069688133632,
                14044488205247893152,
                14044017675137152064,
                14042732588460381504,
                14046304029965461376,
                14045089470708041568,
                4823369668689471696,
                4821220610727702432,
                14046911270526342864,
                4817579335270385280,
                14044691267028319104,
                4821227064853461600,
                14042344892263778112,
                4820720974439910368,
                14022766134604633088,
                4823269281011446624,
                14043432316949895392,
                4818894263721311456,
                14040377717009404864,
                4822647346481329696,
                4821699515430018496,
                14028077026423474688,
                4817557932702790912,
                14044383800484257120,
                4823665637029237792,
                14043820798354006304,
                14033076679602080000,
                14042327622374391840,
                14047260405945129072,
                4820636860018443168,
                4812191441784315904,
                14037917772226225664,
                4823899439311424624,
                4822033578944059360,
                4805966167502031616,
                4823466961012864272,
                4821054860756024096,
                4822527541706653088,
                14043838404532236544,
                14044446149810642400,
                14044031800027279456,
                14038711459048334080,
                14040041961306825536,
                14026336402234876928,
                14046883837249453168,
                4821909097932492480,
                14044544088370095456,
                14043760552704173152,
                4819649833376765216,
                14036524335305462400,
                14044235953127967136,
                4819888308368959456,
                14042513543893949920,
                14046255556696021664,
                4821017447808372864,
                4808391523058194688,
                4821246106167148672,
                4823794142716503680,
                14045609308200076128,
                4814322361633144576,
                4824082437111424176,
                4815242360691093952,
                4823489924531879488,
                4821793360149654752,
                14039529196834787968,
                14042931495374359168,
                4822207043214631296,
                14045889141034063712,
                14046934810695187264,
                4819233873517202176,
                14042572688586014080,
                4819524480379887360,
                14042373285444997952,
                14046166930287668128,
                14044038401318121632,
                14046242716416552608,
                4822019036249625728,
                14046128892999401376,
                14045659384835308640,
                4821618996238505920,
                14033321836878275200,
                4817105381495746048,
                4819421212509030368,
                4815511896646205888,
                4819291732207164864,
                4814623623362994688,
                14039791898298758336,
                4822656176961099104,
                14045058409198700064,
                14043439769165685216,
                4821786513163802912,
                4800070130247992320,
                14044480442594057536,
                4815023689511117760,
                14046856298904896416,
                4824060463334351920,
                14047011728189053376,
                14047449392218806304,
                14043072636762376224,
                4822795979625324576,
                4820848953200563904,
                4819556404437545088,
                14033614011256829824,
                4814374893833611840,
                4793139648904071168,
                14035335573727593984,
                14045461480156290176,
                4821206998364986848,
                14036922699826802304,
                4815554604340740096,
                4821636644830473504,
                14041650945068569664,
                4820939767798377632,
                4797656916403511296,
                14044697667089888544,
                14041246024578569472,
                14036993870463762688,
                4820897320492639168,
                14041481775051314560,
                4818531097727857024,
                4802588126438515712,
                4820182915473146272,
                4823074603746320864,
                4809145847237585920,
                4798783142015828992,
                14034719666053115008,
                4821703675051402336,
                14044849592187605344,
                14044941850175584480,
                14046561159826992032,
                4819677494563634112,
                4810867687044574848,
                14033511170465564416,
                14040107576756789888,
                4820288758912491072,
                14034222784986415488,
                4823515507520839376,
                4813366639822757248,
                4816487660728711040,
                14042487217769909152,
                4819606658237363200,
                14045967413130617856,
                4818970528373539296,
                14046867761976906928,
                14047241861057974000,
                4792806782283632640,
                4823923121266641920,
                14038122342859874176,
                4813931524406361344,
                14040955554324451136,
                14033046759452960256,
                14045025153353754464,
                14041824314132611456,
                4813410108420516864,
                4817493423868752000,
                4818945471047610784,
                4811916798496423808,
                14038170097712571712,
                4807210308010360832,
                4818999971588965056,
                14044720083864563904,
                14046063409632212640,
                4820593621986151840,
                14042121142850950464,
                14047444358045394192,
                4821242933447912640,
                14045701450705743264,
                4822608652257225504,
                4816121186125800320,
                14022641400520940544,
                4822235577594344576,
                4820818878147718112,
                4821813656728771584,
                4823393811335520032,
                4812662589977544448,
                14043120786420024320,
                14044571178147012032,
                14045933182683827680,
                4822521203257907872,
                14047014566700721312,
                4820797329466096288,
                4821192265000701216,
                14041102899453264256,
                14037126305492183168,
                14047022188183292544,
                14045829041139578336,
                4820004151318876032,
                14039676569325289472,
                4821354969070576544,
                4822900322234764608,
                4820924227351107360,
                14032570190573244416,
                14044144349825143648,
                4817350408279433280,
                14038746639715655168,
                14035537784849444480,
                4814744030119768320,
                4819523815871146112,
                14045502353302404576,
                14045699119794785376,
                14043000798510653248,
                14046968012069164464,
                4819622361926939712,
                4820074837716972864,
                14047341243289429632,
                14025309665505894912,
                14024701743558333440,
                14040181442697290752,
                14028808678629110784,
                4797292785021455360,
                14042095035215234944,
                4816550808046938944,
                4823356199020518400,
                14035869243089819008,
                14036210028218821888,
                4807279985289316096,
                4823069624276870016,
                14044943822533434848,
                14042776510329650464,
                14042499180403934784,
                4821373270265770016,
                14045786588700925568,
                4811914484471932928,
                4806613225654606336,
                4823768609204563072,
                14043897965989753728,
                4818293755620989760,
                4819859700468330784,
                14004801607202897920,
                4824017513547630112,
                4823978802077757072,
                4811506598032761984,
                14037299078074427648,
                14033235220325517184,
                4815739045043193920,
                14047277174567657712,
                4823748268781303168,
                14028718654629710848,
                14044316463565045632,
                14046765516897655056,
                14042310880665501024,
                4823791661560914960,
                4822387308009871968,
                14044780598653110336,
                14044400072611719232,
                4820740915992458016,
                14040494265726269376,
                14047205254244982176,
                4818225526970177216,
                14037900575915157184,
                4822219160874755488,
                4812692093784145664,
                4821715452497307008,
                14041166205603164096,
                14044565547953054624,
                4814617644740894528,
                4822939032789664928,
                14034608707708412800,
                4822866853207902368,
                14047127967245985040,
                14046106961386103328,
                14045582860543927680,
                4820173024944134688,
                4804784091795986432,
                4807935949926320896,
                4809085326616123648,
                4820758306097450560,
                14047037595707218688,
                14046994894871673984,
                4814773844798992000,
                14043250224867192320,
                14039116892766709312,
                4814623480008647296,
                4823349351674771072,
                4821853865904467168,
                14043257453802491904,
                14043384698312157248,
                4808004162349238528,
                4815741349821026624,
                14043176519562033824,
                4821952685361690304,
                14042628498912668672,
                14044188011937121472,
                14046093904052350176,
                14041501491335280768,
                14042469499688583136,
                4810436757785617408,
                4818662393499736768,
                14046723329011646720,
                4823443837227239104,
                14045366633413788192,
                14046968887098845280,
                4814911163004364544,
                14042447825700077568,
                4798283492030341120,
                14027072700842153984,
                4820194441192439616,
                14041711858580995264,
                14038069383084359296,
                14026590278867922432,
                14046896907735844352,
                4823803140673402448,
                4815776664945193024,
                4820261429951379776,
                4823226737069167872,
                14040117196345040320,
                4819609571130025696,
                4823557386918859584,
                14044691078301435360,
                14039872306803966656,
                4820136525520219488,
                4820440095280437696,
                4807428604124868352,
                4818200200854840384,
                14043078065489555040,
                14046851247370771712,
                14042615905046766656,
                4819419559074095648,
                4819112756380643456,
                4808948302827880960,
                4820130107936008704,
                14036698063470440960,
                14046903312288905408,
                14026588781053335040,
                4816269192506426624,
                14045850795683210432,
                14039252365685061440,
                4810020597805412864,
                14045356094921604160,
                14043097288932800896,
                14044665434266344256,
                14044562962925736768,
                14044516530214969920,
                4823414511899322128,
                4820204739225923008,
                14042542236139031776,
                14047100595192298144,
                14046729058137353536,
                14044796766035074912,
                4819966076551926592,
                14031825281874523392,
                14041096210268183360,
                14039544134449878528,
                4823383796766809392,
                14047492982535475648,
                14046301091467990368,
                4823862562924047296,
                14047249839214803536,
                4821006253017118080,
                14040428187817643456,
                4824005993688368320,
                14045138135432056544,
                14046446365037435488,
                14038935721085282368,
                14047471169940503792,
                14033495835719313536,
                14042798896398731776,
                4813157751014127488,
                14044474447533584000,
                4819567554994267392,
                14040431189854779520,
                14043090970797978144,
                4820463635250632032,
                14040961570653283520,
                4785209584446308352,
                4821073353742914272,
                4809100580981404928,
                4808607489358899200,
                14042846816211251424,
                14030700313171563776,
                14046720907453635680,
                14042920768275761344,
                4816644796496144640,
                14042497014721546976,
                14028145922326999040,
                14042465958683418368,
                14044255534365527392,
                4822617211641397280,
                14043122364769447616,
                4805631511629792256,
                4810205474183461376,
                4819606117760729376,
                4819049237311854400,
                4819638313986968992,
                14043789396857654336,
                4804022758989834752,
                14040964261201084992,
                14036392944012153984,
                14038391049626679488,
                14030847539825835264,
                4822839210649299776,
                4819499685647439136,
                14040253761405135168,
                14032606430339451648,
                14045174730775718624,
                14029735463763564800,
                4823038293124335712,
                14033238609233370624,
                4821316923062445408,
                4823074215882770208,
                14045908717898737824,
                4802781908572011520,
                4817384894172195072,
                4818144007497931136,
                4816665432062572160,
                14033354940862010880,
                4823914536535917280,
                14044295144949067360,
                14035870561435002496,
                4814539839156746432,
                14043215015797880384,
                14047315189023095792,
                14035369152291028480,
                4808681504791904768,
                4822493077036618048,
                14033266594244150272,
                14043932721849060672,
                14042948378965998240,
                4822978822084341600,
                14032741532056719104,
                4819249622307109536,
                14044748600480618240,
                4817576212678360192,
                14046405478477518496,
                14046847117436838192,
                4820149646918266304,
                4823553674312880880,
                4815301385385155520,
                4822312140696970912,
                4824032081417544704,
                14044992801371797696,
                4819349535848911936,
                4823584106532590608,
                14031880114206224640,
                14047329892044412320,
                4813463750358693248,
                14043127682725156128,
                14042550868905487392,
                4819526262316173056,
                4823492042802582928,
                4813747665811519744,
                14038408769714612864,
                14025515924506802176,
                14040206776833417408,
                4822275175649790528,
                14041651661965319808,
                14045853943419993056,
                14043505194734274752,
                14039929575754856768,
                14029446928943123968,
                4819471829690483680,
                4822358238606616160,
                4815952782782718016,
                4816579803919977088,
                4803172268559085568,
                14037574520474544896,
                14041023293749826496,
                4819669316338293184,
                4822381886685121664,
                4814949541608513024,
                14046518209777144768,
                14044962088148458176,
                14043712021470579552,
                14045462025555960128,
                4823290296369894272,
                14042875242047187712,
                4811227996257409152,
                4820094657302172000,
                14047268026412358496,
                14044261627055153888,
                4816676027372550080,
                4818988112406057056,
                14047168323392133104,
                14036812146916278144,
                4822647148745983232,
                4806416580925257984,
                4822687338421398592,
                14040659473392140992,
                4807617116341448448,
                4823754125084250656,
                14041898383959664640,
                4823928215263594528,
                4823590608007128736,
                14046984033857514832,
                4810656040128120320,
                4819166525645750080,
                14034041966182391040,
                4822822987161371488,
                14045127101047551840,
                4820068862666826144,
                14043434095527401760,
                14040921218767197376,
                14047495591310846416,
                14046903687920233824,
                14042797441888326400,
                4822894497633561792,
                4818982771651696608,
                14043137429542590112,
                14042750052873796832,
                14038252924793468416,
                14040282646075979520,
                14033895360297905152,
                4818821017394163840,
                14042916399651292128,
                4814798536125483904,
                14046806191966722304,
                4823139113113045504,
                14015297166206785536,
                14046827572606184720,
                14047080180235629808,
                14041618148976860928,
                4817363782277768384,
                14037345265549837824,
                4816921621327639168,
                14046700883851729792,
                4812798785083198720,
                4819777826789112832,
                4824093621144554736,
                4821050479025166432,
                4821499796823920384,
                4810080753381523200,
                14035266888196645504,
                14046152857191322464,
                14045147555265602880,
                4819720101365537216,
                14035884162226495104,
                4814557221934779584,
                14028975157409673472,
                4823557713114728720,
                4823011986069562560,
                4814353235093053888,
                14046113294532890976,
                4824039762260425360,
                4819140546758649024,
                4815737341935295680,
                4815435286943200512,
                14043610898880614688,
                14042238454686872704,
                4822589053593557440,
                4811562170768949888,
                4798285318942627840,
                4821598444014079232,
                4816137313013105280,
                4810772711755612544,
                4821153687260206944,
                4809418545373824256,
                4823363559742400304,
                14045337467805364608,
                14046314655885555520,
                4819478119637254400,
                4820824064880936960,
                14042617384550599648,
                14046529274567364192,
                14044756763057829536,
                14030372190572887552,
                4824074930273949312,
                14043260157563907072,
                14041404044477393216,
                4821675538426049472,
                14042047253238559104,
                4822573073662088960,
                14024232844721237504,
                4801746691493966336,
                14042024041810355328,
                4817468615484937728,
                4820419564910000672,
                4820037981555363520,
                14035413828192259328,
                14029374584420809216,
                4820125659001981920,
                4822231509270238976,
                4820084760969442624,
                4807221227979781632,
                14024955392120029696,
                4815923338424602496,
                4822666603030589888,
                4817857794247714880,
                4815815094706722880,
                14039111549850603520,
                14046810693373296288,
                4816792165915616128,
                14042480920902775904,
                14043147966907082912,
                14046633061170736640,
                4803887935008955904,
                14047447627957748080,
                14025361448608221184,
                14042481898715989632,
                4822695462269299520,
                14031561667074544896,
                4823926475793359232,
                14045111035514535456,
                14033792475926343552,
                14037740230693659072,
                14032282177726076928,
                4808147722149140224,
                4821904534654980992,
                14046352571106276384,
                14038572443947110336,
                4819841449235128064,
                4820639502405138368,
                14040803203057666880,
                4820325840742393280,
                14046838066772351792,
                4788234228701003776,
                4819746011374314432,
                14040290217118963584,
                4801568121055811072,
                4821642371227288992,
                4823859126348224128,
                4822472635232691392,
                4817395005835428160,
                4815561947371879232,
                14045612890817049376,
                14041556355980214656,
                4821271401332285600,
                4820785860094018304,
                4821807788617917888,
                14037922882662542976,
                4818149007691290816,
                14042374597710097760,
                4810322861417925504,
                14045073620949091104,
                4813468108857660928,
                14041187569759368192,
                14047192491651720240,
                4821234452466636992,
                4818342463455319424,
                4822782853860455840,
                14038532268403006656,
                14038776597179011520,
                4816140734456347456,
                14036383282552424192,
                14043860887023185824,
                14039366923205984128,
                14042853905491540096,
                4823867769016818448,
                14042038332447023936,
                4814029249873877120,
                14024977505123907072,
                4822596351476697152,
                14036603772330247680,
                4821667776901388352,
                14047173462717938672,
                4820019591090057632,
                4823640503739676496,
                4820298114112882688,
                14043783508696328032,
                14028726705776916992,
                4819628803029101696,
                4823318710764586240,
                4818970967084412864,
                4814388435310996032,
                4821298175323663744,
                4819443772850088160,
                14042759174029573536,
                14046851936453335328,
                4821852725460364672,
                14038131602748077120,
                14037083922071075840,
                4819163326499610912,
                4820948724870138720,
                14044040439348105472,
                4823784312647558816,
                14040969568888977536,
                4820908349952007200,
                14042755081944579840,
                4816556754237347136,
                4820193859696014240,
                14045762037814251072,
                14043224991715790112,
                4823873628123189328,
                14046419856357617280,
                4821573046117805824,
                14035737978225647872,
                14045940787308872320,
                4822957791173172128,
                14046835227131674544,
                14036756773597010304,
                4821015227653029472,
                14039382347475567616,
                4814385784409341120,
                14033447077064123136,
                4810745352876379776,
                4823831421451721440,
                4817115890056272704,
                4819464457500141728,
                4813724091834970752,
                4818029070339465920,
                4823358951554819424,
                14044001591236914144,
                4823607839163985056,
                4811772911301224704,
                14043056632030466464,
                4806416960801803520,
                14042996277296042272,
                14039648365580371200,
                4820152409711828192,
                4820642108352588928,
                14029090544416495104,
                14041179479721601536,
                14038340485397973632,
                14046472002264079520,
                4810726478000431488,
                4812009031527654400,
                4819315764315930944,
                4817317575146479808,
                14045868707891930848,
                4821658017381554144,
                14040757173430545088,
                4814447920884705472,
                14030005929563398144,
                4802073332771989504,
                4822128050040569376,
                4822359116259091168,
                14046325319246567328,
                4798595665430469632,
                14034379409710560000,
                4821891553341924320,
                4797501343319888896,
                14044255277761127040,
                14043973271698199456,
                14046689262494093248,
                14045764001054923488,
                14034054619097519488,
                4819601995670726176,
                14046954568177349824,
                14044406139628367264,
                4823401493582609232,
                4822416999492889344,
                4820050606249603456,
                14041729305763569152,
                14039655485946678592,
                14045766340286793728,
                14040271984167585984,
                14040068671774277632,
                4800418279539573760,
                14044601480897545664,
                14032304512413818624,
                4819238340117434304,
                14045303005801748608,
                14042052206746599936,
                4818709615573168256,
                14047238791822630944,
                4820616519029229856,
                14040734105350532224,
                14043536928763529824,
                4821182466082456960,
                14047132411445369904,
                14045526532385780256,
                14039398073026549824,
                14039320474256265216,
                14032575787568917248,
                4819224304095574112,
                4820798639573090464,
                4816803522852885632,
                4816690685012090176,
                14044419713595851520,
                4815882743657667968,
                4815627252727524736,
                4821439474473379424,
                4820457307381208864,
                4822114080786367552,
                4821072314498901696,
                4822960767583985696,
                4822119231875931200,
                4820234832863064800,
                4815964594203463168,
                4822125426508014368,
                14046439196670498432,
                4806951098695948288,
                14046157477473920768,
                4822634881928081888,
                14038034950202540608,
                4820677684055701728,
                14045369508204984320,
                14044122534704717888,
                4823063123614395520,
                14038968612466453440,
                4823482431263559264,
                4824086635725295776,
                4818021184677034048,
                14034115880897733632,
                4819966612056855296,
                14028856255443871744,
                4800970581927577600,
                4811537776786762112,
                4822273483660427136,
                4822261797596690656,
                4810073792655816448,
                4820682091626689152,
                4822520554778299040,
                4809573375960721664,
                14033507278063002752,
                4819985856232579392,
                14041838307938890368,
                4820345444333655744,
                4820045267160635008,
                4823412697257961792,
                4818000365087560128,
                14041737325021053504,
                14047420526262344784,
                4823910521414846000,
                14045717418532570176,
                4823490868950751600,
                4822367534293583520,
                4819676090810798944,
                4811349907640715776,
                4823629015488249504,
                4820422126990451136,
                14042952444763607680,
                4819470720981846400,
                14042642332972833376,
                14042879472544650400,
                4821689528655304224,
                4820456291005022720,
                14045670581054078720,
                14043533367729650176,
                4801290734701679616,
                4815957326919023552,
                14042269834789089376,
                14044890606275740736,
                4805823458217711104,
                14044227724496891904,
                4823402092703335760,
                4822608778533371456,
                14045645732149140416,
                4818546952019434304,
                14046986317644262624,
                14047017506194726832,
                4810372028260206720,
                14038123799911812608,
                14039190125026145984,
                14033897456602033408,
                4822522716631995136,
                14047277130431192832,
                4823048297695750368,
                14047160333283775552,
                14045884679782399968,
                4819005120583910944,
                14045210385634400384,
                14024182039035762688,
                4821503792210971840,
                4821239335458938688,
                14029227748219801600,
                4806053637299426816,
                14046959868323274320,
                4817859294125530368,
                4824023714355564032,
                14041619919901260416,
                14046344807772762880,
                14045728851633937376,
                4823996386441260224,
                4823231065333489344,
                4815340192858770880,
                14024570343524751360,
                4819074915229193536,
                4817140994373176192,
                4806987178036726528,
                4821323123908480320,
                14039472839561286016,
                14043310271355162464,
                14033691387627211008,
                4823370929661135536,
                4815816211742494080,
                14040717840444771840,
                14037221380182369024,
                14035238055346100736,
                14045517733303433152,
                14046736322858406528,
                14046834828517165536,
                4821757995531734848,
                4816864785469041408,
                14040887163328182144,
                4815875329662489280,
                14045265484758465344,
                14041282294720095360,
                4819505244894497728,
                14041105549822131264,
                14046973493111895504,
                4819206136788759200,
                14038365770000307584,
                4823427509993365872,
                14033010494170406400,
                4820446292889421568,
                14046794481251997888,
                14044648872133409376,
                4819249534589534720,
                14035527248940838656,
                14034261935081950720,
                4821114772958933984,
                4821449709258136256,
                14044634765029429536,
                4822502883067568896,
                4823750421928062432,
                14044475807416224640,
                14047395748166022000,
                14038624747672163584,
                4821953175416184288,
                4819337235590158304,
                4816176896428906624,
                14043552516085828512,
                4823659750748469504,
                4823683180204692768,
                4819997721808574464,
                4815874811355983424,
                14044557403550214848,
                14025471573734111744,
                4820066535420159168,
                14032070845741869312,
                4814013559997335936,
                14044613861689086528,
                14044770624394437824,
                4821753792832931872,
                4820674071879711584,
                4815143732755754496,
                4823696691243399216,
                14040690485748854464,
                14046372584328571552,
                4810316635939921280,
                4820058528214213472,
                4814589008542662720,
                4823019936059684544,
                14043745495751175296,
                4809960520597146240,
                4817891850758788928,
                4819871283148638688,
                14045981412032529152,
                14024263113188784640,
                14042363120210719520,
                14035929970487290496,
                4821586563237456672,
                14047213692821423168,
                14045648439711035456,
                4812069453271974272,
                14046489394534793600,
                4818862190486623072,
                4808013714969195008,
                14041167052405707200,
                14046821750574420768,
                14036010153277055488,
                4819386390564190656,
                4823781272583221984,
                14023960969868794880,
                14044126354803288000,
                14047070891540887984,
                14042892667241457120,
                14042790486042985952,
                14043417583987223840,
                14046822480908767856,
                4822443996441927104,
                14041182822950817152,
                14042470704843533632,
                4817810673950360832,
                14028254104561745920,
                4822853609835256000,
                4822687333974972192,
                4823105465648033632,
                14047168012439471328,
                4816515961740858432,
                4823655675590455088,
                14043630635174836448,
                4817238579574709504,
                4818887415767244032,
                14042948046481616512,
                4819499091780365920,
                4814537184253533248,
                14041117198205066560,
                14042269925194334528,
                14038993805610214336,
                14047085432758954080,
                14046004408873853344,
                14035307190491619456,
                14035750526682482048,
                4812935339925737600,
                14047392809644506672,
                4822050445836341952,
                4822276249439436576,
                14025776736980483072,
                14046451362205787168,
                14037794483080965056,
                14039099824723814016,
                14037187434997084800,
                14042520867569309088,
                14030876598110204416,
                4806439727629671424,
                14045370440314431648,
                14028462420745052672,
                4819831674947039776,
                14043180639921156608,
                4817196335626270208,
                4810518035491653504,
                14044514992861280736,
                14034100268864493824,
                14043428755539938400,
                4819292575565933408,
                4823404944481193360,
                14046532532064297216,
                14047472477624072768,
                14043796311434510752,
                14045823429637120544,
                4817094531227128768,
                4820273109354296864,
                14044187814073736352,
                4820681851865697440,
                4809819994148775168,
                14031928359088231424,
                14043303660277451360,
                4823682648839184192,
                14046785722576646656,
                14040611234845209984,
                14047323800234668544,
                14031218062741227008,
                14045293700618496064,
                4814655726080799488,
                14043819821868333152,
                14044990505834243872,
                14042901196048561920,
                14046538964966124160,
                14040995813292683136,
                4816648289674201152,
                14038059195782628480,
                14043330863112450048,
                4823301218443024832,
                14041088300757269440,
                4819176144373985312,
                14042796397761668384,
                14045435018910573312,
                4823404304185780400,
                14039555351035942336,
                4820920303791018880,
                14040854872510018176,
                14046743312847922464,
                4822881867229273152,
                4822870278549681056,
                4811103157650820608,
                14037406497670069248,
                14028703409747387392,
                14043621620318579776,
                4820726158279935840,
                14022755949943558144,
                4817424135002080896,
                14034183528196808192,
                14046743189766499744,
                4818145017427955456,
                14047098241361704912,
                4822031672980739488,
                14047486743546703440,
                4822720214560048832,
                14046866291759700288,
                4810690458462979840,
                4823357412844257952,
                14042744863780213952,
                14042483051657633024,
                4818970366540676512,
                4823721411484328720,
                14040676837878843968,
                4810095970686856192,
                14043516463327118080,
                14047208816258402480,
                14044244102809007840,
                4817728788172846912,
                14046683228058724000,
                4823387798116752080,
                14047210412729299680,
                14040925792872235008,
                4798877000723968000,
                14045414675307446080,
                14043875385242020992,
                4797879142046307328,
                4817921002095611840,
                4823743980582138848,
                14018857531252613120,
                4811018041032142848,
                4822554275062634784,
                4819271512461310144,
                14047353681180690992,
                14043478909672306272,
                4823505019154075792,
                4814124833699803136,
                4821114957311013824,
                4810032675234218880,
                4822825136326632480,
                14040903881332537280,
                14046618424900302272,
                4815706534555082560,
                4816557647165239360,
                4822282997572038240,
                4821300566469104608,
                14044452451623232832,
                14042249790520235232,
                4816643808720172736,
                14042345021733912352,
                4824030406189854080,
                4819463084060812512,
                14043765414262537152,
                4810206240462452352,
                14043923729116800032,
                4814299821805958272,
                4809031675552807936,
                14040575704732681152,
                14045961286555755744,
                14047092257262150464,
                4821127030371987712,
                4815680639666405504,
                14043989989130508640,
                4814495686803074240,
                14041013770551388800,
                14046804052561675792,
                4824083484623816768,
                4805959629248404736,
                4819254724173426144,
                4815498382544308672,
                14045240350390341664,
                14043434896227629888,
                14046242209451825504,
                4822075008167544800,
                4818900657748672256,
                4824017930179475040,
                4819035268997084256,
                4821198595678204736,
                4823866870401895760,
                4821687226397580768,
                4823457498141729136,
                14032766839416975872,
                14034180913410412928,
                4823270494794457024,
                4814228505680265088,
                14046502457513541216,
                4819843442159029728,
                14031221433860364800,
                4823218008825225536,
                4820770492673680768,
                4820907245418401568,
                4821799766882749120,
                4823551620227722784,
                14036396276658314112,
                4822683185419534592,
                4821021667082329696,
                4810658381506673280,
                4818326933037005824,
                14040019254838181504,
                14047141118489096048,
                14046851990945858032,
                4817899070559940224,
                14043664375618992576,
                4823358103274378544,
                4814633522209839168,
                14044434554669951840,
                14042464678335108928,
                4803947108354246144,
                14043729159908509120,
                4806752781581983488,
                14039512807242246912,
                4814182576743198592,
                14013310543475191808,
                4819572507635344928,
                14032217613873326848,
                14046877226571895632,
                14031883947433794816,
                14041134052009196864,
                4820262456286575040,
                4823102712585947296,
                4820812845360118048,
                14047364617322776352,
                14043184012347870112,
                4816685999375297152,
                14047322654131286768,
                14044134362835530048,
                14044413255469116608,
                14034164336633090304,
                4787698460410433536,
                14033456942139026048,
                4820438074479234272,
                14043663622764917952,
                4820347709485749536,
                14047041855185071472,
                4814837930561079040,
                4814896320994780800,
                14040951312912705792,
                14047145540870023360,
                14041513833326171008,
                4822244114432649024,
                4824099341068386240,
                4820877528574901952,
                4814397176188211136,
                4816095989087295040,
                4814398741154217920,
                4812869438225019008,
                14045327725506778368,
                14038823124142416256,
                4818118098727541440,
                14045050372325388480,
                14045736641499755680,
                14037389938219797632,
                14044296384704244800,
                4819493595272932384,
                4811047750359747328,
                14046225899084480832,
                14046895973279952272,
                14044402994596927040,
                14036576705465070592,
                14046253512832852800,
                4820117361875512288,
                14045011063567676320,
                14025432054961825792,
                14047021960672323840,
                14045151997080962720,
                14042613099088985024,
                14022039240238833664,
                4809878213988696448,
                14047009627734491744,
                14033820054263929984,
                4821319698923306496,
                4822955497384013216,
                14047276388020295184,
                14047096184241382528,
                4823611135109299216,
                4818857901030648448,
                4819991900036441696,
                14045019654580228288,
                14033462813119154176,
                14043566788775828800,
                4818171916692428864,
                14042436133615592096,
                4822339466750503456,
                4817660958014563456,
                14046114236509905632,
                4820567137475811360,
                14042977698243467072,
                14047202509523767072,
                4810023793922915200,
                4823672534259544192,
                14046903960203434752,
                4802629115109755392,
                4819462104396276512,
                4812742613521022464,
                14041319921609080128,
                4822777110685846336,
                4820803370591781472,
                4818564115490740480,
                4823922322425850448,
                4812402951175645440,
                14033518230887070720,
                4816160224236722368,
                14040547656584289536,
                4815258088449519808,
                4816665446776801856,
                4821749414027722432,
                4821658077509654272,
                4820598676166545120,
                4822901554356922336,
                4822811876720564416,
                4821861187996165664,
                14039426922870091520,
                14044082577254496960,
                14046939850957662064,
                4823775979979532832,
                4823203846411833408,
                14046639349080753536,
                4817248548485416384,
                14041112161043629824,
                14047125616403237680,
                4820156295970459808,
                4815062623491864896,
                4815287171972422848,
                14044392931892569856,
                4823123590979828672,
                4821026966198218816,
                14028092806058881024,
                4805459034923118592,
                4821426196700519872,
                14040566195010002688,
                14040567022575945856,
                14039209106098959936,
                14035976994464630272,
                14039341238410081792,
                14045948473375729344,
                4819525811375133600,
                4822234098134713472,
                14041126459144131392,
                4822877398980337824,
                14047382703435330128,
                14046964242539972928,
                4804761455703464448,
                4823252973748797280,
                4821781334453699232,
                14047102543725413584,
                14047230505615006960,
                4798404689703901184,
                4821770082167910976,
                14046833103580599744,
                14033590219261963776,
                4814285438091985280,
                4819188577589261792,
                4807581900448057088,
                4788229220792360960,
                4817586859723202880,
                4813483577183812352,
                4815855429285315264,
                4814915057301381376,
                14038845522429040832,
                14038536283360610560,
                4815989346122288320,
                14042298156668553120,
                4812764814252530048,
                14039025463701560768,
                14041740394287555392,
                14034363885515192448,
                14044435557273584096,
                4813182912998061184,
                14045320263552488192,
                4817176567279651264,
                14030865552733326592,
                4819176655909761920,
                4817626217967129664,
                4819170569235376544,
                4822620760926410656,
                14042656347952278304,
                4807587715613936640,
                4816095088198837376,
                4821563891152559680,
                4822935863857873120,
                14045307167176802464,
                14043388248859445600,
                14034150862208892800,
                4821319654284821056,
                4820771116049600832,
                4822686954182576992,
                14042531582392307008,
                14037205680375455616,
                14039345402214513600,
                14036936694793475968,
                14029535206724152064,
                4820767578646556384,
                14039724192881549120,
                14039236788833008256,
                14040012737763614528,
                4811115643675009152,
                4819935651310128128,
                14044181276260289152,
                4814890797881035712,
                14039456412996557824,
                14045428678483319520,
                4822933752871245312,
                4822384383068537152,
                4823574143491257328,
                14034676801947316864,
                4822132900080793120,
                4822892826528701568,
                4822616577678764192,
                14034164286534441088,
                4811101677600318592,
                14045849806927348320,
                4823808520393398512,
                14042747041188638528,
                4820937431326125856,
                4816222786347003968,
                4812588908975165696,
                14045672835051327776,
                4811796911361400832,
                14044616555411920960,
                4821712305243947392,
                14047024814661021184,
                14040296648016037952,
                4821976839110633344,
                4823834746414167616,
                14037766440292819136,
                14041585671469505856,
                14047382033960289152,
                4818914562640192224,
                14044810836460242080,
                14040318143590506304,
                4813172150722496768,
                4814567200328487872,
                14045973751089579232,
                14039974436792780352,
                4814017694229352704,
                4823374971972368896,
                4811705943173248128,
                4823387947946393888,
                14045704697300347840,
                14035606548230141440,
                14047135251221734544,
                4819271609366685024,
                4821711502139901440,
                4823307836216475520,
                4820124345830491968,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4832045740819742728,
            pinv: 4382166536203340112,
            mod_data: ModData {
                n: 1086317488242689,
                ninv: 672148569487374969,
                norm: 14,
            },
            primitive_root: 3,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                4823669075673047008,
                4821074455055476960,
                4824464537976271760,
                14048002495736585952,
                4827439284260349632,
                14045174112482972512,
                14039465322840855680,
                14047583530830462000,
                4798363000744307712,
                14048239708373958992,
                14050731133834628688,
                14045823572033926208,
                14036443235440844672,
                4809811901440654080,
                14043401806652668352,
                4808386844270543616,
                14046190428065778400,
                4817669223458730688,
                14043371806395188608,
                4822976686508107008,
                4824081006318536176,
                14038968715275889792,
                4820995090977744864,
                4815514108829272640,
                4824223029550427296,
                14048023909235321328,
                4825184773604796608,
                14048926648418871232,
                14045264925715693408,
                14049487039993555776,
                4807139543325878784,
                4824694269976575168,
                14047745396193975056,
                4807414549950819584,
                14050283736512803712,
                14047380340439613968,
                4822245813524250784,
                4815121391312415552,
                4817319226064926656,
                14046026847444144288,
                4818542464428741952,
                4825474976241824960,
                4825883541323858144,
                14043630627172369888,
                14038210136376732416,
                14048095265420288624,
                14050146014957033344,
                14036703814359031424,
                4821179515390904960,
                4825254774599650096,
                4818943853169667136,
                4825344953747088864,
                14049223642061362160,
                14038104667124981504,
                4814642515765468160,
                14046875111226459936,
                4825274776540997216,
                4824758610727820256,
                4822047654827000032,
                14043071888295319616,
                14048272450443581408,
                4822809755460662048,
                14048371011079552256,
                4817890523762114880,
                14050078310196389712,
                4811518488726426368,
                14050309357289728432,
                14032911088151142400,
                4827439317977199872,
                4823676834199080496,
                14042791722262758368,
                4816645695503448768,
                14043772842778193216,
                14049284017012965184,
                14048601325101869536,
                14047718930951295616,
                4819267058212090560,
                4824099035806433072,
                14033006406012555776,
                14043499847196152128,
                4821391322272425856,
                14047502591584659744,
                14041594654704280192,
                14048388332327342688,
                4826788402113082880,
                14027957855955036672,
                14044349817504397984,
                4822785975466479072,
                4825021337472606464,
                14042117320824563456,
                14050045834334406448,
                14045479945677456640,
                4823934452865734304,
                4824021508034647504,
                14046523383579655392,
                14050613509346282560,
                14039688745224568576,
                4823777794160657616,
                4827411646543862736,
                14033469933313939200,
                4824561909263682464,
                14040881506509483968,
                14050009786714029680,
                4821737654230683584,
                14037826153710720960,
                4825211351128951216,
                4823947906853884240,
                4824929118128215600,
                14046566347705385824,
                14039400665966879424,
                14049833831990796528,
                4803965375031389696,
                4804033221111239680,
                14048609834703906304,
                14048876309803297680,
                4825058732463787200,
                14046281325866019808,
                14042656181443171392,
                14048468389490078752,
                14046629866667473824,
                4815648663079374016,
                4824636691110615776,
                14046292328489376224,
                14047234639821289872,
                14050560215382968176,
                14049631567673748032,
                4823148432576698336,
                4802943429249333248,
                14049396806737399680,
                14044576390503023744,
                4819402246238207200,
                4809004640979239424,
                4803348419635223040,
                4811984509382260992,
                4822383556949577344,
                4819119172704411488,
                4819442373740876576,
                14047358631759256576,
                4827527633223030416,
                4823581603372731232,
                4826333822449531472,
                4824434491347899040,
                14046231939514884256,
                14047839749561180624,
                4823302281790578688,
                4827332296145373568,
                4821004722894627968,
                14043428318609857440,
                14046464745538966784,
                14044430118382302240,
                14046962868751032240,
                4819749396157453728,
                14047720029535616496,
                4815689013086704576,
                4825117483528982000,
                4809049348110900736,
                4822250853185248992,
                4826784585253298160,
                14050013836007357360,
                14038247436067576896,
                4816623911501482112,
                4809721466716274944,
                14032104006738276096,
                14050453813473198416,
                14044827212156913216,
                4825814047818603664,
                14047696222193534336,
                4819935698048810304,
                4820272253567008224,
                14050394096636982688,
                4820961846915642400,
                14050214420523755280,
                14039463322110126272,
                14046654697802883296,
                14049135136049004992,
                4815835742090743808,
                4827103202308012656,
                14046442482662991392,
                14032980059939564032,
                4818178058703800256,
                14031953734386717696,
                14049782453639499536,
                4818455757661749376,
                4825920593060035744,
                4820501258139105088,
                14043400192667825760,
                14049304658124207632,
                4826568395635961696,
                14048703594788780624,
                4820152776394181024,
                14048537087304784576,
                4823344774229103744,
                4816707756803048832,
                14047618536844999760,
                14049775357525453664,
                4814772330083138368,
                4827420245671905808,
                14037924894210417088,
                4809897730877532160,
                4821184383292930400,
                14047543661664225760,
                14048638760050180800,
                14047369323019232352,
                14047849344985776672,
                14046936203645396896,
                4814891176592263424,
                4825387344334058000,
                4826743556251727808,
                14044078116837800704,
                4803341727680464384,
                4827414730611485440,
                14042747480909186304,
                4818124830547924096,
                14048714295026209504,
                4825930031181648880,
                14050487440567268672,
                14046266506787087584,
                4811767368486241536,
                4826682832693370352,
                14035679294129261952,
                4825775857735184160,
                4825030095907060368,
                14022195793590770688,
                14044300021171104960,
                4814518461424370432,
                14049487139996102720,
                14046070997212271840,
                4826268793383341984,
                14040023801552677888,
                14029954758406551040,
                4824383474699739888,
                14044527367765150592,
                4826539774740602896,
                4811936105639091584,
                14046897708320262816,
                14027441443096358400,
                4825937439798110320,
                4824750672857837968,
                14043111181614510752,
                4796984850429614080,
                4824438361337115008,
                4822121441594657312,
                14046875487308859712,
                4825565678444384448,
                14040433727900966208,
                14050835357100859312,
                14049088240414533680,
                4824539341897979664,
                4824390763060039760,
                14046739705553552720,
                14050542238461109536,
                4822375761204541408,
                14047627358704858976,
                14041209662298350784,
                14049975128274292416,
                14047218219103102384,
                14047533272021738320,
                14036558530282903040,
                14050314400576337584,
                14047688371808784528,
                14047400949758842288,
                4824878335747892736,
                14044198019162131104,
                4827413344841394544,
                4825502070144544048,
                4813124933629621120,
                14046538532219547392,
                14048464581086399472,
                14048853380031323520,
                4825899505590411456,
                4824227957268193168,
                4813485207076762880,
                4824938087296934864,
                4825466350429488000,
                4822877910404392896,
                4822033347796440736,
                14047520654944302096,
                4812974512988636672,
                4817513278571148928,
                14039105229129261440,
                4824143723196474688,
                4826438126922600992,
                14046090930232306496,
                14047440142812144432,
                4825821199555780000,
                4825242251935149152,
                4825344557574263296,
                14029362673351473408,
                4824553695908829728,
                4827200774914309184,
                14032779564718697728,
                14047378468772007936,
                4804346442806902272,
                14043539288856989056,
                4816548937806409408,
                14046636351351898912,
                4822567550447625728,
                14048145064544052272,
                4825954776696536608,
                4825275041514837600,
                4825171923706505408,
                14043433243494698880,
                4822057195094010432,
                4827442164502080064,
                14043575592671461728,
                4824512812840564672,
                4820367435398346848,
                4826646780773983472,
                4817971560207341184,
                14035138585708664960,
                4824708695056569184,
                14044840415547853248,
                4794942435704320000,
                4813614598824218624,
                14046864234405290544,
                4825872643584083520,
                4825124448481593632,
                4826732744772695504,
                14047893795576817808,
                14042705121682420576,
                4825368735764351472,
                14045403131278602336,
                14047308711687675504,
                14046962429182494064,
                14049282401120782240,
                4824304440995204800,
                4817506698370480448,
                14046248643692129248,
                4815594164916306752,
                14036920489128619904,
                4822096166890467200,
                4815780323351711616,
                4822621976458002048,
                4818936132427483840,
                14034441510654750848,
                14033409571470493696,
                4826346738386027072,
                14047563968588042128,
                4814699469008606656,
                4823815188190957040,
                14039606925036258112,
                4819847602078066400,
                4821544525797217248,
                4824669260376545424,
                4823927018555261024,
                4812819383269788416,
                14046833901108044256,
                4819283554150873952,
                4826116757227458672,
                14038431583242843712,
                14038390930967815232,
                4820412992442146176,
                14049220816671762176,
                4824956053214170320,
                4820252989827651584,
                14049010785158733680,
                4826039612838542352,
                4815327208107521664,
                14048512799808813488,
                14037068283532484352,
                14044295226939709184,
                14049413994963762752,
                4823925675993854896,
                14046309163702963968,
                14047880879843850816,
                4824707508981109872,
                14045726704666720992,
                4827282687894680848,
                14049460838775650144,
                4826377726238276640,
                4812003281287413888,
                14043601869758682368,
                4823289351738063072,
                4821974746981674656,
                14045243755266945120,
                14046791047058545040,
                14036920018457088000,
                14047797079560177840,
                4824627395782606864,
                4824148908627448928,
                4823488120076808000,
                14048650841191402624,
                4825505594331450560,
                4826573194393033152,
                4822568027987764768,
                14049807963597616384,
                14034175756783419136,
                14041901302763657408,
                14037079691831737088,
                4813686074082473216,
                14030064716923749888,
                14045887661478971488,
                4826118309940170928,
                4827027249126472368,
                14050158947176759920,
                14049354830472744064,
                4815616631111631360,
                4819992598618900832,
                14044194233282059584,
                4823712699055877264,
                4825018352088548800,
                14046897227593925504,
                14041604000149550976,
                14040560266786768896,
                14048967780734609792,
                14047840323819025216,
                14044325931583514176,
                14045547485985099808,
                14046631565103956704,
                14048551069591981312,
                4824794158486501792,
                4811422361474846848,
                4824950247308644176,
                4825111990250182560,
                14043101314036845216,
                4827052454849733232,
                14038017500267018944,
                14040305083250122880,
                4826042980419585104,
                4825342870991037216,
                4824345918573050960,
                14044268591040691904,
                4824232359648627792,
                4819095538717736512,
                4825592566920967504,
                4824155977869705632,
                14032901262052418048,
                4827166364929704576,
                14044702639346002720,
                14027394674715025920,
                14047938656523355600,
                4825724886335524496,
                4823653336949540496,
                4825858236687455376,
                14040328641177979328,
                14046324230905685600,
                14048449633302727024,
                4822633743438984128,
                14041275186719642688,
                14049620416879981296,
                4823596465737975904,
                14046605937688023040,
                4816312569683389120,
                14039205226164440000,
                4823385745818104432,
                4819648477556025856,
                4825755172146410496,
                4825622765449648928,
                4815361583976938944,
                4824713188744657744,
                14049028327055436160,
                4827305698993413904,
                14029661602861399552,
                4817686341641616704,
                14041395471567971200,
                4823997409702007600,
                14046099648078241280,
                14049511999725689808,
                14049142078802085744,
                14043696076429037088,
                4823833498319832064,
                14037873040031993536,
                14036108229920586624,
                14048746745203428048,
                4825437259130218288,
                4823317370725625952,
                14050820871013216032,
                14050256815821251744,
                4802232718919720448,
                14040619075253068416,
                14050296154584916928,
                4826499751522105376,
                4826833756388793040,
                4820342546705239584,
                14049809462564536928,
                4827332662364497568,
                14046990049847494016,
                4827426402078713232,
                4823913864879564000,
                4817588255977783296,
                14047400696779163312,
                4824324443623408960,
                4810325341099306752,
                14048806887871202704,
                14043790796546123680,
                4822761639474895072,
                4816575825813205440,
                4810149439538732672,
                14046549005160757920,
                14047120466166117120,
                4825035325271754192,
                4823843293609031664,
                14050361129275027344,
                14030109335402705408,
                14048576876456287712,
                14048999259784570784,
                4790925337410015232,
                14049980284560711872,
                4826213771281123840,
                14038175791516320192,
                14047381052028298816,
                4825250805728601344,
                14039469659193018624,
                4813118754624969728,
                14042345909057223456,
                4825207612711029568,
                14046821627311010048,
                14049701615942508384,
                4813818125305525760,
                14047325910355584624,
                4825907182981559904,
                14049096289898746624,
                14037167020144745856,
                4824736967870173520,
                4816789162740948288,
                14041582344218197120,
                14047971026127931344,
                14045344112028650656,
                14047662222744629136,
                4822314102716085952,
                4816853376218690944,
                14050052232207516416,
                14045591215317552768,
                14050280918360536480,
                4824732898298706032,
                4827106723794861248,
                4827106688684748928,
                4826431103400572112,
                14037403549302600832,
                14049080723883127296,
                4804363289251495424,
                14030185571426728960,
                14038397699034456064,
                14045714778166485408,
                14048600410042614656,
                4820046394897588800,
                14050087337343283808,
                4811207210550991488,
                4823459273999405872,
                14048204491775548864,
                14047877046328385536,
                4826189115062196864,
                14046942449006734160,
                14035292849025363328,
                4824368563833866912,
                14029830211734635008,
                14042360205479957376,
                14040748725018832384,
                4827417388923238144,
                4824214415418328080,
                4794572512130633728,
                14040704638232068096,
                4826023450780372880,
                4822057102906710240,
                14048575305002802496,
                14049453498414305040,
                14040672410733960768,
                4806661874397268736,
                14048064619753234416,
                14042485457419007200,
                4818454219423700864,
                14050812107621478640,
                4824053940518913152,
                14047032699674498272,
                14040893024799306432,
                4821972793164645472,
                14046447913518408608,
                4814733385354665984,
                4803005377339220480,
                4820997982661777472,
                4813812449711378048,
                14038224756913255552,
                4826217103919067648,
                4807414013853091584,
                4814500654973011840,
                14023677137426848768,
                14049193694176265584,
                14047284826100604016,
                14047244433643270448,
                4826509870751570768,
                14048449038250270096,
                14048445421564885312,
                4812895393896041472,
                4820277622734007936,
                14043465674397110176,
                14035734551323447296,
                4819539715644416128,
                4827016561723629280,
                4820879077951299296,
                14047782665357449456,
                14048229597543700528,
                4823587264191490560,
                4825923755597799504,
                4826905897660217968,
                4810744060330181760,
                14047628793872262544,
                4820301758343638528,
                4810504686841833472,
                4820169556005786688,
                14045916074324387616,
                14049014381670234416,
                14043266343409649984,
                4825544080529000128,
                14049195231911444336,
                4816305309518378752,
                4825892666215854096,
                4820228635692091424,
                14039460297863506368,
                14047457486192875952,
                14027478790385997824,
                4827375209142228272,
                4827475596075372240,
                14048942690042111136,
                4816435754268609600,
                14034411773510640768,
                4825032276685385440,
                4818359447447602752,
                14050104396649896688,
                4817671314828727616,
                4816447939916698048,
                4825021181004138400,
                4816605047621449600,
                14048486843705778416,
                4826505842000732128,
                4825500461705777360,
                14042472703736636256,
                4817734717229416768,
                4809291162203853568,
                14044404169266544352,
                4815914602910284800,
                14048858698130966224,
                14036101460776935552,
                4824869906749882560,
                14038073056611875712,
                4821055069919318240,
                4823726146217129904,
                4824644346638022096,
                4821488729281420128,
                4823232972595818240,
                4815861306409708352,
                4825923761784874416,
                4822145926880519424,
                14043912345987186368,
                4825698727528483552,
                4827496799336028672,
                4827388878526922032,
                14047342903851918848,
                14043618080006794176,
                14025656170871706624,
                4818375882812654784,
                4825192101448469120,
                14048290697117854992,
                4827152212331464288,
                14036861650235655680,
                4827234691243587584,
                4824342384021011520,
                14043981782818117216,
                4826118500189347856,
                14048471797006108048,
                14048861362986108736,
                14046759496182247024,
                4819399305753481440,
                14049043476823649440,
                14046823839356329904,
                4816176769121146496,
                4825786095999036160,
                4826241788276223088,
                4818986940494195776,
                14043162540286299168,
                4822722492022500704,
                14050880285328092464,
                4823751698888846336,
                14048300498998944208,
                4817656981259625344,
                4818536874967188160,
                14045195514416569120,
                14047992542429093088,
                14048809850657987056,
                14016791382348544000,
                4824527203528682176,
                4822702137615992672,
                4819969141731513280,
                14035896674846163712,
                4821407164580298464,
                4810656810818985600,
                14045505777984169472,
                14045739340100364480,
                14047566683676771408,
                4752053734082609152,
                14049958816077011232,
                4817174979660770176,
                14035497289759830016,
                4821984623625848256,
                4820332707657795168,
                14050264520749145664,
                14047303025466811488,
                4827524633316930864,
                4824609681466904704,
                14049962564799521728,
                14048309409744718784,
                4797189451316329472,
                14049391175624572864,
                14048037928382118368,
                4808463840777550848,
                4823655610175715008,
                14046890486795299776,
                4827139455543994224,
                4824062291165692144,
                14048138520258705344,
                14050291427696716896,
                14047562554493802480,
                4822978777890482304,
                14048103010413563072,
                14042417322581688640,
                14050700820548139456,
                4825783824557932624,
                4818927202554383616,
                4808164301425248512,
                14044462280281847008,
                4820008554015526816,
                14046704173389119424,
                14046583594210522848,
                14048108219532375232,
                4824901683177351968,
                14034600529698837888,
                14050873228138384256,
                4825970650938056160,
                4819337656592692480,
                14043378739545879616,
                4825545752452926704,
                4820199722098596896,
                14044880618866974112,
                4823426618700293552,
                14048119187221489792,
                4821469617978702304,
                4823924085889139328,
                4824898702371513600,
                14042556653214304256,
                14042895511619905376,
                14049927365129203936,
                14025903512464595968,
                4825989434132668688,
                14042638914587954880,
                14047248376159271936,
                4825163128923226416,
                14041707578127073728,
                14050836205556948736,
                4811433388398753920,
                14038868351932557568,
                4823470498895325024,
                14050244933080351696,
                14049293595355266560,
                4825546240672869056,
                4826141924215864208,
                14028289912637442560,
                4827331827729561072,
                14047298610156851440,
                14050467202633790160,
                4825326846767646944,
                14044014249753023744,
                4816080187705344832,
                4818560413173935424,
                4820850650591711072,
                14048387854682275488,
                14045320099582269504,
                4825872951407024512,
                14050240230394505152,
                4802732933867449856,
                4824654101838303104,
                4814857720289123456,
                4823915462642254512,
                14042986165354480992,
                14039261896837337344,
                14039830524213336384,
                14048461303041803536,
                14018697476565278720,
                4821699702366270336,
                14037812504947253184,
                4821262929071637440,
                14049822765899686912,
                4824796203103431600,
                4806740995057848320,
                14034053820166908544,
                14048448581552980336,
                14050299546710641584,
                4826614252035880768,
                14049770777747138592,
                14049789067993336320,
                4800811229952730112,
                14048674540297025472,
                4826156229654389232,
                14032335315118612480,
                4790364003619381248,
                4826125868533998336,
                14044038920330800352,
                14047391396420267744,
                4814452009523781312,
                14043674053754524928,
                14050735290451595744,
                14034175436955393664,
                4824023548064048592,
                4814944850516883776,
                14049646918486097728,
                4810418144167598976,
                4827320259443302928,
                14042738094118667232,
                14047726635959205248,
                4827391603372602400,
                4815213772740262848,
                14032927041490024448,
                14036010962913791744,
                4811648836022465152,
                14038660053253260032,
                4823320696941159392,
                14047788010599234592,
                14040664049174184448,
                4817346080097335744,
                4822696317625127808,
                14042955765420976544,
                4822749736868095456,
                4807440476460350464,
                14047107902801890400,
                14048531638141195952,
                4817570981414272832,
                4813629601315548672,
                4824569750345782640,
                4821633959043983648,
                4825469606876584800,
                14050675032572867344,
                14038938372769741312,
                4816684898491130496,
                4824349953305523664,
                14045873936439766848,
                14048099006358527632,
                4824774608527428368,
                4826106306343912944,
                4813515605280634624,
                4810542851617532288,
                4802979431790181888,
                14047910718875129408,
                4825885865135236144,
                4822599683782904320,
                4816442549103467456,
                4827520882371575552,
                4805409822583963904,
                4822394640436706368,
                14043112041065373472,
                14043920380321423968,
                14046222368244592512,
                14041105383378377984,
                4825589209030717584,
                14041005813848277952,
                4823525612521249568,
                4822505980892172224,
                14046698847473091584,
                14046198652065521824,
                14050216727789838400,
                4808889700304526336,
                4824187863070011680,
                4820982992489883360,
                14046443535205793472,
                4818985967885981152,
                4824590689752775728,
                14049755323165779440,
                4797117954635166720,
                14047234474970918544,
                14047967707960953376,
                14040584620609446016,
                4827134377446770864,
                14043399782642098656,
                14049086943138672832,
                14036286968742574592,
                4825428831539644032,
                14050351703285447264,
                4820618771246673504,
                4821753888671166304,
                14049749698514023344,
                14047565878872144656,
                4812281368355519616,
                4821545735149027488,
                4814360522434904384,
                14047269841809463536,
                4826818880800809248,
                14048767300672146352,
                4817089660786771200,
                4824328699688647344,
                4826330049959783088,
                4825474219405237552,
                14042529898353777664,
                14045911615046701344,
                14040779063915970176,
                14048354308363775648,
                4813222816533646080,
                14044282134997088416,
                14050090031980771952,
                4827271456927878544,
                14047543190389293424,
                14050069041780897984,
                4817205539946377088,
                14047551075085999328,
                4818154749411420160,
                4811851224349411200,
                4822867542037627328,
                4816652535647179520,
                14046447335895992800,
                14037700084876808192,
                14047251554064535888,
                14046499755852653600,
                14049968091456070032,
                4819682568827203232,
                4820916056718771456,
                14042499295391146432,
                14042159031019988800,
                4819525742772475328,
                14044307436851058304,
                14037814893308110720,
                4822300462032130464,
                14050291413508816592,
                14047474084194200128,
                14030693945142926080,
                4811865913107018368,
                4822739796415177632,
                14046029358772332768,
                4815637940745949120,
                4820582764103204672,
                14039731535567729152,
                14037544277190028160,
                14033929324348290176,
                4812694965287397632,
                14049328209367101920,
                4825594854553298736,
                14043239976808655488,
                14049153053754529120,
                4815354172699059456,
                4815817954694293696,
                14042362261548803232,
                14045206833773344384,
                14034816333524678784,
                4826910615981259616,
                4825846050844994032,
                14035476247042449280,
                14047632965272013104,
                4826897261774151552,
                14046476870082609280,
                14036143952589557504,
                4815195417778694464,
                14044026400811556160,
                14045420358992383968,
                4821718503690183808,
                14031795509465220096,
                4825309571374527808,
                4827389448398884432,
                14046775619633908512,
                14046806371983507248,
                14049447486936208960,
                14049440506105992256,
                14043677160848197312,
                14050172918142501200,
                14043762569795054208,
                14049934524037237872,
                4826867870261576128,
                4827286835851558576,
                4806143666869979392,
                14048922574192087664,
                4827214449426121120,
                14039999205344759616,
                4826073020979652880,
                4816990759827235328,
                14045615613507186720,
                4823657355241872848,
                14044788239382283072,
                4820811915670830016,
                4820117965313582432,
                4824184546227654032,
                4805372051231269376,
                14034439078448139008,
                4817539105828261184,
                14044307641696930592,
                14046271979856627072,
                14047951184380695712,
                14039693765695234624,
                14047557315560712256,
                4825969509629932272,
                4827538221666079984,
                4820219396764646912,
                4820991796866674272,
                4817541247142691776,
                14044225817051180224,
                14037439556916622336,
                4824457733099428880,
                4823679759637159488,
                14038556262951558784,
                4827438241020549152,
                4819687211860892160,
                14049451345734005504,
                4826284605323864816,
                4825152961927119152,
                14049572812692583968,
                4821040761572401280,
                4819818093690164832,
                4827117322194468704,
                14050679583135120528,
                4821648425909622176,
                14038096139607875200,
                4808674625776397568,
                4819809164432985312,
                4811409762472002304,
                14038883530020770880,
                4817368785957615296,
                4825570609990811008,
                4825392391898120176,
                14042699532495128736,
                14050583730812302896,
                4826659672355578304,
                14045773069910965824,
                4811900109399415552,
                4826384868179719456,
                4826137677250241008,
                4822598014691342016,
                14047549635022054304,
                14042803236689179680,
                4820917015969801920,
                14048220794093985760,
                4825490342405589456,
                14050779192957904288,
                4825430427542135296,
                14038700658918012800,
                4826058423629640752,
                14041540798002694336,
                14043277527130728192,
                4824628043828371376,
                14040916580488203200,
                14050077324647863024,
                4826380063284196272,
                14046589991038668896,
                14050499877900179040,
                4823973675530891920,
                4825693329167187184,
                4826072800579081200,
                14045486880605870880,
                14048373661487016304,
                4826907023128104496,
                14049480417396667328,
                4817725360848926080,
                4818540360628950016,
                14049833783619408960,
                4789738689436200960,
                4818889026841473248,
                14048699032871017392,
                14035626354097818112,
                14040993989110635584,
                14030844108281171200,
                14042981850819225984,
                4824885858604141648,
                14049506138838128768,
                14042570485376980896,
                4824097918057795136,
                4821253448194608512,
                14048100209479694960,
                4821135898288099616,
                14049081478406706000,
                14044517733238218752,
                14046668366931898176,
                14047546260800595648,
                4807588188995015424,
                14050529442169741152,
                4822567646897763424,
                4824052387832233968,
                14049532792484758016,
                14043372367620093792,
                4821782306490755520,
                14042943356258703200,
                4818038684068530112,
                14040559390870544832,
                4827512512636644896,
                14049663201837070992,
                4815967538710357120,
                4809965276574625024,
                14049151600144544144,
                4827524526732729872,
                4821288915894488640,
                4796750543907596288,
                14049685422934961872,
                4825358836984044592,
                4824311776782263760,
                4799820440580381696,
                14037988452810018048,
                4826145508676277952,
                14047095223977211984,
                4826014728301725088,
                14034626616776958464,
                14038708410135778048,
                4820586549683437760,
                4825479486824845072,
                4817855097183345024,
                4815930523981551168,
                14045655197291088448,
                14050309170853145552,
                14047650296299121984,
                4820013468421902432,
                14041297358760458176,
                14042699574526062720,
                4821833443125081472,
                14050108093538474304,
                14030375229338249728,
                14044984721761994208,
                4827070815129472384,
                4826396407918438992,
                4822760694962129568,
                4814440197576533376,
                14047943658896591632,
                4815653495464315072,
                14044463156639709824,
                4820060408129761024,
                4817765066312719744,
                4826710444907733728,
                14046511125764393888,
                14050709392201865520,
                14039897241069626688,
                4821000919479208640,
                14044219509765568928,
                4805027040659365376,
                14050438489462040096,
                4813035256688970752,
                4823851084331092320,
                14012455677553266688,
                4809923512089517696,
                14049960963113202064,
                14030802230154784256,
                4813329603483211904,
                14046152649105750688,
                14042217226154760256,
                4823687529311181472,
                4825023163695672624,
                4825023378770437456,
                14049237787250617952,
                4822947758432855232,
                14049600103051778096,
                4824926332635571760,
                4819524260103066432,
                4826044227063143152,
                14033244570576339712,
                14050687531630496224,
                4823745694549864192,
                4822761204795245600,
                4826379907695171584,
                4827489510798892432,
                14048012016273213744,
                14038694339874021568,
                14036748857082834304,
                14048833197502169824,
                14048217926710073536,
                14045689587086360992,
                14037787259748863104,
                14043097026653372256,
                14044635381777187392,
                14048225041862610320,
                14048770609316029216,
                4804977741722480128,
                4825321224700966320,
                4800220111277785088,
                14043442521272979968,
                4825909089225981312,
                4824513766379962976,
                4823870501696420864,
                4816650998669627648,
                14040121625067562688,
                14044523904667088608,
                4825807870433166736,
                14047057535301194544,
                4823814500642216688,
                14043365899367635232,
                4816406064445231040,
                4826263352627281424,
                14047013970916072896,
                4821117458664213696,
                14044507400270140992,
                4825975153264440368,
                4823120098842564960,
                14034543949629549056,
                4814689783561743808,
                14050029546606905472,
                14041276856331759232,
                4820442159264978624,
                14047799844189071312,
                4826453477726942464,
                14046134594232840576,
                4814890551115058240,
                14046248988448574656,
                14050002085753334256,
                4825866515410765904,
                14044453177905086784,
                4827170700347221392,
                4820931836573598208,
                14049605138965574912,
                14043210774064383328,
                4826597074495445568,
                4814213929796513664,
                14042121901078362816,
                4824713729118017104,
                4823029722794282496,
                14047294620577788448,
                4823328725385913920,
                4821742935851688864,
                14048079577359533088,
                4827369676205252320,
                14049902212472525296,
                4811932235002354048,
                4826518470198570576,
                4822108316021943392,
                4820381392089958016,
                4823746493360387360,
                4818867677990904288,
                4820017553903449312,
                4820957215413289856,
                14040100557547119872,
                4803408029714062336,
                4822217410659601792,
                14038073424807886848,
                4818544598829997824,
                4814019917385576960,
                14049873819441567088,
                4827472511627503136,
                4804697258652760576,
                4822363670461187168,
                4826223681760378960,
                4818371615432063936,
                4825410909472836592,
                14050566737821298640,
                14044970817227698880,
                4820390392873326176,
                4821936539900920032,
                4823385137912684496,
                14045633760725393248,
                14044658673874254144,
                4825856308246054544,
                4803558198063867904,
                14049801508680345264,
                4818015224341775040,
                4825063065994072800,
                14030205757538919424,
                4808802554133322240,
                14036060224228209408,
                14050655370894546480,
                14045256328143746656,
                4813746999852420224,
                4818347686664185344,
                4822523515865525408,
                4822181937430099488,
                14048203193318009600,
                4825641198872371072,
                4818125169991300544,
                4827126309964315952,
                4822324608988395040,
                4811154868835276544,
                14049251929630659376,
                4826790543908816144,
                14048346496416447296,
                14044997500025140160,
                4820997880011417152,
                4826694297030078496,
                4826523585620066672,
                4820987166198646752,
                14028654173445591552,
                14036949535500764672,
                14047472727436919744,
                4825028262747784176,
                4826276512785204464,
                14049002064478769584,
                14045792827528888928,
                4822907025802413248,
                4819093965991109536,
                14050719614483158096,
                14049911185973797136,
                14038255833428036608,
                14045702740511516352,
                14046343786939408992,
                4824803736570329472,
                4820749615190259776,
                14033789142699563136,
                4824664740731543664,
                4810596563945365120,
                4826985991060703360,
                14047104887939171344,
                4822593358103381024,
                14041768820159614528,
                14050179831944910656,
                4822975744517806080,
                4820809442889686464,
                4821657249105344128,
                14049494804715260224,
                4823463545667200112,
                4825091619570902608,
                4816659595849054528,
                14047642041402662432,
                4822617244831186144,
                14048265285144342480,
                14043413586657170784,
                14050544478340453824,
                4818974290900593088,
                14050291639403017264,
                4823188246754458144,
                14049225262847383856,
                14050474355542890080,
                4827506822629080832,
                14040931360994469184,
                14019942073152442368,
                14047451438871506256,
                4810603835864989568,
                14022513656549353472,
                14045788808727580128,
                4824334810630821728,
                14018682891098083328,
                14039957450564285376,
                4822879880281669888,
                14036940283619224192,
                14029354777665927424,
                14048454513306374192,
                4819982392044529632,
                14042767370707103136,
                4822736432620661120,
                14048404593452857024,
                14049283530646971232,
                14045808374076604832,
                14047223903156728752,
                14047180825357952896,
                14048624410072117776,
                14049336048107771520,
                4819554192596037632,
                4827092978433806208,
                4810118552391494400,
                4826692659736847328,
                14046089543596634400,
                4823977352043713200,
                4816203662778689152,
                14049634833079222096,
                4826101002856109760,
                4825429156831265632,
                4827421331538066352,
                4823821455165611104,
                14027597363570988032,
                14050112678498391472,
                14022873427945430016,
                14050471526360541632,
                14048180999441940128,
                14047069482431905936,
                14046182363014307040,
                4794196803435882496,
                4815391253384178624,
                14050180295339060256,
                4824887629352012992,
                14045268277999328096,
                14050307536562943232,
                14047940319558644160,
                14045751264001221984,
                4815876874570541696,
                4825445029765670768,
                14050729575798393632,
                4825801663153120096,
                4817748590413628352,
                14031355845451897088,
                14048852067629400432,
                4823036813032966944,
                14049533748394722000,
                14046772638929125392,
                14048523132918560672,
                14045372429393576032,
                14049214494669939824,
                14047082836134608240,
                4811266020377325952,
                4814774508194516736,
                4809915077152572928,
                4826665247702822224,
                4820143764721380512,
                14046670199595657632,
                4802431421646786560,
                4822641704561109600,
                4824930993783765088,
                4802144404521020928,
                14034780170709607936,
                4821751474473472320,
                14049298800854277264,
                14045421448637922528,
                4814768763870693696,
                4824367268709780944,
                4823884230130873312,
                4815452285659675136,
                14047716253881801456,
                14049013520174956112,
                14050261248405261104,
                4825076658505055008,
                14043594259851181760,
                14038932597036082944,
                4824733526815516928,
                14042570109117421728,
                4822314610181687584,
                4826943684329973168,
                14042508323346198848,
                14035695575419164160,
                14044195475706875008,
                4822256929819681344,
                4824776955382945728,
                4820736289951554400,
                4824587143688499664,
                4824979744300740624,
                4819969571161827552,
                4823147499402255712,
                14043124829693532608,
                4824715988204073472,
                4809412333651321344,
                4817618821739681984,
                4822587804868824096,
                4799921925377231872,
                4822826724302940224,
                4825123135569557824,
                4827471205971946336,
                14047378112159624736,
                4826573071239109872,
                14050398375395817808,
                4826223012403801712,
                14047554599342413712,
                14046204387464520160,
                4824614093765751280,
                14048070963445095424,
                4824920686352845728,
                14048836956503377488,
                14042033653767829568,
                14045220400231792032,
                4824629501893930400,
                4819734906215831680,
                4825443236016069616,
                4826711979761802880,
                4821146484393830368,
                4826777864702804688,
                14047221764860915792,
                14042026417581312832,
                4820285560699197280,
                14047226999559571760,
                4787602508735610880,
                4823936981115367216,
                4823591495175996864,
                14033741879784349696,
                14048361774471680016,
                14050822882427221280,
                14049567207357729616,
                14050567733116709344,
                14044298050788024672,
                4821948804293039776,
                14047944342994330464,
                4824490210950416224,
                4823697657900140080,
                14043900304960523360,
                4824226103093316784,
                14033728005607968128,
                14050398296653486032,
                4815002566237056128,
                4824972401781073568,
                4823399058762957904,
                4821647344827854912,
                14043506142490625440,
                14046900087792493920,
                14026937414561577984,
                4804363751547990016,
                4822396623250197312,
                4819919500543536864,
                14047578144727888400,
                14048505909572123088,
                4824995475208691360,
                14048399882332694944,
                4819662007181144576,
                14045817039662018272,
                4825359733401114512,
                4782900175721742336,
                14048595915477955632,
                14024671839365934592,
                14033702678381508096,
                14034082286008763264,
                14032193188209399296,
                14043823712926008928,
                4815904838782364992,
                4825474027556688528,
                14048453841421097056,
                14048711897358954128,
                4817264954216958336,
                14045790320795312224,
                4825977759322491088,
                4811108932895345408,
                14050619395026507456,
                14047546194496197552,
                4821281558749465536,
                4826323819509116848,
                4825069327449529760,
                14046472657775065536,
                4826943144128455792,
                14041016364621278720,
                14047031318265985072,
                4826657357752326336,
                14050903483722911424,
                4825862329558265952,
                14041830234763096192,
                4821002482792071968,
                14045141090235591168,
                14034120605084120064,
                14041746674067750720,
                14048961147925078576,
                4824506967465471072,
                4810218555031910656,
                4817334227632935104,
                4819673687848678080,
                14047035987480697776,
                4823707647925674800,
                14050753368027079232,
                14050751128734157568,
                4826312425000941664,
                14049998191138379392,
                14044687554861509728,
                14043736602194200768,
                4827197903823811568,
                4827127297527704256,
                4823750329270282224,
                4815125194873689728,
                4827022189289690896,
                14044938720144388608,
                4824680263300379440,
                14049456147030673328,
                14049754162131054608,
                14038077139704340544,
                14048205603808229152,
                14047403131663614976,
                4813495894821509504,
                4825978479301031840,
                4826179911661365728,
                4820574390857220928,
                4823632496301265808,
                14049957197783526208,
                4825427331190650400,
                4825592472852119008,
                14035332547723591424,
                14049499533359377424,
                14049522382471897520,
                4822573083094077632,
                4822226755648871136,
                4826074696507201584,
                14045770062522718528,
                4826439870924835984,
                4821541377173092128,
                14050827733559938432,
                4823910365809511952,
                4820611184836479744,
                4823591249804754624,
                14034788110938435328,
                4810433476642056960,
                14042792414334466048,
                4827329776650402304,
                14049733642563550352,
                14029839347643400704,
                14042240822891272960,
                4815197401178689856,
                14048934715739207104,
                4826327471363181968,
                14026532946730756608,
                4824238593354989232,
                4827534234690181840,
                14050257916270278208,
                14047735853276302704,
                14039907775963307136,
                14050428504992850192,
                14049114833708133008,
                14049449998125502720,
                14040991952554807488,
                14047483726311056992,
                14046432757916023680,
                14048033604615045600,
                4818716246421539392,
                4822517009167618912,
                14034952150285154944,
                14049943432368571504,
                4815949131064252672,
                14044675735970686656,
                14047343592979287392,
                14048640225518876960,
                4826811033709229856,
                4819288071959575168,
                4822927236896679424,
                4823099178847253280,
                4821709943674780864,
                4814678903250604032,
                14050090007387814384,
                14046919834140492352,
                4811583017113625088,
                4821441865138998848,
                14029066363982651648,
                14037031379643669120,
                4823367907325536656,
                14031935670364565504,
                4826031729053701456,
                14030592987771446528,
                14042320154001939968,
                14038163677117582720,
                14049705917369389744,
                14023166337212724224,
                14034028223875524992,
                14049229907346033120,
                4825975422726138560,
                14048824751234473376,
                4820314256783915840,
                14045984979326855008,
                4827144204312868192,
                4823964591121316160,
                4817985657136715328,
                4821500380213644384,
                14044721794582030016,
                4822476391350697856,
                4815605548300137728,
                4813304855034136576,
                4820821160961760800,
                4824830586517209392,
                14050092328835294400,
                4827270122667852176,
                14038816622389051136,
                14037722797843146240,
                4817285703013165376,
                14047855397411323008,
                14048534949378627104,
                4826322119666881056,
                14047594419604411520,
                4818245841206746816,
                14033871995781988352,
                4825203060820458544,
                14044923631564411584,
                14042722353808932832,
                4825303756678937888,
                14038209922191202048,
                14046932769278311648,
                4822034464997039936,
                4807265624864805632,
                14046125009671282048,
                4823673755687687248,
                14047553077547373424,
                14050289850285319920,
                4823402464296434864,
                4813514856479012480,
                4823973674097274880,
                4826697050359314960,
                14047931556667538432,
                14026032745708298752,
                4819254213422082464,
                14050410949763823440,
                14043253312615272224,
                14050286302552970464,
                14047471872370744864,
                14043808468669004192,
                4826165539587482624,
                4820760110085622720,
                14049458073641455488,
                14035821210798496768,
                14046894523026764736,
                4825584863612294000,
                4824635487878757200,
                14047926159819913104,
                4806077858399183360,
                14042978102166706592,
                14040743173511341632,
                4815912675432628096,
                14047950993586569936,
                4819825749892560288,
                4817106096189092736,
                4815477945362809472,
                4824027672990393888,
                4823136474217280160,
                4816765255167841984,
                4826426447667747392,
                4825697785836847312,
                4826148514549848672,
                14018139189444648960,
                14048824640855377536,
                4826087354719701344,
                14045337436546218208,
                4824827062987726160,
                4824303789194450832,
                14033930753729546752,
                14041534810055173312,
                14049572454444343680,
                4826668033060512512,
                4821593613436720352,
                14047908856414982784,
                14040754983644121280,
                14043650093291714592,
                14043971627959739776,
                14048345285746207584,
                4827470481687982512,
                14034972829643104256,
                4825876074492582080,
                4824156051457566080,
                14050241455177549856,
                4824547522687808368,
                4825690118020054944,
                14042449363575596896,
                4826536632009297040,
                14047114662869147520,
                4811474144798917888,
                14048199364761032256,
                14050312744345024432,
                4819427969999402048,
                4823580393309598400,
                14033264272005404928,
                4813017592658180864,
                4818345531655184448,
                4821813430172926976,
                4815949157081662016,
                4825646060944816640,
                4821133920102791392,
                4826755056978629552,
                14048861007595561872,
                4821906485362212000,
                14049526204527277776,
                14049705701990684352,
                14039638815157811200,
                14049572982917386896,
                14047273650490327792,
                4825277340358538432,
                14047367318477927872,
                4824706573041473664,
                4822647582773721312,
                14047804777454083792,
                4827372578751824736,
                4825079779431517888,
                4827160403100192320,
                4824103390694118000,
                14034886834366445696,
                4801829262160078848,
                14039762585011989504,
                4815294276729558528,
                4826894437963996912,
                14042229328219276672,
                4811086186472434176,
                14013526282223071232,
                4809287210836285440,
                14049778182087927344,
                14044732544344534400,
                14028937117232335872,
                4822993231573216096,
                14050613592851272992,
                4827324457778488912,
                4820037198918391968,
                14041102401015397824,
                4825401255649667040,
                4820520102616682144,
                14032065290285577728,
                4819988161791230176,
                4825074429088906928,
                14028093281216314368,
                4825902395936467728,
                14050006555322218912,
                14046737675514665616,
                4808796036947104512,
                4825200938220528048,
                4823969928474717840,
                4825039799455237616,
                14045844224917100448,
                14042067174906836416,
                14050278727575344896,
                4825751062043614256,
                4823706312059070352,
                4825012483574840672,
                4822847443248041376,
                4814659527826940608,
                14050017934257601392,
                14038450298828449344,
                4827245570764288352,
                14048862037354472064,
                4826418814259171360,
                4823913297148910704,
                4816104279061863808,
                14034017109329083008,
                4813095091177205760,
                14048219376269528000,
                14044747138651652608,
                14048904809164598816,
                14047675737241597584,
                14048389781924186112,
                14049688445689735792,
                14049561007035039232,
                4816715160504330752,
                14048289741721088912,
                14045790956092582688,
                14033758530111134592,
                14045903142651934208,
                4819054037742504864,
                14038833284531211840,
                14047432247490239920,
                14037937180325997056,
                4815468126803496704,
                14049489987750221456,
                14048736606123453888,
                14048410273649090272,
                4825205747388996048,
                4818382142166444480,
                4823442846389619040,
                14046852454240607104,
                14047381251339453920,
                4825431114848987200,
                4816210102156059648,
                14048546464514646080,
                4825211768181471536,
                4826410336425282768,
                14049529815677378320,
                14046772419246927440,
                4814906014225211136,
                4812028328282472064,
                14049355839577694272,
                14045307973039600128,
                14043015181550925888,
                14043184442480630240,
                14044695593169561856,
                14047700506902293184,
                14047524065584890544,
                14047207783201930928,
                4827368092493634704,
                14025687234495816192,
                4818213448122143552,
                4824135894511944560,
                4826188062098920912,
                4824087500061719296,
                4824860403265937504,
                14049078248388160864,
                4824263586222235344,
                4814372308045610816,
                14049401025871879872,
                4826513770040956064,
                4826926321838507952,
                14049241687990881936,
                14048206632566548080,
                4825522080418198912,
                14049305165946982208,
                14047149351841519200,
                14046203123113878112,
                14040930842304126784,
                14040007461961851456,
                4814556857962670080,
                4824221088434885712,
                14047420720794598592,
                4801917292426891776,
                4823725261690029744,
                4808429160253275136,
                14044115518076677376,
                4827060715213216224,
                14045820660171675136,
                4815990217718815936,
                14044128444329909376,
                14034025466636798976,
                4826968336662012464,
                4827457089673258512,
                14037713619515486976,
                4820687048034723072,
                14047399391908959088,
                4824843002582742304,
                4824616997766990512,
                4827364691500590352,
                4822706623510900768,
                14044036417534410976,
                4820314385196276832,
                14050578607574502768,
                14047593507232460240,
                14050719269215028288,
                14033437509402462336,
                14047717883930505520,
                4823690402705489760,
                14049101757737550064,
                14046958557282545600,
                4823659171409903760,
                14024758379697304576,
                4801132068328516608,
                4825381563035240192,
                14049621005844140672,
                14049100130676469952,
                14050435179636612784,
                14040930408184823296,
                14048996112254772064,
                4824218254522013936,
                14043401774999325440,
                14030361860190806272,
                4823406631495159632,
                4827399112849435152,
                14041692300575804544,
                4814072169833773312,
                14049266232522196736,
                14049448467368422544,
                14047717269449736960,
                14048917952352454784,
                14044794656751510272,
                4802950731667485184,
                4823743900915225216,
                14048182339037749168,
                4793842383082405888,
                14034211709575233664,
                14048781755939040992,
                4823621822123394256,
                14049552480197563600,
                14047666760619420464,
                4820223605471142848,
                14048228442525089568,
                4822676681465611040,
                4812662680993679488,
                4824752815960458800,
                14026896154810910720,
                4825259576539552560,
                14048498286076379600,
                4824151478002402304,
                4801136464720155648,
                4824889430092670352,
                4826415277196794608,
                4810928722964551168,
                14042286429905445728,
                14048392744814175920,
                14050151719985668320,
                4826992050373487248,
                4816291980325788864,
                14039545878587970304,
                14043631370147431616,
                4819092225593443456,
                14040347530954600384,
                14046783632004125376,
                4823589933606790944,
                14048688399459479232,
                14046207497733367776,
                4810803205586402944,
                14026188340085927936,
                14046618758614173408,
                4815550900307929856,
                4819787244044644288,
                4810642813400592128,
                4817446151690797440,
                14041172904004259136,
                14050034382488672032,
                14048557700185702112,
                4825328991444815120,
                4820215203916191456,
                4815610250177554176,
                4815577598021148800,
                4816242307723599936,
                14048531150030771296,
                4824749835675082912,
                4825918944139598480,
                4821906665940949056,
                4821126800484833088,
                14046407663870124512,
                4814631182226612352,
                14035308017630417024,
                4806955943362115328,
                4825949302261867808,
                14042654450308971552,
                4819002226610695616,
                4816920352321078720,
                4823104680385367104,
                14046083325877690592,
                14047264774843374576,
                14045936558956279392,
                14038987754355189056,
                14046727273650193504,
                14032393852681471232,
                14044501927911542336,
                4819112070292472288,
                14046422359134930336,
                4806436395944237824,
                4826144895517751072,
                4825996881753209344,
                14046765211523567440,
                14050769606019933456,
                4815848057591745280,
                4824413486326639360,
                4810715011400012032,
                4827283648904997392,
                14045200247545704832,
                4821272495297799488,
                4818070754547789504,
                14039722428426476864,
                4825410079729698048,
                14000285193140699136,
                14040974942146253760,
                14047730788081596896,
                4826354336072926896,
                4825532282265360128,
                14044679958358097184,
                4805876032793872896,
                14047495126766447248,
                14049248750835755424,
                4819155539256106944,
                14038840155410299968,
                4824435005034634464,
                4814569590254206336,
                14047765783031600448,
                4813871772627196544,
                4821481839601562336,
                4826641754344493760,
                4824526777896244096,
                4819061296163744160,
                14039944886244769408,
                14039915038434647680,
                4827443872741467776,
                14045585699229411584,
                14032378653259896064,
                4821189559285876096,
                4826370528286312320,
                4824677925515610768,
                14045060943439282080,
                14049901342413930496,
                4813371528538449920,
                14044684542653168992,
                14049568489926521600,
                14036656762722131200,
                14037125842619706112,
                14039738301263239744,
                4823359585567389760,
                14037389131326764416,
                4824088163260013648,
                4820998053844144800,
                4827072556256991424,
                4823551499735679872,
                4825617025705500368,
                4826398773626268944,
                4827079271409614304,
                14040163236363352704,
                4825740876669531024,
                4827053366299701920,
                4823923043686703488,
                4813641184365473536,
                14041923015940546368,
                4826755357356721856,
                14048682357901566352,
                14050182151085603520,
                4820026226778570240,
                4824120137725686144,
                14047927810959947072,
                4821612800595171904,
                14049360691055243600,
                4823430008624704112,
                4808836303728278016,
                14047738652259099360,
                14050365317738478864,
                4823709498600428000,
                4826248400919049088,
                4815770902191781376,
                4821516438339962592,
                4809300794441592320,
                4817901470915381760,
                14045531788116694656,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4830638365936189448,
            pinv: 4383068506908503009,
            mod_data: ModData {
                n: 910395627798529,
                ninv: 4366620577834603101,
                norm: 14,
            },
            primitive_root: 7,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                4823953248388537392,
                4825083993720127840,
                14049275608845979040,
                4824558626898942528,
                4803703128081250816,
                14047217599387735920,
                14045860596578195104,
                4823704989170698784,
                4812117899404575232,
                14029321031068354304,
                4817683911404602752,
                14049274581278795600,
                14041025923768159808,
                14048591530656053200,
                4823224929182377440,
                14044807356283555680,
                14048565011689080224,
                14048449022444332320,
                4824619472446582144,
                4823545490913121568,
                14048194762364833840,
                14043725730480177248,
                4820997252961902688,
                14046969896560937456,
                14047944254408845424,
                4814509113908708992,
                4820477893383007712,
                4822886236437798624,
                14030159836736439296,
                4822273251020797280,
                4824537938186787216,
                4825647061013664432,
                4823728502996949664,
                4821165689330117568,
                4818024201873709568,
                14039361062917015616,
                4821924234251739584,
                4825479218392732880,
                4821220156209760192,
                14023539604117214208,
                14046701094988933632,
                14038513230084538304,
                4825632302374308352,
                4814590346725569280,
                14046991709532908576,
                4800002922553151488,
                4816494586703843520,
                14048611296086688256,
                14048428041204873072,
                4824178991170477632,
                14048490301387049200,
                14042705275438139840,
                4821684822767825376,
                4813424424977668736,
                4803161907772867584,
                14042394905524651136,
                14040982099804935552,
                4806735342721739008,
                4820924352012881504,
                14046277953908248512,
                4818426322503451072,
                4819296472033449440,
                14048201536697058832,
                14045292507001908416,
                4823509433060748064,
                14038811872899390208,
                4823749491126068816,
                14045633668192059904,
                4814957669901982016,
                4820728484829706720,
                4810826174971240960,
                14047010399146799952,
                14047627826635961456,
                4824503278026854640,
                4810778845404246784,
                14018769033322659840,
                4823718911246657056,
                14034213468509213312,
                14048318162641566272,
                14045922188606898912,
                4808715529640919296,
                14042831698965526592,
                4825980062247441920,
                4819934294852330240,
                4824873661851166528,
                4788410949623271424,
                4822667211326123904,
                4819447364204318624,
                4810347438158859136,
                4808913645787965952,
                4821158218039483552,
                4823547875455008192,
                14043959405600712992,
                4810762224885885312,
                4796071786087073792,
                4821113327210515232,
                4823092688685074208,
                4820596459587901088,
                14045872098857687488,
                4825734698328484176,
                4819652954745367136,
                14049375417232557296,
                4822957853727417856,
                4823376422399993536,
                4818342611857321664,
                4812217687694509824,
                4824601140231727040,
                14039279975802662144,
                14040584312719823872,
                4825871844980382656,
                4823533362441899216,
                4823460032919144944,
                14048528666393331472,
                14048620582578066320,
                14047253482568712976,
                4818386184811889536,
                4804993988781171712,
                14048718481021689536,
                14049275508725685552,
                14023555239694610432,
                4812180889514960896,
                4823456411053849280,
                4825959825926376512,
                4821664253171391936,
                4825223272740620416,
                4825599422265346592,
                4825459023037646448,
                4816433534926346304,
                4805921150676023296,
                4822650003309728768,
                14044855148220296224,
                14044851843919453024,
                4822712319063919968,
                14041858962814587584,
                4824084971789193328,
                4823683832102123808,
                4826094734836133216,
                4821042713112845536,
                4810552068489937536,
                14009150108824190976,
                4821288213246124416,
                4815774814643972736,
                14047134923109627056,
                4820656392250524320,
                14047562180646757936,
                14049422473494486512,
                14049504298399032288,
                14044624869283200608,
                14047105636895727040,
                4811057924139905920,
                14046547085047285056,
                4823529845578198544,
                14042634533201991072,
                14047920321929641248,
                4816379969293490560,
                14048766282100756928,
                14046327830295601408,
                4820461407562753952,
                14043906922314265216,
                4804374488389633536,
                4821307016383498112,
                4824810200504819488,
                14048444257415607520,
                4826026480753740864,
                4824466787276303808,
                4806523135315836672,
                4822279514727872640,
                4823036130075245600,
                14043069692977278880,
                14035967625060981760,
                4822948649596260544,
                14048596972578474224,
                4821970848247535200,
                4811842985463049216,
                4824260309925335376,
                4821990808009911168,
                14049120049240933312,
                4823408644246315584,
                4819668409327055680,
                14047298351547703296,
                4820109343585729216,
                4825223498588132640,
                14043550967936567456,
                4815364838631025600,
                4797209284497325056,
                4814174389837234944,
                14040591645354942528,
                14049072477378298592,
                14042760207936687776,
                14048872208147027248,
                14048018172151038176,
                4819409765338495616,
                14038704454474944576,
                14046134763060242144,
                14048963994710033056,
                4818948776086721088,
                4820589624317163168,
                4808445475087085824,
                4823397744013543488,
                14048792545867666096,
                14046568923146552352,
                4817033876557824256,
                4824492821322020448,
                14046849022540854560,
                14034105467648868736,
                14045261550903268192,
                14043410693888634848,
                14046826761071100480,
                4816755163740240320,
                14044755616210738528,
                14049291586897935216,
                4825858830293189168,
                14048239312138930720,
                4783651790069874688,
                14047013225808426384,
                14043506562133739360,
                4822057256751904032,
                4815320473529030976,
                14047620675719663936,
                14048354017908925520,
                4825883180799872272,
                4824372690969326928,
                14046832549511142016,
                4818630927824896640,
                4824484475076486672,
                4824078425153333680,
                14043468921944181440,
                14047066873492539072,
                14039792182053281728,
                14047073419824636976,
                4822188982574306912,
                14046270787629103904,
                4825874270076618944,
                14048815527454091600,
                14048711876016877152,
                14042389048580125600,
                14045841002915635328,
                4824537658458520208,
                4824113124921987520,
                14048823020259652448,
                14046529088258217632,
                14048401133198012784,
                14049455056945456624,
                4821795723484087776,
                14047054645656454096,
                4820149308939004000,
                14025018424296692224,
                4817996996499996288,
                4813706085482655488,
                14049308552360670624,
                4820405028202317312,
                14027587350854545408,
                4818109941484212352,
                14042405548863531840,
                14041703772267821504,
                14047224471701078480,
                4824726043440232320,
                4807526909313088256,
                4821293380873255040,
                14042405776601684352,
                4823468121353609648,
                4821456035857869664,
                14048656217488111008,
                4825102598476292384,
                4810961974498593408,
                4825467610202686352,
                14043694176453104768,
                4821820863778876768,
                4825391895584308464,
                14039154425849546240,
                4808138383129685760,
                4825188621388997888,
                14047648612396323760,
                4820363324486896416,
                14034719057045182720,
                4823645272290631904,
                14049335325575376928,
                4824599323870394016,
                4811024792146314112,
                14042724664691536896,
                4826025145299946688,
                14033715910156323072,
                4819443651062763104,
                4815984832222008704,
                4824229659689360768,
                14045463557354927584,
                4825376651425853440,
                4819438192701056032,
                4817116815552996224,
                4821308831284607136,
                4822633234101551648,
                4812743346687088384,
                14048240421667925056,
                14037641820484748672,
                4816137993421516096,
                4803501548758763008,
                4825525825748241248,
                4815122249009667456,
                4824477335476147408,
                14017203941536200704,
                4824038273196424432,
                14029281820040242432,
                14044126003483769056,
                14047878397914920240,
                14048034874375319648,
                4814986718331060224,
                4819306150039353632,
                14038154729728284864,
                4823482525960242736,
                14045901837959338336,
                14038541098886310720,
                14047338117915928560,
                4823566307707468816,
                14047039770878715472,
                14044569679087154592,
                4825365567720527840,
                4825584344455624160,
                14049442328935842192,
                4823250404931640224,
                4824148534724784672,
                4817980249632793088,
                14044216122860790752,
                14046830544426702064,
                4826128759605670704,
                4812014905373941504,
                14048105824940779504,
                14045417170434438464,
                14048863639040829728,
                14037530276010274816,
                4817922093356476736,
                14035279143420302208,
                14044186296602954912,
                4822342874949691424,
                14038416957021400256,
                4817414357615335552,
                4822844826938921792,
                4824258832129913648,
                14045521092932721248,
                4804206449353889280,
                14047796647945882240,
                4816747602877404096,
                4823903987944072864,
                14032799037965747200,
                4814330751977444736,
                14045968555905400000,
                14048157126397274960,
                14041407820743605440,
                4825174991528644720,
                4810352550957093888,
                4825830854087414848,
                4823018937621715232,
                14043179403893050752,
                4826087643510056208,
                14040404768956755712,
                14045769913846005664,
                4823836853493768688,
                14047675630400060096,
                4825591976428686000,
                4820160704103389696,
                4825977261315662448,
                4820011116443432064,
                4814151471421857024,
                4803280076769162752,
                4819521148737191040,
                14049022167673547760,
                4819679658566226784,
                14047068513268930560,
                14047072616017833792,
                4819378615714481536,
                14046650759539548800,
                14035364453431222144,
                14030053348789753600,
                4825700719359063984,
                14044526584110923520,
                14043957901269283968,
                14049313297550170672,
                14048939875429568128,
                4791216540694831104,
                4822961721116407296,
                4822406362512763776,
                14049082284145589168,
                4820217992215437024,
                14044480275792773312,
                14040788003404518976,
                4822380564178811776,
                4817034878203484032,
                14049313872328390080,
                4818960524102592256,
                14043628023005129440,
                4825269036803627168,
                4823157895937672704,
                14043288357667439712,
                14028276451788894208,
                4805512658545223936,
                14048735525210923056,
                14043744743516957344,
                14041544352493287744,
                14049364012766889232,
                14033296220318315392,
                4816901082524599680,
                4818264975119238976,
                14039628942079135872,
                14048314832662593152,
                14041835736408685312,
                14047337492884856176,
                4820478272354778400,
                14048000513096537760,
                4825065748009982944,
                4822048610394722784,
                14046871100847718624,
                4815811072385848960,
                4824331831052059744,
                14047943547581407712,
                4809151315902813696,
                14046241942888731296,
                4822146993129050560,
                4822096017086327648,
                14044327745697293696,
                4820350550652206752,
                14024521197801320448,
                4823889543663640720,
                4824008856115605200,
                14046140174888396960,
                14048623052416985888,
                4819399009524512864,
                4815024815889547648,
                14044839606423821280,
                14047892606675986032,
                14043455633135033376,
                14046124297122335808,
                4824950207011665936,
                14039856917326082432,
                4822119435580499744,
                4822573960278262528,
                14044640620977698048,
                4821439571202711264,
                4786678533351006208,
                14042177753641602624,
                4821095366244187552,
                14031215686492833024,
                4809909582778345728,
                14036087898714888448,
                4824114371515345824,
                14044583842528841632,
                14049017165550411344,
                14024424309353656832,
                4821193836839761696,
                4824893979607517136,
                4825288280109719856,
                4824156359951471232,
                4824492980103616192,
                14049368081538950592,
                4817993961340249152,
                14048383596497315648,
                14043114754878088992,
                14047293100659476704,
                4797946862342383616,
                4825307821932793168,
                14031166591573483264,
                4815090634218279872,
                4813615659856295552,
                4808247220082154240,
                4817654756707757248,
                4825189900209521056,
                4819285444664320160,
                14040983986961982912,
                4821194793193993504,
                14047192053775109824,
                4815201361173582208,
                14049245296529701728,
                4810994209390792448,
                4826020194031829184,
                4810173151544425344,
                4820522164401433056,
                4806065339722821632,
                4812429038963743104,
                14037730777429739456,
                4823382627940347184,
                4804763631472912896,
                4824062613331113536,
                4820103988356859904,
                4822151469707373952,
                4825752120103231280,
                14048126007571492656,
                14044141848136231360,
                14045426663779173856,
                4821386596066810848,
                14043580103710371776,
                14049286625576349328,
                4817518229588646912,
                4823425813215830224,
                4813031980038996736,
                4809649605305686272,
                14036888054973053184,
                4819701922567040768,
                14037214991419952384,
                4823547303553466080,
                14046123571309766784,
                4800343520334873600,
                14038709976900367296,
                14037866488732471168,
                4818966594847896832,
                4817460729130668288,
                14049056114215253184,
                14043730197059700416,
                4824570229506735008,
                4821237415053814432,
                4817144072762029184,
                4824591333785347776,
                14042584898417558656,
                4788947292574593024,
                14047790630409759696,
                14047550726237428608,
                4822238171356125760,
                4809612428219089408,
                14016609240414943232,
                4824295347346960064,
                4824055408006797232,
                14039796386350428672,
                14047063945169299104,
                14043984014069088512,
                14036685261505493760,
                14040895782250957824,
                4823918355798592832,
                14049312825137551808,
                14045273802766847360,
                14047407748782060224,
                14048183745300366800,
                14045642687482105024,
                14048753373521557040,
                14037835168048565696,
                14046458220779203936,
                14039677876305374080,
                4821227751631967840,
                14040713637218013440,
                14043786070643033504,
                14044335093639923392,
                14048306763172282432,
                4820744701446598272,
                4798425194468366336,
                14034842320022247424,
                4819694546609863136,
                4824575687450819808,
                4823878248212043856,
                4823978141389907552,
                4825570065782731376,
                14037716658545033088,
                4820305726901694816,
                14045699945363178848,
                4825013278618348480,
                4789062431559569408,
                4814784471433347072,
                14048111086211267168,
                14020619167057711104,
                14047369775899941392,
                4815600764618304064,
                14049103172804421984,
                4825873890332338944,
                4823593289310521344,
                4819666153957478848,
                4823237514960742272,
                14027744525602444288,
                4825584569701882864,
                14043665139329496672,
                4823405538168842576,
                14049395684821107136,
                4825668465713925808,
                4820658444380342144,
                4819820867580648160,
                14047295166845210656,
                14044625836677581792,
                4824306993923413824,
                14043277352294806208,
                14017104583530530816,
                14041408743768704192,
                4825337046133245888,
                14043459424015837152,
                4818791005747982464,
                14043484365494872832,
                4814492915334685440,
                14048850156880681760,
                4823474313372550144,
                14049478105414574064,
                4801752853527157760,
                4824412154244619280,
                14048347277736416752,
                4824984710439790800,
                4822677850292147872,
                14048583931900137376,
                14044797665892990368,
                14048733968986519872,
                4824128807849208928,
                4821678795456354368,
                4823730962631421824,
                4806759091449108992,
                4807846115789023488,
                4824499778241538656,
                14044061864598245056,
                4817520835622736128,
                4823593575572307792,
                14034016916414466048,
                14036382201833365632,
                14043567033351683104,
                14028777689424467456,
                14041130407231636032,
                14039161108259370240,
                14042753570276657472,
                14043515335673833920,
                14042764250335561280,
                14045674049059466816,
                4822083705534830048,
                14039932944491941952,
                14046812451228188128,
                4825508675374609936,
                4821856665246076992,
                4822451886731514432,
                4824505200319042496,
                14033938158495151488,
                14043282851803953728,
                4823469851512349408,
                4823627755471563616,
                14047731341168771776,
                14048654130466885248,
                4820895642519157024,
                14036320232891451776,
                14043483891116644544,
                4821966039262706944,
                14047759090244674656,
                14048283538237087696,
                4817325311904711616,
                14047681406781325600,
                4806821252655495936,
                14036988929254572160,
                4824053983005699200,
                4823837402328387824,
                14041921342841544832,
                14044139196087001824,
                14036606647725917184,
                4824282786237130096,
                4816645144209495808,
                4825799925434165232,
                14047788571233848544,
                14045484886748963328,
                14028524439307377664,
                4824434132537116000,
                4813386901685951616,
                14042350400140175136,
                4825772706005453408,
                14047582611626698912,
                4820203911544131744,
                14047681484591723424,
                14048140874029456864,
                4819792003275038528,
                14044795721922856768,
                4817800535066705536,
                14049464148580589792,
                4824402420292726608,
                14044791699938753216,
                14041037612342588032,
                14041863687808391040,
                4824217249110654640,
                4826001519285196192,
                14038296375136873920,
                14045504147248822432,
                4823910714973418928,
                14044658950155976672,
                14034624867941200000,
                4821395930520335712,
                14041084919486166720,
                4824713508867757472,
                14044145840700107008,
                14035463543032299776,
                14045772754813139008,
                4823934497472800752,
                4821887790389361952,
                14045693729910927712,
                4821011501311774016,
                14046651368575184064,
                4819273244675296448,
                4818937185678030816,
                4815006552904790976,
                14046837901756820160,
                4824894121203218144,
                14029417748654791680,
                14043852708649155808,
                4817388874652616576,
                14042420722934610848,
                14047316871774709344,
                4821441426874899424,
                4814488714718053888,
                4823970978275452688,
                14048532072002852144,
                4822797158083407488,
                4818672100457414144,
                14048890263534194800,
                4823706211534315872,
                14049222297326893392,
                4820502980005779552,
                14047822342166140208,
                4803375436592053248,
                14034388047058697728,
                14044718981433919904,
                4820567863148559520,
                14048359635938309648,
                14048692051816816624,
                4812575163169714816,
                14045787787949337408,
                14043431647812779968,
                14039365734592012608,
                4806765885879651584,
                4826078626326100832,
                4824947731783341072,
                14048991121840381152,
                14047181734527671760,
                14039127034250110208,
                14048579771075486288,
                4812404479463878400,
                14046834645793195248,
                14035985937727458944,
                14049325749853941536,
                4821548085463008640,
                4823666538394645136,
                4809514371974909952,
                4825757322419148240,
                4822869662775097440,
                4825511594891152192,
                4819754070485701696,
                14049159941061074000,
                4819970646820991264,
                4824277650513278864,
                14047516265122351424,
                4822572389353899040,
                4825350190125892544,
                14046614883698788768,
                4823654199878109296,
                14035138305084036992,
                4811990183293041920,
                4826035914029913616,
                4825698265038752576,
                4823279320258954080,
                14045043386872232096,
                14032313217007383040,
                14044716117862326208,
                14039912072061881984,
                4818702736289266560,
                4819280411070815040,
                14042535436479928640,
                14041359070074589056,
                4821741215284991072,
                4821200099087147584,
                14043952106648267616,
                4820642937196403328,
                14043577356478246272,
                14035334688054819072,
                4820435266939396192,
                14048260440663814736,
                4811261387761558784,
                4815488970708472512,
                14027137219464487424,
                4823440788349503728,
                14043882337908217376,
                14046627618549570944,
                14047650697836113344,
                14048874955758520800,
                4820531222934491968,
                14045207416096249088,
                4824768247361016048,
                14039494650865925568,
                14046955488514550048,
                14029753947182124288,
                4823491728644163072,
                4819132326111815104,
                14046113486044344256,
                4823212333688003616,
                14047867124922568240,
                4823390081715787728,
                4811210057896234880,
                4825672659316091600,
                4800837885380390912,
                14044424782998466272,
                14046230913752192224,
                14048539060472864464,
                4814841269326680192,
                4818569149948283776,
                14017499162106810368,
                4819798846932783104,
                14048256146398728496,
                14049246514430649648,
                14042747735810799904,
                14043899415607785440,
                14042838619177541600,
                4824699167035684176,
                14043366427858079232,
                4821987329132626720,
                14024981376105126912,
                4823819010093279792,
                4819508395545464640,
                14039112515896504192,
                4824960560275669040,
                14044730414669784672,
                14045641623050641312,
                4807890101022833152,
                4820481868470320928,
                14040582983228397696,
                14045551746283425984,
                4824638423022658640,
                14047656300588076992,
                4825969301827138976,
                14045312358402798592,
                4823577108282775520,
                14033616809426549632,
                4817491117598835008,
                14047711946463647920,
                14017138652370186240,
                4814293604152200576,
                4824102080247326992,
                4825433674921535344,
                4798417727273772032,
                4814324715392750592,
                4812067189281820672,
                14048395574014847296,
                14048049620421384416,
                14043816034495334592,
                4825168853606119680,
                14048077812649100640,
                14031278426934983168,
                4822664076090005728,
                14046283724158469280,
                14046397305112937344,
                14044078079401517856,
                14046696762035599520,
                14044740860603369152,
                14047660498738846960,
                4823406115891044256,
                4819069147344075712,
                4820791313144706144,
                14049342494831757536,
                14042125833078413184,
                14046610092037569408,
                14043206480554774176,
                14047225107883394880,
                4808267773743216128,
                4825259889410030112,
                14048511323990994576,
                4821439076136109792,
                14046728194360194384,
                4819779687808646368,
                4821793955451956480,
                14039616051002245568,
                4825279428809623056,
                4812321188306878848,
                14044417556593216832,
                4802055490669989376,
                4825569268326390960,
                4813353961982797312,
                4821421246022231872,
                4812712769663062400,
                14047912393825697392,
                14029879764366103552,
                14044602560736059968,
                4819389678868075936,
                4819469864864033568,
                14049030020002894256,
                4825809929265716736,
                4823466089207036480,
                14048058366392993776,
                4816327221950730304,
                14044401464447192320,
                14046192040418349760,
                4825800845017736224,
                14043247397321882368,
                14047435935261124928,
                14026278802031792640,
                4818595201097564160,
                14039768967160682752,
                4814951722629826880,
                4820950228631234336,
                4825755955743165232,
                14037600389560718336,
                4816047617698501248,
                4824951705205037088,
                4825155018005046032,
                4814848860227197376,
                14048026684245231328,
                14049313033631808624,
                14043219760842215904,
                14047803494729399424,
                4823453214814382048,
                14046514954384740960,
                14047860897014330336,
                14047450644731600016,
                4822455909461261632,
                14036485032092318080,
                14046976674331557728,
                4819986508671765664,
                4818002125417966592,
                14032538563042080256,
                4825048953203652272,
                14029580896322983168,
                14049174892412748320,
                14044230671416116128,
                4823658494405287456,
                14041956290103877760,
                14043370539869093920,
                14045932750545528928,
                4820745277503115488,
                14042652751282579680,
                4819006166548595104,
                14048886013270025760,
                14044450198352722880,
                14045987899762385312,
                4821132896166465888,
                4820989999654882208,
                14043817331432645312,
                14043702900469742848,
                4823893719766536400,
                4819150065671148896,
                14048997539790314816,
                4824223298867460272,
                4811488256658291200,
                14040895757855661824,
                4814940521819383232,
                14045037166395535072,
                4820979872845301536,
                14042017155350596672,
                14047799170698495552,
                14048843603260619280,
                14046989267163272384,
                14045058189431876160,
                14031860262367677184,
                14044474133754137664,
                4812035333352927872,
                14049037963410711680,
                4825433836344307216,
                14043926239572147232,
                4825513164329647872,
                14047311588323725424,
                4820470992176524128,
                14020386550114670592,
                14046318549084136768,
                4820182586433668128,
                4822980553650086624,
                14036203821106896128,
                4823614865262100592,
                14044926533851591360,
                14046851331722533280,
                14043055454296643456,
                14049412885736566592,
                14037962133299571648,
                14046726545222149696,
                14047233090964272336,
                4820243825114128352,
                14048122226215720944,
                14047785455716015824,
                14034545164818383744,
                4823995569577665360,
                4823327236798981824,
                14038367756990910528,
                4816831357013840000,
                14048180586227254880,
                14038685789818344064,
                14044039710535779744,
                14047089040127758112,
                14037731580207534592,
                4826072655394979712,
                14048772946211184912,
                4825081764317694704,
                4821037360437271392,
                14048712226592224128,
                14032276393761443840,
                14046590115601460224,
                4812202559676208768,
                14048707391287436672,
                14035196666207079808,
                14005118577718411264,
                14042244056269009216,
                14035607602456641920,
                4814352533958761216,
                4816543099905685824,
                14048874608064266832,
                4820994560502018848,
                4810358340105771520,
                14046610122499428928,
                14046528530208643648,
                4825461544937897216,
                4823898034442875648,
                4814367885492178816,
                4822197692549141792,
                14047305180238238080,
                4816145561671869760,
                4824669847616201728,
                14048054343846250944,
                4815756824126371328,
                14041544450269063744,
                4824677648755486144,
                14046840423158103856,
                4817043518068634944,
                14040250979245767104,
                14043758755912371840,
                4821268600956909888,
                14046008919841912128,
                4825392626389228560,
                14042580446738220384,
                14039922328993447168,
                4825630664115612160,
                14041155724508215040,
                4792643680791646208,
                4821483983637609632,
                4826027883545339136,
                4823380272997187520,
                14045598350099886304,
                4822211037250860736,
                14048586166521851536,
                14047316714340847648,
                14046108997129038496,
                4825973181750430080,
                4822731795905911744,
                4820243279775614144,
                14049477753663947104,
                14041400369918972672,
                4826016429988591504,
                14048784505175397872,
                14043559231572284608,
                4825801116114137184,
                4813792139219027328,
                4817120541254506240,
                14048605693470775040,
                4814514237594887168,
                14045871682631817472,
                14038037860458179520,
                14049144366911703168,
                14047078364978124240,
                4821578850101173632,
                14042503800921864736,
                14047585718518784768,
                4823898561283142976,
                4820195917385416192,
                14048131952484830384,
                14048815666915868544,
                14033069274113456640,
                4791109880713076736,
                4816923386739969344,
                14047158716388820192,
                4824938869558284784,
                4825773172994281440,
                14040892554145098240,
                4816392176988898816,
                14047481057265452016,
                4824995365003637168,
                4817178940449582400,
                14041333023725420416,
                4825902518291647696,
                4824224703019913424,
                4818359081892465472,
                14042019507024938432,
                4820115281765526208,
                4825422854567360944,
                14048311046053536112,
                14040554322491422592,
                14047201761315155200,
                4823938414170343088,
                4824131217405710928,
                4818602537712200256,
                14036507693119973760,
                14040174584276268800,
                4824511641089796192,
                4816768193009903872,
                14049417503782867632,
                14045802698487560544,
                14036415098945234944,
                4825806809042773792,
                4821803859698855840,
                4821706560609429248,
                14043950492062286496,
                4806348157045050624,
                4824205771810647584,
                14046840541695864656,
                4820093121819765504,
                14042221118025045952,
                14039033129001135552,
                14024834083471730688,
                14046053268531866496,
                4825747432888281536,
                14034735252829027200,
                4819407444096563008,
                4825776961600077552,
                4825622611514804208,
                14048922431405344784,
                4823575863063018272,
                4826097939875141968,
                4824104640104825488,
                4825229295947606032,
                14048614793357476960,
                14047185989290037600,
                14047918960664482256,
                14048931590782925104,
                4823581891259939136,
                4815904832697979904,
                14047783094569982160,
                14041133873969093376,
                14042764293975414464,
                4824529762334589328,
                14028889369648239104,
                4823571553164030624,
                4824108213141242928,
                4822701387282037248,
                4819210585340427584,
                4825073816309822080,
                4801181965573444096,
                4825273702021404576,
                4822362538534677056,
                4824673292872169056,
                14042715161676276000,
                14035556319780078336,
                14047075390563732576,
                14038193007681453504,
                14049035568577790400,
                4825957900710263088,
                4825075603521313088,
                4824920044992839104,
                14047283042243859408,
                4819866246981433920,
                4819520142077709568,
                4796219354047746048,
                14025696480474423296,
                4808070510798359040,
                14048724072351326272,
                4813791367816548096,
                4824136296419628240,
                14047290770581145216,
                4811613783782124032,
                4824716458215033264,
                14049193684361639824,
                4824887242313707520,
                4823553167882904192,
                14046758600947613232,
                14049472643415484816,
                14048428575969953568,
                14048287845359904560,
                4817278761485318976,
                14036002867647282816,
                4821209578793184064,
                14045674501377842336,
                4824243647453932736,
                4824282339143702992,
                14047145559857134048,
                14025476409726808064,
                4818896932169975968,
                14040906064674985088,
                14048168451095962224,
                14049089748406725632,
                14048704023497263152,
                14048150783587470480,
                4822512835324467456,
                4823994949317633232,
                4815664991151044096,
                14037835844266088448,
                4818544623252718400,
                4823559265504350080,
                14049014372719636112,
                14048726995513878304,
                14038446133556496448,
                4820453953457846240,
                14048728709258864160,
                14049391623685815664,
                4815919554030401280,
                14049436839238695632,
                4807654763886386432,
                14042340011054494816,
                14046143334093746304,
                14046395121339726240,
                14042709817675441376,
                4823218290686018944,
                14039524482455525696,
                4821643517508801664,
                4821344155552875264,
                4815057852126473728,
                4819050196005058560,
                4824769265987336688,
                4780195458809905152,
                14049400165700265760,
                14048264862205766816,
                14044717835737217056,
                4819363063391618176,
                14045211094051997056,
                4824535084576824096,
                14047351529205034496,
                14047316924839105392,
                4823457650360081952,
                14047799523690450976,
                4790675648332267520,
                14042685120438631584,
                4820628442932832064,
                14045168614168261856,
                4815881384862278528,
                4820941785371617856,
                14044037031280312448,
                4819951329614367808,
                4815601513799558720,
                14047524630295599328,
                4806848435573614592,
                4805082018605693952,
                4812165917170155392,
                4825634985135820528,
                14035377770703175296,
                14043620814667969440,
                14037289847389732096,
                4810173282423828224,
                14045091722065906720,
                14047736985873469712,
                14047159734014983584,
                4796843728240861184,
                4822842023823075776,
                14047645847783393184,
                4825262280288905472,
                14046926577037285296,
                4825708274313418464,
                4816375971527638784,
                4816079575756826880,
                4802315244269506048,
                14031407977182087936,
                14042859032938692736,
                4824651513548786752,
                14042403972358535264,
                4815513811610422976,
                4824031751120927280,
                4820368773111658848,
                14047327578405552832,
                14048139784817839216,
                14048903780190245120,
                4824679601556008672,
                4821525365964237152,
                14047980094937954912,
                14046914586551752992,
                4815522155359847232,
                14048766649811889360,
                4825339377984455584,
                14040849116159867968,
                4825380102605593408,
                14028936561556855040,
                4824066714949823904,
                4823685275335365888,
                14048546344076282768,
                14024249881007655424,
                4825441330886989392,
                14042336718477837824,
                14047588027390388672,
                4810559102577410688,
                14049469961464651488,
                14044375115535440608,
                14036526016648102272,
                14037172609928812032,
                14034784115223076992,
                14005883356502654976,
                4821930011170387744,
                14038596110466247872,
                4819832764693149440,
                14047940677392518848,
                14039209994486083328,
                14044608821966055552,
                14041527405263008192,
                4813347701156180992,
                14048738693952185392,
                14047704419943755504,
                4825499083079993728,
                4823793258039762560,
                4825974426075657632,
                4823776888165760800,
                4825076614479252816,
                4824828268633283520,
                4821520245219284736,
                14045103040895871136,
                14040105978725592000,
                14044455540809411744,
                4821255116484757664,
                4820572155642001216,
                4815906244300186688,
                4818301484052122240,
                4822025372794514880,
                4813226163572852096,
                14016126667663247360,
                4825212005243271760,
                4810940255103567104,
                4818038529194043456,
                4808159400565080064,
                4816282564000707648,
                14048007772477561696,
                14047427371050800176,
                14042306618792801920,
                14042378149257190816,
                14049187310313806896,
                4824073156392015184,
                14043790606248614336,
                4821858753777262112,
                4818547565089876736,
                4816342130135081216,
                4823422266196108064,
                4824393098916643296,
                4811688966856403200,
                4822637684602825120,
                14047071538622103088,
                4820556898691694528,
                14039391832509022528,
                14046932837057954704,
                4804323275571257344,
                14042807049188526464,
                14040076212099371776,
                4825319052928248240,
                14040719425333898688,
                4825973161023122752,
                4823424284211613408,
                4823861060942531392,
                14046003355238590336,
                14034118309842195968,
                14049463893476095680,
                4819414672164774080,
                14038950728213323008,
                4820624590894352000,
                4818856612532597792,
                14049292297362220960,
                4824908737594090512,
                14043641611839267584,
                4819515721171865056,
                14047505470388100256,
                14040229780935253120,
                14036385049973158144,
                4824262771965927536,
                14043730052512700000,
                4815552318541366976,
                14031915238178992640,
                4825679069718080144,
                4825650127575950160,
                4822473210592656384,
                4822716798786426080,
                4824280892040739440,
                14029031520201799424,
                14047128722833269424,
                4824517242373028416,
                4824240066839333824,
                14045531873696035200,
                14019910079452430336,
                4820686741244024416,
                4819218099392045760,
                4821061996366075936,
                14048558065279703392,
                4824498885699672624,
                4820014654224262720,
                14047031567580460944,
                4823585548683642160,
                14047419844159976048,
                4820645762754922496,
                4821767849614181600,
                14044019317817631808,
                4824041970730964000,
                14040372688366445760,
                4819023751049888320,
                4796783719874294784,
                4822394878317892960,
                4811255662829104512,
                14046255989154242720,
                14018691780982368256,
                4823906857116502048,
                4824947099868674528,
                4815077993369358016,
                4824676904222281872,
                14049461670953825216,
                4824380393482377648,
                4823092832404079008,
                14047221037352793040,
                4818142618789344256,
                14046053765980814688,
                14034378720987832832,
                4822641344974928224,
                14042740407405435584,
                4824850015132325744,
                14049316634820538352,
                4821006028404887104,
                14034226857388254080,
                4813097240535685760,
                4803528448741088768,
                4825657536779356592,
                4825731288649859584,
                4819872991112554176,
                14047634600807230592,
                14045306340314436640,
                4820772029082735648,
                4821920239224421952,
                4825546438441354480,
                14033205191326861824,
                14047579848110928720,
                4825370371105331456,
                14045662227878121824,
                14044051806111074016,
                14048306009450001888,
                14048758655792713072,
                14044473951699608032,
                4821898022998453248,
                14048433348254323072,
                14047746151592458560,
                4814876098472972416,
                14043734318701961696,
                14049302738815623616,
                14047187847308799728,
                4819219583649028128,
                4823110807455759456,
                4823467586745394640,
                14048951010778301920,
                4817278396609124352,
                4824566251280759040,
                4825218202205848576,
                14042859581684650528,
                4825062579313568304,
                14038947275537904192,
                4823914837506054240,
                4819161919869362720,
                14045357549603490592,
                14049026223845267120,
                14049438853404335424,
                14049308253820962752,
                14030159217023705600,
                4818203778939214784,
                4816425904442885824,
                4821854826531764224,
                14040845777828796160,
                14037951351055134656,
                4814804962303242880,
                14048536593531299552,
                4824570330373403440,
                14047908527096471200,
                14048076993120677216,
                14042792447079171424,
                14047358164534244768,
                4825576172781743216,
                14042995724935741344,
                14047477028768425984,
                14039756904882394304,
                4825390044167561040,
                4820667773681926400,
                14039717477028927744,
                4824648373540873376,
                4825967444870362144,
                14044939894450495264,
                4825456092001724288,
                14043106475575138464,
                4826031093638521888,
                4817979695198177280,
                4822841723383758752,
                4824838658898018240,
                14046841277763714752,
                4814239301420616192,
                4825570989749270432,
                14045386014346263936,
                14038056849774306560,
                4824703473195605056,
                4825584703537205872,
                14043218471419296224,
                4824709831590088752,
                4803862519866614784,
                14032551272601084416,
                14044182426497724608,
                4818620508808124928,
                4823207887549416736,
                4823681047231857616,
                14040481433244148160,
                14034244083461213824,
                14044970558620028160,
                14049033070035396880,
                4814587343372635712,
                4824734172206688480,
                4823780917462373504,
                14045764904282614272,
                4824371193007716096,
                14049365917718006688,
                14047075079977112240,
                14042705639472853120,
                14040412562659582976,
                14045091432669031360,
                4821333853854633440,
                4825375510360198752,
                4819082499160857984,
                14045714299176656448,
                14049081224274257904,
                14041956490390223424,
                4822321001281496000,
                4825742476353279552,
                14049065088377326016,
                14029315677724130048,
                4819190960769378912,
                14042907443872146912,
                4803425732686631424,
                4826072834069822480,
                4815540272732431424,
                14043361673160659520,
                14049248718876758320,
                4825998874078804112,
                14048729476439267664,
                4825809443478487840,
                14048120198493568880,
                14044738514824770176,
                14048873644732655072,
                14047590477313707776,
                14049054856840135872,
                14043451856793396928,
                14022405299356661760,
                4820490648150391552,
                14043256753375672992,
                4824391533925071056,
                4823097374685449568,
                14024508975674640384,
                14045630244377295712,
                14028806457685102080,
                14042650859930931136,
                14047111125117091056,
                14041185644203448256,
                14048985448923763248,
                14043619921060370112,
                14047326906115662960,
                14048657177649624720,
                14048497124548970080,
                14044676923680603392,
                4813171192760564992,
                14043307650283889792,
                4823889382630955920,
                4806692602052838656,
                14048244790539753104,
                14046021874097741728,
                14048023067084921824,
                14042490741265074400,
                14035990249621202816,
                4825824781419750176,
                14044554385485625568,
                14048851215330664864,
                14046943539867223456,
                14029078460959363072,
                14036004473463703936,
                14045606893672060544,
                14046409678468354592,
                14048033822599107408,
                14047971611914430640,
                14046792584439944752,
                14041868153127954816,
                4822659215769591680,
                4825755282921193840,
                4816671974918267840,
                4821115976688527040,
                14042702122733295136,
                4815091505599602624,
                4815605164961396672,
                4810005875329161600,
                4817205759075486016,
                4807657564097075200,
                4825294836739854080,
                14047430437156370704,
                4814383337109266176,
                4823752340651761920,
                14037976023854481408,
                4822235389010100576,
                14043050587987948128,
                13996682174067703808,
                4818033039420465152,
                4825250219623421824,
                14048929583122700144,
                14045052191284055264,
                14035435174872359040,
                4824954400487123472,
                4810887326570066816,
                4772013213576265728,
                14046892975615256272,
                14044222308976202048,
                14049044829453335312,
                4807648011826990080,
                4823158702993336672,
                4824597888008003344,
                4824896899180464128,
                4825714446188229744,
                14045545769439664576,
                4825887631338930096,
                14047101974651363728,
                4818352816021585536,
                14042647971660574560,
                4824116624676444480,
                14036322822408096768,
                4819005108630444896,
                4821308921147918656,
                4820699808843720512,
                14046867958948479968,
                4815665711649760384,
                4820738583016020288,
                4797057068646591488,
                4818522619710394688,
                14043463664252902656,
                14040782616925617344,
                14027069236061724160,
                14043013569888157792,
                4811236931491163648,
                14037732504159876160,
                14044454238352781792,
                4808240641602471680,
                4814261254421637888,
                4824615592094282048,
                4825625882797936304,
                4826107716041171104,
                14049169937769497776,
                14041733767654775424,
                14049386921283965904,
                4817701954404875776,
                14033831974902502144,
                4815017250778785472,
                4819958851594276800,
                14046935395852688176,
                14027703185633212416,
                4821367711502553920,
                14048168060275756112,
                4824981591216558624,
                14037181756105496192,
                14041071860705387136,
                4806131581256441344,
                4824164830901797392,
                14031008769674067200,
                14042638303367250144,
                14048995480723402768,
                4825481810707194928,
                4820843121741740800,
                4824607341824331152,
                4819656791844545344,
                4810538957876212736,
                14045126081814421920,
                4824022596455340576,
                14043776037038854656,
                4825432054744660400,
                14048198840929610432,
                14048295951799414848,
                14011745542449807360,
                14043397204078868768,
                14045984386075468544,
                4821102207098806752,
                14030805302206060288,
                4809929375606476672,
                4822819582539387360,
                4818743293603630464,
                14042480325243741504,
                4822577150516546720,
                14048792005909866800,
                4812226271062418304,
                14048267016365053680,
                14045053738879417888,
                14043403185992236736,
                14038848117672041920,
                14042495632758302944,
                4825203403940055104,
                4823155601414092352,
                14042292929242555936,
                14043295705729395520,
                4824390256797995088,
                4824788576253410176,
                14039117549342101440,
                14046929448794273792,
                14045938525766895168,
                14047180560100179024,
                4825636041992423952,
                14043010637192762368,
                14047184546528746640,
                14036249651858988800,
                14040192401804557376,
                14048692200692341200,
                14042836114031696544,
                14031744324563649792,
                4824591506722032912,
                4818153786178878464,
                4820558019365270624,
                4824797307342564736,
                4822260355243384544,
                14043594517210427136,
                4820590286483827808,
                4818951146682830528,
                14045407653358760832,
                4816400647425864320,
                14048869907398063056,
                4825185492861331312,
                14049151211878298592,
                14034801237514465152,
                4796992939868878848,
                14038392605521538816,
                4810724391398766976,
                4823181724992309056,
                4817100580799474880,
                4819699672687728800,
                14043901784075455680,
                14048977913582474784,
                4824636694958947728,
                14047408189128739904,
                4823811888465729744,
                4814473862462062912,
                4816366796509624128,
                14049139232926434144,
                4818730331126065728,
                4815298740199792640,
                4800661970276634624,
                4797534822088979456,
                4822244154465125440,
                14048447337676907104,
                14041057052061026752,
                14040773298390113152,
                4820612934798466784,
                4823318431755368448,
                14029556916406815232,
                14045944328776929056,
                4824845315896753296,
                14042583567146315488,
                14047737192188980240,
                4821462247596004288,
                4813595094717716992,
                4823616883218023072,
                14045212025504628480,
                4813108904091509632,
                4818469734389131968,
                14044757486455116320,
                4816972518788146816,
                4819683002147815808,
                4824173819060184320,
                14039450015401213376,
                4820424705743848000,
                4820839725594160224,
                14034551967967741184,
                4825080499778044544,
                14044041589466984160,
                14049039333486054336,
                4806602919535342848,
                4818700011736314112,
                4822538523765737280,
                4824382965078694896,
                14041902772234098304,
                4824237288610453360,
                14046831556157034720,
                4814845785237918720,
                14046897622289712064,
                4824620131882342784,
                14042532972881543040,
                4815119674515879424,
                14047947513181789952,
                14040451477640662784,
                4821208121540503744,
                4814053300957567488,
                4821819844351069728,
                14047629914344027488,
                4817958729685370240,
                14031770142241237504,
                14044352450847890016,
                14028092292329113088,
                14049173855662117136,
                4821489147587003520,
                4825393231510414816,
                4816587896926043584,
                14038669045262392000,
                4826112081390253296,
                14048244149719511040,
                14044978304958092704,
                14042879469581325280,
                14047990989255782816,
                4825409723702621872,
                4818884777805559648,
                4816419155821253824,
                14034919406712995712,
                4823133687202126016,
                14038607720124004800,
                4822286561576807616,
                4822260931419015872,
                4813012055893198336,
                4820578923075325088,
                14038140370196862144,
                4824382268923450448,
                14043567278679383616,
                4823552579815315664,
                4821790270410893792,
                14048132096760867472,
                4821978643873519488,
                14048188087888229328,
                4825499609220579008,
                14047984753749767312,
                14042466327433861376,
                14029893333343486976,
                14047535968311779152,
                14047557452438877056,
                4822627378513280768,
                14036818453481021568,
                4824912654509633600,
                14041726746972559552,
                4824106279155864304,
                14043418095994417952,
                4803116275213315584,
                4823566597828160992,
                14041761321219023168,
                4810379818947513344,
                14045510424921823168,
                4811754761000817664,
                4821906632488989728,
                4815096383337692096,
                14047542845157394032,
                4822848993038502880,
                4819456631258319904,
                4822727259725573408,
                4823986910134373760,
                14047170596937602672,
                14046897254727875200,
                14040077344334118528,
                14040899048908620992,
                4823375846897111936,
                14041781426061703360,
                4824641192445356064,
                14022268178799889408,
                4814129730951775744,
                14048796573012468000,
                14042399171867924480,
                14045954719682565472,
                14046545194540246208,
                14045244851398842912,
                4820272687960210880,
                14047390047434165312,
                14046278831698285024,
                14037436958055175040,
                4821776659163575360,
                4824543825542467440,
                4811482767314956800,
                14040288803249597184,
                14035253240151331072,
                4821715884245035680,
                4819051953633670048,
                14048840184787734080,
                14048461930705752720,
                4826104299469651376,
                14046954350179926560,
                14048799971822595072,
                4825956652400283616,
                4814585895407026368,
                4816118928550544320,
                4825693321851677632,
                4824306772860527616,
                14046145695133705248,
                4824670895886044224,
                4824984420502205040,
                14046757309880988608,
                14037850422373253248,
                14040490362389863872,
                14048655952136170432,
                14040361922788276096,
                14044513833750573472,
                4822074760257551456,
                4819897032723333120,
                4821879424832142688,
                14041645708105249728,
                4822698100372988832,
                4769382678855090176,
                4824416239948476480,
                4824184770882028192,
                14033286647956071808,
                4824277990100371312,
                14042677436634696640,
                4825796985200076944,
                4811934966415820672,
                4824956497349613936,
                14049080114768413008,
                4821302276642317472,
                4816185732763096704,
                14041003154558285184,
                14041849722295935872,
                14042095665098442048,
                14046765349444140096,
                4823417160342708560,
                14049055943231807040,
                4824356156037244096,
                14048712769202459344,
                14049022432231894896,
                4810481548198206976,
                4820793766834305920,
                14049404426116073056,
                14026584218614313472,
                14046377525596372096,
                14037160552242612480,
                4825438237651103216,
                4824565539385965472,
                14047353912631895904,
                4823743228092602720,
                14044255753598116768,
                4818043524384019648,
                14049428144266440144,
                14049369226999554080,
                14048685168941676432,
                4824652422686914944,
                14049419684778306848,
                14047127409917783088,
                14034528702478299648,
                14043533643187181824,
                14047132377292058128,
                14043460673816996512,
                4783359583883214848,
                4822006319237000224,
                4822194500623665824,
                4794675492266926080,
                4823265792846555648,
                4814027937094236416,
                4824101655379145152,
                14042950922221528320,
                14038325207794778880,
                14048750879072725104,
                14030844322825829888,
                14037622250831881344,
                14043920401321528448,
                14044784105639808896,
                4815462022231653888,
                4816124197111810496,
                14038723667232665408,
                14048595349410294032,
                4825974137205583712,
                14044105223831518688,
                14043938311348614304,
                4825069442163264800,
                4819112179562838976,
                14040654754187275840,
                14048751193535242240,
                4815308145543523328,
                14015422292051261440,
                4825351676772921680,
                14044350090446031008,
                4823682496192554288,
                14043174864867054560,
                14037309698334639360,
                4801028987059078144,
                14048472544522176304,
                14048164459519026144,
                14029598524037666048,
                4823225613997541408,
                14046185289839958784,
                14044193389445317440,
                14049255195022175248,
                14048842451255185088,
                4823391854863890256,
                14046618366497075616,
                14044850773938128928,
                4810830775688146432,
                14015786448413880320,
                4810501707121132288,
                4812642632825899648,
                14042998384337562816,
                14044274816819490304,
                4824861648590340496,
                4824286565732335904,
                4806941321644365312,
                14030487126634521344,
                4805598864205244672,
                4824392085685162880,
                14043011847145156224,
                4798442266469725184,
                14046134534072593664,
                14042268165205901152,
                14047295748668881856,
                4823266060931175840,
                14043605609315993760,
                4824097695465351360,
                14047846618118058976,
                14048031471485058032,
                14047275204363369904,
                4807462349740220416,
                4819511344131059328,
                4823729613383934592,
                4823811170184019904,
                14036097919948041088,
                4821699566704247104,
                14048032517521740160,
                4822614747095277088,
                14044354243816428992,
                14043805724068549792,
                14042374067959400640,
                4812518790674045056,
                4823884912164455056,
                14042236504579985536,
                14049406471192098288,
                4825030496684047040,
                4825186483886753392,
                4823783518265645696,
                14045271666221143328,
                14037005880688230144,
                14037060398469251968,
                14047550698584150128,
                14038042917576651840,
                14048356879725605344,
                4824802777396462672,
                4820084697453743680,
                14046059821839046080,
                14041621992269793600,
                4820953398134286720,
                4824272495401843664,
                4823672112317320864,
                4807244252795201024,
                14039447917070851008,
                4820221792489145312,
                14046263992910333824,
                4820378214053610048,
                14049305241114861840,
                14035582490745490432,
                14046940638736251888,
                4812361753545414272,
                14044355165553484512,
                4824471852330480032,
                4823832628572480688,
                4816229459415984000,
                14036360707813798784,
                4822332225055689216,
                14045966870913586560,
                14045537307402781376,
                4821633100838645376,
                14045828351767763296,
                4824388769982014544,
                14047059316928551392,
                14049202112606955200,
                4811395280921612032,
                14049478264043877760,
                14043068542761814656,
                4821928761914013632,
                14043654340270384864,
                4821063345988320000,
                4820497088082072864,
                4821630392490327360,
                14043904291594592064,
                14044468838323855584,
                14046506042023143904,
                14028389909469078016,
                14048686219154726624,
                14045528671236498912,
                4821146503347831040,
                14040778038683541248,
                4815926276788897152,
                14046626749148089344,
                14047026658313383680,
                14048969457063630448,
                4821462222995653792,
                4822300136827196864,
                4811826401062109824,
                14042960056612821888,
                14039967300100255744,
                14049466609464251024,
                14037796681763199168,
                14043885509709874080,
                4819851305991772928,
                14037974093083905024,
                4814429736733341120,
                4814576073597498112,
                4824958556196312864,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4828949516075925512,
            pinv: 4384749916449448183,
            mod_data: ModData {
                n: 699289395265537,
                ninv: 11253674057546036186,
                norm: 14,
            },
            primitive_root: 5,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                14043622169812404576,
                4820260646800627072,
                4822573843679186272,
                14038877097332927808,
                14046789977532042656,
                14040713522786628864,
                4820318765268317568,
                4816131317178144384,
                14038210499179756032,
                14034957500497820672,
                14046779774437867536,
                14046128589799704960,
                4820756715955919520,
                4824138563762302192,
                14041563707511352064,
                14032199640911435520,
                4820094505759813760,
                14043445196645936320,
                4799321977349047296,
                4822760672783583840,
                14044080953280510016,
                4822523068557746592,
                14026336481545697280,
                4818294762781998720,
                14046537768768901696,
                4814149164508726912,
                14044679199084454432,
                4814454491016390016,
                4812371157287901440,
                14030047316150949632,
                4814010356613300352,
                4822158243140402464,
                4818887362516281024,
                14044694573841889888,
                4820981925724966464,
                4811888475589693824,
                14034062459116458112,
                14047005782346875232,
                4822729425437265248,
                4823655726712856848,
                14043037793104442784,
                4820917078078769824,
                14039972651024706688,
                4821888537163889760,
                4812395179851828224,
                4824016768529508592,
                14042680746024769984,
                4822441165244596544,
                14044515236017049568,
                4819206254053179168,
                4822883195612228256,
                14046379120446889120,
                4811091376783488512,
                14043437165170076608,
                14039185161466973888,
                14045508837599775648,
                14039892832563519680,
                4820074524887993920,
                4824101005073826768,
                4817518632395394176,
                14046934402978041536,
                4810925620462777856,
                14042667939352407456,
                4821996414453731744,
                4824050690961512688,
                14045054452615266784,
                4811410312514628608,
                14020667972812045312,
                4817607100219359232,
                4814368951648908736,
                4817564953312376000,
                14043752184207923712,
                4823907058541388384,
                4817340186786187840,
                4801444388224095744,
                4817743510261775232,
                14041537792859798080,
                4812242691984983296,
                14043873430346643200,
                14046720773401538080,
                4814253760473245056,
                14043187474037793632,
                4820601772358799648,
                14045432882452764256,
                4820900973366881312,
                4823671623248192832,
                14042375358230552064,
                4822961560921908832,
                14046341684750854528,
                14034872908559974400,
                14045673850935154208,
                14029268316669150208,
                4821975219248184416,
                14037881574677811072,
                4823647178519455504,
                4821648941924734464,
                4824171319922972672,
                4823438770983749680,
                4824247795801318816,
                4815867839057086912,
                14037724999193881920,
                4817548391051320384,
                4806258190725730304,
                4816520467902283456,
                14043313577414176320,
                14038527723907451456,
                14044074853032869344,
                14034096991020673152,
                14043968160581506752,
                4818777410307253056,
                4814642181812998400,
                14044350324362495744,
                14043368496364589760,
                4819821581630061760,
                14041349104641567616,
                14047163315950227552,
                14043554826534533856,
                14047189380119438624,
                14044858954455262176,
                4820128832851998816,
                14047428064220476624,
                14044274040160876864,
                4820829726595801184,
                14042039755839511232,
                4822419882713052896,
                14037225492272940416,
                14046963845062170688,
                4820099090541598848,
                4823852019483065600,
                14034248747490327552,
                14044643570980827488,
                4821556909575146880,
                4818430834453135680,
                4821928841695917504,
                4823156828571927104,
                4810889972902040448,
                14046509955294258784,
                4824093576705813840,
                14041590503602655488,
                14040098001600446528,
                4820280809288724000,
                4813907434516782592,
                14042429183096496160,
                14043674829125885440,
                4816282725486917504,
                14039992787601905600,
                4814216617720513280,
                14047535996141040896,
                14034239836294137984,
                14041030856545134144,
                4810871949714195456,
                4819451437098533920,
                4823901371604669360,
                14039765802660186176,
                14030019569933987328,
                14041675386841725952,
                14047633612471047648,
                14043614323179790624,
                14033790638749349504,
                14033888789444894976,
                14037349057875565824,
                4806766194143211776,
                4823799573121956848,
                4823402433425703664,
                14040937207348252800,
                4820360742863475776,
                14034832389925438848,
                14034493482725009920,
                4820354681490794912,
                4818482190339795136,
                14033530162271277440,
                14045119797399565792,
                14043340740026992864,
                4820667382640596384,
                14047694009375627424,
                14047024917097743232,
                4809923789654065024,
                14047591276808957888,
                4821532897338383008,
                4810432822819576192,
                14037419401854811264,
                14039134448345630912,
                4819941097337078528,
                14041365389354265728,
                14045781663357997760,
                14042237466566778272,
                14045509568781967264,
                4818103450094096256,
                4823932290543593264,
                14046215671105456032,
                14047246413984495360,
                14044429366592736448,
                4819953078662576448,
                14044459359221533248,
                4819464507767685952,
                14043353343820478368,
                4816611966817897472,
                14045655143175751808,
                4814681875637925184,
                4811093334935509760,
                4820033184784169280,
                14047281546861695424,
                4814961490307933312,
                14045404447320625792,
                14047676172173846944,
                14038633807406693440,
                14043407695779075424,
                4823044641922566528,
                14047407281020006304,
                14033912883990579072,
                4815601122006018176,
                14043047140831385152,
                14037856019262704192,
                14047038263980883312,
                14042047826908587456,
                4820380867193468096,
                4817816531671256704,
                4816212912883396544,
                14043501535211092224,
                4823429979313086192,
                4820042440627305376,
                14046793868041777232,
                4818885770280867840,
                4819034605394032992,
                4819571796108807616,
                14023453306044328960,
                14045650647085269760,
                14043801547175169280,
                14046186570240108192,
                14047483681688135760,
                4821290887276774240,
                14033217278498342656,
                4819911857498680384,
                4808340188163989504,
                4815333207238273152,
                14034832845719066112,
                4822135365517782624,
                14039789843977418432,
                4803668765432732160,
                14047583816746123984,
                14046640226131609408,
                14045008295670867552,
                14045933732607524544,
                14043978625119140128,
                4824058248590978832,
                14038404182674419008,
                14044118930343270304,
                14039883046456645312,
                4821081913489825184,
                4814398025824142208,
                4824058901242842592,
                14025075400061671936,
                4822122106120202304,
                4819808804479115104,
                4823466419039476496,
                14015804925431586816,
                14046689924603614592,
                4821092173317015936,
                4811433636320527104,
                4820701025712794304,
                14038668452057523456,
                4819142796082036640,
                14030291785226319104,
                4822534139109102592,
                4819974328558699392,
                14047111197194485808,
                4823522585981342080,
                14043326400199287328,
                14041158113909547776,
                4820066968442715744,
                14038284821883315456,
                14046454559332973696,
                4816863152391875264,
                4801844642556047360,
                14030838457869437184,
                14044245485609018624,
                4824002761257276320,
                14047201605907862880,
                14047470344364679248,
                4823442205683944784,
                14039136091797708288,
                14042829870255358208,
                14042453736200543296,
                14046510112333758656,
                4810111882680845312,
                14035030130417796224,
                4823962173626402464,
                14042029922203515200,
                4824036221686191328,
                4819518786094181344,
                14043580622539006880,
                14045400293764423872,
                4820862570444941568,
                4809348836144409600,
                4820028051821109856,
                4815527810206517120,
                14045228816188525568,
                4819164213445513280,
                4809646368961016064,
                14046452663811927744,
                14025694194603387904,
                4823117543791448768,
                4821122636779388160,
                4823108859459870112,
                14032294317663131392,
                14047756100522196192,
                4823676480650987600,
                14043736326378521216,
                14041549032997534400,
                14031469241185101312,
                4812466407924748288,
                14047509160669308224,
                14047414333192198960,
                4824002467170509904,
                4821858009671189952,
                14040091836428805376,
                4822217370431250304,
                14047425005988311072,
                4814830103186837568,
                14047702057678751104,
                4807940491001978368,
                14039263309563137600,
                14046872156462453536,
                14034447162012730624,
                14042465887387803200,
                14036592982926213376,
                14044786340166289376,
                4824386400086355680,
                14043005857572139968,
                4820781543195351520,
                14038020901410037952,
                14042573320898817184,
                14045202238081672352,
                14040836508132771712,
                4815950739044206144,
                14046604953799357504,
                14043569712193431392,
                4817652991098281152,
                14047679835368999936,
                4819860404236049408,
                4816338417212381952,
                14030471744253419520,
                14012962421188407296,
                14043206600420825472,
                4822510664899144160,
                4818457576664356096,
                14041697943456771712,
                14046058705042125280,
                14039167911876574080,
                14035851575353102080,
                14013054850496634880,
                14046044976447218976,
                4823751821983431264,
                4822984316768337696,
                4815844127523398080,
                4814375942658755072,
                4814695690189876032,
                4823454173919204272,
                14047452212117662672,
                14042812125404062624,
                4819865431687444928,
                14045802026688278112,
                4821003521003799040,
                4808364794116682240,
                4817807316505935936,
                14037581177733054976,
                14042043248586366656,
                4820046458460908800,
                4812164612270672640,
                14046654129173130560,
                14047028683554418048,
                14045526640024013536,
                14045713671736887648,
                14046738285767606768,
                4819325252867581280,
                14037301465152720256,
                14021796180965095424,
                14043033520629742176,
                14045715766151803456,
                14045134234030252544,
                4821090419031665888,
                14043632688864235552,
                4814443574702891264,
                14032540235963274496,
                4818856530772798976,
                14042688069984519072,
                4817056524521545024,
                14033846136224726912,
                14046877321506387296,
                4823540057395483472,
                4819961233825566976,
                4824084153442196256,
                4813323162036251648,
                14047054658779337024,
                14039636265290296832,
                14046370224734734176,
                14011988691951890432,
                14045068111392108160,
                4808841565679293952,
                4824175760497460256,
                4823879744258072640,
                4823616708974570176,
                4816122353194917696,
                4819608760767729760,
                14043333733207115680,
                14041581415907576832,
                14045553617792299392,
                14032720118534142720,
                4818669332546279616,
                14026377232137765888,
                4820410821450748864,
                4816202042025028480,
                14039750124826510656,
                14046402519547720960,
                14046982624331150976,
                14039216802048463360,
                14035620496669053824,
                14043994442163451136,
                14044603530843385440,
                14047197749305031792,
                14047202301398791712,
                14045478327086566240,
                4812835584192394880,
                4809948737117772416,
                4821199302567040352,
                14033665550503202560,
                14038156641033573888,
                14047225690915886032,
                14047136181268232688,
                14046071615915710912,
                4811781641904160768,
                4821898166512144480,
                4814572013159245056,
                14037225920096226560,
                4823594233837227200,
                14046196277058815424,
                4823884165551758928,
                14043315232960542176,
                4821175535986151328,
                14042616457197594496,
                14044319524801472672,
                4810593049454641664,
                14046956031271516480,
                14041306620889620160,
                4821493126648458816,
                4817591451093321152,
                4800838502195677696,
                14045807721087566304,
                14044828202376958656,
                14043037583512972480,
                14033463612184828544,
                14041327813539761024,
                4817384796826576512,
                4810658033262625152,
                4821734735177489536,
                4821667046011553728,
                4814614355515668864,
                4818695820502350912,
                4804051854443058688,
                4823673616019886528,
                4823004514785253600,
                4824285018759717328,
                4819434538446183168,
                14046870845312110960,
                4794221853083949056,
                4823036053742170656,
                4820491386959525184,
                14036553047416682112,
                4820904373366483360,
                4823966639664836464,
                14047143128583705520,
                14041888647535081792,
                14038351455690147264,
                14041402637267737088,
                14046563369396852544,
                14044405222571455168,
                4821733245809106656,
                14041296320886141504,
                14029182595785412096,
                4810613454136512384,
                4824155311598023840,
                14036554454700787200,
                14046783552962743856,
                14045739126607319712,
                4823717255777627008,
                4822117072162131584,
                4821325161344766624,
                14041339293954118720,
                14032983494146037248,
                14043727192940695808,
                14045730233505128256,
                14035457906643770112,
                4821444944054979456,
                14044211377564050880,
                4818964265012595456,
                14039140048919979328,
                14043954114552936320,
                4824258882281306800,
                14024314903945856512,
                4816051272643639488,
                14033098932633552640,
                4812856766119812992,
                14030655565170129408,
                4822232571614508224,
                14046864565567694288,
                4817030799777859392,
                14038747192528326912,
                4824330384189775440,
                4822504753350063712,
                14031812946410993664,
                4793487639464667136,
                4820840318078287136,
                14042963498816043264,
                14047403077778826064,
                14045770482712163456,
                4823971822618995008,
                14041709635758112448,
                14045422595035857024,
                4819934385958348768,
                14046966949366733968,
                4823788193090275552,
                4818574439711966464,
                14042366643440688096,
                14040679777762224256,
                14036475782379602304,
                4823090045290943968,
                14045193000021854336,
                14047210510611244496,
                4823370883855062656,
                14044192438102974400,
                4823172849935395680,
                14044225369908184288,
                14034435656948726144,
                14044595568539341696,
                4819843238134021376,
                14039236751501446080,
                4815999922638303552,
                14046506960797797920,
                4824202189178808784,
                14045840884842992256,
                4823496428407902272,
                14037259741467357056,
                14043622418241040704,
                14043059494606156928,
                14038156977094539968,
                4783978436742053888,
                4818132683076678656,
                4813426806276434560,
                14046746601476066048,
                4818996469832819360,
                4821908214814757312,
                14045129393805524000,
                14043555536151410144,
                4818359763290334144,
                4816531298906286208,
                4809050785284685312,
                4820687565394306912,
                4814962452183171968,
                4816748216926943616,
                4823363748359853632,
                4824154252412549984,
                4820166780470940416,
                14047237557269939792,
                4809009933805922560,
                4813083720545387136,
                4817310522289793216,
                4808193529407754752,
                14035993606406228352,
                4822839965905744352,
                4816286824866341632,
                4824398709287367408,
                4817951279683016000,
                14035220148909657344,
                4809375484956807168,
                14041757651118764928,
                14027307665113732608,
                14047205508875497056,
                14042499981999691424,
                14032227273470490880,
                4822126230674729568,
                14043123241540916608,
                4807652468853835776,
                14031133270441010688,
                14042360401905887168,
                4820914221227115200,
                14037435489212567168,
                14044084425749825696,
                4802179898236015616,
                4823551942955099344,
                14046918219052111920,
                14026823325253606400,
                4796095687483103232,
                14026789765757129216,
                4821147753823584864,
                14041818953012312448,
                4823163643539026048,
                4766042926904115200,
                14042311063187861824,
                14043677731116685632,
                14023518806729462784,
                4817883846808087040,
                4820457992998218944,
                4819872476039679008,
                14041368555148452672,
                14044912701208465792,
                4815929607722593920,
                4819988750094976960,
                4816627786067625728,
                14047223259176871584,
                4822490460766517888,
                4823483232183730720,
                14040846908839080896,
                14038974442322030656,
                14045074022424090048,
                4798963152046280704,
                14037957902305924928,
                4821690006425703744,
                4823411257956384368,
                4823992799853228208,
                14043786027421583232,
                4820750559898109568,
                14047741898484199712,
                4814488575167785664,
                14040587549682378048,
                14044471466730240064,
                14044552144996588288,
                4822454133142842432,
                4818888246343293056,
                14043307761330580064,
                4815511458374083264,
                14047145333009124400,
                4811563159049379456,
                14040580528924771840,
                4821425709764831104,
                14044856613195920896,
                4819417043021988832,
                14045954889587736864,
                4819944663728237632,
                14043310348455819008,
                4815975069841904192,
                14040175661232084096,
                4824107697156858960,
                4824353630469378864,
                14046018757555336416,
                4806990858200654080,
                14041993464964108032,
                4823684758329874976,
                14038563780437312768,
                4819175075508282336,
                4823874181292764112,
                14043144080914987648,
                14040042897433577280,
                4821895222841946560,
                4823132903861166112,
                4824079204884126304,
                14046946443043562384,
                14047720022943653216,
                4819540031306070208,
                4819357409200788384,
                4817468216411049472,
                14047173831390564256,
                14047123920917366928,
                4818178365637546304,
                4820530769269769056,
                14047157357336623872,
                4823347699934185600,
                14033043259111935232,
                4821818413153605696,
                4817198502996766336,
                4824187978197310864,
                14045100641827239392,
                14047038361393043072,
                14046605285666345312,
                14039305344636488448,
                4810523087717874688,
                14026524969219397632,
                4803872913560872448,
                14044844408500523744,
                4817526612956464896,
                14027674970290599936,
                14029179487705461760,
                4819949486005550016,
                14046854149593771168,
                14044201139038381440,
                4823209412318806464,
                4820970325931014336,
                4814250609519187328,
                4820326288038460128,
                14039766727968974272,
                14045348013855690336,
                14035707004503463936,
                14043687304030906528,
                4805380190266265088,
                14043226173178851840,
                14043324881835903936,
                4824294074677586704,
                14044663791410196576,
                4810117436090050176,
                14043238005528761440,
                4822936899357343296,
                4815454000118893184,
                14040897901983854528,
                4819306997691563616,
                14037162276539896448,
                4819609759356024064,
                4823489891231088656,
                14044646305517983360,
                14046879365114303888,
                4823943150623105024,
                14045771174191091232,
                4821346449465260352,
                4819581426122145280,
                14039526531889766592,
                4819506159990865440,
                14043119839825452480,
                4814848318451207488,
                4817774253451244160,
                14033118546134105088,
                4822616679730318560,
                4820679990685140640,
                14043768648330125728,
                4823367146092250992,
                14039519310753470144,
                4823237822014886016,
                14046686107588891968,
                14046865775558950576,
                4809103308284029440,
                14034866622232945408,
                14043985310248309440,
                14024452337409473024,
                4821663172441960352,
                4823546136580278448,
                14047136659300635936,
                4802285799709803520,
                4823425069428663136,
                4822126090050887744,
                14047119497713103984,
                14037071496746457472,
                14042510845646411136,
                4810744590775204736,
                4821373128345012192,
                14042399760732162464,
                14032786096245446912,
                4816613113329098944,
                14012605496929517568,
                4824061245623153328,
                14043502198842249600,
                14046813127770734352,
                4819734390975394112,
                4818369390807601600,
                4795893271938328576,
                14047442016166096496,
                4822786277664820096,
                14043915354124806752,
                4820157834971302816,
                14043270839095819584,
                14044245160504810240,
                4823926365893410032,
                14045855751513110752,
                4819915969166955968,
                4819034108168235264,
                14033412400007804160,
                14043984856887490560,
                14047342318824105024,
                4817475156129353856,
                14041466827699587712,
                14040675632413207808,
                4824181990246711056,
                4815970480796887296,
                4822047264229300448,
                14040144833860637696,
                4811279055512741504,
                14040371541105193920,
                14046282590089387072,
                14039280122820808576,
                14040688022735639744,
                4804760781293358080,
                14021313057689651200,
                14046788451590536784,
                4821417974426725408,
                4805270108595715584,
                4819861924579995712,
                4823789505175069472,
                4823498502611394912,
                4822730964651350080,
                14047805676004729376,
                14039661977931821440,
                4817944660572179264,
                4824291948519746768,
                14044298070743509856,
                14045484585407742784,
                4822551436983163552,
                4815543611252325248,
                4824138358834474608,
                14039224806601896192,
                14044539381100877184,
                14041648675405619264,
                4796778203629168640,
                14039200678751936064,
                4824214494743993168,
                14040485861987321600,
                4822852223001953024,
                4822076728507849152,
                4815983234994135936,
                4808366224312305920,
                4815099879688953792,
                14042247284177313344,
                14042437404126597952,
                14047812873348838304,
                4823069288735457056,
                14041347010159477248,
                14043894429400383776,
                4819635122802553248,
                4814201408701105664,
                14044639037278289824,
                14039409820255928640,
                14046838717014631424,
                14035993071963813376,
                4821277331901735008,
                4816909351676540032,
                14047251431830400176,
                4823386327318295584,
                14043720908594367616,
                4824386002378177184,
                4812679633421980800,
                4817421229549538048,
                14033452516393702528,
                14044800509343097920,
                14033229931787345280,
                4817889888602242048,
                4821390566307734656,
                4819892278784002592,
                14042457067283930016,
                4816362956143920192,
                14047202244297569216,
                14045012888550132256,
                4805521806100503040,
                4822854508495359168,
                14036777155852232832,
                4821621989105673184,
                4822787163933571616,
                4811881962806754688,
                4818733485796270912,
                14026740726560588800,
                4823316387193691776,
                4813063882923683200,
                14045289969087003616,
                14037999651314512192,
                14043375513149635872,
                4814923814646151552,
                4821041720292596576,
                14043620217465391136,
                4823648192736489456,
                4818973826825290240,
                4813652998116532480,
                14043232546410813152,
                4819027547726639136,
                14045478387193786208,
                14039157476229041152,
                14025614513382237696,
                14044429658342186304,
                14047203122135595456,
                4824105151430563488,
                4800457286325762048,
                14043750156781419776,
                4811278816331313664,
                4816175674365221952,
                14046782384356416304,
                4823728238871735584,
                4819393609505329312,
                4822142690440658240,
                4820939274248517984,
                4817969547440828672,
                14033371660031957888,
                4821694922204432160,
                4823895697141775440,
                4816615263466927744,
                14042639520078681824,
                14044849793104973440,
                14037351968203753856,
                14032879055835801856,
                14047747907821636544,
                14019625697997414400,
                14044667941025892576,
                4821162679917262656,
                4814481077713604480,
                14046415865069205760,
                14031671723543405824,
                4807864248816519936,
                4821950446119995296,
                14045530015871105120,
                14042326353034790176,
                14044507126665772128,
                4824325313948793920,
                4822274309197656352,
                4811040600690807680,
                14047323673568081264,
                4822183065425030272,
                4815867489894007296,
                14046350567857243904,
                14040193659206467008,
                14045347602934944512,
                4823223568518759808,
                14036067751827837056,
                4818132043388972544,
                14047468777877987584,
                4820343031604131200,
                4812399488116299392,
                4816008373029099200,
                4821481485189605248,
                4819337461674651168,
                14046679949678637504,
                14047815089873968336,
                14042947909259589376,
                14037261240246042112,
                4818058723696343552,
                14042726144028443136,
                14043368531914356448,
                4822972953928057024,
                4819273939932173856,
                4824020200243955040,
                4823455050795745984,
                4821624143044066976,
                4813831970443995648,
                14042766079320147968,
                4823963453842999952,
                4823942240464260240,
                4815103213467292736,
                14037984822979324800,
                4819456754642742304,
                4824004654800969568,
                14035054418122695040,
                4800861817045789696,
                14044257814735385664,
                4823839124462615664,
                14046074964494274880,
                14043526065680249728,
                14043690562130644736,
                4819849880524195616,
                4813705100284043520,
                14043017636332461920,
                4823277396894680480,
                14046771103108435904,
                4811701252214606080,
                14044074701934453472,
                14046691510459560512,
                14035590490954711808,
                4821582773325890272,
                4821026842438069344,
                4824348100021438192,
                14027294365644390400,
                14037373555536799232,
                4816353349070511104,
                4824093909524020016,
                14033525834677674752,
                4796550316280591360,
                14046799848272269824,
                14043288919595671680,
                4823875330713175664,
                14044828494615906560,
                14039135898914167616,
                14040087203332719616,
                4820694628967938816,
                14043203501399302560,
                14043214455983603840,
                4811846308115197696,
                14044466400820524992,
                4820418802992555872,
                14044095171702292224,
                14047196262663958496,
                14037253022752426880,
                14043311279324989696,
                4821993449993954208,
                4824167910211928096,
                4820504733221238912,
                4823328096244781280,
                14042459008937992544,
                4818521394997896064,
                4822132793564605728,
                4819808722954947072,
                4817063439390191296,
                4822866384427722112,
                4818995693736758688,
                14045805217667766400,
                4824085392327121968,
                14043456638406588544,
                14043910448931916736,
                4816646781953200704,
                4823426723838847424,
                14039362996229706496,
                4802112402200382976,
                4813690592250630784,
                14036681282497341184,
                14046486183015637952,
                14038651310703014464,
                14046772694437265104,
                14046366383968819168,
                4815079338717749696,
                4823285429037740320,
                14047487969137554992,
                14046727326390886624,
                14045374426879913056,
                4805425183921085440,
                14043469041260087904,
                14044567288922222848,
                14037120031637651712,
                4819761250553177280,
                4824234216913190768,
                4806692794488079616,
                4810127876327453184,
                14038081110549116672,
                4814567855690719872,
                4813083631402520960,
                4822861541160848064,
                14046273295588046912,
                4817838498090627584,
                14042599055953016288,
                4819004256292943712,
                4822178453996379168,
                4822667289824115072,
                14046712362839916512,
                4823993970596108832,
                4820510323589020192,
                14044462363846754144,
                14036637511010782976,
                14046321934247365792,
                4823265277364256800,
                14037305606934383488,
                4823504002887360736,
                14043928817053838688,
                14047678883796565920,
                4806703235479384320,
                14043423715690290784,
                14047086673479039744,
                4806925163618326528,
                14042377459093944704,
                14047734693509710528,
                4823429713392018864,
                14039394641841434240,
                14036661003382078464,
                4810056547256150912,
                4809190772735646976,
                14038964654704901312,
                4810292617849562880,
                4821900892222560768,
                4813603724124372736,
                4819280735755495296,
                4822610566489478880,
                4816006883859259392,
                14042634560297810816,
                4816898174306484416,
                14041415729104604928,
                14043204774323879424,
                14032263812185247744,
                4824251022306511168,
                4815714708448250176,
                4824352099176760064,
                4822771627786350400,
                14045456005608666432,
                4818150845709286592,
                14046492672684653568,
                4816196911150624896,
                14024289203754354688,
                4816132990815136512,
                4820722995010682368,
                14045548618391181152,
                14047335087038948656,
                14047483236205469840,
                4815287811986221376,
                4819392621112817312,
                14046788616729130368,
                14040185748553312832,
                4822521488495523104,
                4819037459709960256,
                4821857412005156160,
                14031289661305577472,
                14043592793576397216,
                14038079824613482048,
                4819796039201375072,
                14044855003696071424,
                14047348241374504656,
                14042668096284843232,
                4823787437636000992,
                14047143116912036928,
                14043405734570576224,
                4809161337669878272,
                4823652707003485152,
                14016115953265508352,
                14042493814881047136,
                14040564740421615232,
                14043693961272589024,
                14043558905470939840,
                4819128362036283232,
                14045160005047581824,
                4820459876836838368,
                4820740460149114272,
                14037838192801226240,
                4821324465880169984,
                14047713368799961760,
                14046136698295636576,
                4818957119718662848,
                14043087881275217504,
                14045321649620690080,
                14047751558931847168,
                4814481604469777728,
                4809688636361510912,
                14032747037574260736,
                14045950286585398176,
                14045468384871546688,
                4821035325058280736,
                4823893253549734672,
                4824235338383295664,
                14039822301124175936,
                4813737672817582208,
                14039059043318756288,
                14047355953993082944,
                4814448375291251136,
                4815373750324788224,
                4804740873396689408,
                4821050269607314400,
                14040139703997154880,
                4800843072695213568,
                14039950304279988800,
                14046483720400632864,
                4816236974661058304,
                14044510976345469568,
                4820845278245663840,
                4823921198926354352,
                4820982581941428384,
                14045302150871070848,
                4818976014650297344,
                14037399115891802880,
                4819452753883066976,
                4809857189520310400,
                14030285707320278784,
                14042171374130253312,
                14043546346655092192,
                14044504015016730048,
                14046750616062742272,
                14040128030505077760,
                4821975792296201056,
                14047735014810467472,
                14047590122618461920,
                14029594415300371456,
                14047281100856681888,
                4816831069296658624,
                14045486262967254848,
                4816209115508185152,
                14045870558914631808,
                14046952042967399840,
                14042892920375540864,
                14034595799128908928,
                4819129793108769632,
                4820688790156186304,
                14042322096102552448,
                4821428817846958144,
                4819289188876866976,
                4820802049049149472,
                4821885868268199424,
                14028583769458949632,
                14038065367203005568,
                4820964596614892768,
                14044587721461000768,
                4823273201925636832,
                4821577155318449536,
                14046068461590181568,
                4819177116451387296,
                4815199045803863808,
                4812986310863715712,
                14042320457874115968,
                4821728869175179328,
                4817118290021593728,
                14044465515386736704,
                14043013489679421888,
                4795212145455230976,
                4806010771812087808,
                14037825921087217088,
                14025382076973410304,
                14046340635113923968,
                14032305161331090432,
                4814754911905610240,
                14043531567504032640,
                4812425179533299456,
                14038261719361869696,
                4819873550969124032,
                14047109864937727872,
                14046395427080352640,
                14036812773169494528,
                4812480689164345600,
                4819100447569198080,
                4807237462296128512,
                14043731760297209248,
                14043723129297686816,
                14042645333447402144,
                14037835835822670400,
                14029110348785317632,
                14047006297395373120,
                4821913063741499040,
                14044936016405150112,
                4822717712052554784,
                14045122524653940768,
                4821591284936040768,
                14040457461073027392,
                14016146425523748864,
                14047012642170281520,
                14042544041986816384,
                4809028432532429568,
                14038156633758640448,
                4807954720591889920,
                14045947572926379328,
                14047159803845178544,
                4815611164880093120,
                14044686521039847744,
                14045495830219821600,
                4820319362502675936,
                4809294525693260544,
                14026738281151544832,
                14044109710240746336,
                4813233988649725952,
                4809210244393566464,
                14046096384653893120,
                4820502585899403200,
                14039073281870312384,
                4819381377692448544,
                4811759195293818496,
                4824252495791743248,
                4819209359266834624,
                4818434242659458688,
                4796651384639742976,
                14047304526397579088,
                4819057072899896704,
                14043886702060342112,
                14035702716919901312,
                14040144809997392576,
                4816691232206152896,
                4803928499375954944,
                4780354733611663360,
                14045782709149081248,
                4822204646955057312,
                4805702824993946112,
                14043870095802326976,
                4821653791802953248,
                14036088984019447680,
                4821693308789346496,
                4819780132599639616,
                14043391129296452352,
                14019928981721321472,
                4821046524681233216,
                4806594942043273728,
                14038297889287020032,
                4806870243188259072,
                14039290441169335424,
                4811819949339144960,
                4823651863586002976,
                14041377308417522752,
                14047065904518268464,
                4823984547277953344,
                14039579719176256832,
                4816809430984693824,
                14047330352750505536,
                14047267481834992016,
                14046145811618960896,
                14038887624297920320,
                14044618032489246976,
                4820233682049965248,
                14042452114862676192,
                14042458847591791616,
                14023180132084197376,
                14038444346622941120,
                4824299395723656016,
                4818272672822072832,
                14041604791378313792,
                4822579585108401376,
                4814511963403040768,
                14040815467222898240,
                14047225347427368896,
                14040018757898264832,
                14015889855587938304,
                4823517098469829184,
                4798166518074552320,
                14042240202746069856,
                4817631435430149440,
                4820248451816436352,
                4819095661418445280,
                4817153832058025792,
                14046924599444585104,
                14043006637709542784,
                4821207532900752928,
                4822614504780526464,
                4822005759589214752,
                4819224138882024512,
                14044557171411834368,
                14033963449974099584,
                4815613233092124992,
                4811504947924010368,
                14043191541465349024,
                4823597637253280480,
                4818528872451487680,
                14044792103934095424,
                14037985647362476352,
                14043504252721566208,
                14027294662693879808,
                4819925851587257184,
                4806433837706846720,
                4815540747419930176,
                14046849628928559136,
                4820726315660429312,
                4824030503091524288,
                4822969168663340224,
                14047146896339617040,
                4821737278308029504,
                14046209731321115488,
                14044771878530547424,
                4823761369698104336,
                4822423121304083072,
                14046875776775005424,
                4816365006486358016,
                4824122976934244912,
                4810358632108605056,
                14039862300397851072,
                14040819618519188672,
                14047311647881819536,
                14044181267499570144,
                14044941080029631264,
                4823209471822802432,
                14033305008224706432,
                14044453522730380704,
                14043563134412925472,
                14047391853295458368,
                14032052360908685568,
                14047107929229772432,
                4816477744177171200,
                4819553124043671264,
                4823003935814415040,
                14046743297769601776,
                4817713036143886720,
                14033661123323239552,
                4816430168316126144,
                4817288844680599360,
                4823785270842236416,
                4819943196091629184,
                14047704534451122336,
                4814975870930787520,
                4823170433987067456,
                4818949894631688832,
                4818213648479335744,
                4823533175616710144,
                14044434197586028384,
                14037386034400436608,
                4816598624796006720,
                14047688961801601536,
                4823976763447732832,
                4818592093900749184,
                14034360070733327360,
                14046314264033446592,
                4811856828549281536,
                4823838852269394576,
                14047442732139253408,
                4819316904174790752,
                4823822818513649056,
                4797176268169957376,
                4821076299014588288,
                14043004763967198304,
                14047394444087282528,
                14038558150485732352,
                14039208544327764864,
                4805995204463727616,
                14043415203445288544,
                4818938431963797568,
                14041147250445818752,
                14035902534539939200,
                14035572161475482112,
                14041859923234640000,
                14046278991373593824,
                14045561005429541824,
                14047698248554093440,
                4819767166932819936,
                14046302624715167456,
                14038586048938875520,
                14037400739175106304,
                14042122143525630208,
                4822779434321705440,
                4819396562793443552,
                14047484202957279728,
                14047276338225352096,
                14046973764803038160,
                14041324231951552768,
                4817913118120430464,
                14044321112560685696,
                4808302502776418304,
                14047484695052835088,
                14042458043994762368,
                14042282896502234048,
                14047700643038000928,
                14043567711430682976,
                4821471676990267168,
                4823551122999922816,
                14043287067297406784,
                14045580200133713120,
                4822068449999930976,
                14044728823497951168,
                4822152951607183392,
                14047452110552317120,
                14040074895901297472,
                14042584425914731712,
                14032488491824062464,
                4798059679430110208,
                4823717022874466288,
                14046144831806163040,
                14046210206509672576,
                14033479115400395648,
                4824359822644662784,
                14045855510849158016,
                4818409429647746240,
                4806216260485526528,
                4814820692188803904,
                4823591340736127120,
                4823568540118250928,
                4821120247392047456,
                4817611644243472832,
                14047173753915574480,
                4822781831765644448,
                4819987300824400768,
                14042910370310382432,
                4823751810699436240,
                4814559528094715840,
                4820311686548119360,
                4816097610281400832,
                4824240795786472928,
                14047429247787647920,
                4814691235347679040,
                4823193839528439936,
                14045426810151784704,
                4822228182782064832,
                4821164008598388992,
                4824205683657917648,
                14030327408881482240,
                14047210223843661888,
                4784967496909733888,
                14047254377239966096,
                4808675887359889408,
                14045131801245577856,
                14046693708346473728,
                14047363469138028048,
                4820458432932222176,
                14042165364655198144,
                4812125949821001984,
                4816626998785899968,
                14044865070543061504,
                4821676881830030400,
                4813504641694460288,
                14046899868673928176,
                4819975639416213920,
                4817062688781018944,
                4805183220337536000,
                14047339600066537600,
                4814737995099640512,
                14046081227197250464,
                4823205884508119072,
                14044375238697131264,
                4815355389786951872,
                14046777796006780480,
                4819711576898985952,
                14045844984252640256,
                4819098066893399872,
                4821524325555791104,
                14042360239091200224,
                4824356953009671552,
                14047585420050962560,
                4820897390846449632,
                14042923926948395296,
                4820923135385604224,
                14031883854365357824,
                14025977562247279616,
                14047701158989305616,
                4822882602605464352,
                14035521514946993152,
                14038459521056192832,
                14046824278319491744,
                14039302645939582016,
                14046234379387811296,
                14046706673405358944,
                14031836686169992192,
                14032916828081384960,
                14034478277204661248,
                14043483872421376288,
                4807027326922350080,
                14045457851614463616,
                14039712657470712704,
                14043535995640645152,
                4781190069002698752,
                4822493394911715360,
                4820913865558426880,
                14042848467254687360,
                14044218300540241024,
                14042416492279749376,
                14047112192154268496,
                4809062849980522752,
                4822869183616651264,
                14034196479917200640,
                14043512056511054624,
                14038046419294490624,
                4805428344831387648,
                4822272129022904992,
                14035821435293192064,
                4824403183863076128,
                4815312947740003584,
                14046751268344853824,
                14046368717321639808,
                14043888645459893280,
                4822979728090420576,
                14044764797717959360,
                14042860928432459328,
                14028520610043415552,
                14034495580753253888,
                4823242528857728960,
                4816074563009374336,
                14043237273945100832,
                14045006107865117824,
                14042980733972470176,
                4818953101523468608,
                14043755405108586464,
                14041952680977708928,
                4820862160181132448,
                4819111188669601664,
                4824376700572963520,
                14036515688631302016,
                4819259890832796672,
                14042796629121605088,
                14047229467203266640,
                4820352897094299744,
                4814512119779175872,
                14040697385971595072,
                14042836612688433376,
                4823312526753240768,
                14044430062932059744,
                14047177198079744240,
                4824193127097398400,
                14047247811573483984,
                14042643370545074912,
                4821238751087753248,
                14046285498965468096,
                4801252367047785472,
                14045214017015720896,
                4800387493571614720,
                14044971559762065760,
                4820916656771517664,
                14043134737591819424,
                14047250594244384368,
                14027618577795354624,
                4803390966439840256,
                14044580793709814848,
                4820795576566887072,
                14044121145263671296,
                4823639300082839904,
                14046242893781764896,
                4824169055156469472,
                4820622911656633376,
                4818407494553344064,
                4823132595943840544,
                14047788261233029264,
                14047812518264244624,
                14047132692478265440,
                4823797766372715584,
                14012799994927599616,
                4816616543693390976,
                14039837999880766272,
                4819897048216118752,
                14040656393087780224,
                14047797001760125664,
                14037145585324746880,
                4823492515381645184,
                4824222078569410384,
                4805843460972864768,
                4814952543945210752,
                14033031904786615040,
                14047660965375379888,
                14044048253245572512,
                4822321577190644864,
                4810128316400017024,
                4821861530746518560,
                14028718968555846912,
                14044975852117647840,
                14047400130017730912,
                14042225248557556256,
                14039811888342550080,
                14044384438147288832,
                14042040219040749632,
                14042955093508832352,
                14047213254448203392,
                14047779678765732496,
                14040060911340891008,
                4823572615632682688,
                14038863884918282688,
                14043910394752092192,
                4798083768317329408,
                14029674447043756544,
                14043902370111713408,
                14030235128450219264,
                14045986978923457280,
                4802412758610304512,
                4807843497383963392,
                14047309969602672256,
                14047113491932135728,
                14038824108967523968,
                4818986369390365152,
                4812029209816684544,
                14046934480698203808,
                4823200712926546592,
                14046889795365757136,
                4822380915785931328,
                4824077442888265840,
                4814659809643589824,
                14045319376819342976,
                4816101734923469696,
                14044439244143813344,
                14042896548077394528,
                4822172772786270048,
                14036867072506479488,
                14047695942324142944,
                4816733372420111424,
                4820083093962932384,
                14047491085798036576,
                4819764610424076928,
                4819819130727716448,
                14043710494891363360,
                14044466825481203008,
                4823695981929359216,
                4815959408186151680,
                4821903456732700224,
                4817141770277991104,
                4812857953904731904,
                4821801557214778784,
                14047040383521345888,
                4823661919184471920,
                4822587644078091392,
                4817450020359373824,
                14034882454485799040,
                14045375642432151616,
                14046504918605976096,
                14046776485600802704,
                14046705019211443328,
                4819623183750355936,
                4819865638067829984,
                14038322995019137920,
                14046783798459969808,
                4813560665203641728,
                14025122310054795264,
                4823063871266427456,
                14033981220724207360,
                14046721154144792864,
                14042822518445384128,
                4822034619507504512,
                4823106131960710048,
                4823940965030420240,
                14043786577559703008,
                14044097391667306656,
                14030050004434320384,
                4822512125000163040,
                14033594303258450304,
                4819475898398384928,
                4818045198789927040,
                4817389518368260672,
                14047771640547672128,
                14043730397633921856,
                4809559532635950336,
                14044726126453256480,
                4821309576545680192,
                4816759391062564544,
                14046853696255503424,
                4819100830260411616,
                4824419424788298064,
                14046723202305094656,
                4814544556670724224,
                14039271499722070656,
                14026696599710756352,
                4823474363640589328,
                14047028948189274400,
                4819682008796086912,
                14039470959076852928,
                14044389816826803392,
                4819741696910764608,
                14041095107925719296,
                4824420569627771520,
                4824390506741089664,
                14041672947656198656,
                4821408791372344288,
                4819540375374127776,
                4819248293728082816,
                4806936962710708736,
                4819895515521051488,
                4823884919635526832,
                4820504163864409824,
                14043698716671279296,
                4823766888655161760,
                14047151464206465696,
                4817790191762082048,
                4819349715404774496,
                14031104874573218816,
                14047790445837353520,
                14045301380157162240,
                4815580632890572672,
                4820684797750426112,
                14037983152210994112,
                4797907297199373312,
                14045146575882641568,
                14044799477421043968,
                14040169095956681408,
                14038803861642804544,
                14044097748261439712,
                4818698150820339520,
                4823012883833596288,
                14047701964549510448,
                4818370161758307072,
                4820576457891488928,
                4820459963548459360,
                14047214712514987344,
                14040442517581042368,
                14025077579885121024,
                14044805968493898656,
                14045941706387944512,
                14043686832438064960,
                4809849891935518720,
                4816705191054570560,
                14046786392345949920,
                4820380062344707744,
                4818950219923920704,
                4822272170511120736,
                4812710800443716992,
                4824276746619615120,
                4819029035601163872,
                14033293684377528960,
                14041159640329023552,
                4812483688115637632,
                14031904573127046144,
                14042457741636850016,
                14039091781613372480,
                4820927318019567680,
                14043242319895159200,
                14046475949894047616,
                4822394121775350016,
                4822636981833431680,
                14047740530364838784,
                4818694985451997312,
                14033660649117541248,
                4816018022615028928,
                14040709576279109568,
                14044703221840300608,
                14029143281194108160,
                4811085600218215040,
                14041872488248484096,
                4816440343283382144,
                14038148684625784512,
                4818039173569096192,
                14044409957248009184,
                14047717140772428896,
                4822233654567273792,
                14045014413904331232,
                14038262630384989120,
                4801034892246536704,
                4820593581912697504,
                14047431067404474736,
                14042106118517394112,
                14045679394771324480,
                14045803964235293568,
                4819571530039989280,
                4817992542385581120,
                14040716220003257088,
                4821116160787218560,
                4818960771374593696,
                4819982081755677888,
                14047031616543895616,
                14046914178948953168,
                4823801245206784688,
                4815421408875968064,
                14045722841755548928,
                14046403992055730688,
                4822265548039847392,
                4820146594545107808,
                14041354286291536832,
                14045331692075098848,
                4824104892957147216,
                14037279099111422976,
                14011505073551974400,
                4797650488381337600,
                4819930329719833536,
                14034802315388413824,
                4808582432654663424,
                14043446955206387936,
                4816701342642924800,
                4819646896307486304,
                14046959463050292832,
                4822035124047226208,
                14047804957498600304,
                14040768612265496000,
                4824082909256640608,
                4821180563040851936,
                4820737570396308992,
                14028017667358446080,
                4816220679882033344,
                4820346820568523584,
                14046695006976102016,
                14032358063715759872,
                4823272221586211200,
                4819497935761788032,
                4821879668523470112,
                4823163038679642976,
                4807558364765489664,
                14047298086389419056,
                4824423895118097824,
                14040807996560257088,
                14035815559751593856,
                14042532594863171072,
                4820173317409088960,
                14046802420907552768,
                4819648386414263200,
                14043487188473131296,
                4824407500215816656,
                14032104065896952320,
                4823913852248665712,
                4810786061275712256,
                14038120040170306560,
                4824395745741625648,
                4820550564083913792,
                4804983809098205696,
                4810160583923365760,
                4800920352084143104,
                14038304061985251200,
                14034224554573983104,
                4823773871870311920,
                14036993344616877056,
                4814477525440594944,
                14046339579442061056,
                4814590255428767424,
                14045634308801758272,
                14042953266319071936,
                14047556597275717568,
                14044390333021886336,
                4819334215623260128,
                14043485036108604576,
                14046931377355619744,
                14047693987350213808,
                14047153494676446288,
                4820582167050542080,
                4820521939630448192,
                14042651207160465216,
                14019164222742009856,
                14040032540273711936,
                14046984778975810496,
                14044137808748154240,
                14047309611699410048,
                4808449249573603328,
                14041668472275926144,
                4822575134359994080,
                14044530254705037696,
                4820416867876643040,
                14041120892287766784,
                4824241054272468896,
                4823878293680742848,
                14046865154093029600,
                4821103105562856736,
                14047465985844151024,
                4819533786135150144,
                14035024961257298304,
                4818147753074575296,
                4815964475886735296,
                14043995115057475360,
                4819937301192730592,
                4815634586181721536,
                14038766028606549696,
                4814052806435341440,
                4822096862987138816,
                14047000522048339328,
                14043127205223093376,
                14039377820943484416,
                4816608043046676864,
                4823383351250016032,
                14043049200640220704,
                14032474406907333120,
                4819801521307356416,
                14043838539212011488,
                4817809623341709760,
                14043998079897956768,
                4820880415016955072,
                14033806712317000192,
                14043050433861409312,
                4823275798491550112,
                14016682380955770880,
                14034654062998027392,
                4802446900394471424,
                14032910497553583616,
                14036377827472265600,
                14047268673396894576,
                4815581361225974912,
                4808680875431067136,
                4823954636654102624,
                4821012926300724640,
                14026070393259743744,
                4818333383944114816,
                14047586860192220144,
                4822182193071175680,
                14001873419040800768,
                14044876342317314912,
                4824287414674145264,
                14046754953470993936,
                4803093063968686080,
                14043762683810490016,
                4817587022019678656,
                4816890792834352768,
                4824041454783903696,
                4822712377862611424,
                14040386227273706944,
                14046870618327012976,
                14040653515509152320,
                14036381356472305024,
                14044406049077472160,
                14038169909068977216,
                14044114754412481600,
                14042473098198077856,
                14043202667742072032,
                4811089924723728384,
                4814708407105828032,
                14032588426475405824,
                4811822749608269568,
                14046080434926323744,
                14047147017273093456,
                4814798375379535168,
                14040202090153608064,
                4824250093547825520,
                4790709949686468608,
                14044306778958041888,
                4821293350483223392,
                4824199321065388992,
                4820676055722140896,
                4819710845777098496,
                4810420442862988544,
                4815772297745774336,
                4822247186631767584,
                4812128131286420736,
                4807319470975566336,
                14043478617439591968,
                14046839708255231408,
                14046936415890011328,
                4817970800367820928,
                4823922460348815696,
                14040139312965802752,
                4820578199785300480,
                14042744759733613088,
                14045692182572326880,
                14047800216092907008,
                14043327008426986656,
                14044235718400261536,
                14045379468488903968,
                14016357975001667584,
                14040780393514288640,
                14033997341388145792,
                4823577954063905840,
                14046861150808723024,
                14047023416068008752,
                4820298006957654496,
                4807272254180607488,
                4822220961123556736,
                14037977470476288064,
                4811234236807556096,
                14036155846884299904,
                4819330245586116544,
                14045492250189204800,
                4806774316409191936,
                4813911127496019200,
                14044258906467680960,
                14035352415961263232,
                4815492584012832448,
                4823609875070311296,
                4822894388576332448,
                4819704637700896064,
                4793116888844077056,
                4823253146680873824,
                4821048659881089920,
                14030085037827512576,
                14042722297151539872,
                4791912151281739776,
                14039205817442027136,
                14037391109510543104,
                14045098705965703584,
                14035482324306170368,
                14032226153664657152,
                14046126367165035840,
                14046920457521751568,
                4822133760502083168,
                4798067730175451136,
                4818312350801927936,
                14025910390769230848,
                4821145361315738112,
                14043463146632464384,
                14035299930156616320,
                14040285292402275200,
                14046877045717181488,
                14046664442283222208,
                14047049341459729920,
                14040261755018405120,
                14029336578645687552,
                4824013524059117920,
                4821290860306103680,
                14041683553610992576,
                4813162394110489088,
                4816020308622307712,
                14046992609389370608,
                14040658539594748928,
                14041993908508617728,
                4823545052902757264,
                14040570851463978240,
                4822324835731300896,
                4822746580944419936,
                14046767543716330912,
                4822287850681802432,
                14044769004683313600,
                14047514460164226112,
                4815405545693814784,
                14046842051945763568,
                4823758680262007104,
                14036989946088182784,
                4823767499620493120,
                4806629308959177472,
                14041081555847939328,
                14047332956358413136,
                4822329096416309440,
                14045311011202963616,
                4817493622147959552,
                4820852129889496192,
                4823910067768544096,
                4816022299331604480,
                14044604703129190944,
                4815653675378373504,
                4824039697430039296,
                4810814449147564800,
                4817492533314167872,
                4819097795669798432,
                4817726280046190272,
                14041705101123566912,
                14045969773679644960,
                4813751384276521984,
                14042605939098632160,
                14020928961658515456,
                14046287249357044736,
                4822820247812969408,
                14045758115066664640,
                4824073289404049136,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4831535567424454664,
            pinv: 4382457639974474137,
            mod_data: ModData {
                n: 1022545813831681,
                ninv: 1864509616052343418,
                norm: 14,
            },
            primitive_root: 11,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                4825439846457185120,
                4821496375955681152,
                14049432074167511120,
                14048478640921129008,
                14046841195274624976,
                4825650894409250288,
                14046178618945972768,
                14047385253808960784,
                4825851319364483808,
                14046707542787468928,
                14035437132771416064,
                14049249919714584256,
                14048315649665522912,
                4819544071387224864,
                14047809862777334032,
                4804231751593389056,
                4823540658199560512,
                14035096759338017024,
                14047985492045227712,
                14047232511187730096,
                14045558067334366240,
                4818401787736819520,
                4823971754795709104,
                4824274440945422448,
                4813373805408107648,
                14046847133865445168,
                4824874467674102608,
                14047057175127032928,
                14047337512356251696,
                4824688535832160864,
                14039642814059537600,
                4825431061631096736,
                4823857135317523216,
                14047651134929528208,
                4819853611199351008,
                4824891664215266576,
                14049196726504201936,
                14048838363086239424,
                14048788033313157344,
                4821837116763697312,
                4824165132311920512,
                14042851180804928544,
                4806543476166756352,
                4821188583758948480,
                4806058251952569088,
                14047071222383024288,
                14048983310422191728,
                4817331328054397120,
                4819257789212167040,
                4822319399608984352,
                14046288430572866432,
                4826308677866686368,
                4826710067006638368,
                14049100323906066576,
                4824669008026338704,
                4823647945755946512,
                4824144516159091040,
                4802106136673379328,
                14040754280317357760,
                14042788466786814368,
                4821615795891559008,
                14044834037282175840,
                14039478854006833984,
                14040607596865999552,
                4821946028368516800,
                14049516732419034976,
                14049206857969660736,
                14049984964483129792,
                4822786634136944320,
                14048645380840578640,
                4796586952420560896,
                14048299641909678272,
                14050223579179019984,
                4821639862341614496,
                4826083448808429712,
                4818925895533524288,
                14046140310705855360,
                4824447739708704416,
                14040583634108787136,
                4817697548870899712,
                14038495319671992576,
                14049539081702425216,
                4823973861279393648,
                14043953473761831872,
                14040821937507886080,
                14042972836596274880,
                4824241469782134688,
                4826614002054715008,
                14048661006473149200,
                4826158942876350080,
                4820498697288848960,
                14042943144166162848,
                4825476814041280064,
                14046209373554872448,
                14050369711676841760,
                4826625113375115072,
                14048775627815185280,
                14047794119296666112,
                4809037424436230912,
                4819886308662117120,
                14046702230224517120,
                4806171070467751680,
                4823663048961988048,
                4823609660477321120,
                14049121204679784768,
                14043455999063375008,
                4826221803976297536,
                14044128325784850656,
                14033765383685192832,
                14049295679214985392,
                14045637752390369472,
                4824726587349038368,
                4822910890163108864,
                4824418996765631024,
                4824746760597292320,
                14046919827427072720,
                14042940658021060192,
                14035795643607627648,
                14048353366022992208,
                14043457251233012064,
                14049341231454216304,
                14036079412522896384,
                4824023015558510672,
                14047234394853446736,
                14042165854941764096,
                14035059051908634624,
                4826395138883607632,
                4825757721551474000,
                14040808625615315456,
                14047834766764041376,
                4824255872273792688,
                4822487547942965568,
                4825798908091777600,
                14030536133004097024,
                14041347918954649600,
                14049429496376697168,
                4815425678752495744,
                14043007954767362368,
                14032926333973469696,
                4825736866983086112,
                14045816627924422912,
                14043732880686297984,
                4814842852911510720,
                14047357888419900320,
                4825907827293800144,
                14047966526424251616,
                14002559716742758400,
                4810073521747832960,
                14049973814603675072,
                4821674598945080928,
                4825295768309609568,
                14048887066852165264,
                4810619265463375616,
                14048624081486644272,
                4824421793077052992,
                4823991882571222832,
                14048256545945987456,
                4820291280021689888,
                4820266633957734976,
                4819009480151447744,
                4821204518766480448,
                4823875594070730128,
                14049259478421229360,
                14050321028404402480,
                4818877658333212640,
                14047554331660805296,
                14041219495619620928,
                4824537814371695376,
                14025713186051705344,
                14048847933772515792,
                14048859218688977104,
                14049476186512291040,
                4824383929827360064,
                4826518874873005312,
                4815726028918689536,
                14030692357902129408,
                4823625139044720240,
                4818013809370647232,
                14047648467880875952,
                4819479411981134208,
                14048094514946480224,
                14049621633589141200,
                4823094328091085056,
                4809945138134605824,
                4822896877449584544,
                14033399590924075392,
                4817875473122529984,
                4820898691632714112,
                4817176120574170560,
                14049483272303519520,
                4824857280230884176,
                4810265091033998592,
                14042291333033269344,
                14042240775611339872,
                4819290206020753504,
                14049992373047944896,
                4826794530549922064,
                14049407313043269264,
                4822222138002923616,
                4816715619420569088,
                14049419955940566608,
                14041725160979721536,
                14047329107528684720,
                4821888646645182112,
                4819584455773980768,
                4815684254437081728,
                4825751281298205024,
                14046551727574677632,
                4824465785789955200,
                14044243325953149408,
                14035621024797297152,
                14045156568874581088,
                4824530800850812304,
                14046314914821141760,
                4826092114703573360,
                4826784285577746032,
                14048559484278655232,
                14047217799016411136,
                14049371450465537136,
                14045902624781340736,
                14047837948620381584,
                14036397915340799616,
                4825556903921301504,
                14046744415782606864,
                14037076939308192256,
                14050116905265819696,
                14048477057662066992,
                4814018216343754368,
                4797599443515247616,
                14050155978648458432,
                4815898157752423296,
                14047892865499719536,
                14048282980144324816,
                14042207184694697088,
                14048226518381435872,
                4821603726844806304,
                14046234806401221952,
                4826001184804767344,
                14047819008011546704,
                4825566132635704752,
                14047250970282086272,
                14050176659091494576,
                4825734802991863312,
                14040170659585065088,
                14036681382702296576,
                4821824713381115200,
                4818152594735670016,
                14035406496419305344,
                14049243037275575216,
                4825017005959015552,
                4826635783914605664,
                4822346645713292704,
                4826637544877222064,
                4825294442525891200,
                4825830785175699776,
                14040697121801716672,
                14045012117981227424,
                4824168735652351216,
                4826447266245115904,
                14046516602256015040,
                4817202642448776768,
                14046855072105445872,
                4825260965865601232,
                14049762559979192336,
                14038359549076815424,
                4824880816583420592,
                4825969418483895200,
                4824674280745916160,
                4825318513062859184,
                14048787506801188032,
                4826769947669656320,
                14048133072431917552,
                4825983939612366240,
                14049386051819287024,
                4820228311272340480,
                14045269817483728608,
                14048530851330290112,
                4824382435936497936,
                14048802284956680592,
                14036396827522221568,
                4822532016225992416,
                4817702104052781376,
                4823847534414169648,
                4816715516567467456,
                4825092875893318368,
                4826482831842853136,
                4825021622063929360,
                14048795651545758320,
                14040963313355219712,
                14045204371684147424,
                4824312270644756224,
                4810581102974092672,
                4826430318245484096,
                4822295706121617952,
                4820411158551192608,
                14042277403359517824,
                4819068179216221920,
                4820878151923922016,
                14048372605695284080,
                4817182474358183616,
                14040395635930603584,
                14049168165703315216,
                14036987055459178880,
                4819201072549382112,
                4824082106520130544,
                4823756490292596112,
                4821452835792602080,
                4820771256439777472,
                14049410599165310288,
                14045277100298570528,
                14046213307027472864,
                4825242206270109456,
                4811532625785862016,
                14040688091704011904,
                4822619394684522816,
                4816333038347396416,
                14026674975446486016,
                4815862890758514624,
                4826645760117212544,
                4825272946715171968,
                4823604178010629040,
                14049904196728932320,
                14050067685668342848,
                4825171982775794432,
                4815388921128173312,
                4826119520486388272,
                4823788409425996112,
                4824765239299562864,
                4826779432598009200,
                4811440425768318720,
                14049505734665451152,
                14042391975464536320,
                14049381343011974656,
                14044540453754271008,
                14020587942509486080,
                14043647104960028576,
                4823849829521596512,
                4825885184058158208,
                4825902361501455152,
                14040184349038736832,
                14023730280822118400,
                4819637203821021024,
                4814864937783417536,
                14045140967046545856,
                4801549417825792512,
                4814424904006263232,
                4815169646328046464,
                4819500496277027232,
                14049552317581345632,
                14045889270549134048,
                4821832716006128320,
                14041965506656694592,
                4825498982319318720,
                4825619054106821248,
                14047141004118321648,
                4814936855401470336,
                14043783962626559936,
                4826727388778005168,
                14048006119331581104,
                14042731692928365120,
                4822013985983097728,
                4824232106235068720,
                14049409117379024480,
                14044085783029509056,
                4820200493272226336,
                4822479442500902368,
                14039364370094074368,
                14047325203924138560,
                4819684284883995424,
                4819070679250932864,
                4821267478059587904,
                14040885711575448960,
                4826764026048432480,
                4826802182038415312,
                4822162150327408512,
                4811662723463885056,
                4822740194952644512,
                4824408842656977472,
                14047552556339420432,
                4823955575677817328,
                14049845523229576432,
                14049767743838189616,
                14045318914905471712,
                4825328220400156112,
                4823638354597169440,
                14042363969061733312,
                4824140736343351344,
                14041904554047165312,
                4825190543136406064,
                4815783965092671680,
                14023972928314634240,
                14040597923386037056,
                4823131374472999840,
                14049919093648136768,
                4825356348717539792,
                4816951159099933120,
                4819453906571232064,
                14040716287590795584,
                14049013900291608288,
                14040234476364309888,
                4825970269891838448,
                4820752838051846368,
                4823498853947566016,
                14048380975301037776,
                4821452588103068352,
                4823783301985832816,
                14021403150307355648,
                14040721939593446144,
                14049535717764115056,
                14048461964356772480,
                14048496183702034480,
                4824409224561906000,
                14042603297674050528,
                4823922282601109504,
                4825466993846379920,
                4826995751540017216,
                4823281069958606464,
                14045646770566069088,
                4824575750684921408,
                14043208150546584640,
                4826996588836298656,
                4824736778634036528,
                14042286746572494432,
                4822504839104164672,
                14048691040060141952,
                14047355978975364080,
                4823750966892361088,
                14028188694380263936,
                4821011994680771936,
                14041983186979442624,
                4822254982781049984,
                14034940666250038656,
                14046682469371083456,
                14049926134188778384,
                4816280370878262144,
                4826343908792766976,
                4820894682002475104,
                14047904237205727536,
                4821237398477175776,
                14045658287882346240,
                4818359231666234496,
                4825236691698971904,
                14039499859206479104,
                4824019573488824800,
                14050285875103353168,
                4824391398762946432,
                4816119493188454144,
                14047889610306379936,
                14046864442446616384,
                14048353843027293696,
                4826910037252760192,
                14049942324334851408,
                4824231023076788032,
                4819510038671787040,
                14043876694452371232,
                14039741973866638400,
                14041073622438834048,
                4824934762448348416,
                4824433818469612496,
                4819733937074020672,
                14045521682297220576,
                14049299785189010448,
                14045877844421124160,
                4824639572617382464,
                4823677039543959424,
                14048558464022900544,
                14031024396471978240,
                4816337874438634048,
                14048955707982341856,
                4807748437136682752,
                14036607901753294336,
                4822933451224082656,
                4818489078521299776,
                14045939638836249152,
                14030084009143558400,
                14049987984258383040,
                4826686622448442816,
                4819803611899043200,
                4825797068268621248,
                14037683166895959936,
                4824414103396857488,
                14039846689628315264,
                4826558905340836752,
                4821283912522613184,
                4823749785067243552,
                4825089353421362096,
                14036844074703361024,
                14048759031375612400,
                4824736654607524592,
                4824837390459668688,
                14017030017284132864,
                14048549363791237888,
                14048268963466243728,
                14049843957187662208,
                4824958833567658384,
                4815364328462287552,
                4807307617245065472,
                4826500897732746976,
                4824337483163992400,
                4817062577208958464,
                14042407853197218208,
                4824690927746163664,
                14049468599377236944,
                4826648924684605888,
                14039071815433929856,
                14038148806069372672,
                14042775386823149952,
                14047156478776688304,
                14048872969713169920,
                4811547568881958784,
                14037113358034368256,
                14039662166213802240,
                14036822908249530368,
                4825075158881459616,
                4795119593266028544,
                14038906582407862336,
                14024313017620431360,
                4823960575994067824,
                4799472508850048000,
                4825650290575776624,
                14043324890206042848,
                4818979306384984544,
                4822071500741073088,
                14036128351785239808,
                4817226027045636416,
                4826554358365942144,
                4825661727902174672,
                14049039392648512656,
                14046641398275848672,
                4813515345678205824,
                4825898830368634704,
                14044312294333542464,
                4821549216934020128,
                4822016692002862816,
                14046493545003971936,
                4825162770744742384,
                4823516311344336816,
                4823706597452143360,
                4824666357692637984,
                4823584262980329520,
                14033601008849362816,
                4824234970790291648,
                4823060903647197888,
                4814849777588118208,
                14045520557179463424,
                14048744670606424576,
                4826270678208114976,
                4820865186154251296,
                4825568802975275728,
                14049542671919275456,
                14039931685086816576,
                4824237336375659472,
                14050045806336407600,
                14047271232968161536,
                4816723896056407936,
                4821525035261909440,
                14045864470024110560,
                14049602534072716656,
                4824688150974602448,
                14036798330832329728,
                4812286073985733760,
                14047145630953159328,
                4826455677854903968,
                14047344046922410432,
                14037127073201500928,
                14043542973236493600,
                14033912162969075968,
                14043462748018882752,
                14049425767573745872,
                4820568386167520096,
                14046080505180103552,
                14046053370511627456,
                4818828357635448640,
                4826331097166840720,
                4810638366685441664,
                14033340269387483264,
                14042709212052946880,
                14045052978390783936,
                14048142430406778768,
                14048440192607175008,
                14038481930555397056,
                14048898918960950736,
                14022631639189305344,
                14044545110440436864,
                4824569540153180560,
                14048979119157150160,
                4817506697255589888,
                14045871076192335648,
                14042730057149022304,
                4818175592273592128,
                4823431183585260864,
                4820617230021939968,
                14042474368019836736,
                14046372771584161120,
                14043422801323945280,
                14036572240553991040,
                14034662342192216576,
                4825320004088378192,
                4807800418904261376,
                4817045316579373888,
                14042747936623150944,
                4824176106466215408,
                4822594936836978976,
                4816017344086285312,
                4813664948448407040,
                4820244204869737280,
                4819148758840189280,
                4817949881454028032,
                14032814218523377920,
                4817641178576458880,
                14045849068800341888,
                14049940644631331408,
                4824856006764364368,
                4821147618192466304,
                14048652779938710752,
                4803826622211950080,
                14043336844994776640,
                4824763929097326560,
                14047410002213487888,
                4824757238532195120,
                14045303433252424320,
                14046079823483535680,
                14042394042499877408,
                14048154907769951792,
                14048711639123229024,
                14049131229502242896,
                4824871085925037328,
                4817531397551552256,
                14049810863594677696,
                14047899945136881504,
                14046755647165919936,
                14048677382877737856,
                4821295906805741312,
                4820367788584550400,
                14049528022891518848,
                14049179816082274736,
                4824403309474203616,
                4826130448927041328,
                14038761107343131904,
                4810852209145262720,
                14049973225576423312,
                4800308232723200000,
                14049995619627505456,
                4807717568771531520,
                4812823248937967616,
                14047573210008597280,
                4825124177681552320,
                4823880704686516480,
                14049169339115445472,
                14047664367957566576,
                4824080487495534656,
                4822110916558156832,
                4822474728988646976,
                4815547369838738880,
                4813759360908208384,
                4826393960327734496,
                14045403110379662624,
                14048138448148485488,
                4824412996159721328,
                4826449173214665440,
                4812119531866916480,
                14039064264952847040,
                4810038100637919872,
                4822061851829804160,
                4819607045127841696,
                4824971342012011152,
                14043235008871433312,
                14038603410745437248,
                14045115613112012192,
                4820378306860499520,
                14048292795468980528,
                4820485536164221152,
                14048592981206063104,
                4825634304340203024,
                4826361706128051776,
                4823923018594407984,
                4821067687723533920,
                14034718645823337600,
                4824876054991360080,
                4796846518314719232,
                4824720487400231264,
                14047062858483509152,
                4812604756067401856,
                4822539066659357664,
                4827000063820702464,
                4824178633920672992,
                4815274196970367872,
                4825338915440250384,
                4826152124684246416,
                14042542906148414752,
                14042525956216601504,
                14043099611161991840,
                14033459074969784064,
                14049866209312737680,
                14041437704515657408,
                4820663341206715872,
                4819599997341311584,
                4825659499550340080,
                14047400607394115056,
                14042389168941073760,
                14043454830622202304,
                14048039578958039504,
                14046836207905883184,
                4826454662676513088,
                14039045173613872256,
                14046128589203081152,
                4826030772614305824,
                4811518011268153728,
                14036217924826495872,
                4805744518735155968,
                4820658237813497440,
                14047951338530823264,
                14050149103677225536,
                4823251641267295616,
                14035891587959352960,
                14043771124136676768,
                14047484707462289248,
                14033870594489282432,
                14035382387270127744,
                14049413597009271872,
                4826495797908445728,
                14044302384756198208,
                4808798022799624960,
                4816266262628546880,
                14015765324118446080,
                14029583277355657216,
                14027425222137940992,
                4825548741658910240,
                4820486782811366880,
                14049627269157569264,
                4820869070258316704,
                14047897776056204224,
                14046709688696975808,
                4797351224611823616,
                14044306594147305216,
                14048759603106942224,
                4824921994972638576,
                4819093160934810880,
                4819777150824746400,
                4825469984026456576,
                4821855056544062752,
                14041484337592020352,
                14047162457818414288,
                4825579489031771392,
                14045409921482667776,
                14049502986651713216,
                14044089508238178592,
                4805584847020056064,
                14049642162491457408,
                14047392605268107136,
                14038191608691707712,
                14045926630779467008,
                4826961446116550480,
                4809423666134189568,
                4824685277725351312,
                4815855588104679680,
                14048091258367868496,
                4819217259501132800,
                14047777463802578288,
                14047246937568362048,
                4825755712070607680,
                14049268546762237712,
                4814576355710964800,
                4821694409038310496,
                4823244017262304928,
                14042371362774673792,
                4826785512340213488,
                4818902671001911904,
                14023406777958383616,
                14046259886234207488,
                4823926147925104976,
                14033455468399341696,
                14035239372554111104,
                4826453350357865728,
                4824400787144292592,
                14040639694771469440,
                14032511588392805376,
                14042278402574395232,
                4821443001047528800,
                14047510164774242608,
                14046127177886709856,
                14049387924701320544,
                14043463601800607616,
                4822875730173340832,
                4820354706127420448,
                4826623659534784112,
                14033968932604615680,
                4814905870122492800,
                4825735847869654800,
                4799689029665595392,
                4824079747914595696,
                4826371673164429840,
                14049950732580699312,
                4820367999390297472,
                4824322495376996208,
                4820090362278880064,
                14045929780988237152,
                4826192249397381312,
                14049836059559425216,
                4826633796876354400,
                4826075003648160720,
                14049512940147944032,
                4815195885277015680,
                4826979736650115232,
                4809986930076721536,
                4820213035302990176,
                4824741945156946816,
                4815890841606257984,
                14029183012973093120,
                14046130537650035744,
                4819315693364971840,
                14042917069162641728,
                14046669144130864608,
                4818859157581594752,
                14030328471082210304,
                14039443063793102016,
                4823418770397502672,
                4823818180144152976,
                4826904007596055936,
                14043744198151351840,
                14037374062775425408,
                14047927914571752736,
                4825564456034688016,
                4824533421499704352,
                4823939785236395632,
                14044229703397373568,
                4820601716647929536,
                4819487496734492640,
                4826526329396875328,
                14043231179398194304,
                14045545737844476352,
                14046002242483695232,
                14047763197586319872,
                4826987405878869296,
                4818542575417747072,
                14042858460978928384,
                4823877262103057472,
                4824258821813163520,
                14042651024878868800,
                4814930319937262784,
                4816798607497173760,
                4815823823167915264,
                14050353905051478832,
                14042885595953849248,
                4812575329450717184,
                4825231872087973152,
                4825282376062237888,
                14037676278814186368,
                14050302740000229488,
                14049894648032058400,
                14049206713474606080,
                14044838246628745984,
                14049095836655535552,
                14049968214001048720,
                14044227582927963840,
                14048641082553657024,
                14048372273111292080,
                14046654014624341216,
                14047033100361827488,
                4810301788389754624,
                4819652107322060800,
                14047938053517573664,
                4822499302560775072,
                14048095407390508864,
                4819789371325841152,
                14042888958448864768,
                14048969430698072048,
                4818031726029999040,
                14045642808305735936,
                4825968564518465424,
                4820557431700935392,
                14040743629522074304,
                4815000782626714240,
                4822477092099813184,
                4819378807116125952,
                14043143846145778880,
                4810173887417183104,
                14047046126653069616,
                14046235874810864352,
                4821956453653179552,
                4822019943690503392,
                14045969616696886304,
                14047182795170331712,
                4822770793588756544,
                4821429285262282240,
                14043454524442908992,
                4821515647695305184,
                4823600111391195872,
                4823769809983629952,
                4826201393072381712,
                4824733559659976928,
                14048338761246973504,
                14039278764680940096,
                4819203263347387328,
                4826823705040708560,
                4820141583604387872,
                14047246367360338608,
                14048863302639523280,
                14048017404046559984,
                4822765405561003424,
                4824942651098081520,
                4812718003030252416,
                4820468236814268768,
                4825066985069040096,
                4825569512721551296,
                4819671786241032416,
                14034625309146908032,
                4820839568389181696,
                4820946277405463424,
                14049844745794832672,
                14049215085359949776,
                4818334344290953472,
                14046127869628347680,
                14022220936127863808,
                4826516177736531936,
                4821366808516176352,
                14041435382413692480,
                14049375929547494288,
                4812796398722643072,
                4813289227877067008,
                14037312721648543616,
                14049005237534088528,
                4826829034573383392,
                4826488458664625472,
                4825524396028412144,
                14046636513540159136,
                14048825164605475824,
                4813356299740130048,
                14032842616344302592,
                4811065878872511616,
                4823991091686203536,
                14048705018704599376,
                14044971868279260320,
                14046018082164159200,
                4821797347583687968,
                14043987263225202752,
                4815038065148411200,
                14042345223280430080,
                14048620122827002736,
                14044118514012857152,
                14043744435022921536,
                14046519768891554176,
                4826051844271858176,
                14045014223420747008,
                14035373638332441856,
                14049682757039302432,
                4823270303523298624,
                4822064180558385920,
                14041694855809086400,
                14032837796621953792,
                4816438443657809024,
                4826788103791773728,
                4826520238854468256,
                14047636733556707136,
                4824418530271369424,
                4823410202322094352,
                4817599598034374592,
                4824685115979946816,
                14029764788408598528,
                14047307215220347104,
                14046504293845433952,
                14047589664575596832,
                14042387774984080256,
                14046670580002995936,
                14040923813559830912,
                4826790217518370672,
                14049261678863331216,
                4816375768647296896,
                14049629842661921056,
                14042967395677096960,
                14047270587850405472,
                4824741100189444192,
                14034231755276104064,
                14047674892218507360,
                4823547538853694384,
                4826656806385249680,
                4825956739762067568,
                14048530764307271344,
                14042343636662625280,
                14047958383424955792,
                4819550859965958208,
                4815211313426282112,
                14042965360708413728,
                14049705793243530208,
                14047434928515237408,
                4820554446173328736,
                14015506114511925248,
                4822929228433297792,
                4825784103807786064,
                14043284597103888192,
                14049561312226384544,
                4817127930150870208,
                4819987335537630112,
                14047126856689396352,
                14043008935335511456,
                4826948320477658480,
                14039613373101957440,
                4816065657029506880,
                4821127159174599904,
                14042962080275296832,
                14049718837132357280,
                4819079995865709152,
                14034848005353102976,
                4825044032733391648,
                4819984866554399808,
                14047000303049511808,
                4819989828606245024,
                4823954289410169840,
                4823915094795780000,
                4820079626384799488,
                4813226839480610944,
                4826628316346224960,
                14034502223421584896,
                14044143276650279584,
                14033488023314340992,
                4816300966530191872,
                4822369313988188896,
                4818179196508826944,
                4821668373061070112,
                14040802742465851264,
                4823162495545218240,
                4825024222162203008,
                4825316907755618096,
                14044333239230684544,
                4826437049633839248,
                4819954104206541056,
                4823696242301690800,
                14048628076877786176,
                14044073929032496960,
                4819785834658580928,
                4826274314036046864,
                14049129466280858640,
                4822305249037436608,
                4824676915362923760,
                14030626858710564608,
                14047548513061270800,
                4826299696939748048,
                14047677687271339952,
                4819703657166055296,
                4826123106258670656,
                4814494561027482496,
                14047595719191995952,
                4820290370792754336,
                14048588448461892176,
                4825489440091287104,
                14038430452169271744,
                4821943257095109056,
                4810570234222318464,
                4814441036464969472,
                4826432144159867488,
                14038876040000856320,
                14049846460802877824,
                4797446831860947968,
                4800452802573444096,
                14046806877626272304,
                14029788929538882560,
                4818909271150376640,
                14043585412179423072,
                4823962447889166624,
                4819223493994120800,
                14047818317681896848,
                4826689597366998160,
                4823313439603733984,
                4792767879105748992,
                4822492540107020128,
                4817325418698451328,
                4819374804666530144,
                4810906165122853248,
                14046973755419059312,
                14049143398304481392,
                4823915832138753360,
                14047456354968544192,
                14048030057206810080,
                14049080069005429664,
                4825329629560243824,
                14050203466536735376,
                14047259869801015264,
                4824549576136668736,
                4825422072700504176,
                4821047988790626240,
                4823171540843029376,
                14040605886499666944,
                14047588690533763920,
                14039861601899159488,
                14048919388030028032,
                4791879807981289472,
                4822619776376717504,
                4820136989492235136,
                14039787137695227712,
                14047777870197080944,
                4821778475313640544,
                4824603659490274960,
                4823121015640963456,
                14047272632378851264,
                14046902723877733024,
                4823914248522111904,
                4825432797714302368,
                14049283862014817024,
                4820147655076425536,
                4821438503795564000,
                14044249101722111936,
                4820679207125281248,
                4824030319502576704,
                14047412760310556736,
                14040491766856776448,
                14048433310975025184,
                14045138227902389472,
                14038246844811241280,
                14013182530125299712,
                14044337679270986784,
                14048141994381478032,
                4803044374332002304,
                14044242565610171424,
                14046307199516274432,
                14049756400785096416,
                4807131973487489792,
                4820852463101817696,
                4818359712902447616,
                4811919784360547968,
                14048755303230566480,
                14050269981455532288,
                14037870852578746112,
                4825520135781005072,
                4820354070894826464,
                4823794715321659936,
                4826053468822012288,
                14036991397143189376,
                14037431300751563776,
                4811530836259894528,
                4810926535090671872,
                4825592620633234592,
                4824097521296087616,
                14044175780359309856,
                4819847400102978464,
                4822744404688184192,
                14031160185260761856,
                14048607097045334736,
                14046939316674684512,
                4817330339518588544,
                4812759831043427200,
                14044108570754980960,
                4826009000771851584,
                14037848495792716544,
                4808929004254640896,
                14037065678234222336,
                14020857437520893952,
                4823183312704643264,
                14046950564152196320,
                4815747721095218432,
                14050314493195724672,
                4826225363998048992,
                4804148171821246464,
                4825752542128104880,
                14049709949051090320,
                14048130094101239232,
                4826337035164226016,
                14043381932350579328,
                14049353777096587344,
                4822471464151734112,
                4826245182002943600,
                14048909659817754336,
                14047909261643443568,
                4821221176591159136,
                4826711140177431440,
                4825458692263520400,
                14044860238871633888,
                4824306477632930864,
                4815951350281205440,
                4819253086299931456,
                4796543367766173696,
                4825101563299500896,
                4819999581443394560,
                4824482264609853632,
                4826811345746284752,
                4820922701782187168,
                14047948790565785904,
                4825541011185013104,
                4823196259360788480,
                4816319632084924800,
                14036471294960703104,
                4823035655924240736,
                14046938119666594320,
                14050176578974035424,
                4824509524606850720,
                4816123365714627456,
                14038742311889040320,
                14040494386843939392,
                4825718956116088128,
                4806889039969765376,
                4814575420765909248,
                14042412615453765280,
                4817771483819901376,
                4814495640955967104,
                4822153577161486336,
                14037554026376755456,
                4824727050046397712,
                14039172958646028096,
                4824236915291075472,
                4820762957900082368,
                14032479336683529472,
                14046641404795147008,
                14032056089182161664,
                14032197948507593216,
                14043745007938122784,
                4823584857958768352,
                4820323913366312576,
                14046185783913124096,
                14047429041491562448,
                14047965095846403456,
                4824788802286565696,
                14049654991143129808,
                4825885452662721184,
                14045476205272549504,
                4825868815597100208,
                4819420769586381760,
                4819822403642163808,
                4825592746953216032,
                4813605056777581184,
                4825552316431883088,
                14047765912609298496,
                4824138522888393536,
                14049587860241542400,
                14048173277158064800,
                4813439619653685376,
                4826089665418992304,
                4826196899562722496,
                4825081416070216240,
                14048276227124763248,
                14034284957261792896,
                14046170815933109184,
                4816086607136520064,
                4822809563083392288,
                4824829074996751072,
                4816836911373258240,
                4826046162427789520,
                4824797222859209648,
                14048446240795550400,
                4824143743560886000,
                14046985642333586352,
                14048909038628702448,
                4814301446758108160,
                14048464017215606000,
                4823888234356872880,
                4819423383845975136,
                14048421304194497808,
                4813339900290152960,
                4826728691086466832,
                14046015903365080224,
                4824236855735842112,
                4813915471922892032,
                14039463645589175680,
                14048796532573511456,
                14044598060993028992,
                14042942765800923520,
                4823406627730367792,
                4814163796892690560,
                4820536026366912064,
                14038169298413220224,
                14047611918471099792,
                4826741809243464448,
                14048070145981044512,
                14047871351779314624,
                4826219963917336112,
                14048111882735954848,
                14041990737815684544,
                14039471523651096960,
                4824258170952457072,
                4826255987486838784,
                4811852247995185152,
                4826403842148221728,
                14048178215624261616,
                4820747532149644672,
                14019751516481141760,
                4825537450867081456,
                4806894111534958080,
                4815892556662859392,
                14048042338679889920,
                14044939536066528608,
                4821582547498918976,
                14040933604370686272,
                14043943305402206560,
                14048476690997752864,
                4808318502219236352,
                14043164964543085440,
                4825485388567324352,
                4822552672395115712,
                4818789949735707136,
                14047053024070127328,
                4819654097025476480,
                4826804190407413760,
                4824133763811074336,
                4816648722922354560,
                4817393400097349440,
                4820293062245492736,
                14043953091056011168,
                14049711376046639744,
                4824917227063910096,
                14047134730213249296,
                14031038240764570368,
                14044434224538882496,
                4821748476715239456,
                4823504041115816768,
                14048797153992188864,
                14049938008208514528,
                14047149066117257024,
                4806351249621259520,
                14048120193485889952,
                4809840470600779776,
                4816026615325588672,
                4804948647360359424,
                14048963088481197328,
                14045240901348843712,
                4809394648214140672,
                14048185385951011568,
                14044836711974848896,
                14033785658298971776,
                14047641065199970416,
                14047583799743240976,
                14050181407417338816,
                4820737802524540896,
                14041891759427852032,
                14044457651661143168,
                14046944166956308032,
                14035567746451128832,
                4823013155896423264,
                4824285675630475616,
                4825084525051707024,
                14050269478797102064,
                14050359236633670192,
                14047607623552658144,
                4825652509333356176,
                4822255951798439744,
                4819772822830510464,
                14046978867928959424,
                14046917968702578544,
                4824456049594556144,
                4819625950844985440,
                4816387432303887232,
                4812083553806669312,
                14043985391311278336,
                14044480740720573472,
                4823211887556564096,
                14016583140060821504,
                4819906212071993536,
                14041483172895711616,
                4824949774559324464,
                4817542567014155712,
                4826728159076317840,
                4821520786034099808,
                14049863634959999008,
                14038741117966392192,
                14049368136722705808,
                14048186632629201536,
                4821102470974378752,
                14048244569498905552,
                14044953601067135968,
                4815230950245974336,
                14040974555162249472,
                14043347516161419936,
                14029617310758649600,
                14039860776417689856,
                4820583943804101024,
                14046254775406378272,
                4808329137798987520,
                4825986483115752928,
                14048899265200552800,
                4824739304425436480,
                14035739421423227392,
                14042787038294124992,
                4825817632497591232,
                14047375320605378368,
                4803952415216879616,
                14046234405827477696,
                14032419552812955392,
                4816145077642689280,
                4826889270591175808,
                4825060462423522144,
                4826592297688266352,
                4823356264334252880,
                4824288247621825760,
                14047511999047995296,
                14045946291583477984,
                4824903689575812384,
                4824798081038212240,
                4821186856290193856,
                14049981337315338560,
                4827000395756173584,
                14043124773056072032,
                14046037551195392000,
                4813111672367320576,
                14045120941965299232,
                14048604636422214576,
                14042648769702025984,
                14046716642684931328,
                14046095853466408064,
                4822941483311167904,
                4824259468642938848,
                4823504475960459856,
                14045849879349392864,
                4825771480509140128,
                14044990403509249792,
                14049556253943900592,
                14037445488276187904,
                14044578198019793216,
                14044387310190291936,
                14046298048276456480,
                14042569721787555168,
                14050380414401739792,
                4820817181633632192,
                4821654779093982656,
                14050022148261812144,
                4824553590009302496,
                4824513668487248208,
                14045922401824014816,
                4825145125914348832,
                4826955639517804704,
                14050088439872854224,
                4826342717404428928,
                4823504375151870944,
                14046905484156924320,
                14038246643554791232,
                4825640588322413216,
                4817440889399166080,
                4826619704933710928,
                4819828544130119360,
                14047911018518934480,
                4823476427886154576,
                4826741533517054528,
                4823819962658517024,
                4823017985615223680,
                14007972156868919296,
                4817915087741585024,
                14038019531852635264,
                14049971652863745680,
                4826732531823049632,
                4806702662171230208,
                4800280155724620800,
                14048582412558968976,
                14050176775204780512,
                14038841642857498240,
                4821522603856178848,
                4812159375519389056,
                4817483175532139840,
                4826757774988687920,
                14046042218686540704,
                4811907985366866048,
                14048710865644571664,
                14045554630980844512,
                14033776592126946176,
                14042478820511500608,
                4819032866156458016,
                4816951991993230912,
                14049836654866279920,
                4825002966912610992,
                4824350437780540432,
                14042658649619208064,
                4816387912109924288,
                4822249872411261728,
                14048749082715245136,
                14048910350591238768,
                4821075825689468704,
                4814156455305786112,
                4820352753242367296,
                4824817474869839648,
                4823766221737785424,
                4821413945503262336,
                4824018909257097568,
                14044327407090908000,
                4824092044126163104,
                14047932041556017456,
                4823955314026203472,
                4821899966424712256,
                4824560176261311760,
                4819556483839416992,
                4823582584189814944,
                14048396706455320944,
                14042462281834194880,
                4821415590976539072,
                4818875693049439744,
                14048022164592874640,
                4816359248765248960,
                14048553219247178768,
                4824993443519122608,
                14047470201004715360,
                4814725086017628800,
                14048362820662586752,
                4824201274119435136,
                4817525552815527040,
                4826816321960095920,
                4822495284665335648,
                4823495312536349984,
                4823423546369904976,
                14049804948284949120,
                14045794597291580128,
                4825363654137113088,
                4824304627970683680,
                14045307964267453984,
                14042616500024715200,
                14048545974147001024,
                4826701935269041600,
                4816097250299011072,
                4825040314247223536,
                14042546208692535264,
                4820181521171473504,
                14046979231743893376,
                4824757982060070368,
                4823510128064686176,
                14043456597105802400,
                14048145368947174560,
                14047831280027726976,
                4826306259893735392,
                14037392716565903872,
                4820227960395513600,
                4822837955691074560,
                4823682107330982832,
                14048021331878239312,
                4822613793903993248,
                4824468923427139856,
                14046763139382734080,
                14046570501544411040,
                14043831027226196576,
                14041488578648610560,
                14046438164875921312,
                14046807851315383712,
                14037131730701250176,
                4826859771957013680,
                14041861951313989248,
                14048969939287891072,
                14044464260514826944,
                4815747147179601600,
                4807228720428141824,
                4825335964692005440,
                14038579359248175808,
                4824296091476457520,
                4823371145629464512,
                4811974800141394176,
                4824954027672691616,
                14049017521573291776,
                14033804773590299648,
                14049900982598159968,
                14047900234773537568,
                14048053924107199824,
                4807025578591968512,
                14044049452599187040,
                4822675330746200832,
                4817849261617340352,
                4825166319042070832,
                4818034409673005952,
                14049230956802255232,
                4820342335007337504,
                4815288980825441728,
                14050202921602986352,
                14044226444113633344,
                14046710569192130400,
                4822403151516937632,
                14047111266617014688,
                14045311161844417696,
                4824437209140276208,
                4824294536233436048,
                4826583464122238128,
                14048343277757924144,
                4812534467063176960,
                4811070970808184448,
                4820676808825991520,
                4815520262510235072,
                14041953380187747200,
                4824659542538461296,
                4825924445854376832,
                4821369459846907488,
                14049788119375923168,
                14043389625569876832,
                4816097146744870912,
                4817819963198776448,
                14038935813634969088,
                14050314137765697152,
                4810630835809058304,
                14044439962977664832,
                4822692796627273056,
                14037916695401171776,
                4821948988798858880,
                14047530027596012448,
                4821148769758957888,
                4812741877952696704,
                4826121857522812784,
                14042955203190647488,
                14043838241508323168,
                4826455829917334000,
                14044506214913952544,
                4817242318425768448,
                14046962336677935776,
                14049646546102863056,
                14038373574308968192,
                14049638247713734416,
                4806787291405901824,
                4823593115746579872,
                4819093118386918592,
                4822994777755530688,
                4809961387020574848,
                4823085436466622880,
                4812713748662732800,
                14049334583722684176,
                4822929660385233088,
                4815025488364019264,
                4825057688321364368,
                4821779996738790208,
                14045221209337665344,
                4825587530221902864,
                4818024601764440448,
                4824400704834961504,
                14048429024546680736,
                14037590158187846784,
                14048308392828760432,
                4816861049524085632,
                4816208878815724864,
                4803995892228722688,
                4825194003812114880,
                4823661329109171312,
                14049740215485385808,
                4824223353761470816,
                4819437827420016320,
                14034491112708651776,
                4820503272556359488,
                4825896176477528608,
                4814739028080879104,
                4823916997167553776,
                4826486557849964880,
                14028417292665296896,
                14041312909684077952,
                4820599057763908032,
                4819070306181481504,
                4823509856779361776,
                4823612348510249152,
                14044557735548507104,
                4825357238952569728,
                14049782571897932992,
                14048448058465315408,
                4817196628885106816,
                4826706291810242016,
                14034389231462510208,
                4823972713464442240,
                14049548100495544176,
                14043928937181569344,
                4820947218881948864,
                4824682919731118800,
                4823960403920997568,
                4821872811296834048,
                14047081796615753200,
                14047203450685982704,
                14038660813630139648,
                4826883210122778064,
                14048734369853168240,
                4821246693342109888,
                4824113443298676208,
                14049327646808716464,
                4827008645489881552,
                14050130863787317440,
                4819894905687163648,
                4818824874114218688,
                4826126527355560960,
                4817814506978647104,
                4822235975726277856,
                4825387855685014848,
                4825404711346732368,
                14047662240244513168,
                4820583721379047552,
                14044202145464581888,
                14028086285990765568,
                14043445865816615936,
                14045417496689893440,
                14032225424463567104,
                14047795867073309328,
                14048239301865053136,
                4809511958832710912,
                4821639854725086880,
                14048210935271976672,
                4826207876711999248,
                4823932418190385200,
                14045322633841252448,
                14048744025555198304,
                14004519280049324032,
                14047006101882084560,
                14048309591520782144,
                4826370485642349904,
                4823464484389071584,
                4825633686374016880,
                4819818250586263232,
                14029662975750372608,
                4823645398383868448,
                14044140273208182848,
                14050346319433422224,
                4823780705985484768,
                4824448774291990656,
                4826387294426337008,
                4824904733477846800,
                4826257345629324144,
                4823568242425851808,
                14047494598402896576,
                14049556025970338160,
                14045346765518864064,
                4816882271685640128,
                4812928322042141952,
                4822202457637178464,
                4822743282355661280,
                14048446989852183648,
                4824136861647769232,
                14034110703522126464,
                14037890672735795264,
                14049229296017695104,
                4825494913203540496,
                4822287670857857344,
                4817896458487387200,
                4825984135807891488,
                14044795731299322368,
                4826869491530128944,
                14047557388804465792,
                14045273610727535008,
                14044622858232728928,
                4817795697797931776,
                4813807398642846848,
                14049836151809199248,
                4824575904371739184,
                14045484026610000512,
                4808120005931792640,
                4825049572854158608,
                4807416235454870272,
                14039181824665880192,
                14042122446237690304,
                4826825440926239904,
                4819386461792489376,
                4825454054599997536,
                4824175878193000432,
                14049041100006051040,
                14046256726845991712,
                4826228254255950912,
                14043589627205975744,
                14032719653987641600,
                4825055616313143648,
                14042462378922748416,
                4825679120283502160,
                14048327036877893648,
                4824380379149475152,
                4825324485563110224,
                14047991840588314464,
                14049340628751140944,
                14050386581483220384,
                14049022429583085872,
                14033312282245391360,
                14046732985129364944,
                4812652715911210240,
                4816213878965598720,
                14040038480545065472,
                14025160878632648704,
                4826963780137039648,
                14047522265028865632,
                4820349660205531136,
                14036883772189656960,
                14044152749069925696,
                4825552828696468320,
                14048563823690479024,
                14030455256348985600,
                4825985257305659520,
                14049119559190809664,
                4824407092655869120,
                4826876864970481472,
                4819589842567840480,
                14043844513007503360,
                14047701361816516112,
                14038673881964376448,
                4818578847743258624,
                4825009922789398752,
                4794647900895479808,
                4826584262023826784,
                4825475835751686336,
                4818935633117503968,
                14046311634240345824,
                4816243175557617408,
                14047316128610743712,
                14050124867208011776,
                4808382482357242368,
                4824642767332485792,
                14046690852699346880,
                14042258888921612928,
                14042913818238120992,
                4823601825046207232,
                4819795939960280384,
                14043305642111563680,
                4825428231513926416,
                4820120878080386592,
                14047037798896737696,
                4823516157604645888,
                4815747829737092992,
                4826252426656470000,
                4819926446552226976,
                14040010428707993920,
                14043435723798294848,
                14043233969202285504,
                4824445073012859360,
                14045006988632565856,
                4820560834806834240,
                4815294002732771072,
                14042501223771940000,
                4821592541054222560,
                14045554554677133472,
                4826372287928391536,
                14048744121856970672,
                14043538274880890784,
                14045509255011748448,
                4812244562852267520,
                14049968039044416848,
                4826915182655836496,
                4819351863690680736,
                14046443947125096064,
                4823646985388566560,
                4825102256140644624,
                14048823737051732032,
                14049714216147792000,
                14048500942435690432,
                14046967218525159712,
                14034345696757952640,
                14040537946971417472,
                4825102698915087280,
                4825010718277323440,
                14040220089583963840,
                14038953125165337472,
                14050052470812233552,
                14033724626394242432,
                14040529519055901376,
                4807618178158558464,
                14048034691616895360,
                4824206041696383136,
                14045748618996727968,
                14048176028304207888,
                4817774454980068352,
                4819022413307113536,
                14048038073258886528,
                4824255453644224464,
                4819334078957093184,
                4822953738851166784,
                4819777161106546016,
                4824371788628917008,
                4821180978528803232,
                4818210681043392704,
                14050220024392281264,
                4814460917429043584,
                14048782837587198768,
                14044897144280841088,
                14034285676187728000,
                4822114357786113792,
                14047222359279277696,
                4803356161066532352,
                14047390369256095616,
                4824669783340554528,
                4823807521836723872,
                4821428959640002464,
                14024500817583929344,
                14041572821642777536,
                4820334721759161184,
                4815093687146802176,
                14049192922549600848,
                4826107246492551200,
                14038255593217494720,
                14048070915991946496,
                14037017753525203072,
                14049162615217054880,
                14040261855872021120,
                4819358922875158464,
                4803459961727256064,
                4819041052901324384,
                14049829626863457904,
                14048302278328593088,
                14036184300521872512,
                4810111472734145536,
                4815629102568766976,
                14049725704914389040,
                14048698355980350736,
                14046907874083368928,
                14044219613299633120,
                4826843843341551344,
                4825814879252869680,
                14050387031982471616,
                14046611041701457568,
                4825304392467587744,
                4825482345109604528,
                14050360798251040944,
                14046781266396278960,
                14039512020855226752,
                14050166359293773648,
                14033601036272941440,
                14045892173451118368,
                4810107325648705280,
                4819596456235106848,
                14034676051888983040,
                4825538221735414288,
                4820736741307720384,
                4816406278538255232,
                4825098644895795552,
                4815890859717271168,
                14047493601964200880,
                14047612289691821872,
                4823232864194843616,
                14040337312209482048,
                14047094853312119584,
                14047603550125293728,
                14047395006479348256,
                14049004644282541696,
                4819829006639404512,
                4826127954952750512,
                4820053235145574784,
                4821752284220280800,
                4822190597677158880,
                4825318946518790880,
                14047594724273745616,
                14050009994324352304,
                4820650890674854240,
                14039451415979393216,
                14047260395530473568,
                14047652180770077440,
                4824098156969192480,
                4823382309099936000,
                14035860561104472064,
                14039390791156409280,
                4796408937667940352,
                4810481476953535616,
                14047990478854565408,
                4826515146318441680,
                4805488446506747136,
                14043705800095967296,
                14046172787990548864,
                14037755041527788160,
                14021610300325761024,
                14043147634800268928,
                14041663058837872704,
                14041544739256108480,
                14047161686811858560,
                4825906789220059360,
                4824196507355004752,
                14048415935474726752,
                14042348734584953472,
                14049548813523729184,
                4819393917570848512,
                4825765607257631520,
                14045723735397976896,
                4812499529122388608,
                14047746179937980096,
                4824643863796155792,
                14048372722326881152,
                14033904761883055488,
                14049729029885848944,
                4819540472962949664,
                4826951853175949824,
                4825769893550953648,
                14049775327798027744,
                4824672908039304864,
                14042159892508817920,
                14049038105367161232,
                14048055525241910688,
                4821612229112130048,
                4818789576123961280,
                14048422127579856528,
                4822296188468900832,
                4819087040934395136,
                14042220494334781632,
                4825411306427650624,
                14042923719704688832,
                14044761843608653856,
                14040944860831471936,
                14048964086407954528,
                4824104588097178208,
                14035923090899508096,
                14030524012802870784,
                14047422351335699472,
                4823015253974865408,
                14040383510463157888,
                14047275360713146336,
                14047391090409943232,
                14047850381142283008,
                14039516883028265152,
                14006415774645075968,
                14048499678039701200,
                14036545505289196672,
                14048847478039742336,
                4826623829027218368,
                14046837267005826096,
                4818915438175823680,
                14037399254739363712,
                4816033507981116864,
                4820385877433056832,
                14047615650387250288,
                4807038628806562304,
                14044422482325045664,
                14047812237176520288,
                14048509833824251840,
                14042212732525123008,
                4825198427790427104,
                4825624362522840928,
                4815008762717817984,
                14047036551828177136,
                14050222615451067152,
                14040214265193336640,
                14032230174190772480,
                14044050054574931136,
                14039995569462228480,
                14042357303480415328,
                14032273916463947776,
                14044167584954213920,
                4823621736779969056,
                14049200019094823072,
                4826076196071654448,
                4802918797468423680,
                14045735987758439104,
                14047247353592620288,
                4824778785395283888,
                14049983280216469728,
                4822128190067187072,
                14049367367560314064,
                14037517315011367936,
                14041349824715694720,
                14047878350251701536,
                4823891494123471168,
                14040075337064462848,
                14046868729889458672,
                14041731896359393856,
                4820078566836918560,
                4820902115747632640,
                14048826124561595408,
                4824227353872573392,
                4800915695091262976,
                4826636136481301248,
                4814982297116827136,
                4821828722561273344,
                4820498837584286336,
                14042939358816585056,
                14045418282475930496,
                4819640142905624704,
                14033731889993414016,
                4821479698086380768,
                4819397642454309344,
                14041335567837243648,
                14036140589121085312,
                4816870774372371968,
                14044494726856080512,
                4824703986083544784,
                4826965952713317280,
                14047924308892749968,
                4824118392422061456,
                4823746317588446384,
                14049046926733949296,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4831465198680277000,
            pinv: 4382500666457514068,
            mod_data: ModData {
                n: 1013749720809473,
                ninv: 2040746090583899817,
                norm: 14,
            },
            primitive_root: 3,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                4817247727980125568,
                4825321074127147056,
                14045897366133639168,
                4799076302293404672,
                4815096634960094144,
                14032413498573211392,
                14048131086875926720,
                4824961258136783936,
                14048647426631102048,
                14033844839309557120,
                4812376598533030016,
                14040476274729997696,
                14049317458526386944,
                14047091506787708368,
                4820111890967091360,
                14045519652690835840,
                4825423312945966352,
                14050221761703734416,
                14049879988542651136,
                14045653392598027936,
                4809658051387331072,
                4823047852989701184,
                14043897352608058944,
                14048856151523561904,
                4815848502957585856,
                4826892684983434640,
                14042869236451698656,
                14049880623794938528,
                4819578146339783840,
                14044812389203359168,
                14049149527341699872,
                4817426255157415616,
                4810616878939192704,
                14040675184820247616,
                14043338056002125888,
                4825988602241020304,
                14043675625404483392,
                14046484360952658048,
                4823071036591053984,
                4823785102892147392,
                4815640938452832064,
                14040906557683203392,
                14049442167416609552,
                14050082520665835008,
                4825529645800553248,
                14045697111833594848,
                4809701732190784000,
                14046740669301075680,
                4818491503596189184,
                4819271739338795968,
                4814994381110367936,
                4814287932015059328,
                4826893216458965200,
                14049374347974003856,
                14049690523986300064,
                14046993172634227424,
                14049922908470693056,
                14038060216251590720,
                4818989473290089376,
                14047074031023484528,
                14046432866756713568,
                14035276392248976000,
                4817754412243740800,
                14037883319745406720,
                4802212562804460544,
                4821270173053818208,
                14039683621379689216,
                4825703143847413680,
                14046988017117655168,
                14048612349944228592,
                14030193643659148800,
                14048133864531518976,
                4816534743448840960,
                14032202866638982912,
                14044953737445956608,
                4826590184334372560,
                14046844280201201664,
                4820640033542428512,
                4816841558156658560,
                4800610735082861568,
                14041087126981829504,
                14049013824293805328,
                4820326027993933472,
                14046814625996616816,
                14048695259430989968,
                14043991882890555584,
                4825301109404366816,
                4811252942205037440,
                4825607720404157760,
                14047707233972303376,
                4818518089915074432,
                14038543403062469888,
                14049111493964486560,
                4822421055549660992,
                4825303102579638048,
                4820051247094122240,
                4815452854279961728,
                14044032486787756480,
                14043357989756589312,
                4822365832989823456,
                14027286583426888704,
                4812051851201686400,
                4821556755010824928,
                14040830369786274240,
                14046607602693685888,
                14041542586621442816,
                4817363364845815424,
                4824077197219980240,
                14035164600336721024,
                14049117324932605856,
                4805496587839898112,
                14043070558021474592,
                14042393142787556800,
                14047267672452546016,
                14050203426318129744,
                14050205212826655856,
                14042011226601735872,
                4820790042538903392,
                4821450440634288032,
                4798803893457392640,
                14047500319381373104,
                14031666317021128192,
                14044037260676175872,
                14047435325672699520,
                4824401055608835136,
                14047229578779307424,
                14047290655869536768,
                4817775182462038080,
                4817839968247378880,
                4826727467825576032,
                4825705393107090640,
                4819245725442869728,
                4816732980152952768,
                4821480803481381536,
                14046033895611066784,
                14047517011185894016,
                4821776036603368256,
                14047933236563027712,
                4826435711911637664,
                4820501196403473088,
                14042855259192733728,
                4825294802508505696,
                4811783740398346112,
                14043393108172016608,
                4812227194344915968,
                14048478971209265328,
                4819052380929893888,
                14048267554488027248,
                4823831305139698784,
                14048560878999062144,
                14048888262160795248,
                4813401423847082496,
                4822321984566678432,
                4825411103948254160,
                14049956069210542544,
                4822373800028262240,
                4820785044898098240,
                14042436161317528416,
                14050022381485030240,
                4824885920824324416,
                4826172787133621248,
                4820012297158944896,
                14036247539392002688,
                4825378076858837040,
                14043132369698897088,
                14044103387171144960,
                14024863020143131136,
                4825118156218632576,
                4810485575720084864,
                14033248211791048960,
                14049396061044568080,
                4810490341997276672,
                14047827549995917376,
                4825153696758014448,
                14048783455109537632,
                4799927289216800768,
                14045711037293712192,
                4824825183013633920,
                14041375434691079424,
                14041984292342412864,
                4820252426055550848,
                4826067712725732960,
                14048296872887875408,
                14041865134026575104,
                14044281813490105088,
                14037713456342445312,
                14049614924845659728,
                14048019028511673904,
                4821983803495383872,
                4823335156631948352,
                14036381263410124160,
                4817445037286628352,
                4824728085145249360,
                4812457641990374400,
                4825867696990924448,
                14050313017841934816,
                14050075819775351616,
                4816908024084271744,
                14047918857752990416,
                4825073243497182864,
                4821468600371419488,
                4825669557015477856,
                4825895375065998720,
                4826543597171310096,
                4814685298716716416,
                14047254363350515392,
                4819059368480581600,
                14043156558178590848,
                14049586759268805728,
                14047820557986704576,
                4820007423222845440,
                4826784660194864688,
                14039838824737512512,
                4809922061111647616,
                4820717299139551520,
                4816346758052272064,
                14030193050466259712,
                4807027060315917824,
                4797114810679913472,
                14049272329023560496,
                4823737395222962384,
                14043780618518719968,
                4826169169264256672,
                14049051289844378496,
                4824688892948045152,
                4819002335038054432,
                14046913438012915344,
                4825618611410595584,
                14038807439231778624,
                4821166297978331968,
                14044189910563672480,
                14045689696735212672,
                4810926285687961216,
                4826046957226221808,
                14046299921412173152,
                14043932173396777856,
                4819358751019051776,
                14033774489891646848,
                14045459624458070784,
                14049340655944428272,
                4819933974381387840,
                14041514089948438272,
                14048879830235182480,
                14043357388614516960,
                14046139160351580096,
                14043257177500582912,
                4814571168449543360,
                14038054265897331072,
                14050162231718555440,
                14043855283120998880,
                4816605869219511936,
                4821692244655636832,
                14045908279964528896,
                4824161211664133248,
                14044623744673721792,
                4818625522523472512,
                14049803851566399776,
                14048702450340064400,
                4824709352340310160,
                14048042223671935040,
                4822146589031120512,
                4817227680101645440,
                4826484027378866800,
                4815383370009139648,
                4824430616525852928,
                4816297551031623232,
                4826293191961438432,
                4826121693898336832,
                14040272768988886336,
                4822794872035475392,
                4819178925861825216,
                14040930387960073408,
                14043845036815974816,
                14048858663024925776,
                4824219575099298224,
                4812708167864436224,
                4824781804083932400,
                4823386089894994848,
                14046476056355188672,
                4816710127987636928,
                4825052195407440784,
                14046789934236262240,
                14045283020417087904,
                4818339673445823872,
                14046931085037218848,
                4814570516628108096,
                4821597740470276128,
                14045715297449567456,
                14046799343966158592,
                14044526979886664096,
                4822590163478787456,
                14048944124198852624,
                14048037612365859680,
                4825374552605309616,
                4825883494317744400,
                14043651043260695072,
                4825783811623427840,
                14002529360831528960,
                4820998670401813920,
                4824011924454919584,
                4825940018090815264,
                14018822878973458432,
                14049672696347445328,
                14034702410133325952,
                4821354039653970848,
                4824919630999725216,
                14048260826578930672,
                14049322901801867808,
                14025396975639941120,
                4820421926977429472,
                4824952101725667344,
                4826069920802110816,
                4826400069372329104,
                4810293334654057984,
                4824339524613870944,
                4825557554763124432,
                14037987054156467520,
                14046015563539831232,
                14047519151376571600,
                4821542814897532352,
                14025023093008722432,
                4824573049926996496,
                14047889467680928480,
                4826447026563549616,
                4810243419264615808,
                4826676334017085168,
                14049138981758873424,
                14045309689852550368,
                4826257931627573744,
                4815882363200098880,
                4815766465308388480,
                4809996137606160512,
                4819536572687478112,
                14045095257580854912,
                14046899717161879360,
                4816660067459389248,
                14048423701644560960,
                14034053766605905536,
                4824840291761964848,
                4826893092015778512,
                14047033290823828240,
                14044854007769184640,
                4824595704843934688,
                4824739528485642208,
                14048090265605705024,
                14046972269284891488,
                4822287088818254016,
                14036292660791469568,
                14047479066706692960,
                4826059055465154688,
                4805217788935621120,
                14039929529930651712,
                14045579995840724736,
                4821028449249191264,
                14048633041888341040,
                14048700923782786224,
                4817082879672406464,
                14049705608751836720,
                4821150750313838112,
                14047206191228607392,
                14042506440118707200,
                14047361221958137088,
                4819863867688203744,
                4811068521210525312,
                4824873851817057552,
                4822760170925511296,
                4801420263170261504,
                4823434161378211280,
                4797541161619253248,
                4823831900861184672,
                4793531812516716544,
                14050238926341491824,
                14040930320701782336,
                14047933410996576016,
                4819683150271984544,
                14045730136551340704,
                4810504454175822208,
                14047009818833638752,
                14047812851283968912,
                4825514204256313680,
                4819815371168489216,
                14028149300567108608,
                14048821856356385328,
                4821709813957582912,
                4826925035543150864,
                4824385933560766112,
                14042551645153713152,
                14046872573205029424,
                4806908526872391168,
                14040632295050160640,
                4826201876143785680,
                4824573620087514544,
                14049336286930974160,
                4806435030947848448,
                14050262510935517536,
                14047994999201748720,
                4810549870652156672,
                14044225502951681280,
                4823826953806031424,
                4824563562880265056,
                14037408746295225216,
                14048793781541068768,
                14047919632595832688,
                4821063592540214048,
                4819464693928865344,
                4823851066292438960,
                14038077009473914624,
                4815870078126786944,
                4820413949281085856,
                14048381398248761168,
                14047781361523048256,
                14048190403104487280,
                14035827290296305024,
                4825722656047968256,
                4825583003686548592,
                4822593431742379648,
                4823839111780243408,
                14026908170648473088,
                4807646277057426432,
                14047352483697346400,
                14048773854632410080,
                4825821991769392912,
                4824531381501430688,
                14044876376391119968,
                4810786286085069056,
                4823404794866865632,
                4818768938731229760,
                14049154589141956912,
                14046397336735781824,
                14038617669938231616,
                4824914636947133632,
                4826290250455565344,
                4817664509448726144,
                4826261276281810416,
                14038877300792047744,
                14045113414164871296,
                14049639085809418528,
                14042971026722054240,
                14032740906178474496,
                4821185458492525344,
                14036705879821549440,
                14035044639995235584,
                14049022278692248592,
                14046483307483724096,
                14043661628638383328,
                4818093367173774656,
                14040476733919508224,
                14049163111699653744,
                14045437876906763712,
                14045758151386091168,
                4821480813655307392,
                4825952211794413888,
                4793951600858667008,
                14035129932671057792,
                14049333757598101280,
                14048205968065322928,
                14039245339415826880,
                4826204962667300560,
                4815414079499956864,
                14042490622445243904,
                14045769223322912288,
                14048586673093989264,
                14047014276973146000,
                4823580973391122832,
                14037466350456584576,
                14049359445535476096,
                14047297078540720224,
                4811787419445252352,
                14028900113309792768,
                4824240337277109472,
                4816547074395133824,
                14037397287508535296,
                14045110014875789248,
                4826123424112271440,
                4797350601556633600,
                14041518906197837696,
                4820529605923954368,
                4825190814279963824,
                4815321990733636032,
                4826582632475960368,
                14043393699986467616,
                4823916116940856544,
                14050195792884740016,
                14031645050948277760,
                4826077430167600016,
                4815711447509679744,
                4826901187515376976,
                14047568802398895456,
                4818884524874976288,
                14040187179418917504,
                14041510136669915840,
                4822851777368962080,
                14049179291689597776,
                4809054163488595712,
                14049511936722004368,
                14049443848248981968,
                4821883686839722848,
                4822317592557665024,
                4820933286182567648,
                14042539615341990432,
                14049565438113034208,
                4826254480637490656,
                14043008279789330592,
                4820030287370943456,
                4818802015336235136,
                14049840906431819424,
                4826038665313220208,
                4824662433783319904,
                14044142809064929056,
                14046752340706113632,
                14049876585425099744,
                4826229668489658816,
                14043255517149582144,
                4819107838797533856,
                4819694943498257568,
                14049909971315187712,
                14043187220776154112,
                4820311334255641088,
                4825258002643439184,
                14050128850472564560,
                14041209073460566848,
                4810976488444294784,
                4823618207383722784,
                14048630895509271424,
                4823539148065537776,
                14050135555417231456,
                14040655362754024704,
                14033616761445810176,
                14041691844414895104,
                14050320916628430080,
                14049124774173115328,
                14035319571415079040,
                14048699395981034384,
                14049095948128942752,
                14048926419471587696,
                14050058752937606432,
                14046831644390647920,
                4821470706560000544,
                4818363553368584448,
                14026630451652196864,
                14049834904153395200,
                4824860412181453760,
                14045689841766635040,
                4825182705554027904,
                14047798498244471328,
                4824012117900795600,
                4822478178905397024,
                4826096103588816336,
                14047580743331772720,
                4825430160754486112,
                4823127884763617472,
                14033694608093543680,
                14035586030643123328,
                14047842109729376384,
                14048167281019064144,
                14050154990887546592,
                4824138704351804944,
                4817143288096894272,
                14048061818425130736,
                4817706371691658624,
                14046746823486324464,
                14044375444772357376,
                4824309274559565072,
                4824320249358117344,
                14042689886707067424,
                14043454515401690496,
                14039087968893311552,
                4825935819913731360,
                4824383397909951616,
                4814484324684005952,
                4819577087919466080,
                14048101058097173760,
                4824927411552890048,
                4805959722732647424,
                4826271371045042400,
                4818626670550594816,
                14043408062671562592,
                4814560135319369472,
                14048920724651993280,
                14050024079913756720,
                4816655759203087936,
                4825471561409238096,
                4826915875022509872,
                14050231928991914832,
                4823638122275032832,
                14038554271987794368,
                4819084626709039296,
                4820472390486184320,
                14044838543423845792,
                14047719534458722944,
                4816085638089357568,
                14045723399422283968,
                4824395432876887040,
                4817922828175261504,
                4824684725355074528,
                4809975698137597952,
                4825779005969581360,
                4824652933432589568,
                14043666893341873600,
                4825612640208968912,
                14047975420344355920,
                4786978507628683264,
                14040769739506090752,
                14048409043299729488,
                14044744986252845696,
                14047344966096101408,
                4811165537628197760,
                4822941956264106304,
                4816057076874422976,
                14033242976542914048,
                14049829326051514384,
                14048051758011764304,
                14034260906215013376,
                14050152093276452384,
                14045160038234589600,
                14048266368775294928,
                4816206936817654592,
                4815101186579795904,
                4825968563325836848,
                4824364409306105104,
                4825636546095512576,
                14046769672401285904,
                14031918399171531264,
                4825550189494056336,
                4814541607317456960,
                14033491541048930816,
                14045690057850890656,
                4802767042748937216,
                14048371390733981824,
                14046825329767057184,
                4824818656724774976,
                14033443567766374016,
                14049598424820232416,
                14049030248131398944,
                14046979659025601136,
                4812934853586468224,
                14037745419383400000,
                14047798955405701712,
                14048412153231304256,
                4826678622688850352,
                14049679056020007984,
                4826803449031923648,
                14048484583406910928,
                4814511303219655040,
                4815222835682892672,
                14047061295177712032,
                4823995697094804432,
                14042463937266084608,
                14047067789412636224,
                14044508290484253920,
                14050203866494847296,
                14048621081002088288,
                4821689750421510496,
                4825366472969600496,
                14049786833126483360,
                14021432429700867072,
                14047400305681501312,
                14047157483025862688,
                14035891889080145792,
                14048451975820597408,
                4823003925825723840,
                4822941707106765632,
                4822066021741098784,
                14044738465294511136,
                4816756103666551424,
                4819850210025292480,
                14047095445248234768,
                14049241641059216144,
                14048398067929671136,
                14048767550551961056,
                14047496300270598944,
                4811909507216142848,
                4799024801365312512,
                4826595031267162320,
                4824390859054002656,
                14048132904256476288,
                4818233267543254016,
                14049006817536756064,
                14049372407728530272,
                4815425732848367680,
                4825892109393936400,
                4821747396259684096,
                4819118424667024608,
                4796462607974899712,
                14037123605610355072,
                14048727823331434608,
                14044917453734940288,
                14030191905886627840,
                4809432075117755136,
                4825131942972153488,
                4825949344106449872,
                4806619522554018560,
                4823615112182119344,
                14043569243837980064,
                14038669094821695424,
                4825237033959089440,
                14045908771484399584,
                4823892701164094496,
                14044134670781049056,
                14040025907226767552,
                4805328444848555008,
                4825933992639767168,
                14047650787185673904,
                4818839670387821120,
                14044121155032277152,
                14049234577508221456,
                4816425340173759872,
                14049865421537271520,
                4822530421945224160,
                14042275633722909216,
                4815269864310197760,
                4815507000795249536,
                4819318177621888704,
                4826366625421524512,
                4824341714701900800,
                14049786711066844432,
                14038838971763903872,
                14050208519389623696,
                4825987249978294288,
                14046310523685566720,
                14050166585083853856,
                14044236536628223456,
                14041566084122202112,
                14044601176253674752,
                14045746114518815776,
                14047825871604318384,
                14045748509616889600,
                4824896069042970960,
                4815681103907160832,
                14039019360194180608,
                14043136526094787008,
                14049522165432313280,
                14044824767302418464,
                4820259762042386464,
                14034391132653060864,
                4819806861728229056,
                4815177723391939200,
                4824821687299382752,
                14034167427550307712,
                14027994832328501760,
                4819742118653682368,
                4826284060157550496,
                14049797621315469216,
                14045514310149370976,
                4820778765529905504,
                14049494127544297824,
                4813861410196148480,
                4826104822685119136,
                4817066621055353152,
                14034373091663632768,
                4811287658855612544,
                14049008343322368784,
                14048243208946989824,
                14049597113988013040,
                14043502262025973440,
                4823878020634670256,
                4820679423514715584,
                4823018892214500128,
                4816831146529527104,
                14041620601628831104,
                14042294240788787200,
                14039695798833516928,
                14048889493018925584,
                14044502654623655904,
                4814334260551099264,
                14048654833481089376,
                4815694363615094848,
                14047421979063561392,
                4819199469837470880,
                14044845553357749568,
                4815758790417902592,
                4815462067064319040,
                14045518664255117120,
                14048522976973641936,
                4817175035022535680,
                4810338678673849856,
                14046542040971371616,
                4824240308981853584,
                4816471078617809728,
                4823724605489689216,
                14045694238483946144,
                14046520713912716192,
                4823500299169456160,
                4812083763592010496,
                4823985822057411856,
                4816634651574984576,
                4823740590247787808,
                4824282134247508400,
                4816062785382170752,
                4825619746344117184,
                4823912139976035344,
                14048675424662902672,
                14042939885674523424,
                4821624402847589344,
                14049007550489459664,
                14046331685242379104,
                4822554852884839008,
                14049747681362846944,
                4813184206679021312,
                14047066134311707472,
                4820820259085746016,
                4815662347878129920,
                4820551052513217824,
                14043124730426127648,
                4815101220031491264,
                4819455526624935936,
                14049898863557837104,
                4807289677020162816,
                4805829356415959808,
                14047965674250709040,
                14040136117962901824,
                4815507543518433856,
                4825623386341106672,
                4815856688992445120,
                14038510960212613632,
                14043680886784916320,
                14049441336926428016,
                14042561819160995616,
                14033765482838049152,
                14048213742507053664,
                14042047508359348544,
                14047645253136802272,
                4818581100918459136,
                4822934330491954144,
                4825598065719643936,
                14038482410683762944,
                14048316668686995968,
                14043947716148251968,
                4824311298492920976,
                14048369931211422016,
                14042847951216838336,
                4826917181362397344,
                4821522437948429088,
                14021150816372140032,
                4821316945228902368,
                14049800850834786800,
                4818877886408567968,
                4804036933624215552,
                4813660962439297024,
                14039061955985228736,
                14042481528347465728,
                4815343921417232640,
                4813033908711305088,
                4823190010914186592,
                4813501654668972544,
                14049764259323347632,
                4825686801023153440,
                4824749651623456288,
                4826366151590533200,
                14042863130472813952,
                4817721990984510976,
                4824173051796002288,
                14028800575884833280,
                14024609263881438208,
                14037220253630006912,
                14048412866819204320,
                14042581745818108992,
                4822689549024319456,
                4820419339235596160,
                4824421530321601024,
                4825859610368592688,
                14039572945181449536,
                4820987246690320576,
                4825344265006339776,
                4819546325047122432,
                4825291774233448832,
                14047242210352665808,
                14046828194192830960,
                4820792259458170752,
                14019627585624745984,
                14049431601287193440,
                14035491022620441600,
                14020769037385361408,
                14048543181998637088,
                4813475114576069888,
                14048550552911199440,
                14039821272519929792,
                14047100360468475840,
                14024219802742226944,
                4821782981289337792,
                14045308445804968032,
                14044906799280268192,
                14043295173858398688,
                14031885951784964352,
                14045478486265331968,
                4825468511369567984,
                14046006499878247968,
                4824878292398498576,
                4825382953520901808,
                14039814746421640512,
                14035990051551264896,
                4824216047668151856,
                4821021150233557952,
                4815175965809316992,
                4824711755678594208,
                14042131662160587904,
                14046790590764246464,
                14048569552876582624,
                4821624953849427712,
                4814043525519353600,
                14050203280581311344,
                4823731604342113312,
                4824911616728419408,
                4820196491582223680,
                4810429532919018880,
                4822190182100799584,
                4826772259511108048,
                4803763847718480896,
                4817631166608410944,
                4826590278193928272,
                14043580606556829056,
                14048824762071397424,
                14044912323819590688,
                4825868292679894592,
                4825154300159856256,
                14050110175022115824,
                14047859417880894304,
                4820026358652404704,
                4817237118153420160,
                4819146540813001088,
                14040394777020196416,
                4826111566665222832,
                4817920400597215744,
                14049512809596988368,
                4822477386213783456,
                4822645937828777792,
                14050064663568410512,
                4822210632246529472,
                4824324264052326640,
                14038518332673861632,
                14049598044163080432,
                14035673663585692288,
                14047689305557722992,
                14033388469789937792,
                14039809171386309120,
                14043949727104152128,
                4822972836137302304,
                4810855576822244096,
                4826539129364821808,
                4824603841237380032,
                4821864584250289568,
                14048632679247674976,
                14036793094333882624,
                14047925592039309328,
                4824653457492522864,
                4825871936971540048,
                14048576465561437424,
                14024610100978245120,
                4810540742116280320,
                4823956380359175584,
                4822707087601131808,
                4802620402126849536,
                14046334207775196224,
                4821174982928947264,
                4802846403564153344,
                14049266538475637568,
                4808850643825442048,
                14050301257407021936,
                14040586408748265472,
                14049830648169289968,
                4826379937068506960,
                4818957934909462400,
                4814622985871031040,
                4820613361651953344,
                14046256360993203648,
                4826805614007695728,
                14041151319512331072,
                4823681476165661888,
                14049859238794401376,
                14048648296448771008,
                4821879794722405472,
                4820719939125484928,
                14041881127082587008,
                14042945285866221792,
                14039500415128635328,
                4817090972240461760,
                14044696434556812704,
                14046422206168833792,
                4826323303096491440,
                4825375922828193376,
                4818840990549136704,
                4823964574461564896,
                4814890768699297280,
                14036611279488544768,
                4826083103752923728,
                14042812927173664352,
                14047413986230291600,
                4805564067941945088,
                4817514956410754560,
                4824975970523952800,
                14050231891602647232,
                14049961206181387168,
                14050212595411043296,
                14048346110030177360,
                4824614032947703488,
                14036986207363709440,
                14041157670583370560,
                14049778515500089904,
                14047105661380568240,
                14038444686944273216,
                14047824257011488592,
                14046777986997232848,
                14049569146145233312,
                4822011828346373824,
                14046419121918514592,
                14047299613483835792,
                14048261979949853904,
                4822114390072989248,
                14043007440337998400,
                4820385573103708352,
                4802755167629208576,
                14048029743312987840,
                4824804698925307216,
                4824517644622516896,
                4804312500609511936,
                14044804324760050816,
                14050299319780785728,
                4818812611163396160,
                4818914735497844896,
                14037923899594549952,
                4806914803854025728,
                4823855671493782080,
                4824938766814820240,
                14045047802481543776,
                4823710904618536656,
                4801151897131472896,
                4810471032896192640,
                14042919441463922272,
                4824645279463541616,
                14048545031687348672,
                4821442781824600160,
                14039726724744515904,
                4820640678625198560,
                14042575444748416480,
                4823878546802610352,
                14044068862098677088,
                14034354528286481792,
                14047476926720607920,
                14032178582844491008,
                14047930339899884480,
                14047509864096854752,
                4826678430448873088,
                4822516940025661856,
                14049453956792296128,
                14049838119601362976,
                4826481272856355680,
                4826318640303867536,
                4825506368441949616,
                4825022007861316832,
                4820921832299512672,
                14045818337179549152,
                4818098033005847040,
                14036432480280821376,
                14050171878416033632,
                14050125404423452240,
                4811625315005181056,
                4824386137318990272,
                14045173072756503840,
                14031906694195139584,
                4825700730707832592,
                4814924687069149568,
                4816802454571175488,
                4821160121534093280,
                4822511029048724928,
                4825409474142888656,
                4825473252844903200,
                14047292370171146368,
                14037665394332372992,
                14043948280129620896,
                4819258095941803392,
                14045074045605102752,
                4816794549039724288,
                14043829607258225216,
                14048471408774628816,
                4826652500105106112,
                4826354426784644208,
                14040110278804448960,
                4824639931259022176,
                14037315726303117952,
                14050048266696721680,
                4819851025585314816,
                14046009066308168608,
                4823434993616185376,
                4825753558535047104,
                4822327051868229792,
                4802970576429953536,
                14047026830261247296,
                14049189304802691520,
                14049093584275153904,
                4819902555315921824,
                4826456219583485024,
                14049409329959976112,
                14046086467962991872,
                4797803988727835648,
                14047427519949842544,
                14048639211188112624,
                14045266517437051616,
                14042731419909285728,
                4816663150541298816,
                4822777613850569344,
                4826698796270417712,
                14048133399859796896,
                4816414454972982144,
                14031211772545969920,
                14036930816947345920,
                14048850140412403200,
                14042547861214274400,
                4815720106637119872,
                4824280276900405488,
                14050145557281474448,
                4824367741353982032,
                4818762423935229696,
                4806825133483597824,
                14038868528432410240,
                4817906767256899520,
                14046328665710018912,
                14035459749581470976,
                4826466041866350480,
                4822385112634071040,
                14030560733044676864,
                4823871054553724064,
                4816085873843739200,
                14037983327044601856,
                14048177183659682464,
                14048614095689390784,
                4825442662302350640,
                14040483019737266944,
                4822963667763986144,
                14034731786143349248,
                4824912513434329856,
                14042254108134298976,
                14048311090745317472,
                4813240083022987264,
                4826575419615642368,
                14049446992884145280,
                14050101263253739568,
                14044393036622020864,
                14038583217634284864,
                14048213535983753808,
                4823729731080926256,
                4814400493933272000,
                14047660495382054880,
                14035377540454069504,
                4809650856007455488,
                4817123923399032640,
                4821535002754424736,
                4826690193755012320,
                4814507285350845888,
                14050331062732985824,
                4826546141758795952,
                4826793168025620320,
                14049897789369177344,
                4824986586630702592,
                14039826350773989696,
                14041597744631778496,
                4820687216782492704,
                4826174412867434064,
                4822124395090062432,
                14039110365246141504,
                4826809959601279312,
                4824398176685925536,
                4824180217737185504,
                14036616628866637440,
                14044234317904744960,
                4819022025410504640,
                4820390089579366720,
                4818759743132623552,
                14047881189077442368,
                14047324877210731840,
                4815665847331630528,
                4824071446394561808,
                4823931062690657200,
                14047779299900247696,
                14043538470067181056,
                14046658134796199136,
                4826505722051825136,
                14043893067006883552,
                14047168985010279008,
                4823266219662441824,
                4824964677937329472,
                4816413032973682496,
                14042801962553008192,
                4812909484450620416,
                14030721988088970496,
                4806186986602184448,
                14047427347158047056,
                4819331045524401792,
                4826948408941322176,
                4824100628303842912,
                4826937203088584752,
                14041859089079198336,
                14043403242206972320,
                4822499151623263680,
                14045278435963308480,
                14042743180850591136,
                4817457096824119296,
                14031655228992721920,
                14039065715210283136,
                14045263630049835520,
                4815316882086869760,
                4822325555224290016,
                4819292073990938592,
                14046012602259221856,
                14040348696823431168,
                4812703759350432384,
                14047284798945988720,
                4813318780878870144,
                4819927281196159360,
                14045166110170720864,
                4807315067395886336,
                4824415473787439376,
                4821477474301857600,
                14046062684528029600,
                14045792485273857984,
                4824820070469760400,
                14050008418968197360,
                4814431323810466816,
                14037242051725248640,
                14039792178429578368,
                14046534595444825344,
                14050327269550633424,
                14038710286172470976,
                4816689841131331584,
                14045582315906886464,
                4805689689836821504,
                14039895835775547328,
                4825430874036856624,
                4811105933231247232,
                4810304558110137984,
                4824219036519864976,
                14042871459590589792,
                4812295649960950272,
                14046398301748287072,
                14046729200965126752,
                14045086009291187264,
                4814592710686625984,
                4826499199371484496,
                14042456195845784192,
                14043782362564128320,
                14046538000328054592,
                14044957119342174400,
                14038747155968993536,
                14038089157257823552,
                4822192525314914560,
                14038173977685434048,
                4825908726109267280,
                4818955311322269248,
                14049177326111980144,
                4811641936083464576,
                4820403222966988960,
                4823429509854849936,
                14046506076265233408,
                4809647396425148160,
                14047396951276662496,
                4825721596193774000,
                4825271106397595824,
                14045185689561125536,
                14032131274278046464,
                14034259451901156864,
                14049410332045906096,
                4815458437517500800,
                4826216665503370176,
                4826057797324400272,
                14044742488404534240,
                14045881049265113120,
                14046714628993528544,
                4820739042443125248,
                14031124069933872896,
                4819091616929653408,
                14045802672477544640,
                14042565149325177248,
                4815853371272416768,
                14036472405094239232,
                14047595727699691520,
                4815583161355561024,
                4824668870202229280,
                14049576532217676288,
                4819584553504868288,
                14049832133891394048,
                14046744458085234832,
                4826959249228020144,
                4826419644405293504,
                4824790826334228048,
                4826741738923454336,
                14047770551390614992,
                4817928088000460544,
                4820417684139858464,
                4826779216732479488,
                14048610546891668128,
                4826658347749369424,
                14045703293186572448,
                4823800417434260752,
                14038359543956871296,
                14049399791614362000,
                14045161464364385600,
                14044283900328685440,
                4821098404986123488,
                4821591689417088256,
                14049310532663755584,
                4826550543477429872,
                14039268201603397056,
                14046035221918146784,
                14047109469419852432,
                14039921568895164608,
                14043114517720362016,
                14048104634279366112,
                4826721395303155680,
                4815748957255838272,
                14045561875698613280,
                14039865165698559104,
                14040499865021454016,
                4823540176588596608,
                14042958006809962304,
                14043784542557953248,
                14033626412027598720,
                14049083773360983952,
                4823925773472677552,
                14047599591385616288,
                4819818191127520032,
                4821005279758539104,
                4821729544138992672,
                4826806165639067136,
                4824191090524116368,
                4809889998738795008,
                14044903948787625440,
                14032314074474503936,
                14045082214915465344,
                14046874855807370336,
                4819130127576333696,
                4815314312382352576,
                4824827397931913968,
                4820006662479595776,
                14043343613480873024,
                4813709130292190592,
                14041186794177400448,
                14047225905084627488,
                14040160034003550848,
                4819345984403310016,
                14046940334722481072,
                14037147952713442048,
                14049248859633135584,
                14049592861044562176,
                14046948466181513808,
                14034485791480281600,
                14043828365458618240,
                4823653520617894016,
                4815977720741612288,
                14049472440275706752,
                14016927522388590592,
                14048143890579627312,
                14043531116254385280,
                14036741312203048320,
                14049340686131019440,
                14048298100268450752,
                4822524323174652768,
                14049623756928336576,
                4825353722969032112,
                4826238407930097936,
                4810134574992762496,
                14025008228204036608,
                14045344398672473952,
                4801239008936496128,
                14039424172869117888,
                4823050422979333056,
                4809333033203437312,
                4825977946368591760,
                4817647886340551872,
                14042526567082607136,
                14044071085684323584,
                4819942239172214784,
                14047988716290887280,
                4813665758315836928,
                4822473289705901856,
                14036590519625924096,
                4821475674926317056,
                4812275257145741952,
                14046940670853183936,
                14041056289975149888,
                4820979076768268320,
                4821277445435551072,
                14038212966596109696,
                14043670554936683712,
                4824843372559980432,
                14047851622576791600,
                14042554910194468224,
                4826426587794629072,
                14045471588977557632,
                4819809082358957824,
                4823537787401180944,
                14048787871363009440,
                14043485195716361440,
                14050169507038767408,
                14015563508529203200,
                4810907430930699904,
                4817690189083001984,
                14043731529721203040,
                4813740448502300288,
                14045504917971409184,
                4823724864256285120,
                4819702667795472064,
                4819113474981210208,
                14041470889409578624,
                14046061472608016320,
                4826180033562468080,
                4808695882335891712,
                14045607038789187136,
                4820833771722894880,
                4824624489003467392,
                14047464721468051072,
                4825756304856139184,
                14035361360545765888,
                4820320048909808224,
                4814903707711663744,
                14043641807356974400,
                14047596103714766608,
                14048308796984851952,
                4823599795472242000,
                4825802073788910032,
                14047912793425508880,
                14040285522013028864,
                14041830881993127040,
                4824183292120291152,
                4823573551243175008,
                4826205950630512080,
                4826110827002683824,
                4821242033139421856,
                14046595489967649024,
                14046739193208183968,
                14047643596190989248,
                14044291972541684064,
                4825907996605884912,
                4824142005641012096,
                4823946050461684416,
                14043158685662281984,
                14047774044448959104,
                14049388812257621824,
                4819419990613361440,
                4822764514783642912,
                4819657173591701696,
                4819217837594722176,
                14040460477505672000,
                4823973258504315664,
                14043374741689165664,
                4821282242964747776,
                4823799306074397616,
                14046936828426049680,
                4821870868572990208,
                14050181882516785232,
                14047714736943783520,
                4801189891334238720,
                4823669923153445056,
                14038779706521375552,
                14011724012760666112,
                14043133033429311456,
                4825448895436383520,
                14030681777952812032,
                14046303604562837696,
                4823674596948371952,
                4818477128188028288,
                14043554174717082496,
                4826719173625740080,
                14048868851668976752,
                14046067626884145056,
                4815744371828726720,
                14039482495414675968,
                14043611891754084672,
                4825280466981079408,
                4825325697870563424,
                4797889082578248704,
                14029968121472800768,
                14037877367918907968,
                4826344598558717008,
                4826287233065469232,
                4821517119455963744,
                14042700711639103328,
                14043224446664263936,
                14040023591716085952,
                4819638586368484736,
                14046773166104972912,
                14036557916447469184,
                14048580532509234256,
                14048782163996708864,
                4825866189477949680,
                4806479525456668928,
                4824639020910807056,
                4824727552510192064,
                14037090994808603904,
                14046193470301857504,
                4825362055723210880,
                4813839296816154112,
                4810757570570752256,
                14045944309298065344,
                14050123291995155120,
                14048087995480347632,
                14039194283985143616,
                14036456245704149248,
                14049568704188914112,
                4826890451140417472,
                14049137183358473552,
                4824009969348381936,
                4824658336934616096,
                4825014840655641232,
                14038446790400409024,
                14048292818172862864,
                14049483891062560016,
                14048881951936602816,
                4825439233560778032,
                14045741073164180032,
                4823508094722707584,
                4818939132062635904,
                4801839018533815808,
                14050158950402119872,
                14037852181763395328,
                14044975830208267744,
                4799562953612472320,
                14032198474991196416,
                14048769762474074432,
                4825925540746191152,
                14043826615226574240,
                14037788219577848192,
                4821679672579468960,
                4823412204567093584,
                14042844801014694144,
                4824908230413536080,
                4821237909489727040,
                4823741029165099792,
                4820451874095959040,
                14046994755965290032,
                14042882028746882912,
                14048599596335834800,
                4820848393900347296,
                14033683658742444544,
                14048119267795480960,
                4825626937940377104,
                14033247092982311808,
                14045094672442789024,
                4825424570497252272,
                4822625571632936096,
                14049846876382433872,
                4819756326969954368,
                14048589339926688272,
                4824733792226706368,
                4817435680015633216,
                14034068072994805120,
                4813425517930099200,
                4825467456567002672,
                14029417442193019648,
                14036127128759831424,
                14038222524000804608,
                14037954555900257536,
                4824678865942379808,
                14038162264942015552,
                14047059466415571344,
                4808507988300786176,
                14047379236945366720,
                4824811852524353984,
                4825962833071723072,
                14043780554457397696,
                4822089103969874656,
                4825553895462155408,
                14047847253606307264,
                4813198280742542976,
                4806281969197665024,
                14050047802891852176,
                14050044672452234528,
                14048685310196268192,
                14041845629847243648,
                14042909401919375040,
                14047009485653365264,
                4811930836955190656,
                14036232868650257024,
                4820312497040000256,
                14046845953074549168,
                14039037345199055488,
                4826948064122195376,
                4819352333468647040,
                4825532842426705056,
                4814740447995174912,
                4823135385403874304,
                14048861480097149504,
                14037685768899205760,
                14046792983934469728,
                4825251501912806304,
                14049949959941555008,
                14047015735900433344,
                14047775801851290240,
                4823769351458372208,
                4821734858053597312,
                4824112191616721760,
                14049644203490906256,
                14044659766388767808,
                14040285202816623936,
                14039555910774034496,
                4795269880864606208,
                14047782673931289248,
                14034299402360590080,
                14040734064196177856,
                4818127639049477568,
                14029571732868275456,
                14043957490970947680,
                4814268799672511360,
                14039802785517223360,
                4811316200358008704,
                4804697987078153728,
                14048574842010763216,
                14038428763584605760,
                14048410284206602032,
                4803652145280393216,
                4812070588564075520,
                4826819746102603808,
                4824782154337212160,
                14046915438265674896,
                14050110971093036128,
                14047977440341485056,
                4826007721019444528,
                4821288512102514944,
                4824966357532074928,
                4799554366440880128,
                4817087393414771968,
                4825910302229906000,
                14047364116365411488,
                4825931848481007712,
                4820196379780346592,
                14040837484181335104,
                14045249196849348896,
                14031550817935136768,
                14033830564203800960,
                4821581662032552512,
                14046522807449830432,
                14041071366655870976,
                4824494867117277312,
                4825964145785616336,
                14040627439725476864,
                4825150616996436560,
                14036811163683064576,
                4819742155660645216,
                14049560784928292000,
                14046142716521787392,
                14049165830367134864,
                4804268100711416320,
                14049029777049091744,
                14048061304451135600,
                14045977088088006208,
                14049354119559599840,
                14048700462223856352,
                4819328453895107232,
                4810016650773992448,
                14042076993880854528,
                4822666318759786848,
                4824157062810021920,
                4818074328918507328,
                14044136367018160864,
                14048102642163619664,
                14049364593594341632,
                4824384636622035248,
                4825525204670665920,
                14048571388829208160,
                4825630694036067680,
                4781602868934770688,
                4816705570011381120,
                14039487888907608000,
                4823824959782903616,
                14046378137120881248,
                4826287749556244864,
                14020249323286068224,
                4825343030790815568,
                4812977226661632128,
                14048313768339534192,
                4825763233476029456,
                4798567689904268288,
                4825926956838313264,
                4825557832701644064,
                14034486574935069952,
                4825875637790215840,
                4802967726807395840,
                14044236065860212832,
                14049296903521964912,
                4819661500929950912,
                14047034740043047664,
                14033582588293634688,
                14049279682039536096,
                14035314929688738176,
                4808924784577974016,
                4824127989476453872,
                4821108251331829280,
                4824086529359302560,
                4823874788038901968,
                4815779500299794432,
                14047859315038723088,
                4826694264288990512,
                4826508450846926400,
                14050081463863713744,
                4819596585376210912,
                4826588269179974256,
                14042134436867156224,
                14028721364846511104,
                4822494940425982336,
                4819016011950519008,
                4808065936599183360,
                4821088347734886016,
                14046837107321043024,
                14049488663081340112,
                14049770814093768800,
                14043856530070793376,
                14047418558191558000,
                4825731355264696368,
                14037330966336571264,
                14047339261970925648,
                14044508102413389408,
                14047377461334258336,
                14048866529485113552,
                4822735036807800832,
                14047825754760376384,
                4825100869502078240,
                14021632233654950912,
                4811711937731716992,
                4823519138679137088,
                14050260469037443536,
                14048050032868952064,
                14038453007250838016,
                14049969897280517680,
                14045028052625692000,
                4826925310446028640,
                4820593196368871488,
                14038400997552674496,
                4816834426523102400,
                4821101677950620352,
                4817380245898972544,
                14043719992269401632,
                4819613368858676992,
                4825739745506537440,
                14047034600635341008,
                4791185688169639936,
                4823567157551617472,
                4825405059998762496,
                4808683623717294336,
                4826819031055544832,
                14044400931839100512,
                4812269819130522496,
                14049619972031732336,
                14046060365758934880,
                14048829357910777488,
                14039942286399539712,
                14049217736751488032,
                4825019749012772960,
                14046481301877367712,
                4809755820681807360,
                14034931753381590144,
                4820623931121564736,
                4824977818136784320,
                14043903134420377632,
                4814610827820452160,
                4812024989837711360,
                14044842678283248480,
                14049710692705613904,
                4811623510677114240,
                4820858475068412800,
                4818652668250115008,
                4825467603666672128,
                14049296665541506048,
                14040843436138507136,
                14039794059207799936,
                14049447146463822816,
                4820382369956742112,
                4820629838718541120,
                14046206083871117696,
                4821310291094453600,
                4820392991419503392,
                14048942569461123408,
                14016876797060233216,
                14048651390415477456,
                14039274293743808384,
                14011226921604186112,
                4805022918510459904,
                14049444451553260256,
                4826271924849156928,
                4819558993038724384,
                4825612176276985296,
                4817172745039958976,
                14031710083534521088,
                4825215892169349760,
                14048589175132542160,
                14045609652487719808,
                4820294449069408544,
                14043945640553982848,
                4815814847435082240,
                4821053469099567648,
                14041209371022388480,
                4822246834760564256,
                14049131127272228128,
                4806580903063107328,
                4823675747324566080,
                4825754762546058944,
                14041389070809651456,
                4814151173954179584,
                14046311006627619872,
                4824742871550435952,
                14043403762418688032,
                4817442215958204608,
                14048452020987022256,
                14048083251126236112,
                14047789106465549472,
                4825118519925331968,
                14045985869796732480,
                4806338785680196096,
                14049860396272606448,
                4824992526356272960,
                4810300319471518976,
                4811846211442415872,
                4824922953257709200,
                14045493501841980864,
                14039844980945745344,
                14041996272697490816,
                4821801317070200352,
                14049371652385225328,
                4819481722947731232,
                4825913950314967024,
                4804157024224937472,
                14037166276036356480,
                14036290982871222400,
                4825743400327333440,
                14048852253472926112,
                4821440144854897984,
                14033754280946242944,
                4816627956302891328,
                14038608876587441152,
                14049934931933749632,
                4826332914797029792,
                4820454979232198528,
                14040391891247570880,
                14045036698586386720,
                14045981682928912640,
                14049732951170840832,
                4825341256578527808,
                14047079871842308080,
                4820372931725386720,
                4819996848224670176,
                4824878349717131328,
                14042907893200628448,
                14042325612592508256,
                14049780534290595072,
                4825569995644470336,
                14028251182685343232,
                4820739364643074400,
                14030008662815248896,
                4802921735795429888,
                14042695433088040928,
                14047336377220835936,
                14047344489686119776,
                4822589092573212128,
                4818857219782288960,
                14047754867792374656,
                14047050134487578768,
                4825780315750226624,
                4817413901576596864,
                14047256223096132576,
                14048539161216325744,
                14039105851251281408,
                4826762629996954736,
                14049214055512534144,
                4821732831230411680,
                14047912734441563248,
                14047729054116542864,
                14029575474804608512,
                14046160937765504096,
                4813033628318880384,
                14049205924693891648,
                14049054588582980672,
                14039702812641552256,
                14038881886775874752,
                14047122305293384496,
                4824307385378216704,
                14036971194039520384,
                14041166166604219584,
                4821294545064671200,
                4821235713695939968,
                4821584140063203712,
                14050041792424639904,
                14046726149986308928,
                14049650439069122176,
                14040926824655945984,
                14049670756987411152,
                14049094159229408368,
                14045991127544591680,
                14050072842447325440,
                4823303132068986880,
                4814824043338737664,
                14047706742967928160,
                4819712948692548960,
                4824068427540981664,
                14045927148042741312,
                14037638282930654592,
                4819290210038685312,
                14047515600221722704,
                14048498828390954448,
                4818865422356400352,
                14021816576989010944,
                4825236157255052880,
                14036407210164043776,
                4824163677193185648,
                4822605170417242080,
                4805944635898422016,
                14045438646090817408,
                4826259382309007680,
                14048998173569764288,
                4825989353064943248,
                4826403958670544784,
                4822452853008918688,
                14037337428208347136,
                14044013034419674592,
                14043136324289841792,
                4821540350940488224,
                14031918041872049664,
                4816168519761424320,
                4814404645281789312,
                14048635715316806784,
                4826702309336811328,
                4822333786360623776,
                14040833841760326528,
                4820541293564453696,
                14047530675431387280,
                4814272839122453120,
                4822624134567601536,
                4803362015905946112,
                14041787737373813376,
                4826533385285333104,
                4825524782678921120,
                4815620834722150144,
                4825199305415704128,
                14049012846271227504,
                4817164476807641920,
                14044957405400082784,
                14047309613699346336,
                14044054326412418144,
                4817570512876238720,
                14044253700519634048,
                4824381525990644704,
                4798086108912438272,
                4819867128032419680,
                14042250538756632608,
                4824901122443871072,
                4814490478832659136,
                14049540765266276032,
                14041179593912429184,
                14042313229836733472,
                14047211594023816256,
                14050213186065067504,
                14044286070512332096,
                14035691182974036480,
                4825284505319701104,
                14044085722086261408,
                14043597567539006560,
                4817403911024083904,
                4820284432111798336,
                14043329331356165024,
                4816644506959309120,
                14038349973868458880,
                14038109515839231680,
                14029706865694825472,
                4816142263581370048,
                4823461323901894624,
                4817851841953979328,
                14045302135694605824,
                14034541951408060544,
                4822868116947773120,
                14046932086423087984,
                14044042994029073728,
                14050232477255837520,
                4824132224690131760,
                4810307163224214400,
                4825991895482074992,
                4810613745463803264,
                14042372932696761120,
                14046754476403833216,
                14041544320346888768,
                14049954068094901760,
                14034920533801847808,
                4822730554387418848,
                14046005213975127584,
                14041988650538038720,
                4820754630688166656,
                4822078668495877440,
                14046813384168253808,
                14027568759679188992,
                4815292706762136448,
                14039472939035111232,
                4824873505574911952,
                4825851644463274000,
                14050183574814181344,
                4821450232022766048,
                14047763178436700624,
                4823406727004291728,
                14035947178632160384,
                4825060952979661792,
                4818172395009685760,
                14044890897904312960,
                14039828885739508288,
                4801625667033952768,
                4809707871339315200,
                14047037091871758576,
                14049724886169234352,
                14045857263744979264,
                14046568553060396160,
                14047482683942887824,
                4823533464616027008,
                14048608119480333440,
                14039688484120061760,
                14044675344318986592,
                4825834429329575264,
                4824686440876648272,
                14025076799742054400,
                4822753550810898176,
                4821810185452530240,
                4823615469977353872,
                4824409015872223216,
                14043936778888232512,
                14043444080472609728,
                14041108678828827712,
                14048197215196928432,
                14047205196063837360,
                14047021970143933168,
                4821920784109661600,
                14049281981729604256,
                14038437896084173824,
                4825822516895912000,
                14048774195667936544,
                4821856141862019360,
                4820114299063921792,
                4824003949400487408,
                14048825701361332496,
                4818996249356312800,
                4807468211705052672,
                4822969887678456480,
                14049004818151757120,
                4825243034325856896,
                4806110113346621184,
                14046847826494862720,
                14050259454522843088,
                4821492900901991840,
                4818587239210906496,
                4818477893547100352,
                14043421070573427616,
                4826813199526290160,
                4819536773944629312,
                14043172806022311648,
                4823546528938830160,
                4812513254292338304,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
        SerializedFFTContext {
            p: 4830304114401345544,
            pinv: 4383336415042637786,
            mod_data: ModData {
                n: 868614185943041,
                ninv: 5463972295250649786,
                norm: 14,
            },
            primitive_root: 3,
            w2tab_depth: 12,
            w2tab_backing: [
                4607182418800017408,
                14043228097021372032,
                14042817191572437888,
                4819605159994420960,
                14047581432524294064,
                14039677153516493120,
                14021517279837736960,
                4825573147916255904,
                14046786866629089872,
                4816556504985579904,
                14045007839975801248,
                4823493081183302560,
                4823374360624130144,
                14049115856735280752,
                4814783368078661824,
                14045776367532642240,
                4813211216664688640,
                14046748403814652160,
                14048094306135921008,
                4816074495325307968,
                14025445256807130112,
                4822275123098533952,
                4822868403043080448,
                4825057915767726816,
                4824538351066130512,
                14043575823342944992,
                4819890865056798624,
                4809740873623140352,
                4824063588250253728,
                4825643869443244592,
                14032476193136987136,
                4819041622153057952,
                4823616243278662176,
                4816789000370097408,
                14045168516972838368,
                4824936663882930448,
                4804025334237775872,
                4824592636802917712,
                4821173042409316736,
                14042455943764399904,
                4824842605659959680,
                14044205851848637536,
                4823238844129275008,
                14040622713825906048,
                14045683995220758720,
                14047016110888916192,
                4820629377494216416,
                14029496107202945536,
                4818946574080300160,
                4825164588638135296,
                4807959773326895616,
                4806684889484666880,
                14044015744520577696,
                14045043195219040512,
                14037661998141788800,
                14048280430169695664,
                4818794394705152512,
                4823710638713947296,
                4815006634046066688,
                4823556240445652400,
                4801268250072522752,
                4821934618660915520,
                14040665625652734784,
                14045782609231479744,
                14048153043798963424,
                14043913606556118208,
                14045467300185766208,
                14043491892675332384,
                4815197558347393920,
                4823846501176797312,
                4814629072152215872,
                14042741063698376800,
                4817701856292165952,
                14044266561572250784,
                14039905706471689984,
                4818416290211374592,
                14046433847459287552,
                4811752856996228480,
                14043016220096694912,
                14048030876028483648,
                4822271558355174080,
                4824998052596069552,
                14046734170965334592,
                4825204217636478800,
                14020170227317134336,
                14048158682205633344,
                14048851174006661152,
                14047486398249945088,
                4823541227391590320,
                4819293698107807648,
                4819813913348754496,
                4822633609117653856,
                14046334987985762496,
                14031010408771188992,
                14030348505737732352,
                4823056625361965216,
                4823852187578458432,
                14047649528334422384,
                14039795666187369920,
                4825317899076089200,
                4824648989411968688,
                4812366575593819392,
                14039306853856624448,
                14049038433022781488,
                4820117641493807648,
                4824724090423447680,
                14047953256333565552,
                14045813264857351904,
                4825770006041219312,
                4825716442757008160,
                14041182826615153216,
                4818543307551362176,
                4812153361844840448,
                14048304395677791632,
                4823389970041179648,
                14044605781322472896,
                4824311899833575120,
                14045021054794832480,
                14048485350653332448,
                4824248837739626208,
                4823956668219443744,
                4806453406743994112,
                14042561300008624960,
                4807478167973515264,
                14039233389488045632,
                4824023082963240960,
                4824356469014786384,
                14040455366948864064,
                4811146009991142400,
                14048492574812532144,
                14044248268865570272,
                4818762803725290496,
                14047578387515440864,
                14046743480560656320,
                14048937241972521648,
                4809601641300267520,
                14039857620376310208,
                4810889622697800448,
                4823032225851786848,
                4807771494236538880,
                4817151130329423360,
                14039494299158070912,
                4821014657694789088,
                4819372361948962240,
                14034567216733372416,
                4823696913086053200,
                14044751232279002848,
                14023125857922617344,
                14048595210380632080,
                4808325146790618880,
                14045819608409311680,
                4816873565206425216,
                14043977785984785440,
                14047532055007916272,
                14048573190700393872,
                4819831787784499520,
                4821336011224334592,
                14047400630617533888,
                14048140469986330928,
                4823887202767065424,
                14046789542532691216,
                4821211000139485632,
                14042511090656306400,
                14044463033323023872,
                14035697884481155328,
                4815537213924490368,
                4817883194768016640,
                4817291324728961600,
                14045375626186159904,
                14039322302281897216,
                14042597358834456224,
                14048581247628822832,
                14042468013007756192,
                14047530682838137584,
                4822749486898855136,
                14036942136986220928,
                4818872741954901568,
                14039558937777904448,
                14047246767204121344,
                14048353810966509456,
                14044278130680061952,
                14047082403861123088,
                4823879166754666080,
                14048830676703197936,
                4824467442917944976,
                4818252656652572672,
                14047490588578878576,
                4825397574725751152,
                4801587996619713024,
                14040301569897250688,
                14045464350015452192,
                4822493008984130720,
                14048257471581994576,
                14043386344636854048,
                4819684406345089440,
                4825421962233155376,
                14044853963976721792,
                14048418775057315296,
                4796356120043623424,
                4818928717414739136,
                14041846000285873664,
                4825443561341982240,
                14048125546774998560,
                4823399690524872896,
                14048423220730846976,
                14044449649622759392,
                14048815104229701616,
                14039817011373274944,
                14046136611741309600,
                14048456080134091872,
                14044902860034504352,
                4825657928293665296,
                4811544117288883456,
                14042002652392637184,
                4820184220383988032,
                14037488626801430784,
                14040692634491958592,
                4824966814558508048,
                14017294735675809792,
                4817025807106292352,
                4822350897607845696,
                4821416249275903584,
                4816988467499206144,
                4816591084442674112,
                4824915733173046192,
                4824345130832153824,
                14039472746644277824,
                14047703966491578752,
                4808735245956530176,
                14048048521386073408,
                4822616820716423328,
                4823711842643187824,
                4823680176880773600,
                4823969249593708336,
                4785975436417843200,
                4822052261069128544,
                14044032827683610912,
                4821123266422297152,
                4819573562239676992,
                14045300722060315936,
                14037932071484928000,
                14047150856875119600,
                14017796322560208896,
                14048886515267072768,
                4823937141761900880,
                4816525263002487232,
                4821560040537881312,
                14043049127940811008,
                14045109143434532224,
                4823254216694120000,
                14039481553174771968,
                14040290700967531712,
                4822566376907020800,
                4822695861706298912,
                14046952990065715280,
                4824513378017517168,
                4824823435977420960,
                4818951160076784256,
                14042295278648503968,
                4825190818327628432,
                14042287724691899456,
                4825496108321101056,
                14047102573233849856,
                14047868361374624688,
                14045170022524073504,
                14047837248355976288,
                14043496329717280160,
                4820043614202620544,
                14044277656781778240,
                4825274243410493920,
                14048717589150544544,
                14038410788865076736,
                14035816807981539968,
                14046795909796069280,
                14018170533872201728,
                14045544571148311296,
                14048362076129690528,
                14042230008467320448,
                4824254051598430384,
                4824749629501762048,
                14043224935777164192,
                4821818949915751424,
                14036157627346449152,
                14047502583610411760,
                4818694112881786752,
                14048710150381433600,
                4824556054338182736,
                14047056328729011936,
                14028224915517056512,
                4824798578828433680,
                14045824593035869376,
                14038485642051598784,
                4803438157391490048,
                14047521899047352176,
                4809565254022689536,
                4809462367543568384,
                14047083115694135440,
                4812469832573374720,
                14047835160068902704,
                4818774500081596992,
                14045373419636137728,
                14046823325959267088,
                4825440105679591968,
                4821405120788440096,
                14048912332811238736,
                14040587886319056128,
                4821951430529851808,
                4820723733550290944,
                14048955995979799152,
                4819410070494934848,
                4817705066446278720,
                4823932032405782320,
                14047336587541093152,
                14044323616133786432,
                14040655733887880128,
                4823412699245564992,
                14042443200543240192,
                14046635720139267328,
                4809345389930984192,
                4816936625687693440,
                4815644120315787136,
                14040009288647017088,
                4823331664349444224,
                14042906320792794656,
                14038407256768144896,
                14044605720100835264,
                14046068016489800192,
                14041957149422180992,
                14047924659096534528,
                14044262261262093440,
                14012689275923214336,
                4815948114216399424,
                14035209197836205568,
                14044737985059552224,
                4824128229217487888,
                4823374042255367008,
                4821548916339568544,
                14035688220421668864,
                4821590559915433184,
                4818567241480520512,
                4819805682681621600,
                4818345885301512384,
                4824341147448967168,
                4823405898452287600,
                14029487420349151488,
                14040093542562044992,
                14047015892723834144,
                4814686549252682880,
                14047362048569403008,
                4815317326327131968,
                4824165113650089680,
                4824434014823559808,
                4811194322361416448,
                4824980264473546320,
                14048344334685303808,
                14020802325539778560,
                14042152634613383680,
                4825758940138348240,
                4817526706204524544,
                4821186510476286976,
                14038404272613930368,
                14038004583880895424,
                14048454621355116064,
                14047367841231139680,
                14046806755773781024,
                14048138183264354176,
                14048589155742149376,
                14047429612013606432,
                14029157834045246208,
                14048766466314769104,
                4823631879534589840,
                4815999987879628992,
                4820163772323651776,
                14048563721887823792,
                4815139124790407296,
                4817619384968446656,
                4824314914129774240,
                4822014268429311008,
                4824295806396779296,
                14048710604396895984,
                14047365797250896416,
                4816833727037317056,
                14038887232791438592,
                14041247402057501440,
                4818292974470206976,
                4825253778847974128,
                4821983807267931392,
                4823878213511816368,
                14037546185492343936,
                4820030849238970624,
                4804459468026718720,
                14041750227165653440,
                14039576697340134016,
                4819161529531549600,
                4824745178681213248,
                4819701239283249344,
                14047754633764038336,
                4814327162678704896,
                14048530731728601728,
                4821912622719414624,
                4808167531754461696,
                14045728385546240832,
                14044053520441863808,
                14047434719592489840,
                14037401128502595584,
                14046861241151263424,
                14022208777514068992,
                14041959922282851584,
                14037758751625253440,
                14043450847621283552,
                4818393804998841344,
                4820085613654887744,
                4814364981542683776,
                4819656246768450944,
                14048747044915088944,
                14027608620531751424,
                14046430507935750656,
                14043933511036770048,
                4816267946201320512,
                4819011455589756704,
                14044654194769966720,
                14042556849826320576,
                14047410235151134928,
                4810541084821220864,
                4783378357999992832,
                4824169676573682016,
                4825194992135601584,
                4820829692712282048,
                14045234815888724672,
                4824536951587011872,
                14038634379291224128,
                14047920816213613024,
                4824240546755815216,
                14048810525711174528,
                4818887892976219008,
                14047981706810162336,
                14042817254998608480,
                14039650495529741888,
                14026431103085966848,
                4821086022437241152,
                14044908123376528672,
                4821942098105353696,
                14047990977267455776,
                14045822226120079200,
                4820750006881336576,
                14048224679307755232,
                14048239171818288000,
                14048825942491131360,
                14042410946871682240,
                4823859872194970512,
                4821500405583493376,
                4824968047514252832,
                4818497623928069312,
                14045756123989134656,
                4825245620074935792,
                4820436738597915264,
                4811304233764865280,
                14037844308624685248,
                4823914143377133408,
                14048316925372661840,
                4814087281058600320,
                14041513559587289152,
                4819347685468512544,
                4819237760509496896,
                14044622635128790912,
                4823873503725295664,
                14047614194401523776,
                14048413934677668160,
                4823607109400202288,
                14046849912092914176,
                4824154642579472176,
                4821361500887907648,
                4823942390615114112,
                4825229832920725904,
                4824179731758597440,
                4825006815771701264,
                4822608534557168800,
                14032885571326626560,
                4820143275860926176,
                4811594963418491648,
                4824881501322501552,
                4807134495379920384,
                14047604891892185840,
                14047332957012664528,
                14048078456623843904,
                14038662957961723264,
                4815626585925600640,
                14047868938395736560,
                14043710698861738016,
                4824611750219152784,
                14043993046101387136,
                4825242014597327392,
                4818116102667389696,
                14047728342120029392,
                14022219049402516480,
                14038048719047372288,
                4823968979684594624,
                14046887907478004464,
                14045288438306444192,
                4818283008160113728,
                4823451558568972592,
                14046287008020350944,
                4824832758625711200,
                4819652812670393184,
                14046825290634125120,
                4814456286971480576,
                14042302887881969056,
                14044836835438148960,
                14047838534528495824,
                4816702947033893120,
                14019678658256308224,
                4825636301326055520,
                14030861431732603392,
                14042743351495309696,
                14035937802676778496,
                14048022267163631152,
                4822848956880109920,
                14042364094287160544,
                14040143720674356800,
                14044637126181639776,
                4792716801032855552,
                4821773211317746112,
                4824019668689826096,
                4812424785661291136,
                14045885847204700320,
                14048356180248350208,
                14046966570176105520,
                4811494437115600256,
                14048689693908169552,
                4818506356145420480,
                14047472041030630800,
                14045127798519704192,
                4815681458997155840,
                14038550225824590784,
                14040270621590114880,
                4821360487145246944,
                14045457175217474208,
                4818534578906627584,
                4825252099883082544,
                4823540340658053488,
                14046785363053377040,
                4816945205242537472,
                4824221625712923904,
                4819111678335613632,
                4823494238427749936,
                4813566095802117632,
                14044686251276656192,
                14039016618663065856,
                14035591542985836672,
                14048110990063373024,
                4825010637444282832,
                14047716180911378432,
                14047022329380671840,
                4824232742807896592,
                4822509014179726592,
                4823298498913008864,
                4821496670768081952,
                14046321931468516576,
                4820428733251579744,
                4817218941935424000,
                4812933224489377920,
                4802797542327358464,
                4824496402866146848,
                14048218916817746896,
                14034546284361348608,
                14038355548285699520,
                14044702691585707168,
                14049024625112457184,
                4823202762755908288,
                14043609575577517184,
                4811154369008552192,
                14042795875821682368,
                14040182360109089984,
                14034013046950897280,
                4823072652860753824,
                14046972952640013536,
                14039343913731150336,
                14044319793744245568,
                4812650534253177088,
                14046371812627101504,
                4821063192203342624,
                4816924948346064512,
                4822872909638449856,
                14046185065798809632,
                4823075209095194016,
                4824812749989680208,
                14032131995952173056,
                14046598159936915488,
                4824338718474497744,
                14040417984111794496,
                14047434972759928240,
                14047713965230483408,
                4811805958561124352,
                4823661434788375392,
                4819371101476383872,
                4820368836068829024,
                4822601097759280320,
                14035601872838437632,
                14042585095347772224,
                4820211343488097856,
                4785100483842703360,
                14046485788724875328,
                4823620521064961808,
                4823958279807517936,
                14048946927087735920,
                4825067580189147632,
                14041610004630052800,
                4824171629500849904,
                14046682938938099328,
                14045817550738463456,
                14043905289703031456,
                14043207014105289920,
                14026280079566404096,
                14042851025125833120,
                4825056853645007456,
                4823178747794311520,
                4820867314915536160,
                14045758619376659712,
                4821772027815496480,
                4823469709834069136,
                14048745474488465952,
                14044708671883746048,
                14047462456265114192,
                4814515730598206144,
                14042620790796421600,
                4823522554720315824,
                4818230251858751616,
                14042796273302997088,
                4818105121608829824,
                14043261364282836928,
                4823692751597217328,
                4814807973994157888,
                14047455597442272880,
                4818460671558840896,
                14045112515845387840,
                14047637957357090320,
                14043788692012826400,
                14037733980508571392,
                4811056429270741888,
                14033974608165490304,
                4817892642233619648,
                4825444696005299840,
                14044148709143213760,
                4824898509546609296,
                4823783601325098704,
                4816917189341124928,
                4823670859580445312,
                4816105355467003840,
                4818438040889401408,
                14043492641661840064,
                14048989600483952144,
                4824270426581410848,
                4825285819311812560,
                4809003322107628288,
                4821778204908211296,
                4822777819699761696,
                4815409247251764992,
                14046896183798847984,
                4824682763596078304,
                4817008793446921792,
                4812958265950076928,
                4821088619569523104,
                4820593058516318912,
                14043975487509986944,
                14047621300427075520,
                4811744799544471040,
                4816791978625591616,
                4824802506771449008,
                4819604751910446944,
                14045784959723410656,
                4825552964609381216,
                4825600846414555664,
                14046429139785310304,
                4825664339865192544,
                4817402314147039040,
                14046674036541752416,
                4823659676638521888,
                14043094088489140640,
                14045460970277451488,
                4820706698326074112,
                4819592168162455680,
                4820339872951433344,
                14038585544076013760,
                14044363882277070016,
                4823132024209448672,
                4810720209485323136,
                14048126467681110144,
                14036130612338681472,
                14037641435922013440,
                4825290837153705648,
                4821682231586133472,
                14048508866230148560,
                14043055749983035840,
                14047912405750249056,
                4823080210441220608,
                4823777842033183696,
                4823820002656487936,
                4825799721898478864,
                14046636435075699648,
                4825480010489585520,
                4823581677442506688,
                4822250372574087200,
                14033302697861504640,
                14045693919176894912,
                4823358046825654224,
                14048272816343027904,
                4823413803268144096,
                4825463800618642384,
                14046026414240434176,
                4816033709328416768,
                14040908040559709056,
                4824480404421529872,
                14047779831783860704,
                4809530260274340096,
                4821829968700340672,
                14039105607067115648,
                14042242818078999424,
                4824280037184775648,
                14047422510889145904,
                4811354492706416512,
                14038703788439499328,
                4824314904346435840,
                4823721605852964928,
                4825390660868555616,
                4824393569512251664,
                4822969447700513408,
                14047013774182033344,
                4822458840987607872,
                14046834031563964480,
                4823972782196108480,
                4825720711634082448,
                4824447418339265472,
                14047469975413542928,
                14047625963598415952,
                4799468734284798976,
                4825408554609456528,
                4824410355098476240,
                14038597314327841536,
                4824493909051150592,
                14047444315067137952,
                14037918024033555520,
                14046262630488680320,
                14037324877806814464,
                4824023445801633760,
                14046887947282102000,
                14044940070320078944,
                4823641899469778080,
                4824123234429243392,
                4823860495067764112,
                4803433872244803584,
                14048616725384401872,
                4824408377942691040,
                4824514206593680928,
                4824350346873041088,
                14042388346432008352,
                14048439262684646528,
                14048991124704661936,
                4815892311406985664,
                4824134086696805360,
                14044132095110882816,
                4815158786482322816,
                14048650388135545088,
                14044921312257901536,
                14047142758640897136,
                14045293876766700032,
                4815499533728784512,
                4819668747697122912,
                4820025237521622112,
                4822940764057731072,
                4823019288024570176,
                4820365750874427744,
                4820730122761988064,
                14048875947967487136,
                4821016435912748704,
                14044140892818081664,
                14048113318515215456,
                4818867018662177504,
                4825615440028521632,
                4813565970332964096,
                4821379434016807648,
                14048984548531799216,
                4824737372497321440,
                4824537491254704192,
                14043661628615990592,
                14047581081479198544,
                14048524243159034704,
                4824342523339760768,
                14049063797956166208,
                14046320395644539840,
                4820327652416853088,
                14041210068769242432,
                4825222744942625312,
                4820783551179446016,
                14042929054388566304,
                4825185980008379888,
                4819774187262191552,
                4824688749300207616,
                4824163308595914000,
                4813900956304566016,
                14048722398222204528,
                4822549480334712544,
                14035255403370842624,
                14042986249689417280,
                14042818161816751872,
                4805077075890746368,
                4824173084024554960,
                14046765958292228480,
                4820339171570542688,
                4825711291054058304,
                4807092377174223616,
                4810822891367042944,
                4819103894964737376,
                14048963089960440368,
                4823547061017868944,
                4822093383424033664,
                4818886068543277408,
                14047131226867724496,
                14045352715678334752,
                4818627784578037312,
                4814504138869771456,
                14047561869935177072,
                4823699041501809472,
                14030085388505836288,
                4821984907811720672,
                4819263651972265856,
                14049036633608379920,
                4824857816255758960,
                4816705633918291264,
                4825515089957303776,
                14030441610146929152,
                14047152086431763568,
                14045934717468309888,
                14046239514229562656,
                4816664242405193920,
                14040488042159794176,
                4801246988415622656,
                4821179326921310592,
                14046000518988881600,
                4812140807020007296,
                14044961783589598912,
                4823639809789632496,
                14040745514798170496,
                14047726171579062528,
                14048415161159316592,
                14044732776655038144,
                4821739117710811392,
                14049165323498981024,
                14028373760152723968,
                4814979032221229440,
                4813717948683407872,
                4820759981033289984,
                14048007857030982320,
                14047680862765500608,
                14042681424022127072,
                4821808387038366752,
                14048399085692705840,
                4821865710990341184,
                14041279171555902144,
                4822390394090191360,
                4824618662500613104,
                14043490887518243584,
                4813629834794785792,
                4824484195353297744,
                4821558475914252896,
                4823118423615618848,
                4818595084526150016,
                4816568009332876736,
                14039102753865354048,
                14048242540863132912,
                14045884521152186272,
                14047757444607404160,
                14044652017933776736,
                14032793007844305664,
                14049027279532698192,
                14046892829488229968,
                14026797022747316736,
                4825163595661451920,
                14044455581861546976,
                14042727201393173792,
                14048685766115795312,
                14046025959264294272,
                4820511945091319840,
                4823743909907030624,
                14042949939972600256,
                14039580159555560064,
                4819015937985659712,
                4824362982326659216,
                4824552111129251792,
                4823457638671805424,
                4823921140191502080,
                14040345307052881216,
                4823533418350332032,
                4825338171039361216,
                4822612552487225120,
                14038700238698098688,
                14043715555620946880,
                4819904199248797376,
                14039743487162291648,
                4825070690262801600,
                14038985231958932352,
                14042815702035420160,
                14047505889168939776,
                4824086563950945248,
                14036804189463831680,
                4813414579830468224,
                4816539955452386432,
                14043599782684410272,
                4821145681434145120,
                4815103961915534336,
                14045934264249440512,
                4814959335414219392,
                14041846622307731520,
                4825155188489548992,
                14040131482669972224,
                4820739432987995872,
                14037981962948801600,
                4825299708248529184,
                4823510448253360048,
                14046833288683250624,
                4824607805015615744,
                14044315509699201728,
                14048393865545262640,
                4824244048683455248,
                4810670042511891840,
                4824691539254249968,
                14046296444243381344,
                14045557391572858880,
                14046261225365569760,
                14035749892700217472,
                4806369623280819968,
                4822332825577109760,
                4819555559649771360,
                14030060638786317312,
                14047941426888210016,
                4821728909065972096,
                4819665495462708064,
                4803717209641332736,
                4825197891685549568,
                4820659740520598496,
                4825493605265544336,
                14049022842860213632,
                14046087634811030624,
                4823436116850100976,
                14033145032014503424,
                14046767118481846688,
                4816500336190882304,
                14046242707297517568,
                14046776031495662816,
                4815703354135552320,
                14043360699546394784,
                4825051797675560016,
                14046724073075621312,
                14046614971263859424,
                4825138949304023168,
                4816214500039761408,
                14045119227321720544,
                14043811896782311488,
                4815202472834941376,
                4824902240377816288,
                4817916989179734272,
                14038744235187764864,
                14048130188551567312,
                14040422021022565568,
                14047572286945449088,
                4819493806941414080,
                4824757416212172544,
                4823142472158525664,
                4816810368623767936,
                14046764252318726768,
                14046840463438634624,
                14045433209606397824,
                4819834990348396448,
                4824913541516905952,
                4818428436337149760,
                14041081194394334016,
                14043197886526868416,
                14049002736020079632,
                4822008707556525120,
                14032669599490028288,
                4824846972709498688,
                14048389408623910080,
                4820581640170525440,
                14044299140972670176,
                4825205011168604096,
                4825522397425522000,
                14040506994769310656,
                4819704023598634752,
                4806084138736763648,
                4824595862144404208,
                14048767342883926880,
                14045420265757879552,
                14041096228393989376,
                4820967791712436000,
                4812267997001086720,
                14047859097364719184,
                14042623333028794272,
                4815019804759284416,
                4825483745771451824,
                14043713502251792224,
                14048100419397610224,
                4817956529314049344,
                4825099698095493680,
                14047603064479999376,
                4821677781523566720,
                4824675647976840240,
                14041044320136109312,
                14048357716882199312,
                4820832261441515840,
                4818307872204423616,
                4824900621368785328,
                4819228265911136512,
                14046291018795745760,
                14038138648593437504,
                14044533727359865344,
                14047529370610032800,
                4814749962329873600,
                14048876665590507952,
                14047261473896587296,
                14048265991775029968,
                4818982682813134784,
                14030627681786138368,
                14041004067595664448,
                4824633852670295840,
                14048578467832803648,
                14048969123484945664,
                14048613237520856832,
                14044920039306676352,
                14048079665556436256,
                4825635219583812128,
                14044224953991823040,
                4810080860085029888,
                4823516978872418752,
                14048985187750213584,
                14042926472270744768,
                4818098313978017600,
                4822987407276604448,
                4825268175142055680,
                4808063063380076800,
                4784705798763724800,
                4822191680941913632,
                14043989991150913728,
                4814565868856249152,
                4824908724883329552,
                4825491385159090256,
                14046867539259995504,
                14033661380005742336,
                14047331556102338720,
                4823316224765885632,
                4825303165855541696,
                4819599262551974592,
                14045174835131343712,
                4797811320920848384,
                4825399016814281648,
                14048769460534934608,
                4823550245189390816,
                4822556106598021440,
                4821330865977190144,
                4823634967448699472,
                4825770823169695536,
                14042508098622725504,
                4825765859659562640,
                14042311761928053216,
                4823939054384931984,
                4815799315823292672,
                14045870005443132480,
                14048819568468780400,
                4823810729965960224,
                14028743388748786944,
                14048139468978053232,
                14048515423817757280,
                14047863303690080336,
                4818039579239938816,
                4817677313551843584,
                4820854682816799328,
                14048973544294974368,
                14014616574546919424,
                14048564014456705424,
                14043667026177980256,
                4820913313671891392,
                4824838162898347088,
                14045466989798356736,
                14040620994713362176,
                14042020059809823616,
                4810151737271640064,
                14034922773766791808,
                14041167727637456384,
                14048921480856579088,
                14047505225963272688,
                4823884869399481472,
                4813303195463768832,
                14043732960720243424,
                4821704450958995968,
                14048726718832678736,
                14030664253432975616,
                14029442077796864768,
                14046857880889520304,
                4811411208422272512,
                4824691826138273024,
                4810929180882090624,
                4825713654706116016,
                14043277707007597472,
                4823814842162294848,
                4825061298287918544,
                4811395359900589952,
                14040093784478105920,
                14010846819932356608,
                14047609996612463824,
                4820589049093050784,
                14046043014746844032,
                14035347817301138944,
                14047165054493622784,
                14043001489257504096,
                4824796042815448800,
                4823940060130537152,
                4812053543038616960,
                4810504410389741312,
                4815675717771747904,
                4817343667700242368,
                14047867209982106576,
                14042553564915148448,
                14041674310627193856,
                4824626747854791472,
                4809469662999577600,
                4816853196745531328,
                14039415523564640576,
                14047366217729915568,
                4804512050904220672,
                14044061893743300512,
                14040877084533261824,
                4825149794512835168,
                14043369298173682080,
                14032920822853072640,
                4815451004354370048,
                4820031712543295456,
                4824864106082153728,
                14048745447546426768,
                14042979561052101792,
                4821363200561319680,
                4822188232926783040,
                4823731095105076720,
                14024330928877349376,
                4822124569350486144,
                14046181020766844096,
                4816008032659257600,
                4823505532255655232,
                14048608926876817744,
                14043086816360609152,
                14043431218222617024,
                4823742227279148896,
                14033434271271102848,
                14043254654206696352,
                4820799526351658208,
                4810042652985639168,
                4818464096024626048,
                4820810156746239552,
                4821861130857032736,
                4817824308536477184,
                14047859633748925680,
                4819153922482361760,
                4824647649089435648,
                14046758314719623072,
                14029987412182777856,
                14046822443461942432,
                14039953205051747328,
                4825718202891572000,
                4811552120232699392,
                14047432855865009888,
                14048929586987963552,
                14042662844130310208,
                14033607778619611392,
                4819441198173008800,
                4818917877881869824,
                14049085323745459216,
                4823860559748031344,
                4807365921367104256,
                4824861016138671968,
                14031654614643143680,
                4817914381448875776,
                4825198479846029904,
                14047939231914667456,
                4819277230271576256,
                14047371905361045008,
                4822149782054294400,
                14039237228312403328,
                14047050714534011008,
                4824316363071183616,
                4806274560160168192,
                4820570106516500704,
                4824191688082688400,
                4812114795851291008,
                4823590921617211760,
                14039375058746366720,
                4823822080073498736,
                14031968529294401536,
                4823638948432959920,
                14035302807104554112,
                14048814407632134160,
                4814120764064260992,
                4819008980077095968,
                14037959542815727808,
                4820454790779644032,
                14008603624705097728,
                4811994176005042816,
                14030279414180350976,
                14042582547940812512,
                14047104138168244432,
                14046010004457038048,
                14048513193303984672,
                4806572390951808000,
                14049020594390580960,
                4821598109261442784,
                14035158615887344768,
                4817734477992260160,
                4824699225026522000,
                14041047372336474176,
                14042919785460425792,
                14045990127414022048,
                4796735231262048256,
                4824997937700429040,
                4824968653599102176,
                4825417884620012464,
                4813592728514745344,
                14046786361181204368,
                14047632926479269440,
                4822646764126377696,
                14043336938170193248,
                4822392379978847936,
                4825446974385574320,
                4824474636133764528,
                14041518929823639552,
                4824039833716783600,
                14040235325891868800,
                4824746124298134272,
                14047634769619181984,
                14045313348135125376,
                14041436195472132224,
                4824664257085369088,
                14044357955201268992,
                4821441676178600160,
                14032154578807784704,
                14047432270807972608,
                14041150570552848640,
                4802039259094374400,
                14046547865216255840,
                14034665588260917120,
                4822198523984619360,
                14024155782596941824,
                4822550622765951488,
                14039723891016340160,
                14034531657195725568,
                14046402720168212160,
                14048815450179842816,
                14047068368869358448,
                14041082432262534720,
                4824471937691770512,
                14035399376366849536,
                14041787027145811264,
                14033307753871640704,
                14049130446858848736,
                4824880548850009248,
                4815164664896434624,
                14038337419048270720,
                14044589637814572928,
                14036308343873620736,
                4811765600305797248,
                4821093404696239488,
                4824499179044062416,
                14044796935843991552,
                4825044229752982976,
                14047016579479895648,
                14023645206820292608,
                4823835181733434800,
                4807508680976417792,
                14041429724337838912,
                14047946070668179568,
                14043533962612662528,
                14043033764563326048,
                14034149244040961664,
                14047781173396705728,
                14042978827476653952,
                14048316289435030752,
                4821422836857409664,
                14048182187160617440,
                14040211650041108288,
                4824637274054143536,
                4822076319777330752,
                4824498758037584416,
                14047423287414214288,
                14047990392117113696,
                4811259113780879104,
                14048886565567525616,
                4824094482538051680,
                14047618874943624544,
                14027399186241871360,
                4820902637664070176,
                4821122205470090976,
                4825308486408796000,
                14036214974157370496,
                4820396805880857184,
                4823766232033999008,
                4825514506451478160,
                4802033423964268032,
                14045883021204027744,
                14031276819043171072,
                14047924286335157552,
                4825172419180734480,
                4823970631424233440,
                4821779064645009952,
                4812773864779906560,
                4803271333529530880,
                4825492139971995424,
                14036413216541245312,
                14044356743822607840,
                4816682525860259968,
                4818463722202679232,
                4818808340069366784,
                4824850732171055776,
                14041264449465872640,
                14048183324220056400,
                14047291514935738304,
                4817334145361688640,
                14040263704621852928,
                4814897156578506816,
                4820103469433420576,
                14049098392876593520,
                14046874669210997440,
                14037204041975831936,
                4821142109959339200,
                14033357282232927232,
                4795366749952940032,
                4825073699214020976,
                14048643664617618288,
                4823975143141394608,
                14042259665693915872,
                4817288477211253504,
                14039804331806362816,
                14039597521658132032,
                4822245547121096000,
                14044364854982553280,
                4823163843499253280,
                14042434601051075968,
                4825771636441478256,
                4825696122035969024,
                4819057330289958240,
                4824451369999172128,
                4825660860991803968,
                14046095891170898368,
                14047815988034435024,
                4822222424956392288,
                14040454923402367680,
                4818759848294333440,
                4814869787699289088,
                14048168241346501888,
                14034492491026147712,
                14037781350341329408,
                4818046862503595200,
                14048674650136630112,
                4809043926402394368,
                4822130643009194144,
                4825584322019064032,
                14043463764490388928,
                14047711734126476496,
                14042028771981653632,
                4821213783731303008,
                4824097787867862848,
                4824552947270173088,
                4825510007112537888,
                4824914528218860432,
                14038334858020807168,
                14030665390759691776,
                4823020534669674528,
                4810083679642412928,
                4824384252572698528,
                14047566306679343776,
                14038912295696402560,
                4823717782054597264,
                4808200379836104192,
                4824394076386796656,
                4820330319581919776,
                14045325426999314656,
                14046365120501436832,
                14044149789380628704,
                4819039223841385856,
                14039235563336614848,
                14045969129271658624,
                14041817754655880128,
                4825131551847934256,
                4811254555456829568,
                14043670928709967232,
                4825332575611757680,
                4821088497814710496,
                14048048589564974960,
                14044612644721478880,
                4823905787144242640,
                14043759638687472608,
                4825689559050848240,
                4820920774517506016,
                4821109658015699552,
                4809168362666924288,
                14032159081907142144,
                4823941424989302368,
                4824422034810973536,
                4824329055777266784,
                14046990117354139552,
                14048781017505987008,
                14049165448903487424,
                4823396333782532592,
                4808897556958704128,
                14043869462381141568,
                4823625411153540944,
                14045044730168242816,
                14048512604526218176,
                4806320010870609920,
                4780960499617218560,
                14048305794661702272,
                4825502815947091904,
                14035111104035609472,
                14046494058493286272,
                14038098854484362688,
                4822281089241756736,
                4819478842187358240,
                14043342756211376992,
                4825118434462241936,
                4822680930955796352,
                4823486188302607248,
                4824708561328341456,
                4820411491316775584,
                14047652395226744976,
                14043556844085627648,
                4795329193623121920,
                14045229224944328608,
                14045505766908476224,
                14043410007211580544,
                14046431309206230560,
                14044352395881500096,
                14047091179732440912,
                14040660958297720896,
                4821817055165850944,
                4819199782566382816,
                4820552519312091552,
                14044038080378180224,
                4823626586759988288,
                14049029660881844256,
                4823432679904451936,
                4816937081132080384,
                14044918008458111424,
                14020902098382045184,
                4825319351585650272,
                4815961531267460672,
                14048587033792391584,
                4815021075536897536,
                14036479029193372544,
                4819185431676456448,
                14048663720639524448,
                14038583725798463104,
                4813159270269736448,
                4825780158746887536,
                14048645304410417152,
                14042715766195774336,
                14011700343665528832,
                14048351210226755120,
                14034421464178087808,
                4824683488419712752,
                14046799120506050944,
                4823325141407800960,
                4824828138576424432,
                14021094136442047488,
                4823638235325125392,
                14034017471368043264,
                14042288828097558816,
                14043156075144106336,
                4806837410053747968,
                14039925246703034816,
                14042136769992976192,
                4825294132408825440,
                4824795331719690688,
                14043192984385229536,
                4820394933017762400,
                4820158500518951232,
                4820563390870483168,
                4824587126480364048,
                14048921609774002400,
                14047415578198840048,
                4822498766602738752,
                14042318320626030880,
                4812727538142044032,
                14044952908571129728,
                14049006924595280848,
                14036687082704309760,
                14038118743210154304,
                4816879028373490944,
                14047830244698481744,
                4824775736211304000,
                4814172527318878464,
                4824523525066340544,
                4815098745828375040,
                4815101512388185856,
                14015215148728569856,
                4824554621870243872,
                14047131527335992640,
                14037040587996897664,
                14046826979045978352,
                4823810932579291328,
                4820479286536100096,
                4824025064337768448,
                14031625757285242880,
                4809664499448005376,
                4824003556673392016,
                4814462241983823744,
                14047183313265195856,
                4819427535743887392,
                4824864172787250080,
                4825599773713811008,
                4823430056784091840,
                14036617675265517824,
                14044697207842096768,
                14028793082616640256,
                14047767428554719104,
                14046228029542860736,
                14048357082089106688,
                14039046738265045696,
                14036966647204158976,
                4823901096678996656,
                4825265566354568736,
                4823313053677949760,
                14046729053382192432,
                4803677510675791872,
                4822072021462983520,
                14047882657639345600,
                4815989131287157888,
                4824648798597445312,
                4823596800095263776,
                4825452425024528880,
                4817059429024057088,
                4822849296170395872,
                14044635622196772896,
                4819361904919562496,
                14049068364825738960,
                4810501446803364224,
                4824485945741776448,
                4823259803769131136,
                14044747587695985472,
                4820908189929728608,
                4818794376220434816,
                4816108343408973760,
                4825403958920374368,
                4823793936674110640,
                14043807775905800256,
                14036431093034641280,
                4823428374613190160,
                4823456223292231312,
                4815422236714533824,
                14042335396392254432,
                4822552706222506912,
                14044868192340871520,
                4822247264741971456,
                14045261901037167712,
                4814120624571797632,
                14038417954804688000,
                14035810273727324800,
                4824668946196266800,
                4822946311429356928,
                4824865598517886784,
                14047989092002799952,
                14047189150594752928,
                4824529248758541888,
                4822959577716853792,
                14043967904406082336,
                14044025182676338144,
                4823055223635684160,
                4820258622215998240,
                4823708037201768336,
                14048686191809961712,
                14040526815067820864,
                4814321300577441280,
                4821662091867274560,
                4825696541231398816,
                4824536689847720384,
                14040069041008209344,
                14048116803683574192,
                14044339303715978080,
                4820922439718925184,
                4821347579251020256,
                14046205369346919328,
                4814820021000367360,
                14048010483661446336,
                4824246456163389840,
                14043862768895973312,
                14041578814391084480,
                4821828337744762016,
                4817625345557820160,
                4819625978766232672,
                4822261489834261664,
                4824797767744218112,
                4825467190193831088,
                14044944519505486080,
                4825257099096686752,
                4822844067889225472,
                14049062794721039088,
                14048419495768346192,
                14048358845022615392,
                4821940456313966208,
                4825781222648606272,
                14044770118777752960,
                4822477589161561344,
                14045903838232765248,
                14042525171771461760,
                14047894001338874944,
                4822117288483348576,
                14047103947997857184,
                4814703670485199808,
                4822716150688547040,
                4818747066279927808,
                14042317720043200384,
                4822782618761166080,
                14046221411775730336,
                14042180291607736896,
                4823198288935028608,
                14045640872416596896,
                14049069445492502832,
                14048407156054820144,
                4816408571398304448,
                4824886878132944752,
                14042901405467415424,
                14048983891005575440,
                4811277492240575104,
                14039592740227219968,
                14037720094846931968,
                4824103161134812208,
                14041228168804467392,
                14049084259695085552,
                4823028054587460672,
                14034617407306666752,
                14027205404510754304,
                14045596794367193952,
                14049109822368874736,
                4814700155417299392,
                14038205574719259200,
                4821133414948934240,
                4807658014437523712,
                14046818250910660240,
                14043500660972239680,
                14048927820078980528,
                14042223465469575296,
                14044466448556423008,
                4818839803760532672,
                14042554233179444000,
                4824652631904467808,
                14042150581838090944,
                14047104815928853792,
                4824849657250712416,
                14048255013656985072,
                4825612138913241424,
                4822638137927943936,
                14048572819666547536,
                4825233263122045456,
                4819910553766348384,
                4821715471609333568,
                4814875770870063808,
                4819786472723278688,
                4818402455693673984,
                14046186192283658272,
                14048260117997113040,
                14038419085957396544,
                4823725894356626624,
                4819446055545337792,
                14040300318702617728,
                4822360928336805824,
                4823373043301644432,
                14035351792974377728,
                14045293124139190464,
                14044525947970532160,
                4825748900760840688,
                14020353453775311872,
                14042235348754988992,
                14048959636038672560,
                14041420114076209920,
                4824580918715324960,
                4810129767972218240,
                14048518287661526624,
                14048965794690965088,
                4823501006594178784,
                14040998374858042432,
                14042327360407432992,
                14045160048934373312,
                14024832427335436800,
                14042999912589697376,
                4821342494564902848,
                14045602366058426688,
                14042556540900780960,
                4805581525172769536,
                4815753853996979392,
                14048234469037794032,
                14029812006270044160,
                14042500138902327872,
                4822172984996334336,
                4819838152469835072,
                4819399941274559712,
                4819347064913619872,
                14041326363585569856,
                4823139506591837568,
                14047979518243091328,
                14041606606399951680,
                4824297525055589696,
                14036333397661454336,
                14044505619532453280,
                4816831158832552384,
                4821666117537948960,
                14042478164651294208,
                4817589718173583680,
                14048191343534622448,
                14048645125773154608,
                4814233095401211392,
                14047483709747098320,
                4818680658625789248,
                14040636169532221632,
                14040803336369050944,
                14044593280942246944,
                14047129120235775072,
                14038823200748777152,
                14046763680973508656,
                14046608882492330432,
                14047481293264791312,
                4825589446653083744,
                4824920886445615776,
                4824531828603699616,
                4818988687019059488,
                14045414187235242880,
                14036111466687911168,
                4819160184232783808,
                14048805170158592512,
                4824035378279041872,
                4824237923961393072,
                4825132171646934880,
                14048257841820499040,
                4819528509169402688,
                14043657591186423872,
                14046387890913359424,
                4824134418209535264,
                14048743834403249888,
                14042294856302848352,
                14047148995976767104,
                4825031720907314480,
                14042052453229739136,
                14046676121336856224,
                14049054967715551472,
                14038599511694023424,
                4825162663832051264,
                14047442025147249216,
                14037723993555736512,
                4821940087027561280,
                14024900525013959680,
                4817253328084959296,
                4819461413846577344,
                14044882395932832128,
                4824528870231913088,
                14037070311974496640,
                14046342472613602112,
                4824951359190630624,
                4825546747119167232,
                14044781802203471584,
                4816600845839623488,
                4825778936880648768,
                14048620634226905392,
                4821974040045795584,
                4822259517303351968,
                4823831795524903504,
                4799950832228170752,
                14048979205247875120,
                4812537347165889792,
                4824337283629199376,
                14045670381235236992,
                14045244379693435200,
                14036459055618907648,
                4822888550680909920,
                4823635667656511824,
                14049134823592440912,
                4824069872689553152,
                4816595357216173824,
                4808710766082249216,
                14042418790464045632,
                14046477506892596800,
                14043398260487037152,
                14047020603191320272,
                4823794606714205136,
                4825208919820651920,
                4810255898296833280,
                14048174993702557472,
                14031218065677010688,
                4815370418413929344,
                4824486838814085024,
                4822739708391689568,
                4822586152193057248,
                14045954091572279264,
                4802778812519639552,
                14042773259051778624,
                4823700719930457424,
                14044502550048991872,
                14030560325937258496,
                4812722163493309568,
                14042869278648109312,
                4823954717183032640,
                4808510638068955392,
                14044754168329762240,
                4824952843856497776,
                14043625850189021792,
                4825018626037774912,
                4816537793204529408,
                4815421908627850432,
                14047954475478614496,
                14037690995066713728,
                4822356440614009856,
                4825547180506781600,
                4814430861172927616,
                14048326267377747344,
                14047980604595262016,
                14046556665036832224,
                14044802675006348800,
                4815077004599362368,
                14037523503206304640,
                4822411895407200480,
                14042969473449009984,
                14045443781189650112,
                14044508042724035136,
                4823079439063141504,
                4825601113859181872,
                4810021666733410176,
                4824277006514015152,
                4823987077946328576,
                4818233613479956864,
                4825438135440397184,
                4814524885019299136,
                14024573821519523328,
                4815307854132227072,
                14047459192522621856,
                4825115332910152704,
                14045060474407595840,
                14045251198651260096,
                4821903354082042496,
                4824656606233529056,
                4812983876140134912,
                14039958129181022272,
                4823437081122836688,
                14039773269233049344,
                14047100644790258960,
                4820120081736677344,
                14042081864130170624,
                4824891684722971296,
                14043200110983080416,
                14046198772202153312,
                14039743336140037504,
                14047164062653083696,
                4823776775075343536,
                4819020122735314048,
                4825241065497721072,
                14041883400219110144,
                14048491980588049008,
                14034733642170184064,
                4816623046341058368,
                4819448054750859776,
                4821959319467467104,
                4816595589642135744,
                14031406190985562880,
                14046723341210022880,
                4822121187834219680,
                4819409601088840192,
                4825555928031439568,
                14043166967486658880,
                4824518984465831024,
                14042639801898105344,
                14040080437567239872,
                14044159693466196736,
                4814683868293188608,
                14046251883788447776,
                4812865744470700672,
                4821028470729843968,
                4823993597005770000,
                14043813122652458400,
                4819786778529327168,
                4823580361172319984,
                4823992542478761104,
                4823907011920804240,
                14037775829442203328,
                4796402677603721216,
                4815028467032232384,
                14047961248981739168,
                14041153369005993280,
                14046881044539894448,
                14046922994809413696,
                14039906385651157312,
                4825227028615957616,
                4823770328847239184,
                14047449421980167376,
                4824287127141871648,
                4819027602398519616,
                4819914689616567584,
                14043404391358018688,
                4822837655710840128,
                14046791501974347424,
                14048942270802509472,
                14045452733107151840,
                14039554327645985536,
                14045827934158284032,
                14047239433789808256,
                14037130380023548160,
                14034867204809081472,
                14035241676013645824,
                14048207166401850240,
                14047991323392969440,
                4824246953235221056,
                14043851835145181760,
                4818367307904894464,
                4824652778964147552,
                14048730476311653600,
                14040418399699816704,
                14047456050418096416,
                4824430752514720832,
                4819492142642010592,
                4825227620005671216,
                4820263067040228352,
                4819284821463994560,
                4821934641184135872,
                14039829019717110208,
                14047082653720845536,
                4811937098022243328,
                14048203816622421248,
                4818121595931286784,
                4824371128853501840,
                4824500741613638064,
                14033485559620271744,
                14040671843562067584,
                14044378526694689952,
                14046860384716577184,
                14048728206259739136,
                14041876662741834048,
                14047149212732573824,
                14039936263056435584,
                4817745944332642560,
                14047853251317322544,
                4824052561202876528,
                14046032242323604608,
                14048949668235440368,
                4801409254327659008,
                4820801340618463968,
                4813837026340930304,
                14042746947779002752,
                14043737286503750112,
                14048572057235414832,
                14044021129288586496,
                4825411860536978096,
                4816253493935780288,
                14039587257297321600,
                4816802878535489216,
                4825254207903054640,
                4817108214976570432,
                4825522844708905248,
                14046236965204166528,
                14048428679290519712,
                14041403454063425920,
                4824920652007546144,
                4822076402978010432,
                14040782966056027968,
                14045469910120356224,
                14040817268304582592,
                4823537046448287360,
                4825542199994661728,
                4816795274138577408,
                4803516639061754880,
                14048031366099736640,
                4822170201496685792,
                4823917485742546144,
                4824650573257132432,
                4824520928744856064,
                14042850428874976544,
                14042551426705223744,
                4823073668841395072,
                14043677174658654688,
                4819885514414555648,
                4820567441476092768,
                14037822649441574656,
                4815507352615158272,
                14048069958799448320,
                14035956905390485632,
                4824006387258217312,
                14047825084095033664,
                4825497617704600336,
                4823710251822915952,
                4818564662891733760,
                4802540568370867200,
                4817783542940734784,
                4819097907965471552,
                4815770203467603456,
                4823503628351117552,
                4825575873764536032,
                4819964201468093600,
                14047110080179873952,
                14037976031954335616,
                14047206272173840192,
                4819555700974924192,
                4819682760681990048,
                4814575666592819712,
                4824593570341773600,
                14045731131286984032,
                4820453382547030080,
                14035579719987047552,
                4823394873587251984,
                14038409257607009152,
                14008802837672419328,
                4823119450280492928,
                4823697101508112944,
                14045803432805343744,
                4825235470573760592,
                4824362808272949840,
                4823141118950601248,
                4818402729592626048,
                14047965960600300160,
                4820480098771281920,
                4825075385656996960,
                14045375639208778912,
                4818870980556533568,
                14045744963691315328,
                4825743495166271600,
                14024465663582709760,
                4825218767317859104,
                4825456778648256128,
                4819959260922282048,
                14023603196420501504,
                14025329975515606528,
                4795643535283232768,
                4824039028940734384,
                4824328230144321984,
                4817359991911098176,
                4813965683063214592,
                14044153524067540608,
                14041007745824524544,
                4820060462529641216,
                14048272011270279664,
                4822516552777929056,
                14042790287495060736,
                14049030264483091920,
                4814897236898586944,
                14041714513845410368,
                14045645552131582752,
                4824902083693964608,
                14045635924064324800,
                4821197816935667328,
                4824493519784159488,
                14045059031499263712,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ],
            w2tab_offsets: [
                0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
    ],
    crts: [
        SerializedCRTData {
            prime: 1108307720798209,
            coeff_len: 1,
            nprimes: 1,
        },
        SerializedCRTData {
            prime: 659706976665601,
            coeff_len: 2,
            nprimes: 2,
        },
        SerializedCRTData {
            prime: 1086317488242689,
            coeff_len: 3,
            nprimes: 3,
        },
        SerializedCRTData {
            prime: 910395627798529,
            coeff_len: 4,
            nprimes: 4,
        },
        SerializedCRTData {
            prime: 699289395265537,
            coeff_len: 4,
            nprimes: 5,
        },
        SerializedCRTData {
            prime: 1022545813831681,
            coeff_len: 5,
            nprimes: 6,
        },
        SerializedCRTData {
            prime: 1013749720809473,
            coeff_len: 6,
            nprimes: 7,
        },
        SerializedCRTData {
            prime: 868614185943041,
            coeff_len: 7,
            nprimes: 8,
        },
    ],
    crts_data_0: [1, 1108307720798209, 1],
    crts_data_1: [
        659706976665601,
        0,
        1108307720798209,
        0,
        1768014697463809,
        39636172800,
        659706976665601,
        448600744132608,
    ],
    crts_data_2: [
        1746024464908289,
        38849740800,
        0,
        2194625209040897,
        65267564544,
        0,
        1768014697463809,
        39636172800,
        0,
        2854332185706497,
        143753478144,
        2334150,
        571641331050399,
        264058712526685,
        369275654225854,
    ],
    crts_data_3: [
        2656420092706817,
        9223372161875443712,
        1917337,
        0,
        3105020836839425,
        173578125312,
        3221127,
        0,
        2678410325262337,
        126892376064,
        1956150,
        0,
        2854332185706497,
        143753478144,
        2334150,
        0,
        3764727813505025,
        9223372321477099520,
        3624386149345124124,
        115,
        458320576515567,
        97569782239540,
        1036168050845794,
        811521334526211,
    ],
    crts_data_4: [
        3355709487972353,
        4611686244149100544,
        12608207587853570738,
        72,
        3804310232104961,
        13835058346567139328,
        1997174910934683142,
        122,
        3377699720527873,
        9223372265281814528,
        2855889094178193272,
        74,
        3553621580972033,
        9223372288811859968,
        8932863472618095828,
        88,
        3764727813505025,
        9223372321477099520,
        3624386149345124124,
        115,
        4464017208770561,
        4611686445765099520,
        11571777141199897105,
        80555675693875672,
        50394861723794,
        258028603731868,
        773781365962580,
        227761278779927,
        298113091205252,
    ],
    crts_data_5: [
        4378255301804033,
        6917529439377555456,
        12530393500700933832,
        74322200788992441,
        0,
        4826856045936641,
        11529215548235186176,
        7614436330990988976,
        124861297325507225,
        0,
        4400245534359553,
        2305843424874463232,
        4338630002270041433,
        75826698780672449,
        0,
        4576167394803713,
        2305843458156265472,
        17511087166284620218,
        90479200960512519,
        0,
        4787273627336705,
        2305843502523613184,
        15767648752728317208,
        117793676722176637,
        0,
        4464017208770561,
        4611686445765099520,
        11571777141199897105,
        80555675693875672,
        0,
        5486563022602241,
        16140901739284398080,
        6996870336501118609,
        14398896805553899065,
        4465387963968,
        465694486061214,
        121967058613713,
        753509900459637,
        334781288330872,
        601064818874366,
        857013090336611,
    ],
    crts_data_6: [
        5392005022613505,
        17293823221448310784,
        2198478172704326192,
        14933593249072088535,
        4084412403550,
        0,
        5840605766746113,
        14987980327317929984,
        7157356428090476222,
        6564030839720445995,
        6861812837965,
        0,
        5413995255169025,
        4611686675905773568,
        17498989514742629167,
        2837081764142908908,
        4167092816578,
        0,
        5589917115613185,
        13835058755710222336,
        4466506778020173865,
        2923420645518345907,
        4972328143453,
        0,
        5801023348146177,
        13835058811679014912,
        1196502022415599580,
        3070261776836331495,
        6473408337703,
        0,
        5477766929580033,
        6917529700301012992,
        13621513655758281367,
        14394739531794089519,
        4426976024493,
        0,
        5486563022602241,
        16140901739284398080,
        6996870336501118609,
        14398896805553899065,
        4465387963968,
        0,
        6500312743411713,
        12682137526980575232,
        5414242920244170579,
        1602665819603013542,
        613989000473298913,
        245397550,
        369585359167388,
        139053507976977,
        197670239731636,
        810816405262515,
        464183612954890,
        207483271871031,
        455632918774715,
    ],
    crts_data_7: [
        6260619208556545,
        2882304667759673344,
        3730551556212422699,
        6864787753339620743,
        15487482481366708770,
        192325460,
        0,
        6709219952689153,
        576461794752856064,
        12548400340138486966,
        16018745093780771332,
        3882874023334036815,
        323106774,
        0,
        6282609441112065,
        1729383169321074688,
        7686718500326172996,
        13089866517368245683,
        14606063416176826766,
        196218688,
        0,
        6458531301556225,
        10952755257409273856,
        2741863966014413374,
        15654288961721831229,
        11636034492611489364,
        234135343,
        0,
        6669637534089217,
        10952755323318566912,
        9393959891602620577,
        11456823266980106630,
        9579969358296738720,
        304817711,
        0,
        6346381115523073,
        14987980490484219904,
        11211844038443280667,
        14041014936563027513,
        6670475906452161904,
        208455983,
        0,
        6355177208545281,
        10376294474599628800,
        15564451032506485917,
        16359389422381633100,
        1246349985313081608,
        210264712,
        0,
        6500312743411713,
        12682137526980575232,
        5414242920244170579,
        1602665819603013542,
        613989000473298913,
        245397550,
        0,
        7368926929354753,
        16717363099189116928,
        17073008061340272950,
        7820777766012624523,
        8382868381485621416,
        3665382864143079344,
        11555,
        880374631983717,
        648658714639505,
        567379657715946,
        136167427417685,
        657261478444690,
        163175436259942,
        815098541074103,
        656711192629307,
    ],
    vec_two_pow_tab_backing: [
        [4607182418800017408, 4607182418800017408, 4607182418800017408, 4607182418800017408],
        [4611686018427387904, 4611686018427387904, 4611686018427387904, 4611686018427387904],
        [4616189618054758400, 4616189618054758400, 4616189618054758400, 4616189618054758400],
        [4620693217682128896, 4620693217682128896, 4620693217682128896, 4620693217682128896],
        [4625196817309499392, 4625196817309499392, 4625196817309499392, 4625196817309499392],
        [4629700416936869888, 4629700416936869888, 4629700416936869888, 4629700416936869888],
        [4634204016564240384, 4634204016564240384, 4634204016564240384, 4634204016564240384],
        [4638707616191610880, 4638707616191610880, 4638707616191610880, 4638707616191610880],
        [4643211215818981376, 4643211215818981376, 4643211215818981376, 4643211215818981376],
        [4647714815446351872, 4647714815446351872, 4647714815446351872, 4647714815446351872],
        [4652218415073722368, 4652218415073722368, 4652218415073722368, 4652218415073722368],
        [4656722014701092864, 4656722014701092864, 4656722014701092864, 4656722014701092864],
        [4661225614328463360, 4661225614328463360, 4661225614328463360, 4661225614328463360],
        [4665729213955833856, 4665729213955833856, 4665729213955833856, 4665729213955833856],
        [4670232813583204352, 4670232813583204352, 4670232813583204352, 4670232813583204352],
        [4674736413210574848, 4674736413210574848, 4674736413210574848, 4674736413210574848],
        [4679240012837945344, 4679240012837945344, 4679240012837945344, 4679240012837945344],
        [4683743612465315840, 4683743612465315840, 4683743612465315840, 4683743612465315840],
        [4688247212092686336, 4688247212092686336, 4688247212092686336, 4688247212092686336],
        [4692750811720056832, 4692750811720056832, 4692750811720056832, 4692750811720056832],
        [4697254411347427328, 4697254411347427328, 4697254411347427328, 4697254411347427328],
        [4701758010974797824, 4701758010974797824, 4701758010974797824, 4701758010974797824],
        [4706261610602168320, 4706261610602168320, 4706261610602168320, 4706261610602168320],
        [4710765210229538816, 4710765210229538816, 4710765210229538816, 4710765210229538816],
        [4715268809856909312, 4715268809856909312, 4715268809856909312, 4715268809856909312],
        [4719772409484279808, 4719772409484279808, 4719772409484279808, 4719772409484279808],
        [4724276009111650304, 4724276009111650304, 4724276009111650304, 4724276009111650304],
        [4728779608739020800, 4728779608739020800, 4728779608739020800, 4728779608739020800],
        [4733283208366391296, 4733283208366391296, 4733283208366391296, 4733283208366391296],
        [4737786807993761792, 4737786807993761792, 4737786807993761792, 4737786807993761792],
        [4742290407621132288, 4742290407621132288, 4742290407621132288, 4742290407621132288],
        [4746794007248502784, 4746794007248502784, 4746794007248502784, 4746794007248502784],
        [4751297606875873280, 4751297606875873280, 4751297606875873280, 4751297606875873280],
        [4755801206503243776, 4755801206503243776, 4755801206503243776, 4755801206503243776],
        [4760304806130614272, 4760304806130614272, 4760304806130614272, 4760304806130614272],
        [4764808405757984768, 4764808405757984768, 4764808405757984768, 4764808405757984768],
        [4769312005385355264, 4769312005385355264, 4769312005385355264, 4769312005385355264],
        [4773815605012725760, 4773815605012725760, 4773815605012725760, 4773815605012725760],
        [4778319204640096256, 4778319204640096256, 4778319204640096256, 4778319204640096256],
        [4782822804267466752, 4782822804267466752, 4782822804267466752, 4782822804267466752],
        [4787326403894837248, 4787326403894837248, 4787326403894837248, 4787326403894837248],
        [4791830003522207744, 4791830003522207744, 4791830003522207744, 4791830003522207744],
        [4796333603149578240, 4796333603149578240, 4796333603149578240, 4796333603149578240],
        [4800837202776948736, 4800837202776948736, 4800837202776948736, 4800837202776948736],
        [4805340802404319232, 4805340802404319232, 4805340802404319232, 4805340802404319232],
        [4809844402031689728, 4809844402031689728, 4809844402031689728, 4809844402031689728],
        [4814348001659060224, 4814348001659060224, 4814348001659060224, 4814348001659060224],
        [4818851601286430720, 4818851601286430720, 4818851601286430720, 4818851601286430720],
        [4823355200913801216, 4823355200913801216, 4823355200913801216, 4823355200913801216],
        [14050949362419236880, 14039408888374100032, 14050597518698348560, 14047782768931242000],
        [4805340802404318720, 14043912488001470528, 4810407351985110912, 4821244138588471264],
        [4809844402031689216, 4823073725937090464, 4814910951612481408, 4825747738215841760],
        [4814348001659059712, 14040534788280943040, 4819414551239851904, 14034905288746730112],
        [4818851601286430208, 14045038387908313536, 4823918150867222400, 14039408888374100608],
        [4823355200913800704, 4820821926123404448, 14049471618791506192, 14043912488001471104],
        [14050949362419237392, 14045882812838446816, 4820118238681627616, 14048416087628841600],
        [4805340802404285952, 4819133076263137888, 4824621838308998112, 4818570126309715008],
        [4809844402031656448, 4823636675890508384, 14048064243907954768, 4823073725937085504],
        [4814348001659026944, 14036594138607049344, 4824551469564817264, 14048064243907957712],
        [4818851601286397440, 14041097738234419840, 14048204981396316464, 4820118238681608416],
        [4823355200913767936, 14045601337861790336, 4824269994588093872, 4824621838308978912],
        [14050949362419270160, 4819696026216450848, 14048767931349763248, 14043771750513196192],
        [4805340802402188800, 14047430925210465520, 4822932988448599392, 14048275350140566688],
        [4809844402029559296, 4800837202762632192, 4827436588075969888, 4819273813751172512],
        [4814348001656929792, 4805340802390002688, 14026461039454104064, 4823777413378543008],
        [4818851601284300288, 4809844402017373184, 14030964639081474560, 14046938344001758416],
        [4823355200911670784, 4814348001644743680, 14035468238708845056, 4823988519610103408],
        [14050949362421367312, 4818851601272114176, 14039971838336215552, 14046305025308698208],
        [4805340802267971072, 4823355200899484672, 14044475437963586048, 4824832944536345008],
        [4809844401895341568, 14039408888431366208, 14048979037590956544, 14042927325603731808],
        [4814348001522712064, 14043912488058736704, 4822088563483826208, 14047430925231102304],
        [4818851601150082560, 4823073725822558112, 4826592163111196704, 4822651513389030048],
        [4823355200777453056, 14040534788739072448, 14040816263535869760, 14048486456456013168],
        [14050949362555585040, 14045038388366442944, 14045319863163240256, 4818007175692342464],
        [4805340793678036480, 4820821925207145632, 14049823462790610752, 4822510775319712960],
        [4809844393305406976, 14045882814670964448, 4818570124083988032, 14048627194525330256],
        [4814347992932777472, 4819133072598102624, 4823073723711358528, 4816881271137805760],
        [4818851592560147968, 4823636672225473120, 14050878995900791248, 4821384870765176256],
        [4823355192187518464, 14036594197247613568, 4796333033362176000, 4825888470392546752],
        [14050949371145519632, 14041097796874984064, 4800836632989546496, 14032090708952434944],
        [4805340243922222592, 14045601396502354560, 4805340232616916992, 14036594308579805440],
        [4809843843549593088, 4819695908935322400, 4809843832244287488, 14041097908207175936],
        [4814347443176963584, 14047431042491593968, 4814347431871657984, 14045601507834546432],
        [4818851042804334080, 4800822190778190848, 4818851031499028480, 4825536462010496784],
        [4823354642431704576, 4805325790405561344, 4823354631126398976, 14038002873273042880],
        [14050949920901333520, 4809829390032931840, 14050598088485750800, 14042506472900413376],
        [4805305059550133760, 4814332989660302336, 4810398235386675072, 14047010072527783872],
        [4809808659177504256, 4818836589287672832, 4814901835014045568, 4823845062558052496],
        [4814312258804874752, 4823340188915043328, 4819405434641416064, 14046803045642739440],
        [4818815858432245248, 14039468936369131584, 4823909034268786560, 4824259116328141360],
        [4823319458059615744, 14043972535996502080, 14049489851988377872, 14045222638436546400],
        [14050985105273422352, 4822953629947027360, 4820045305894140896, 4825915331408496816],
        [4803053259736448512, 14041015172241195456, 4824548905521511392, 14031231156442032896],
        [4807556859363819008, 14045518771868565952, 14048210109482928208, 14035734756069403392],
        [4812060458991189504, 4819861158202899616, 4824259738414870384, 14040238355696773888],
        [4816564058618560000, 14047265793224016752, 14048788443696210224, 14044741955324144384],
        [4821067658245930496, 4808373226153415424, 4822850939062811488, 14049245554951514880],
        [4825571257873300992, 4812876825780785920, 4827354538690181984, 4809197145563504896],
        [14046307259231897632, 4817380425408156416, 14030212519701812480, 4813700745190875392],
        [14050810858859268128, 4821884025035526912, 14034716119329182976, 4818204344818245888],
        [4809772916323319040, 14043758615014201888, 14039219718956553472, 4822707944445616384],
        [4814276515950689536, 4823368336412714480, 14043723318583923968, 14048430025399426832],
        [4818780115578060032, 14039303804382793920, 14048226918211294464, 4818458624145033152],
        [4823283715205430528, 14043807404010164416, 4824226120958137872, 4822962223772403648],
        [14051020848127607568, 4823283893919702688, 14048855678609675248, 14048175746072639568],
        [4800694231360240640, 14039694116350494144, 4822581999408951392, 4819672230022880992],
        [4805197830987611136, 14044197715977864640, 4827085599036321888, 4824175829650251488],
        [4809701430614981632, 4822503269984302240, 14036017513755900544, 14045555785148105888],
        [4814205030242352128, 14042520125116651232, 14040521113383271040, 4825582184696937328],
        [4818708629869722624, 14047023724744021728, 14045024713010641536, 14037554145049201024],
        [4823212229497093120, 4812981909772472960, 14049528312638012032, 14042057744676571520],
        [4827715829124463616, 4817485509399843456, 4819891463295604256, 14046561344303942016],
        [14001762727133986816, 4821989109027213952, 4824395062922974752, 4824576625541101200],
        [14006266326761357312, 14043548447030827808, 14048517794680001488, 14043952601584707040],
        [14010769926388727808, 4823578504396088560, 4823644368020723824, 14048456201212077536],
        [14015273526016098304, 14037524882517766528, 14050019184484503344, 4818249217643827520],
        [14019777125643468800, 14042028482145137024, 4817004350532847296, 4822752817271198016],
        [14024280725270839296, 14046532081772507520, 4821507950160217792, 14048385152573845200],
        [14028784324898209792, 4816817475503602240, 4826011549787588288, 4818817606749686208],
        [14033287924525580288, 4821321075130972736, 14043842404132971808, 4823321206377056704],
        [14037791524152950784, 14044884514823310240, 14048346003760342304, 14047816763467986512],
        [14042295123780321280, 4821129672293411040, 4823987949860042192, 4821108160441493216],
        [14046798723407691776, 14045267320498433632, 14049332020805866608, 4825611760068863712],
        [4827434354286231568, 4820364060943164256, 4820676630624185952, 14037080939098378880],
        [14033252179524452224, 14046762890483752112, 4825180230251556448, 14041584538725749376],
        [14037755779151822720, 4815751629797923520, 14046947460022838096, 14046088138353119872],
        [14042259378779193216, 4820255229425294016, 4826785037335050608, 4825049831491923344],
        [14046762978406563712, 14046871722001622352, 14039273269745038528, 14041895917421630400],
        [4827505844288487696, 4814880977654961600, 14043776869372409024, 14046399517049000896],
        [14031000240090242816, 4819384577282332096, 14048280468999779520, 4824738452796042320],
        [14035503839717613312, 4823888176909702592, 4824119019381167760, 14043305292564942560],
        [14040007439344983808, 14031923805713418496, 14049069881763615472, 14047808892192313056],
        [14044511038972354304, 14036427405340788992, 4821725186793190496, 4821139645544187040],
        [14049014638599724800, 14040931004968159488, 4826228786420560992, 4825643245171557536],
        [4822649846890529824, 14045434604595529984, 14042973457601080992, 14036577177455277696],
        [4827153446517900320, 4820029492748971552, 14047477057228451488, 14041080777082648192],
        [14037733371165794112, 14047097458677944816, 4825725842923823824, 14045584376710018688],
        [14042236970793164608, 4811802166829703552, 14044985231588029664, 4825553593135024528],
        [14046740570420535104, 4816305766457074048, 14049488831215400160, 14037865824276820928],
        [4827550660260544912, 4820809366084444544, 4820049388986051744, 14042369423904191424],
        [14029566128984411904, 14045907932916366624, 4824552988613422240, 14046873023531561920],
        [14034069728611782400, 4819082836107298272, 14048201943299106512, 4824119160550496400],
        [14038573328239152896, 4823586435734668768, 4824276070782513776, 14045782461547126240],
        [14043076927866523392, 14037397981100483200, 14048755778960923440, 4825355508297916976],
        [14047580527493893888, 14041901580727853696, 4822981598003958624, 14039450502973681344],
        [4825870746113827344, 14046405180355224192, 4827485197631329120, 14043954102601051840],
        [14045109306269792224, 4817325081172735552, 14022490816190501888, 14048457702228422336],
        [14049612905897162720, 4821828680800106048, 14026994415817872384, 4818237209513069120],
        [4820256777700778144, 14043869303485043616, 14031498015445242880, 4822740809140439616],
        [4824760377328148640, 4823160094969944288, 14036001615072613376, 14048397160704603600],
        [14048139009590542032, 14040189312149527744, 14040505214699983872, 4818721541703619008],
        [4824753781920531056, 14044692911776898240, 14045008814327354368, 4823225141330989504],
        [14048152200405777200, 4821512878386235040, 14049512413954724864, 14047912828514053712],
        [4824727400290060720, 14044500908312785632, 4819955058028752928, 4820723900257224416],
        [14048204963666717872, 4821896885314460256, 4824458657656123424, 4825227499884594912],
        [4824621873768179376, 14043732894456335200, 14048390605213704144, 14040474570280257856],
        [14048416016710480560, 4823394056970581168, 4823898746953318512, 14044978169907628352],
        [4824199767680654000, 14039098039919860416, 14049510426619313968, 14049481769534998848],
        [14049260228885531312, 14043601639547230912, 4819963007370396512, 4793735012815390720],
        [4821667485747303776, 4823525311879685456, 4824466606997767008, 4798238612442761216],
        [4826171085374674272, 14038048000647026112, 14048374706530416976, 4802742212070131712],
        [14043907949226404512, 14042551600274396608, 4823930544319892848, 4807245811697502208],
        [14048411548853775008, 14047055199901767104, 14049446831886165296, 4811749411324872704],
        [4824208703394065104, 4812478307248546944, 4820217386302991200, 4816253010952243200],
        [14049242357458709104, 4816981906875917440, 4824720985930361696, 4820756610579613696],
        [4821738971454592608, 4821485506503287936, 14047865948665227600, 4825260210206984192],
        [4826242571081963104, 14044555652078679840, 4824948060050271600, 14040212887701143616],
        [14043622006397249184, 4821787397782671840, 14047411800425407792, 14044716487328514112],
        [14048125606024619680, 14043951869519912032, 4825856356529911216, 14049220086955884608],
        [4824780589052375760, 4822994962900207456, 14044463177163680096, 4809928261727681664],
        [14048098586142087792, 14040849840428475072, 14048966776791050592, 4814431861355052160],
        [4824834628817439536, 14045353440055845568, 4822137606683450016, 4818935460982422656],
        [14047990506611960240, 4820191821828340384, 4826641206310820512, 4823439060609793152],
        [4825050787877694640, 14046935129598575984, 14040423917938879296, 14047615049539258128],
        [14047558188491450032, 4814373716879332544, 14044927517566249792, 4821915016156406752],
        [4825915424118715056, 4818877316506703040, 14049431117193620288, 14049222953688636464],
        [14044930594250241376, 4823380916134073536, 4820280245073171232, 4809882394003651968],
        [14049434193877611872, 14039203166611921472, 4824783844700541728, 4814385993631022464],
        [4820971625778981536, 14043706766239291968, 14047740231124867536, 4818889593258392960],
        [4825475225406352032, 4823420185187624400, 4825199495130991728, 4823393192885763456],
        [14046691389099693472, 14038889014183514560, 14046908930263967536, 14047706784987317520],
        [4827613174233344624, 14043392613810885056, 4826862096852791728, 4821548074364169184],
        [14026418524450547200, 4823734337616031312, 14038656793603109568, 4826051673991539680],
        [14030922124077917696, 14035031550998682496, 14043160393230480064, 14025023548310227456],
        [14035425723705288192, 14039535150626052992, 14047663992857850560, 14029527147937597952],
        [14039929323332658688, 14044038750253423488, 4825351971665025680, 14034030747564968448],
        [14044432922960029184, 4822821201433184544, 14046480716623222240, 14038534347192338944],
        [14048936522587399680, 14041544886296566720, 4827472002988927536, 14043037946819709440],
        [4822962310939830304, 14046048485923937216, 14024179730417904640, 14047541546447079936],
        [4827465910567200800, 4818751858897883456, 14028683330045275136, 4822209028525119520],
        [14032278119171423488, 4823255458525253952, 14033186929672645632, 14048928941319923696],
        [14036781718798793984, 14039807857928289088, 14037690529300016128, 4814467296781058240],
        [14041285318426164480, 14044311457555659584, 14042194128927386624, 4818970896408428736],
        [14045788918053534976, 4822275786828712352, 14046697728554757120, 4823474496035799232],
        [14050292517680905472, 14042975091427831008, 4827254991057392656, 14047544178687245968],
        [4816225059845183552, 14047478691055201504, 14033307241418768256, 4822198499564455392],
        [4820728659472554048, 4793112746123274240, 14037810841046138752, 14048939470280587824],
        [4825232259099924544, 4797616345750644736, 14042314440673509248, 4814383065095745216],
        [14047195246046990224, 4802119945378015232, 14046818040300879744, 4818886664723115712],
        [4826641309007634672, 4806623545005385728, 4827043876778967312, 4823390264350486208],
        [14041830471247919296, 4811127144632756224, 14036685069873573760, 14047712642057872016],
        [14046334070875289792, 4815630744260126720, 14041188669500944256, 4821524646081951200],
        [14050837670502660288, 4820134343887497216, 14045692269128314752, 4826028245709321696],
        [4808914943734769920, 14046992607539419152, 14050195868755685248, 14026522958372178432],
        [4813418543362140416, 4813479785046114176, 4815590876363392064, 14031026557999548928],
        [4817922142989510912, 4817983384673484672, 4820094475990762560, 14035530157626919424],
        [4822425742616881408, 4822486984300855168, 4824598075618133056, 14040033757254289920],
        [4826929342244251904, 14042552696483545376, 14048111769289684880, 14044537356881660416],
        [14039526205354981440, 14047056296110915872, 4824456418801357040, 14049040956509030912],
        [14044029804982351936, 4812460767902166656, 14048395082923236912, 4812794348877340800],
        [14048533404609722432, 4816964367529537152, 4823889791534252976, 4817297948504711296],
        [4823964991882170256, 4821467967156907648, 14049528337457445040, 4821801548132081792],
        [14049729780482498800, 14044590730771440416, 4819891364017872224, 14049336421712961424],
        [4819789279359433824, 4821717240397150688, 4824394963645242720, 4806289409197215488],
        [4824292878986804320, 14044092184290954336, 14048517993235465552, 4810793008824585984],
        [14049074006273230672, 4822714333358122848, 4823643970909795696, 4815296608451956480],
        [4822412376196506336, 14041972358596813504, 14050019978706359600, 4819800208079326976],
        [4826915975823876832, 14046475958224184000, 4816997996757997248, 4824303807706697472],
        [14039633136717982016, 4817041969696896320, 4821501596385367744, 14045043872922321952],
        [14044136736345352512, 4821545569324266816, 4826005196012738240, 4826094096922721264],
        [14048640335972723008, 14044435526436722080, 14043867819232372000, 14020407721797487616],
        [4823751129156169104, 4822027649066587360, 14048371418859742496, 14024911321424858112],
        [14050157505934501104, 14043471366952080992, 4823937119661241808, 14029414921052228608],
        [4817305153816418496, 4823655584474835376, 14049433681203467376, 14033918520679599104],
        [4821808753443788992, 14036291601257817472, 4820269989033782880, 14038422120306969600],
        [4826312353071159488, 14040795200885187968, 4824773588661153376, 14042925719934340096],
        [14043342878440463648, 14045298800512558464, 14047760743203644240, 14047429319561710592],
        [14047846478067834144, 4820301100914914592, 4825158470973438320, 4822657936066596896],
        [4825338844965946832, 14046825850512001776, 14046990978579074352, 14048480033778446320],
        [14046982074314945648, 4815247949571926208, 4826698000222578096, 4818058557112877248],
        [4827067652471723824, 4819751549199296704, 14039969566644818624, 4822562156740247744],
        [14038419723535206080, 14047375402227619664, 14044473166272189120, 14048575813104795472],
        [14042923323162576576, 4804390673671925248, 14048976765899559616, 4817292322502084032],
        [14047426922789947072, 4808894273299295744, 4822097650249413920, 4821795922129454528],
        [4826177955521720976, 4813397872926666240, 4826601249876784416, 14049342047715588688],
        [14043880468638217696, 4817901472554036736, 14040743569411168064, 4806109377113143040],
        [14048384068265588192, 4822405072181407232, 14045247169038538560, 4810612976740513536],
        [4824263664570438736, 14042716520722441248, 14049750768665909056, 4815116576367884032],
        [14049132435105961840, 14047220120349811744, 4819001639184016160, 4819620175995254528],
        [4822178660865581664, 4809834758127975680, 4823505238811386656, 4824123775622625024],
        [4826682260492952160, 4814338357755346176, 14050297442903177680, 14045764001258611744],
        [14041502859365379392, 4818841957382716672, 4814778283183452608, 4825373968586431472],
        [14046006458992749888, 4823345557010087168, 4819281882810823104, 14039302820665565376],
        [14050510058620120384, 14039447463988956224, 4823785482438193600, 14043806420292935872],
        [4814484732331464256, 14043951063616326720, 14049736955649563792, 14048310019920306368],
        [4818988331958834752, 4822996574707378080, 4819056891249397216, 4819135134632213792],
        [4823491931586205248, 14040843393199792576, 4823560490876767712, 4823638734259584288],
        [14050675901074428816, 14045346992827163072, 14050186938772415568, 14047215702239675856],
        [4811967983734933376, 4820204716285705376, 4815662316229549504, 4823433803134268528],
        [4816471583362303872, 14046922235141210992, 4820165915856920000, 14047625564490307376],
        [4820975182989674368, 4814476872538252480, 4824669515484290496, 4821872956352209760],
        [4825478782617044864, 4818980472165622976, 14047968889557370000, 14049265013492833456],
        [14046677160256922144, 4823484071792993472, 4824742178265986800, 4808574472241310464],
        [4827627403076115952, 14038377921340561984, 14047823563993977392, 4813078071868680960],
        [14025507878513182208, 14042881520967932480, 4825032829392772016, 4817581671496051456],
        [14030011478140552704, 14047385120595302976, 14047242261740406960, 4822085271123421952],
        [4607182418800017408, 4607182418800017408, 4607182418800017408, 4607182418800017408],
        [4607182418800017408, 4607182418800017408, 4607182418800017408, 4607182418800017408],
        [4611686018427387904, 4611686018427387904, 4611686018427387904, 4611686018427387904],
        [4611686018427387904, 4611686018427387904, 4611686018427387904, 4611686018427387904],
        [4616189618054758400, 4616189618054758400, 4616189618054758400, 4616189618054758400],
        [4616189618054758400, 4616189618054758400, 4616189618054758400, 4616189618054758400],
        [4620693217682128896, 4620693217682128896, 4620693217682128896, 4620693217682128896],
        [4620693217682128896, 4620693217682128896, 4620693217682128896, 4620693217682128896],
        [4625196817309499392, 4625196817309499392, 4625196817309499392, 4625196817309499392],
        [4625196817309499392, 4625196817309499392, 4625196817309499392, 4625196817309499392],
        [4629700416936869888, 4629700416936869888, 4629700416936869888, 4629700416936869888],
        [4629700416936869888, 4629700416936869888, 4629700416936869888, 4629700416936869888],
        [4634204016564240384, 4634204016564240384, 4634204016564240384, 4634204016564240384],
        [4634204016564240384, 4634204016564240384, 4634204016564240384, 4634204016564240384],
        [4638707616191610880, 4638707616191610880, 4638707616191610880, 4638707616191610880],
        [4638707616191610880, 4638707616191610880, 4638707616191610880, 4638707616191610880],
        [4643211215818981376, 4643211215818981376, 4643211215818981376, 4643211215818981376],
        [4643211215818981376, 4643211215818981376, 4643211215818981376, 4643211215818981376],
        [4647714815446351872, 4647714815446351872, 4647714815446351872, 4647714815446351872],
        [4647714815446351872, 4647714815446351872, 4647714815446351872, 4647714815446351872],
        [4652218415073722368, 4652218415073722368, 4652218415073722368, 4652218415073722368],
        [4652218415073722368, 4652218415073722368, 4652218415073722368, 4652218415073722368],
        [4656722014701092864, 4656722014701092864, 4656722014701092864, 4656722014701092864],
        [4656722014701092864, 4656722014701092864, 4656722014701092864, 4656722014701092864],
        [4661225614328463360, 4661225614328463360, 4661225614328463360, 4661225614328463360],
        [4661225614328463360, 4661225614328463360, 4661225614328463360, 4661225614328463360],
        [4665729213955833856, 4665729213955833856, 4665729213955833856, 4665729213955833856],
        [4665729213955833856, 4665729213955833856, 4665729213955833856, 4665729213955833856],
        [4670232813583204352, 4670232813583204352, 4670232813583204352, 4670232813583204352],
        [4670232813583204352, 4670232813583204352, 4670232813583204352, 4670232813583204352],
        [4674736413210574848, 4674736413210574848, 4674736413210574848, 4674736413210574848],
        [4674736413210574848, 4674736413210574848, 4674736413210574848, 4674736413210574848],
        [4679240012837945344, 4679240012837945344, 4679240012837945344, 4679240012837945344],
        [4679240012837945344, 4679240012837945344, 4679240012837945344, 4679240012837945344],
        [4683743612465315840, 4683743612465315840, 4683743612465315840, 4683743612465315840],
        [4683743612465315840, 4683743612465315840, 4683743612465315840, 4683743612465315840],
        [4688247212092686336, 4688247212092686336, 4688247212092686336, 4688247212092686336],
        [4688247212092686336, 4688247212092686336, 4688247212092686336, 4688247212092686336],
        [4692750811720056832, 4692750811720056832, 4692750811720056832, 4692750811720056832],
        [4692750811720056832, 4692750811720056832, 4692750811720056832, 4692750811720056832],
        [4697254411347427328, 4697254411347427328, 4697254411347427328, 4697254411347427328],
        [4697254411347427328, 4697254411347427328, 4697254411347427328, 4697254411347427328],
        [4701758010974797824, 4701758010974797824, 4701758010974797824, 4701758010974797824],
        [4701758010974797824, 4701758010974797824, 4701758010974797824, 4701758010974797824],
        [4706261610602168320, 4706261610602168320, 4706261610602168320, 4706261610602168320],
        [4706261610602168320, 4706261610602168320, 4706261610602168320, 4706261610602168320],
        [4710765210229538816, 4710765210229538816, 4710765210229538816, 4710765210229538816],
        [4710765210229538816, 4710765210229538816, 4710765210229538816, 4710765210229538816],
        [4715268809856909312, 4715268809856909312, 4715268809856909312, 4715268809856909312],
        [4715268809856909312, 4715268809856909312, 4715268809856909312, 4715268809856909312],
        [4719772409484279808, 4719772409484279808, 4719772409484279808, 4719772409484279808],
        [4719772409484279808, 4719772409484279808, 4719772409484279808, 4719772409484279808],
        [4724276009111650304, 4724276009111650304, 4724276009111650304, 4724276009111650304],
        [4724276009111650304, 4724276009111650304, 4724276009111650304, 4724276009111650304],
        [4728779608739020800, 4728779608739020800, 4728779608739020800, 4728779608739020800],
        [4728779608739020800, 4728779608739020800, 4728779608739020800, 4728779608739020800],
        [4733283208366391296, 4733283208366391296, 4733283208366391296, 4733283208366391296],
        [4733283208366391296, 4733283208366391296, 4733283208366391296, 4733283208366391296],
        [4737786807993761792, 4737786807993761792, 4737786807993761792, 4737786807993761792],
        [4737786807993761792, 4737786807993761792, 4737786807993761792, 4737786807993761792],
        [4742290407621132288, 4742290407621132288, 4742290407621132288, 4742290407621132288],
        [4742290407621132288, 4742290407621132288, 4742290407621132288, 4742290407621132288],
        [4746794007248502784, 4746794007248502784, 4746794007248502784, 4746794007248502784],
        [4746794007248502784, 4746794007248502784, 4746794007248502784, 4746794007248502784],
        [4751297606875873280, 4751297606875873280, 4751297606875873280, 4751297606875873280],
        [4751297606875873280, 4751297606875873280, 4751297606875873280, 4751297606875873280],
        [4755801206503243776, 4755801206503243776, 4755801206503243776, 4755801206503243776],
        [4755801206503243776, 4755801206503243776, 4755801206503243776, 4755801206503243776],
        [4760304806130614272, 4760304806130614272, 4760304806130614272, 4760304806130614272],
        [4760304806130614272, 4760304806130614272, 4760304806130614272, 4760304806130614272],
        [4764808405757984768, 4764808405757984768, 4764808405757984768, 4764808405757984768],
        [4764808405757984768, 4764808405757984768, 4764808405757984768, 4764808405757984768],
        [4769312005385355264, 4769312005385355264, 4769312005385355264, 4769312005385355264],
        [4769312005385355264, 4769312005385355264, 4769312005385355264, 4769312005385355264],
        [4773815605012725760, 4773815605012725760, 4773815605012725760, 4773815605012725760],
        [4773815605012725760, 4773815605012725760, 4773815605012725760, 4773815605012725760],
        [4778319204640096256, 4778319204640096256, 4778319204640096256, 4778319204640096256],
        [4778319204640096256, 4778319204640096256, 4778319204640096256, 4778319204640096256],
        [4782822804267466752, 4782822804267466752, 4782822804267466752, 4782822804267466752],
        [4782822804267466752, 4782822804267466752, 4782822804267466752, 4782822804267466752],
        [4787326403894837248, 4787326403894837248, 4787326403894837248, 4787326403894837248],
        [4787326403894837248, 4787326403894837248, 4787326403894837248, 4787326403894837248],
        [4791830003522207744, 4791830003522207744, 4791830003522207744, 4791830003522207744],
        [4791830003522207744, 4791830003522207744, 4791830003522207744, 4791830003522207744],
        [4796333603149578240, 4796333603149578240, 4796333603149578240, 4796333603149578240],
        [4796333603149578240, 4796333603149578240, 4796333603149578240, 4796333603149578240],
        [4800837202776948736, 4800837202776948736, 4800837202776948736, 4800837202776948736],
        [4800837202776948736, 4800837202776948736, 4800837202776948736, 4800837202776948736],
        [4805340802404319232, 4805340802404319232, 4805340802404319232, 4805340802404319232],
        [4805340802404319232, 4805340802404319232, 4805340802404319232, 4805340802404319232],
        [4809844402031689728, 4809844402031689728, 4809844402031689728, 4809844402031689728],
        [4809844402031689728, 4809844402031689728, 4809844402031689728, 4809844402031689728],
        [4814348001659060224, 4814348001659060224, 4814348001659060224, 4814348001659060224],
        [4814348001659060224, 4814348001659060224, 4814348001659060224, 4814348001659060224],
        [4818851601286430720, 4818851601286430720, 4818851601286430720, 4818851601286430720],
        [4818851601286430720, 4818851601286430720, 4818851601286430720, 4818851601286430720],
        [4823355200913801216, 4823355200913801216, 4823355200913801216, 4823355200913801216],
        [4823355200913801216, 4823355200913801216, 4823355200913801216, 4823355200913801216],
        [14050949362419236880, 14039408888374100032, 14050597518698348560, 14047782768931242000],
        [14041942163164495936, 14049577171907772432, 14049436434419417104, 14047114265861554192],
        [4805340802404318720, 14043912488001470528, 4810407351985110912, 4821244138588471264],
        [14046445762791866432, 4816459063984390080, 4817022013937811392, 4822581144727846880],
        [4809844402031689216, 4823073725937090464, 4814910951612481408, 4825747738215841760],
        [4819273813751496608, 4820962663611760576, 4821525613565181888, 14047888322047508528],
        [4814348001659059712, 14040534788280943040, 4819414551239851904, 14034905288746730112],
        [4823777413378867104, 4825466263239131072, 4826029213192552384, 4819484919984029536],
        [4818851601286430208, 14045038387908313536, 4823918150867222400, 14039408888374100608],
        [14038564463443968832, 14043982856745648416, 14040675525769298496, 4823988519611400032],
        [4823355200913800704, 4820821926123404448, 14049471618791506192, 14043912488001471104],
        [14043068063071339328, 14048486456373018912, 14045179125396668992, 14044968019164136096],
        [14050949362419237392, 14045882812838446816, 4820118238681627616, 14048416087628841600],
        [14047571662698709824, 4822018194774424480, 14049682725024039488, 4825501447611219312],
        [4805340802404285952, 4819133076263137888, 4824621838308998112, 4818570126309715008],
        [4808718502124820736, 4826521794401794976, 4815051689100832320, 14033497913863186816],
        [4809844402031656448, 4823636675890508384, 14048064243907954768, 4823073725937085504],
        [4813222101752191232, 14036875613583722112, 4819555288728202816, 14038001513490557312],
        [4814348001659026944, 14036594138607049344, 4824551469564817264, 14048064243907957712],
        [4817725701379561728, 14041379213211092608, 4824058888355573312, 14042505113117927808],
        [4818851601286397440, 14041097738234419840, 14048204981396316464, 4820118238681608416],
        [4822229301006932224, 14045882812838463104, 14048029059535872912, 14047008712745298304],
        [4823355200913767936, 14045601337861790336, 4824269994588093872, 4824621838308978912],
        [14044334700466589216, 14050386412465833600, 4823460754030049520, 4823003357192870432],
        [14050949362419270160, 4819696026216450848, 14048767931349763248, 14043771750513196192],
        [4823425569657926128, 4791830003512971264, 14049225328186920496, 14047466109582484976],
        [4805340802402188800, 14047430925210465520, 4822932988448599392, 14048275350140566688],
        [14041379213211496640, 4796333603140341760, 4818710863797784256, 4821173769844123744],
        [4809844402029559296, 4800837202762632192, 4827436588075969888, 4819273813751172512],
        [14045882812838867136, 4800837202767712256, 4823214463425154752, 4825677369471494240],
        [4814348001656929792, 4805340802390002688, 14026461039454104064, 4823777413378543008],
        [4820399713657495200, 4805340802395082752, 14049577171908063568, 14027586939363125760],
        [4818851601284300288, 4809844402017373184, 14030964639081474560, 14046938344001758416],
        [14047360556467020144, 4809844402022453248, 4815896114028639680, 14032090538990496256],
        [4823355200911670784, 4814348001644743680, 14035468238708845056, 4823988519610103408],
        [4812659151785290112, 4814348001649823744, 4820399713656010176, 14036594138617866752],
        [14050949362421367312, 4818851601272114176, 14039971838336215552, 14046305025308698208],
        [4817162751412660608, 4818851601277194240, 4824903313283380672, 14041097738245237248],
        [4805340802267971072, 4823355200899484672, 14044475437963586048, 4824832944536345008],
        [4821666351040031104, 4823355200904564736, 14045953181591939360, 14045601337872607744],
        [4809844401895341568, 14039408888431366208, 14048979037590956544, 14042927325603731808],
        [14045460600400391456, 14049577171917008912, 4826838453741278960, 4824868128902747664],
        [4814348001522712064, 14043912488058736704, 4822088563483826208, 14047430925231102304],
        [4821244138534446560, 4816459063910498240, 14027586939948516864, 14040675525856284608],
        [4818851601150082560, 4823073725822558112, 4826592163111196704, 4822651513389030048],
        [14046305025411560544, 4820962663537868736, 14032090539575887360, 14045179125483655104],
        [4823355200777453056, 14040534788739072448, 14040816263535869760, 14048486456456013168],
        [4819555288512108384, 4825466263165239232, 14036594139203257856, 4825290341291700304],
        [14050949362555585040, 14045038388366442944, 14045319863163240256, 4818007175692342464],
        [4824058888139478880, 14043982857041215776, 14041097738830628352, 14036875614975490944],
        [4805340793678036480, 4820821925207145632, 14049823462790610752, 4822510775319712960],
        [14034905292204313216, 14048486456668586272, 14045601338457998848, 14041379214602861440],
        [4809844393305406976, 14045882814670964448, 4818570124083988032, 14048627194525330256],
        [14039408891831683712, 4822018193592155040, 14050104938085369344, 14045882814230231936],
        [4814347992932777472, 4819133072598102624, 4823073723711358528, 4816881271137805760],
        [14043912491459054208, 4826521793219525536, 4808155533090963712, 4824586652545123472],
        [4818851592560147968, 4823636672225473120, 14050878995900791248, 4821384870765176256],
        [4823847778665461136, 14036875632500033152, 4812659132718334208, 14042575487429242336],
        [4823355192187518464, 14036594197247613568, 4796333033362176000, 4825888470392546752],
        [14038001541151216576, 14041379232127403648, 4817162732345704704, 14047079087056612832],
        [14050949371145519632, 14041097796874984064, 4800836632989546496, 14032090708952434944],
        [14042505140778587072, 14045882831754774144, 4821666331973075200, 4822721859947612320],
        [4805340243922222592, 14045601396502354560, 4805340232616916992, 14036594308579805440],
        [14047008740405957568, 14050386431382144640, 4826169931600445696, 14047747606827743088],
        [4809843843549593088, 4819695908935322400, 4809843832244287488, 14041097908207175936],
        [4816318105210675776, 4791820318361718784, 14039549778506152000, 4820047780863091296],
        [4814347443176963584, 14047431042491593968, 4814347431871657984, 14045601507834546432],
        [4820821704838046272, 4796323917989089280, 14044053378133522496, 4824551380490461792],
        [4818851042804334080, 4800822190778190848, 4818851031499028480, 4825536462010496784],
        [14046938565286469072, 4800827517616459776, 14048556977760892992, 14042716575647889056],
        [4823354642431704576, 4805325790405561344, 4823354631126398976, 14038002873273042880],
        [4816879506166583744, 4805331117243830272, 4821454634246217504, 14047220175275259552],
        [14050949920901333520, 4809829390032931840, 14050598088485750800, 14042506472900413376],
        [4821383105793954240, 4809834716871200768, 4825958233873588000, 4822157507073025440],
        [4805305059550133760, 4814332989660302336, 4810398235386675072, 14047010072527783872],
        [14046027090892545184, 4814338316498571264, 14041243360321013568, 14048311959702329968],
        [4809808659177504256, 4818836589287672832, 4814901835014045568, 4823845062558052496],
        [4820111157550139104, 4818841916125941760, 14045746959948384064, 4816729137443056832],
        [4814312258804874752, 4823340188915043328, 4819405434641416064, 14046803045642739440],
        [14047649112574376240, 4823345515753312256, 14050250559575754560, 4821232737070427328],
        [4818815858432245248, 14039468936369131584, 4823909034268786560, 4824259116328141360],
        [4806240106103495424, 14049586857068261392, 4801650488392954368, 4825736336697797824],
        [4823319458059615744, 14043972535996502080, 14049489851988377872, 14045222638436546400],
        [4810743705730865920, 4816381582700478400, 4806154088020324864, 14023416834127668224],
        [14050985105273422352, 4822953629947027360, 4820045305894140896, 4825915331408496816],
        [4815247305358236416, 4820885182327848896, 4810657687647695360, 14027920433755038720],
        [4803053259736448512, 14041015172241195456, 4824548905521511392, 14031231156442032896],
        [4819750904985606912, 4825388781955219392, 4815161287275065856, 14032424033382409216],
        [4807556859363819008, 14045518771868565952, 14048210109482928208, 14035734756069403392],
        [4824254504612977408, 14044292781881295136, 4819664886902436352, 14036927633009779712],
        [4812060458991189504, 4819861158202899616, 4824259738414870384, 14040238355696773888],
        [14030334418370208000, 14048796381508665632, 4824168486529806848, 14041431232637150208],
        [4816564058618560000, 14047265793224016752, 14048788443696210224, 14044741955324144384],
        [14034838017997578496, 4820778494231837600, 14047809863187405840, 14045934832264520704],
        [4821067658245930496, 4808373226153415424, 4822850939062811488, 14049245554951514880],
        [14039341617624948992, 4825282093859208096, 4823899146726983664, 4824534634510834704],
        [4825571257873300992, 4812876825780785920, 4827354538690181984, 4809197145563504896],
        [14043845217252319488, 14044719534265340320, 14048348542793052208, 14042783559566397408],
        [14046307259231897632, 4817380425408156416, 14030212519701812480, 4813700745190875392],
        [4823915052872195856, 14049223133892710816, 4822288374117580640, 14047287159193767904],
        [14050810858859268128, 4821884025035526912, 14034716119329182976, 4818204344818245888],
        [14037206656480841600, 4819071484695656864, 4826791973744951136, 4821889571398992032],
        [4809772916323319040, 14043758615014201888, 14039219718956553472, 4822707944445616384],
        [14041710256108212096, 4823575084323027360, 14029637249486296320, 14048579895376363376],
        [4814276515950689536, 4823368336412714480, 14043723318583923968, 14048430025399426832],
        [14046213855735582592, 14049137405089320144, 14034140849113666816, 4814585652050789568],
        [4818780115578060032, 14039303804382793920, 14048226918211294464, 4818458624145033152],
        [4819737627864064288, 4819414399909219552, 14038644448741037312, 4819089251678160064],
        [4823283715205430528, 14043807404010164416, 4824226120958137872, 4822962223772403648],
        [4824241227491434784, 4823917999536590048, 14043148048368407808, 4823592851305530560],
        [14051020848127607568, 4823283893919702688, 14048855678609675248, 14048175746072639568],
        [14030759286259571968, 14048451574662194768, 14047651647995778304, 14046550692387613984],
        [4800694231360240640, 14039694116350494144, 4822581999408951392, 4819672230022880992],
        [14035262885886942464, 4822157721617721056, 4824215577110238736, 4823918774387741424],
        [4805197830987611136, 14044197715977864640, 4827085599036321888, 4824175829650251488],
        [14039766485514312960, 4826661321245091552, 14047715682026542064, 14045247000058770528],
        [4809701430614981632, 4822503269984302240, 14036017513755900544, 14045555785148105888],
        [14044270085141683456, 14034643184090976896, 4824087509048711216, 4825222466716584880],
        [4814205030242352128, 14042520125116651232, 14040521113383271040, 4825582184696937328],
        [4823490184982831888, 14039146783718347392, 14047971818149597104, 14037840823345586880],
        [4818708629869722624, 14047023724744021728, 14045024713010641536, 14037554145049201024],
        [14040862290612250560, 14043650383345717888, 4823575236802601136, 14042344422972957376],
        [4823212229497093120, 4812981909772472960, 14049528312638012032, 14042057744676571520],
        [14045365890239621056, 14048153982973088384, 14048996362641817264, 14046848022600327872],
        [4827715829124463616, 4817485509399843456, 4819891463295604256, 14046561344303942016],
        [4821433558855987360, 4823348088374146592, 4819697094722520416, 4823500659343276688],
        [14001762727133986816, 4821989109027213952, 4824395062922974752, 4824576625541101200],
        [14045926184768478944, 14049584284447427056, 4824200694349890912, 14046823349002603248],
        [14006266326761357312, 14043548447030827808, 14048517794680001488, 14043952601584707040],
        [4820312969798271584, 4816402163667153088, 14047745447547237712, 4823550006538725936],
        [14010769926388727808, 4823578504396088560, 4823644368020723824, 14048456201212077536],
        [14047447300326243760, 4820905763294523584, 4824027978007319920, 14046722071454832480],
        [14015273526016098304, 14037524882517766528, 14050019184484503344, 4818249217643827520],
        [4811271250037712256, 4825409362921894080, 14048090880232379696, 4823747395320522928],
        [14019777125643468800, 14042028482145137024, 4817004350532847296, 4822752817271198016],
        [4815774849665082752, 14044210458014596384, 4823319024360270688, 14045932516327644512],
        [14024280725270839296, 14046532081772507520, 4821507950160217792, 14048385152573845200],
        [4820278449292453248, 14048714057641966880, 14049472610972947632, 4824536950447710896],
        [14028784324898209792, 4816817475503602240, 4826011549787588288, 4818817606749686208],
        [14047481820832062096, 4821107789698632608, 4816732601509567168, 14042774295818892640],
        [14033287924525580288, 4821321075130972736, 14043842404132971808, 4823321206377056704],
        [4810718921944618880, 4825611389326003104, 4821236201136937664, 14047277895446263136],
        [14037791524152950784, 14044884514823310240, 14048346003760342304, 14047816763467986512],
        [4815222521571989376, 14043402352398160288, 4825739800764308160, 4821926626389011104],
        [14042295123780321280, 4821129672293411040, 4823987949860042192, 4821108160441493216],
        [4819726121199359872, 14047905952025530784, 14042607231668229408, 14048542840386344304],
        [14046798723407691776, 14045267320498433632, 14049332020805866608, 4825611760068863712],
        [4824229720826730368, 4823847706539089104, 14047110831295599904, 4814882091970942144],
        [4827434354286231568, 4820364060943164256, 4820676630624185952, 14037080939098378880],
        [14031127499530113280, 14048592160657196656, 4825297210510595536, 4819385691598312640],
        [14033252179524452224, 14046762890483752112, 4825180230251556448, 14041584538725749376],
        [14035631099157483776, 4821595377637713504, 14044377592683079904, 4823889291225683136],
        [14037755779151822720, 4815751629797923520, 14046947460022838096, 14046088138353119872],
        [14040134698784854272, 4826098977265084000, 14048881192310450400, 14045364932707003680],
        [14042259378779193216, 4820255229425294016, 4826785037335050608, 4825049831491923344],
        [14044638298412224768, 14040680363142466880, 4820157776047987872, 4825104534068351728],
        [14046762978406563712, 14046871722001622352, 14039273269745038528, 14041895917421630400],
        [4822888742510779936, 14045183962769837376, 4824661375675358368, 14038784284531452096],
        [4827505844288487696, 4814880977654961600, 14043776869372409024, 14046399517049000896],
        [14043015817458893792, 14049687562397207872, 14046824084896302800, 14043287884158822592],
        [14031000240090242816, 4819384577282332096, 14048280468999779520, 4824738452796042320],
        [14047519417086264288, 4815575940068906560, 4825870703309189744, 14047791483786193088],
        [14035503839717613312, 4823888176909702592, 4824119019381167760, 14043305292564942560],
        [4810117381877383808, 4820079539696277056, 14041943604836199616, 4819872273029291296],
        [14040007439344983808, 14031923805713418496, 14049069881763615472, 14047808892192313056],
        [4814620981504754304, 4824583139323647552, 14046447204463570112, 4824375872656661792],
        [14044511038972354304, 14036427405340788992, 4821725186793190496, 4821139645544187040],
        [4819124581132124800, 14047121295088079760, 4826344430869648208, 14043418606983089056],
        [14049014638599724800, 14040931004968159488, 4826228786420560992, 4825643245171557536],
        [4823628180759495296, 4825417020413991152, 14038153784352531904, 14047922206610459552],
        [4822649846890529824, 14045434604595529984, 14042973457601080992, 14036577177455277696],
        [14039758324398943296, 14044179828046208096, 14042657383979902400, 4819349381732225440],
        [4827153446517900320, 4820029492748971552, 14047477057228451488, 14041080777082648192],
        [14044261924026313792, 14048683427673578592, 14047160983607272896, 4823852981359595936],
        [14037733371165794112, 14047097458677944816, 4825725842923823824, 14045584376710018688],
        [4823498346098201552, 4821230309572185760, 4825196905887249552, 14045510172171352480],
        [14042236970793164608, 4811802166829703552, 14044985231588029664, 4825553593135024528],
        [14040797001689293248, 4825733909199556256, 14044778811176463840, 4824959294604002928],
        [14046740570420535104, 4816305766457074048, 14049488831215400160, 14037865824276820928],
        [14045300601316663744, 14042912272903947680, 14049282410803834336, 14039946200246242496],
        [4827550660260544912, 4820809366084444544, 4820049388986051744, 14042369423904191424],
        [4821564136701901984, 14047415872531318176, 4818254202862473536, 14044449799873612992],
        [14029566128984411904, 14045907932916366624, 4824552988613422240, 14046873023531561920],
        [14045665029076649696, 4824827865527514320, 4822757802489844032, 14048953399500983488],
        [14034069728611782400, 4819082836107298272, 14048201943299106512, 4824119160550496400],
        [4820835281181930080, 14046536447592115424, 14050033832843374288, 4807850070865504512],
        [14038573328239152896, 4823586435734668768, 4824276070782513776, 14045782461547126240],
        [14046924988942585264, 4826395925229458224, 4810137651433247616, 4812353670492875008],
        [14043076927866523392, 14037397981100483200, 14048755778960923440, 4825355508297916976],
        [4816988116917654208, 14038304779427473088, 4814641251060618112, 4816857270120245504],
        [14047580527493893888, 14041901580727853696, 4822981598003958624, 14039450502973681344],
        [4821491716545024704, 14042808379054843584, 4819144850687988608, 4821360869747616000],
        [4825870746113827344, 14046405180355224192, 4827485197631329120, 14043954102601051840],
        [14045809869390404256, 14047311978682214080, 4823648450315359104, 14049108597027739408],
        [14045109306269792224, 4817325081172735552, 14022490816190501888, 14048457702228422336],
        [4820545600554420960, 4825035653225722512, 14048849935616301328, 4800016192451673088],
        [14049612905897162720, 4821828680800106048, 14026994415817872384, 4818237209513069120],
        [14047214669570094384, 14045705296799282656, 4820282802824584160, 4804519792079043584],
        [4820256777700778144, 14043869303485043616, 14031498015445242880, 4822740809140439616],
        [4814670671897581248, 14050208896426653152, 4824786402451954656, 4809023391706414080],
        [4824760377328148640, 4823160094969944288, 14036001615072613376, 14048397160704603600],
        [4819174271524951744, 4807080665983567104, 14046420824917643424, 4813526991333784576],
        [14048139009590542032, 14040189312149527744, 14040505214699983872, 4818721541703619008],
        [4823677871152322240, 4811584265610937600, 4826370810415574896, 4818030590961155072],
        [4824753781920531056, 14044692911776898240, 14045008814327354368, 4823225141330989504],
        [14039360801256327744, 4816087865238308096, 14037942747985118400, 4822534190588525568],
        [14048152200405777200, 4821512878386235040, 14049512413954724864, 14047912828514053712],
        [14043864400883698240, 4820591464865678592, 14042446347612488896, 14047935276186829840],
        [4824727400290060720, 14044500908312785632, 4819955058028752928, 4820723900257224416],
        [4823895869240817104, 4825095064493049088, 14046949947239859392, 4819297103426744288],
        [14048204963666717872, 4821896885314460256, 4824458657656123424, 4825227499884594912],
        [14037513594582901632, 14045467651729976352, 4825618978622076560, 4823800703054114784],
        [4824621873768179376, 14043732894456335200, 14048390605213704144, 14040474570280257856],
        [14042017194210272128, 14049971251357346848, 14043090520237155808, 14045719285393277088],
        [14048416016710480560, 4823394056970581168, 4823898746953318512, 14044978169907628352],
        [14046520793837642624, 4812264855116529280, 14047594119864526304, 4824750181382078320],
        [4824199767680654000, 14039098039919860416, 14049510426619313968, 14049481769534998848],
        [4819123751659944224, 4816768454743899776, 4824330633372742736, 14041619106021639360],
        [14049260228885531312, 14043601639547230912, 4819963007370396512, 4793735012815390720],
        [4823627351287314720, 4821272054371270272, 14047485569501534064, 14046122705649009856],
        [4821667485747303776, 4823525311879685456, 4824466606997767008, 4798238612442761216],
        [14039764960176387904, 4825775653998640768, 4824547734098727216, 4824346761126345552],
        [4826171085374674272, 14038048000647026112, 14048374706530416976, 4802742212070131712],
        [14044268559803758400, 14042745293707609632, 14047051368049565104, 14043535053104354016],
        [14043907949226404512, 14042551600274396608, 4823930544319892848, 4807245811697502208],
        [4823491710320756944, 14047248893334980128, 4825416137002665136, 14048038652731724512],
        [14048411548853775008, 14047055199901767104, 14049446831886165296, 4811749411324872704],
        [14040850087908850112, 4825161823920190416, 14043901886714801504, 4818883597247165600],
        [4824208703394065104, 4812478307248546944, 4820217386302991200, 4816253010952243200],
        [14045353687536220608, 14045200614021411040, 14048405486342172000, 4823387196874536096],
        [14049242357458709104, 4816981906875917440, 4824720985930361696, 4820756610579613696],
        [4821457964262788256, 14049704213648781536, 4822060599921101472, 14047050273940084432],
        [4821738971454592608, 4821485506503287936, 14047865948665227600, 4825260210206984192],
        [14045877373954877152, 4815442730056317248, 4826564199548471968, 4822837112413725920],
        [4826242571081963104, 14044555652078679840, 4824948060050271600, 14040212887701143616],
        [4820410591425475168, 4819946329683687744, 14035071231330047616, 14047632354361629488],
        [14043622006397249184, 4821787397782671840, 14047411800425407792, 14044716487328514112],
        [14047349678699040176, 4824449929311058240, 14039574830957418112, 4820508790727545696],
        [14048125606024619680, 14043951869519912032, 4825856356529911216, 14049220086955884608],
        [4812833196072969600, 14047387715113258384, 14044078430584788608, 4825012390354916192],
        [4824780589052375760, 4822994962900207456, 14044463177163680096, 4809928261727681664],
        [4817336795700340096, 4824884180363633904, 14048582030212159104, 14039521434238936384],
        [14048098586142087792, 14040849840428475072, 14048966776791050592, 4814431861355052160],
        [4821840395327710592, 14046311188247637088, 4821354424441153056, 14044025033866306880],
        [4824834628817439536, 14045353440055845568, 4822137606683450016, 4818935460982422656],
        [14045112511825032480, 4826621184573936560, 4825858024068523552, 14048528633493677376],
        [14047990506611960240, 4820191821828340384, 4826641206310820512, 4823439060609793152],
        [4821940315685164512, 14035285370829456768, 14042045038761529152, 4814995747112277568],
        [4825050787877694640, 14046935129598575984, 14040423917938879296, 14047615049539258128],
        [14044912671110124640, 14039788970456827264, 14046548638388899648, 4819499346739648064],
        [14047558188491450032, 4814373716879332544, 14044927517566249792, 4821915016156406752],
        [4822339997114980192, 14044292570084197760, 4826242996944318672, 4824002946367018560],
        [4825915424118715056, 4818877316506703040, 14049431117193620288, 14049222953688636464],
        [14044113308250493280, 14048796169711568256, 14038965255755168192, 14044910312141661984],
        [14044930594250241376, 4823380916134073536, 4820280245073171232, 4809882394003651968],
        [4823646961874022064, 4820779341420227104, 14043468855382538688, 4825559154633693424],
        [14049434193877611872, 14039203166611921472, 4824783844700541728, 4814385993631022464],
        [14039608075482729152, 4825282941047597600, 14047972455009909184, 14031932764120736512],
        [4820971625778981536, 14043706766239291968, 14047740231124867536, 4818889593258392960],
        [14044111675110099648, 14044716145511782304, 4823573963081976976, 14036436363748107008],
        [4825475225406352032, 4823420185187624400, 4825199495130991728, 4823393192885763456],
        [4823648595014415696, 14049219745139152800, 14048998910083065584, 14040939963375477504],
        [14046691389099693472, 14038889014183514560, 14046908930263967536, 14047706784987317520],
        [14039595010359580096, 4819085039709888928, 4819686904957527136, 14045443563002848000],
        [4827613174233344624, 14043392613810885056, 4826862096852791728, 4821548074364169184],
        [14044098609986950592, 4823588639337259424, 4824190504584897632, 4825025903772507408],
        [14026418524450547200, 4823734337616031312, 14038656793603109568, 4826051673991539680],
        [4823661660137564752, 14049110295060856016, 14047765827077224272, 14039413326898206656],
        [14030922124077917696, 14035031550998682496, 14043160393230480064, 14025023548310227456],
        [14039490489374387648, 4819522840023076064, 4823987218947346800, 14043916926525577152],
        [14035425723705288192, 14039535150626052992, 14047663992857850560, 14029527147937597952],
        [14043994089001758144, 4824026439650446560, 14048172398352325936, 14048420526152947648],
        [14039929323332658688, 14044038750253423488, 4825351971665025680, 14034030747564968448],
        [4823766181122757200, 14048234694434481744, 4822992951880485728, 4815860605838115392],
        [14044432922960029184, 4822821201433184544, 14046480716623222240, 14038534347192338944],
        [14038654321492848064, 4823025242528573152, 14049798683452732592, 4820364205465485888],
        [14048936522587399680, 14041544886296566720, 4827472002988927536, 14043037946819709440],
        [14043157921120218560, 14049907130293000496, 4813900041683514752, 4824867805092856384],
        [4822962310939830304, 14046048485923937216, 14024179730417904640, 14047541546447079936],
        [14047661520747589056, 4813290792146070912, 4818403641310885248, 14040678116335414848],
        [4827465910567200800, 4818751858897883456, 14028683330045275136, 4822209028525119520],
        [4805843044560685312, 4817794391773441408, 4822907240938255744, 14045181715962785344],
        [14032278119171423488, 4823255458525253952, 14033186929672645632, 14048928941319923696],
        [4810346644188055808, 4822297991400811904, 14049884394394962576, 4825287750812570064],
        [14036781718798793984, 14039807857928289088, 14037690529300016128, 4814467296781058240],
        [4814850243815426304, 4826801591028182400, 4812528666607835008, 14036917062641574784],
        [14041285318426164480, 14044311457555659584, 14042194128927386624, 4818970896408428736],
        [4819353843442796800, 14031581296236581120, 4817032266235205504, 14041420662268945280],
        [14045788918053534976, 4822275786828712352, 14046697728554757120, 4823474496035799232],
        [4823857443070167296, 14036084895863951616, 4821535865862576000, 14045924261896315776],
        [14050292517680905472, 14042975091427831008, 4827254991057392656, 14047544178687245968],
        [14037924225913567296, 14040588495491322112, 4826039465489946496, 4824545204879039632],
        [4816225059845183552, 14047478691055201504, 14033307241418768256, 4822198499564455392],
        [14042427825540937792, 14045092095118692608, 14040593507390145600, 140427412780935776