// Copyright © 2025 Mikhail Hogrefe
//
// This file is part of Malachite.
//
// Malachite is free software: you can redistribute it and/or modify it under the terms of the GNU
// Lesser General Public License (LGPL) as published by the Free Software Foundation; either version
// 3 of the License, or (at your option) any later version. See <https://www.gnu.org/licenses/>.

use malachite_float::exhaustive::exhaustive_positive_floats_with_precision;
use malachite_float::test_util::exhaustive::exhaustive_floats_helper_helper_with_limit;
use std::panic::catch_unwind;

fn exhaustive_positive_floats_with_precision_helper(
    precision: u64,
    out: &[&str],
    out_hex: &[&str],
) {
    exhaustive_floats_helper_helper_with_limit(
        20,
        exhaustive_positive_floats_with_precision(precision),
        out,
        out_hex,
    );
}

#[test]
fn test_exhaustive_positive_floats_with_precision() {
    exhaustive_positive_floats_with_precision_helper(
        1,
        &[
            "1.0", "2.0", "0.5", "0.2", "4.0", "8.0", "0.1", "3.0e1", "2.0e1", "0.06", "0.03",
            "0.02", "6.0e1", "1.0e2", "0.008", "0.002", "3.0e2", "0.004", "5.0e2", "1.0e3",
        ],
        &[
            "0x1.0#1",
            "0x2.0#1",
            "0x0.8#1",
            "0x0.4#1",
            "0x4.0#1",
            "0x8.0#1",
            "0x0.2#1",
            "0x2.0E+1#1",
            "0x1.0E+1#1",
            "0x0.1#1",
            "0x0.08#1",
            "0x0.04#1",
            "0x4.0E+1#1",
            "0x8.0E+1#1",
            "0x0.02#1",
            "0x0.008#1",
            "0x1.0E+2#1",
            "0x0.01#1",
            "0x2.0E+2#1",
            "0x4.0E+2#1",
        ],
    );
    exhaustive_positive_floats_with_precision_helper(
        2,
        &[
            "1.0", "2.0", "1.5", "0.5", "3.0", "0.8", "4.0", "0.1", "6.0", "0.2", "0.4", "0.19",
            "8.0", "16.0", "1.0e1", "0.03", "24.0", "0.06", "0.09", "0.05",
        ],
        &[
            "0x1.0#2", "0x2.0#2", "0x1.8#2", "0x0.8#2", "0x3.0#2", "0x0.c#2", "0x4.0#2", "0x0.2#2",
            "0x6.0#2", "0x0.4#2", "0x0.6#2", "0x0.3#2", "0x8.0#2", "0x10.0#2", "0xc.0#2",
            "0x0.08#2", "0x18.0#2", "0x0.10#2", "0x0.18#2", "0x0.0c#2",
        ],
    );
    exhaustive_positive_floats_with_precision_helper(
        10,
        &[
            "1.0", "2.0", "1.002", "0.5", "1.004", "2.004", "1.006", "4.0", "1.008", "2.008",
            "1.01", "0.501", "1.012", "2.012", "1.014", "0.25", "1.016", "2.016", "1.018", "0.502",
        ],
        &[
            "0x1.000#10",
            "0x2.00#10",
            "0x1.008#10",
            "0x0.800#10",
            "0x1.010#10",
            "0x2.01#10",
            "0x1.018#10",
            "0x4.00#10",
            "0x1.020#10",
            "0x2.02#10",
            "0x1.028#10",
            "0x0.804#10",
            "0x1.030#10",
            "0x2.03#10",
            "0x1.038#10",
            "0x0.400#10",
            "0x1.040#10",
            "0x2.04#10",
            "0x1.048#10",
            "0x0.808#10",
        ],
    );
    exhaustive_positive_floats_with_precision_helper(
        100,
        &[
            "1.0",
            "2.0",
            "1.000000000000000000000000000002",
            "0.5",
            "1.000000000000000000000000000003",
            "2.000000000000000000000000000003",
            "1.000000000000000000000000000005",
            "4.0",
            "1.000000000000000000000000000006",
            "2.000000000000000000000000000006",
            "1.000000000000000000000000000008",
            "0.500000000000000000000000000001",
            "1.000000000000000000000000000009",
            "2.000000000000000000000000000009",
            "1.000000000000000000000000000011",
            "0.25",
            "1.000000000000000000000000000013",
            "2.000000000000000000000000000013",
            "1.000000000000000000000000000014",
            "0.5000000000000000000000000000016",
        ],
        &[
            "0x1.0000000000000000000000000#100",
            "0x2.0000000000000000000000000#100",
            "0x1.0000000000000000000000002#100",
            "0x0.8000000000000000000000000#100",
            "0x1.0000000000000000000000004#100",
            "0x2.0000000000000000000000004#100",
            "0x1.0000000000000000000000006#100",
            "0x4.0000000000000000000000000#100",
            "0x1.0000000000000000000000008#100",
            "0x2.0000000000000000000000008#100",
            "0x1.000000000000000000000000a#100",
            "0x0.8000000000000000000000001#100",
            "0x1.000000000000000000000000c#100",
            "0x2.000000000000000000000000c#100",
            "0x1.000000000000000000000000e#100",
            "0x0.40000000000000000000000000#100",
            "0x1.0000000000000000000000010#100",
            "0x2.0000000000000000000000010#100",
            "0x1.0000000000000000000000012#100",
            "0x0.8000000000000000000000002#100",
        ],
    );
}

#[test]
fn exhaustive_positive_floats_with_precision_fail() {
    assert_panic!(exhaustive_positive_floats_with_precision(0));
}
